/*
 * Decompiled with CFR 0.152.
 */
package com.html5app.uni_tencent_call;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.drawable.AnimationDrawable;
import android.net.Uri;
import android.os.Binder;
import android.os.Build;
import android.os.Bundle;
import android.provider.Settings;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.LocalBroadcastManager;
import android.text.TextUtils;
import android.util.Log;
import android.view.KeyEvent;
import android.view.TextureView;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.html5app.uni_tencent_call.FloatingService;
import com.html5app.uni_tencent_call.Plug;
import com.html5app.uni_tencent_call.R;
import com.html5app.uni_tencent_call.TRTCMoreDialog;
import com.html5app.uni_tencent_call.TRTCSettingDialog;
import com.html5app.uni_tencent_call.TRTCVideoViewLayout;
import com.html5app.uni_tencent_call.TestCustomVideo.TestRenderVideoFrame;
import com.html5app.uni_tencent_call.TestCustomVideo.TestSendCustomVideoData;
import com.html5app.uni_tencent_call.utils.PermissionStatus;
import com.tencent.rtmp.ui.TXCloudVideoView;
import com.tencent.trtc.TRTCCloud;
import com.tencent.trtc.TRTCCloudDef;
import com.tencent.trtc.TRTCCloudListener;
import com.tencent.trtc.TRTCStatistics;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

public class TRTCMainActivity
extends Activity
implements View.OnClickListener,
TRTCSettingDialog.ISettingListener,
TRTCMoreDialog.IMoreListener,
TRTCVideoViewLayout.ITRTCVideoViewLayoutListener {
    private static final String TAG = TRTCMainActivity.class.getSimpleName();
    private boolean bBeautyEnable = true;
    private boolean bEnableVideo = true;
    private boolean bEnableAudio = true;
    private boolean beingLinkMic = false;
    private boolean bEnableVideoTab = true;
    private int iDebugLevel = 0;
    private String mUserIdBeingLink = "";
    private TextView tvRoomId;
    private EditText etRoomId;
    private EditText etUserId;
    private ImageView ivShowMode;
    private ImageView ivBeauty;
    private ImageView ivCamera;
    private ImageView ivVoice;
    private ImageView ivLog;
    private ImageView ivVideo;
    private ImageView floatingDialog;
    private TRTCSettingDialog settingDlg;
    private TRTCMoreDialog moreDlg;
    private TRTCVideoViewLayout mVideoViewLayout;
    private TRTCCloudDef.TRTCParams trtcParams;
    private TRTCCloud trtcCloud;
    private TRTCCloudListenerImpl trtcListener;
    private HashSet<String> mRoomMembers = new HashSet();
    private boolean mEnableCustomVideoCapture = false;
    private TestSendCustomVideoData mCustomCapture;
    private TestRenderVideoFrame mCustomRender;
    private TRTCReceiver receiver;
    private int mBeautyLevel = 5;
    private int mWhiteningLevel = 3;
    private int mRuddyLevel = 2;
    private int mBeautyStyle = 0;
    private int mSdkAppId = -1;
    private int isShowBackIcon = 0;
    private int videoFps = 15;
    private int videoBitrate = 600;
    private JSONObject setBeautyStyle;
    private JSONObject buttons;
    public static final int FLAG_NOTCH_SUPPORT = 65536;
    private boolean isretclose = false;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.getWindow().addFlags(128);
        this.requestWindowFeature(1);
        this.getWindow().setFlags(1024, 1024);
        this.getWindow().getDecorView().setSystemUiVisibility(9216);
        if (Build.VERSION.SDK_INT >= 19) {
            TRTCMainActivity.setFullScreenWindowLayoutInDisplayCutout(this.getWindow());
        }
        String manufacturer = Build.MANUFACTURER;
        if (PermissionStatus.isMIUI("xiaomi")) {
            if (Build.VERSION.SDK_INT >= 19) {
                WindowManager.LayoutParams localLayoutParams = this.getWindow().getAttributes();
                localLayoutParams.flags = 0x4000000 | localLayoutParams.flags;
            }
            TRTCMainActivity.setXiaomiStatusBar(this.getWindow(), true);
        }
        Intent intent = this.getIntent();
        this.mSdkAppId = intent.getIntExtra("sdkAppId", 0);
        int roomId = intent.getIntExtra("roomId", 0);
        String selfUserId = intent.getStringExtra("userId");
        String userSig = intent.getStringExtra("userSig");
        this.isShowBackIcon = intent.getIntExtra("isShowBackIcon", 0);
        this.setBeautyStyle = JSONObject.parseObject((String)intent.getStringExtra("setBeautyStyle"));
        this.buttons = JSONObject.parseObject((String)intent.getStringExtra("buttons"));
        this.videoFps = intent.getIntExtra("videoFps", 15);
        this.videoBitrate = intent.getIntExtra("videoBitrate", 15);
        Log.i((String)"setBeautyStyle", (String)("=toJSONString====" + this.setBeautyStyle.toJSONString()));
        this.trtcParams = new TRTCCloudDef.TRTCParams(this.mSdkAppId, selfUserId, userSig, roomId, "", "");
        this.initView();
        if (this.checkPermission()) {
            this.trtcListener = new TRTCCloudListenerImpl(this);
            this.trtcCloud = TRTCCloud.sharedInstance((Context)this);
            this.trtcCloud.setListener((TRTCCloudListener)this.trtcListener);
            this.enterRoom();
        }
        this.receiver = new TRTCReceiver();
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("trtc_close");
        this.registerReceiver(this.receiver, intentFilter);
    }

    public static void setXiaomiStatusBar(Window window, boolean isLightStatusBar) {
        Class<?> clazz = window.getClass();
        try {
            Class<?> layoutParams = Class.forName("android.view.MiuiWindowManager$LayoutParams");
            Field field = layoutParams.getField("EXTRA_FLAG_STATUS_BAR_DARK_MODE");
            int darkModeFlag = field.getInt(layoutParams);
            Method extraFlagField = clazz.getMethod("setExtraFlags", Integer.TYPE, Integer.TYPE);
            extraFlagField.invoke((Object)window, isLightStatusBar ? darkModeFlag : 0, darkModeFlag);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @RequiresApi(api=19)
    public static void setFullScreenWindowLayoutInDisplayCutout(Window window) {
        if (window == null) {
            return;
        }
        WindowManager.LayoutParams layoutParams = window.getAttributes();
        try {
            Class<?> layoutParamsExCls = Class.forName("com.huawei.android.view.LayoutParamsEx");
            Constructor<?> con = layoutParamsExCls.getConstructor(WindowManager.LayoutParams.class);
            Object layoutParamsExObj = con.newInstance(layoutParams);
            Method method = layoutParamsExCls.getMethod("addHwFlags", Integer.TYPE);
            method.invoke(layoutParamsExObj, 65536);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            Log.e((String)"test", (String)"hw add notch screen flag api error");
        }
        catch (Exception e) {
            Log.e((String)"test", (String)"other Exception");
        }
    }

    private boolean checkPermission() {
        if (Build.VERSION.SDK_INT >= 23 && (0 != ActivityCompat.checkSelfPermission((Context)this, (String)"android.permission.CAMERA") || 0 != ActivityCompat.checkSelfPermission((Context)this, (String)"android.permission.RECORD_AUDIO"))) {
            if (ActivityCompat.shouldShowRequestPermissionRationale((Activity)this, (String)"android.permission.CAMERA")) {
                Toast.makeText((Context)this.getApplicationContext(), (CharSequence)"\u5141\u8bb8\u4f7f\u7528\u6444\u50cf\u5934\u53ca\u9ea6\u514b\u98ce\u6743\u9650\u624d\u80fd\u6b63\u5e38\u4f7f\u7528", (int)0).show();
            }
            ActivityCompat.requestPermissions((Activity)this, (String[])new String[]{"android.permission.CAMERA", "android.permission.RECORD_AUDIO"}, (int)1005);
            return false;
        }
        return true;
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        Log.i((String)TAG, (String)("requestCode==" + requestCode + "===permissions=" + permissions.length + "===grantResults=" + grantResults.toString()));
        int conut = 0;
        for (int i = 0; i < grantResults.length; ++i) {
            Log.i((String)TAG, (String)("===permissions====" + permissions[i]));
            Log.i((String)TAG, (String)("===grantResults====" + grantResults[i]));
            if (!permissions[i].equals("android.permission.CAMERA") && !permissions[i].equals("android.permission.RECORD_AUDIO")) continue;
            Log.i((String)TAG, (String)"===permissions=0000==conut=");
            if (grantResults[i] != 0) continue;
            Log.i((String)TAG, (String)"===permissions=0000111==conut=");
            ++conut;
        }
        if (conut == grantResults.length) {
            this.trtcListener = new TRTCCloudListenerImpl(this);
            this.trtcCloud = TRTCCloud.sharedInstance((Context)this);
            this.trtcCloud.setListener((TRTCCloudListener)this.trtcListener);
            this.enterRoom();
        } else {
            this.checkPermission();
        }
        Log.i((String)TAG, (String)("===permissions===conut=" + conut));
    }

    protected void onResume() {
        super.onResume();
        Log.i((String)TAG, (String)"===\u56de\u5230\u524d\u53f0\u663e\u793a===");
        this.isretclose = false;
        this.dismissFloatingView();
    }

    protected void onPause() {
        super.onPause();
        Log.i((String)TAG, (String)("===\u56de\u5230/\u5904\u4e8e\u540e\u53f0\u663e\u793a===" + this.isretclose));
        if (!this.isretclose) {
            this.showFloatingView();
        }
    }

    protected void onDestroy() {
        super.onDestroy();
        Plug.setAllRteurn(1, null);
        this.unregisterReceiver(this.receiver);
        this.exitRoom();
        TRTCCloud.destroySharedInstance();
        this.trtcCloud = null;
        this.dismissFloatingView();
    }

    private void dismissFloatingView() {
        if (FloatingService.isStart) {
            LocalBroadcastManager.getInstance((Context)this).sendBroadcast(new Intent(FloatingService.ACTION_DISMISS_FLOATING));
        }
    }

    private void showFloatingView() {
        if (FloatingService.isStart) {
            Log.i((String)TAG, (String)"===\u542f\u52a8\u60ac\u6d6e\u7a97\u7ba1\u7406\u670d\u52a1====01");
            LocalBroadcastManager.getInstance((Context)this).sendBroadcast(new Intent(FloatingService.ACTION_SHOW_FLOATING));
        } else {
            Log.i((String)TAG, (String)"===\u542f\u52a8\u60ac\u6d6e\u7a97\u7ba1\u7406\u670d\u52a1====02");
            this.startService(new Intent((Context)this, FloatingService.class));
        }
        this.moveTaskToBack(true);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 10012 && Build.VERSION.SDK_INT >= 23) {
            if (Settings.canDrawOverlays((Context)this)) {
                Log.e((String)TAG, (String)"\u5df2\u7ecf\u6253\u5f00\u60ac\u6d6e\u7a97\u6743\u9650");
                this.isretclose = false;
            } else {
                this.isretclose = false;
            }
        }
    }

    public void onBackPressed() {
        this.exitRoom();
    }

    private void initView() {
        this.setContentView(R.layout.main_activity);
        this.initClickableLayout(R.id.ll_beauty);
        this.initClickableLayout(R.id.ll_camera);
        this.initClickableLayout(R.id.ll_voice);
        this.initClickableLayout(R.id.ll_log);
        this.initClickableLayout(R.id.ll_role);
        this.initClickableLayout(R.id.ll_more);
        this.mVideoViewLayout = (TRTCVideoViewLayout)this.findViewById(R.id.ll_mainview);
        this.mVideoViewLayout.setUserId(this.trtcParams.userId);
        this.mVideoViewLayout.setListener(this);
        TXCloudVideoView localVideoView = this.mVideoViewLayout.getCloudVideoViewByIndex(0);
        localVideoView.setUserId(this.trtcParams.userId);
        this.ivShowMode = (ImageView)this.findViewById(R.id.iv_show_mode);
        this.ivShowMode.setOnClickListener((View.OnClickListener)this);
        this.ivBeauty = (ImageView)this.findViewById(R.id.iv_beauty);
        this.ivLog = (ImageView)this.findViewById(R.id.iv_log);
        this.ivVoice = (ImageView)this.findViewById(R.id.iv_mic);
        this.ivCamera = (ImageView)this.findViewById(R.id.iv_camera);
        this.ivVideo = (ImageView)this.findViewById(R.id.iv_more);
        this.floatingDialog = (ImageView)this.findViewById(R.id.floatingDialog);
        this.etRoomId = (EditText)this.findViewById(R.id.edit_room_id);
        this.etUserId = (EditText)this.findViewById(R.id.edit_user_id);
        this.findViewById(R.id.btn_confirm).setOnClickListener((View.OnClickListener)this);
        this.findViewById(R.id.btn_cancel).setOnClickListener((View.OnClickListener)this);
        this.tvRoomId = (TextView)this.findViewById(R.id.tv_room_id);
        this.tvRoomId.setText((CharSequence)("" + this.trtcParams.roomId));
        this.settingDlg = new TRTCSettingDialog((Context)this, this);
        this.moreDlg = new TRTCMoreDialog((Context)this, this);
        ImageView backIcon = (ImageView)this.findViewById(R.id.rtc_double_room_back_button);
        if (this.isShowBackIcon == 0) {
            backIcon.setVisibility(8);
        } else if (this.isShowBackIcon == 1) {
            backIcon.setVisibility(0);
        } else if (this.isShowBackIcon == 3) {
            backIcon.setVisibility(8);
            this.floatingDialog.setVisibility(8);
        }
        backIcon.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                TRTCMainActivity.this.isretclose = true;
                TRTCMainActivity.this.exitRoom();
            }
        });
        this.floatingDialog.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                TRTCMainActivity.this.isretclose = true;
                if (Build.VERSION.SDK_INT >= 23) {
                    if (!TRTCMainActivity.this.checkFloatPermission((Context)TRTCMainActivity.this)) {
                        Intent intent = new Intent("android.settings.action.MANAGE_OVERLAY_PERMISSION", Uri.parse((String)("package:" + TRTCMainActivity.this.getPackageName())));
                        TRTCMainActivity.this.startActivityForResult(intent, 10012);
                        return;
                    }
                    TRTCMainActivity.this.showFloatingView();
                } else {
                    TRTCMainActivity.this.showFloatingView();
                }
            }
        });
        if (this.buttons.getIntValue("float") == 1) {
            this.findViewById(R.id.ll_show_mode).setVisibility(8);
        }
        if (this.buttons.getIntValue("beauty") == 1) {
            this.findViewById(R.id.ll_beauty).setVisibility(8);
        }
        if (this.buttons.getIntValue("videoEnable") == 1) {
            this.findViewById(R.id.ll_camera).setVisibility(8);
        }
        if (this.buttons.getIntValue("mic") == 1) {
            this.findViewById(R.id.ll_voice).setVisibility(8);
        }
        if (this.buttons.getIntValue("camera") == 1) {
            this.findViewById(R.id.ll_more).setVisibility(8);
        }
    }

    private boolean checkFloatPermission(Context context) {
        if (Build.VERSION.SDK_INT >= 23) {
            boolean result = false;
            try {
                Class<Settings> clazz = Settings.class;
                Method canDrawOverlays = clazz.getDeclaredMethod("canDrawOverlays", Context.class);
                result = (Boolean)canDrawOverlays.invoke(null, context);
                Log.e((String)TAG, (String)("checkFloatPermission:-->" + result));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return result;
        }
        if (Build.VERSION.SDK_INT >= 19) {
            return TRTCMainActivity.getAppOps(context);
        }
        return true;
    }

    private static boolean getAppOps(Context context) {
        try {
            Class[] arrayOfClass;
            Object object = context.getSystemService("appops");
            if (object == null) {
                return false;
            }
            Class<?> localClass = object.getClass();
            Method method = localClass.getMethod("checkOp", arrayOfClass = new Class[]{Integer.TYPE, Integer.TYPE, String.class});
            if (method == null) {
                return false;
            }
            Object[] arrayOfObject1 = new Object[]{24, Binder.getCallingUid(), context.getPackageName()};
            int m = (Integer)method.invoke(object, arrayOfObject1);
            return m == 0;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("permissions judge: -->" + e.toString()));
            return false;
        }
    }

    public boolean dispatchKeyEvent(KeyEvent event) {
        if (event.getKeyCode() == 4) {
            Log.i((String)"isShowBackIcon", (String)("=000=" + this.isShowBackIcon));
            if (this.isShowBackIcon == 2 || this.isShowBackIcon == 3) {
                return true;
            }
            this.isretclose = true;
            this.finish();
            return super.dispatchKeyEvent(event);
        }
        return super.dispatchKeyEvent(event);
    }

    private LinearLayout initClickableLayout(int resId) {
        LinearLayout layout2 = (LinearLayout)this.findViewById(resId);
        layout2.setOnClickListener((View.OnClickListener)this);
        return layout2;
    }

    private void setTRTCCloudParam() {
        TRTCCloudDef.TRTCVideoEncParam encParam = new TRTCCloudDef.TRTCVideoEncParam();
        encParam.videoResolution = this.settingDlg.getResolution();
        encParam.videoFps = this.videoFps;
        encParam.videoBitrate = this.videoBitrate;
        encParam.videoResolutionMode = this.settingDlg.isVideoVertical() ? 1 : 0;
        this.trtcCloud.setVideoEncoderParam(encParam);
        TRTCCloudDef.TRTCNetworkQosParam qosParam = new TRTCCloudDef.TRTCNetworkQosParam();
        qosParam.controlMode = this.settingDlg.getQosMode();
        qosParam.preference = this.settingDlg.getQosPreference();
        this.trtcCloud.setNetworkQosParam(qosParam);
        TRTCCloudDef.TRTCVideoEncParam smallParam = new TRTCCloudDef.TRTCVideoEncParam();
        smallParam.videoResolution = 100;
        smallParam.videoFps = this.settingDlg.getVideoFps();
        smallParam.videoBitrate = 100;
        smallParam.videoResolutionMode = this.settingDlg.isVideoVertical() ? 1 : 0;
        this.trtcCloud.enableEncSmallVideoStream(this.settingDlg.enableSmall, smallParam);
        this.trtcCloud.setPriorRemoteVideoStreamType(this.settingDlg.priorSmall ? 1 : 0);
    }

    private void enterRoom() {
        this.setTRTCCloudParam();
        this.startLocalVideo(true);
        this.trtcCloud.setBeautyStyle(this.setBeautyStyle.getIntValue("beautyStyle"), this.setBeautyStyle.getIntValue("beautyLevel"), this.setBeautyStyle.getIntValue("whitenessLevel"), this.setBeautyStyle.getIntValue("ruddinessLevel"));
        if (this.moreDlg.isEnableAudioCapture()) {
            this.trtcCloud.startLocalAudio();
        }
        this.setVideoFillMode(this.moreDlg.isVideoFillMode());
        this.setVideoRotation(this.moreDlg.isVideoVertical());
        this.enableAudioHandFree(this.moreDlg.isAudioHandFreeMode());
        this.enableGSensor(this.moreDlg.isEnableGSensorMode());
        this.enableAudioVolumeEvaluation(this.moreDlg.isAudioVolumeEvaluation());
        this.enableVideoEncMirror(this.moreDlg.isRemoteVideoMirror());
        this.setLocalViewMirrorMode(this.moreDlg.getLocalVideoMirror());
        this.mRoomMembers.clear();
        this.trtcCloud.enterRoom(this.trtcParams, this.settingDlg.getAppScene());
    }

    private void exitRoom() {
        if (this.mCustomCapture != null) {
            this.mCustomCapture.stop();
        }
        if (this.mCustomRender != null) {
            this.mCustomRender.stop();
        }
        if (this.trtcCloud != null) {
            this.trtcCloud.exitRoom();
        }
        this.finish();
    }

    public void onClick(View v) {
        if (v.getId() == R.id.iv_show_mode) {
            this.onChangeMode();
        } else if (v.getId() == R.id.ll_beauty) {
            this.onChangeBeauty();
        } else if (v.getId() == R.id.ll_camera) {
            this.onEnableVideo();
        } else if (v.getId() == R.id.ll_voice) {
            this.onEnableAudio();
        } else if (v.getId() == R.id.ll_log) {
            this.onChangeLogStatus();
        } else if (v.getId() == R.id.ll_role) {
            this.onShowSettingDlg();
        } else if (v.getId() == R.id.ll_more) {
            this.onShowMoreDlg();
        } else if (v.getId() == R.id.btn_confirm) {
            this.startLinkMic();
        } else if (v.getId() == R.id.btn_cancel) {
            this.hideLinkMicLayout();
        }
    }

    private void onChangeMode() {
        int mode = this.mVideoViewLayout.changeMode();
        this.ivShowMode.setImageResource(mode == 1 ? R.mipmap.ic_float : R.mipmap.ic_gird);
    }

    private void onChangeBeauty() {
        boolean bl = this.bBeautyEnable = !this.bBeautyEnable;
        if (this.bBeautyEnable) {
            this.trtcCloud.setBeautyStyle(this.setBeautyStyle.getIntValue("beautyStyle"), this.setBeautyStyle.getIntValue("beautyLevel"), this.setBeautyStyle.getIntValue("whitenessLevel"), this.setBeautyStyle.getIntValue("ruddinessLevel"));
        } else {
            this.trtcCloud.setBeautyStyle(1, 0, 0, 0);
        }
        this.ivBeauty.setImageResource(this.bBeautyEnable ? R.mipmap.beauty : R.mipmap.beauty2);
    }

    private void onEnableVideo() {
        this.bEnableVideo = !this.bEnableVideo;
        this.startLocalVideo(this.bEnableVideo);
        this.mVideoViewLayout.updateVideoStatus(this.trtcParams.userId, this.bEnableVideo, false, "", "", "", "", "", "");
        this.ivCamera.setImageResource(this.bEnableVideo ? R.mipmap.remote_video_enable : R.mipmap.remote_video_disable);
    }

    private void onEnableAudio() {
        this.bEnableAudio = !this.bEnableAudio;
        this.trtcCloud.muteLocalAudio(!this.bEnableAudio);
        this.ivVoice.setImageResource(this.bEnableAudio ? R.mipmap.mic_enable : R.mipmap.mic_disable);
    }

    private void onChangeLogStatus() {
        this.iDebugLevel = (this.iDebugLevel + 1) % 3;
        this.ivLog.setImageResource(0 == this.iDebugLevel ? R.mipmap.log2 : R.mipmap.log);
        this.trtcCloud.showDebugView(this.iDebugLevel);
    }

    private void onShowSettingDlg() {
        this.settingDlg.show();
    }

    private void onShowMoreDlg() {
        this.ivVideo.setImageResource(this.bEnableVideoTab ? R.mipmap.camera2 : R.mipmap.camera);
        this.bEnableVideoTab = !this.bEnableVideoTab;
        this.trtcCloud.switchCamera();
    }

    @Override
    public void onComplete() {
        this.setTRTCCloudParam();
        this.setVideoFillMode(this.settingDlg.isVideoVertical());
        this.moreDlg.updateVideoFillMode(this.settingDlg.isVideoVertical());
    }

    @Override
    public void onEnableRemoteVideo(final String userId, boolean enable) {
        if (enable) {
            final TXCloudVideoView renderView = this.mVideoViewLayout.getCloudVideoViewByUseId(userId + 0);
            if (renderView != null) {
                this.trtcCloud.setRemoteViewFillMode(userId, 0);
                this.trtcCloud.startRemoteView(userId, renderView);
                this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        renderView.setUserId(userId + 0);
                        TRTCMainActivity.this.mVideoViewLayout.freshToolbarLayoutOnMemberEnter(userId);
                    }
                });
            }
        } else {
            this.trtcCloud.stopRemoteView(userId);
        }
    }

    @Override
    public void onEnableRemoteAudio(String userId, boolean enable) {
        this.trtcCloud.muteRemoteAudio(userId, !enable);
    }

    @Override
    public void onChangeVideoFillMode(String userId, boolean adjustMode) {
        this.trtcCloud.setRemoteViewFillMode(userId, 0);
    }

    @Override
    public void onSwitchCamera(boolean bCameraFront) {
        this.trtcCloud.switchCamera();
    }

    @Override
    public void onFillModeChange(boolean bFillMode) {
        this.setVideoFillMode(bFillMode);
    }

    @Override
    public void onVideoRotationChange(boolean bVertical) {
        this.setVideoRotation(bVertical);
    }

    @Override
    public void onEnableAudioCapture(boolean bEnable) {
        this.enableAudioCapture(bEnable);
    }

    @Override
    public void onEnableAudioHandFree(boolean bEnable) {
        this.enableAudioHandFree(bEnable);
    }

    @Override
    public void onMirrorLocalVideo(int localViewMirror) {
        this.setLocalViewMirrorMode(localViewMirror);
    }

    @Override
    public void onMirrorRemoteVideo(boolean bMirror) {
        this.enableVideoEncMirror(bMirror);
    }

    @Override
    public void onEnableGSensor(boolean bEnable) {
        this.enableGSensor(bEnable);
    }

    @Override
    public void onEnableAudioVolumeEvaluation(boolean bEnable) {
        this.enableAudioVolumeEvaluation(bEnable);
    }

    @Override
    public void onEnableCloudMixture(boolean bEnable) {
        this.updateCloudMixtureParams();
    }

    @Override
    public void onClickButtonGetPlayUrl() {
        if (this.trtcParams == null) {
            return;
        }
        String strStreamID = "3891_" + this.stringToMd5("" + this.trtcParams.roomId + "_" + this.trtcParams.userId + "_main");
        String strPlayUrl = "http://3891.liveplay.myqcloud.com/live/" + strStreamID + ".flv";
        Intent intent = new Intent("android.intent.action.SEND");
        intent.putExtra("android.intent.extra.TEXT", strPlayUrl);
        intent.setType("text/plain");
        this.startActivity(Intent.createChooser((Intent)intent, (CharSequence)"\u5206\u4eab"));
    }

    @Override
    public void onClickButtonLinkMic() {
        if (this.beingLinkMic) {
            this.stopLinkMic();
        } else {
            this.showLinkMicLayout();
        }
    }

    private void setVideoFillMode(boolean bFillMode) {
        if (bFillMode) {
            this.trtcCloud.setLocalViewFillMode(0);
        } else {
            this.trtcCloud.setLocalViewFillMode(1);
        }
    }

    private void setVideoRotation(boolean bVertical) {
        if (bVertical) {
            this.trtcCloud.setLocalViewRotation(0);
        } else {
            this.trtcCloud.setLocalViewRotation(1);
        }
    }

    private void enableAudioCapture(boolean bEnable) {
        if (bEnable) {
            this.trtcCloud.startLocalAudio();
        } else {
            this.trtcCloud.stopLocalAudio();
        }
    }

    private void enableAudioHandFree(boolean bEnable) {
        if (bEnable) {
            this.trtcCloud.setAudioRoute(0);
        } else {
            this.trtcCloud.setAudioRoute(1);
        }
    }

    private void enableVideoEncMirror(boolean bMirror) {
        this.trtcCloud.setVideoEncoderMirror(bMirror);
    }

    private void setLocalViewMirrorMode(int mirrorMode) {
        this.trtcCloud.setLocalViewMirror(mirrorMode);
    }

    private void enableGSensor(boolean bEnable) {
        if (bEnable) {
            this.trtcCloud.setGSensorMode(2);
        } else {
            this.trtcCloud.setGSensorMode(0);
        }
    }

    private void enableAudioVolumeEvaluation(boolean bEnable) {
        if (bEnable) {
            this.trtcCloud.enableAudioVolumeEvaluation(200);
        } else {
            this.trtcCloud.enableAudioVolumeEvaluation(0);
            this.mVideoViewLayout.hideAudioVolumeProgressBar();
        }
    }

    private void updateCloudMixtureParams() {
        int videoWidth = 720;
        int videoHeight = 1280;
        int subWidth = 180;
        int subHeight = 320;
        int offsetX = 5;
        int offsetY = 50;
        int bitrate = 200;
        int resolution = this.settingDlg.getResolution();
        switch (resolution) {
            case 3: {
                videoWidth = 160;
                videoHeight = 160;
                subWidth = 27;
                subHeight = 48;
                offsetY = 20;
                bitrate = 200;
                break;
            }
            case 104: {
                videoWidth = 192;
                videoHeight = 336;
                subWidth = 54;
                subHeight = 96;
                offsetY = 30;
                bitrate = 400;
                break;
            }
            case 56: {
                videoWidth = 240;
                videoHeight = 320;
                subWidth = 54;
                subHeight = 96;
                bitrate = 400;
                break;
            }
            case 7: {
                videoWidth = 480;
                videoHeight = 480;
                subWidth = 72;
                subHeight = 128;
                bitrate = 600;
                break;
            }
            case 108: {
                videoWidth = 368;
                videoHeight = 640;
                subWidth = 90;
                subHeight = 160;
                bitrate = 800;
                break;
            }
            case 62: {
                videoWidth = 480;
                videoHeight = 640;
                subWidth = 90;
                subHeight = 160;
                bitrate = 800;
                break;
            }
            case 110: {
                videoWidth = 544;
                videoHeight = 960;
                subWidth = 171;
                subHeight = 304;
                bitrate = 1000;
                break;
            }
            case 112: {
                videoWidth = 720;
                videoHeight = 1280;
                subWidth = 180;
                subHeight = 320;
                bitrate = 1500;
            }
        }
        TRTCCloudDef.TRTCTranscodingConfig config = new TRTCCloudDef.TRTCTranscodingConfig();
        config.appId = -1;
        config.bizId = -1;
        config.videoWidth = videoWidth;
        config.videoHeight = videoHeight;
        config.videoGOP = 3;
        config.videoWidth = videoWidth;
        config.videoHeight = videoHeight;
        config.videoGOP = 3;
        config.videoFramerate = 15;
        config.videoBitrate = bitrate;
        config.audioSampleRate = 48000;
        config.audioBitrate = 64;
        config.audioChannels = 1;
        TRTCCloudDef.TRTCMixUser broadCaster = new TRTCCloudDef.TRTCMixUser();
        broadCaster.userId = this.trtcParams.userId;
        broadCaster.zOrder = 0;
        broadCaster.x = 0;
        broadCaster.y = 0;
        broadCaster.width = videoWidth;
        broadCaster.height = videoHeight;
        config.mixUsers = new ArrayList();
        config.mixUsers.add(broadCaster);
        if (this.moreDlg.isEnableCloudMixture()) {
            int index = 0;
            for (String userId : this.mRoomMembers) {
                TRTCCloudDef.TRTCMixUser audience = new TRTCCloudDef.TRTCMixUser();
                audience.userId = userId;
                audience.zOrder = 1 + index;
                if (index < 3) {
                    audience.x = videoWidth - offsetX - subWidth;
                    audience.y = videoHeight - offsetY - index * subHeight - subHeight;
                    audience.width = subWidth;
                    audience.height = subHeight;
                } else if (index < 6) {
                    audience.x = offsetX;
                    audience.y = videoHeight - offsetY - (index - 3) * subHeight - subHeight;
                    audience.width = subWidth;
                    audience.height = subHeight;
                }
                config.mixUsers.add(audience);
                ++index;
            }
        }
        this.trtcCloud.setMixTranscodingConfig(config);
    }

    protected String stringToMd5(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return "";
        }
        MessageDigest md5 = null;
        try {
            md5 = MessageDigest.getInstance("MD5");
            byte[] bytes = md5.digest(string2.getBytes());
            String result = "";
            for (byte b : bytes) {
                String temp = Integer.toHexString(b & 0xFF);
                if (temp.length() == 1) {
                    temp = "0" + temp;
                }
                result = result + temp;
            }
            return result;
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return "";
        }
    }

    private void showLinkMicLayout() {
        FrameLayout layout2 = (FrameLayout)this.findViewById(R.id.layout_linkmic);
        layout2.setVisibility(0);
        this.etRoomId.setText((CharSequence)"");
        this.etUserId.setText((CharSequence)"");
    }

    private void hideLinkMicLayout() {
        FrameLayout layout2 = (FrameLayout)this.findViewById(R.id.layout_linkmic);
        layout2.setVisibility(8);
    }

    private void startLinkMicLoading() {
        FrameLayout layout2 = (FrameLayout)this.findViewById(R.id.layout_linkmic_loading);
        layout2.setVisibility(0);
        ImageView imageView = (ImageView)this.findViewById(R.id.imageview_linkmic_loading);
        imageView.setImageResource(R.drawable.trtc_linkmic_loading);
        AnimationDrawable animation = (AnimationDrawable)imageView.getDrawable();
        if (animation != null) {
            animation.start();
        }
    }

    private void stopLinkMicLoading() {
        FrameLayout layout2 = (FrameLayout)this.findViewById(R.id.layout_linkmic_loading);
        layout2.setVisibility(8);
        ImageView imageView = (ImageView)this.findViewById(R.id.imageview_linkmic_loading);
        AnimationDrawable animation = (AnimationDrawable)imageView.getDrawable();
        if (animation != null) {
            animation.stop();
        }
    }

    private void startLinkMic() {
        String roomId = this.etRoomId.getText().toString();
        String userId = this.etUserId.getText().toString();
        if (roomId == null || roomId.isEmpty()) {
            Toast.makeText((Context)this.getApplicationContext(), (CharSequence)"\u8bf7\u8f93\u5165\u76ee\u6807\u623f\u95f4\u540d", (int)0).show();
            return;
        }
        if (userId == null || userId.isEmpty()) {
            Toast.makeText((Context)this.getApplicationContext(), (CharSequence)"\u8bf7\u8f93\u5165\u76ee\u6807\u7528\u6237ID", (int)0).show();
            return;
        }
        this.mUserIdBeingLink = userId;
        this.trtcCloud.ConnectOtherRoom(String.format("{\"roomId\":%s,\"userId\":\"%s\"}", roomId, userId));
        this.hideLinkMicLayout();
        this.startLinkMicLoading();
    }

    private void stopLinkMic() {
        this.trtcCloud.DisconnectOtherRoom();
    }

    private void startLocalVideo(boolean enable) {
        TXCloudVideoView localVideoView = this.mVideoViewLayout.getCloudVideoViewByUseId(this.trtcParams.userId);
        localVideoView.setUserId(this.trtcParams.userId);
        localVideoView.setVisibility(0);
        if (enable) {
            this.trtcCloud.enableCustomVideoCapture(this.mEnableCustomVideoCapture);
            if (this.mEnableCustomVideoCapture) {
                if (this.mCustomCapture != null) {
                    // empty if block
                }
                this.trtcCloud.setLocalVideoRenderListener(2, 3, (TRTCCloudListener.TRTCVideoRenderListener)this.mCustomRender);
                if (this.mCustomRender != null) {
                    TextureView textureView = new TextureView((Context)this);
                    localVideoView.addVideoView(textureView);
                    this.mCustomRender.start(textureView);
                }
            } else {
                this.trtcCloud.startLocalPreview(this.moreDlg.isCameraFront(), localVideoView);
            }
        } else if (this.mEnableCustomVideoCapture) {
            if (this.mCustomCapture != null) {
                this.mCustomCapture.stop();
            }
            if (this.mCustomRender != null) {
                this.mCustomRender.stop();
            }
        } else {
            this.trtcCloud.stopLocalPreview();
        }
    }

    static class TRTCCloudListenerImpl
    extends TRTCCloudListener
    implements TRTCCloudListener.TRTCVideoRenderListener {
        private WeakReference<TRTCMainActivity> mContext;
        private HashMap<String, TestRenderVideoFrame> mCustomRender;
        private JSONArray countArray = new JSONArray();

        public TRTCCloudListenerImpl(TRTCMainActivity activity) {
            this.mContext = new WeakReference<TRTCMainActivity>(activity);
            this.mCustomRender = new HashMap(10);
        }

        public void onEnterRoom(long elapsed) {
            TRTCMainActivity activity = (TRTCMainActivity)this.mContext.get();
            if (activity != null) {
                activity.mVideoViewLayout.onRoomEnter();
                activity.updateCloudMixtureParams();
                Plug.setAllRteurn(2, null);
            }
        }

        public void onExitRoom(int reason) {
            TRTCMainActivity activity = (TRTCMainActivity)this.mContext.get();
            if (activity != null) {
                activity.finish();
            }
        }

        public void onError(int errCode, String errMsg, Bundle extraInfo) {
            Log.d((String)TAG, (String)"sdk callback onError");
            TRTCMainActivity activity = (TRTCMainActivity)this.mContext.get();
            if (activity != null) {
                if (errCode == -100013) {
                    Toast.makeText((Context)activity, (CharSequence)"\u6b20\u8d39\u5bfc\u81f4\u670d\u52a1\u6682\u505c", (int)0).show();
                } else if (errCode == -102005) {
                    Toast.makeText((Context)activity, (CharSequence)"\u623f\u95f4\u4e0d\u5b58\u5728", (int)0).show();
                } else if (errCode == -102003) {
                    Toast.makeText((Context)activity, (CharSequence)"\u7b7e\u540d\u9519\u8bef", (int)0).show();
                } else {
                    Toast.makeText((Context)activity, (CharSequence)("onError: " + errMsg + "[" + errCode + "]"), (int)0).show();
                }
                if (errCode == -3301) {
                    activity.exitRoom();
                }
            }
        }

        public void onWarning(int warningCode, String warningMsg, Bundle extraInfo) {
            Log.d((String)TAG, (String)"sdk callback onWarning");
        }

        public void onUserEnter(String userId) {
            TRTCMainActivity activity = (TRTCMainActivity)this.mContext.get();
            if (activity != null) {
                TXCloudVideoView renderView = activity.mVideoViewLayout.onMemberEnter(userId + 0);
                if (renderView != null) {
                    renderView.setVisibility(0);
                    activity.trtcCloud.showDebugView(activity.iDebugLevel);
                    activity.trtcCloud.setDebugViewMargin(userId, new TRTCCloud.TRTCViewMargin(0.0f, 0.0f, 0.1f, 0.0f));
                }
                JSONObject obj = new JSONObject();
                obj.put("userid", (Object)userId);
                if (!this.countArray.contains((Object)userId)) {
                    this.countArray.add((Object)userId);
                }
                obj.put("count", (Object)this.countArray.size());
                obj.put("userList", (Object)this.countArray);
                Plug.setAllRteurn(4, obj);
            }
        }

        public void onUserExit(String userId, int reason) {
            TRTCMainActivity activity = (TRTCMainActivity)this.mContext.get();
            if (activity != null) {
                activity.trtcCloud.stopRemoteView(userId);
                activity.trtcCloud.stopRemoteSubStreamView(userId);
                activity.mVideoViewLayout.onMemberLeave(userId + 0);
                activity.mVideoViewLayout.onMemberLeave(userId + 2);
                activity.mRoomMembers.remove(userId);
                activity.updateCloudMixtureParams();
                TestRenderVideoFrame customRender = this.mCustomRender.get(userId);
                if (customRender != null) {
                    customRender.stop();
                    this.mCustomRender.remove(userId);
                }
                if (activity.beingLinkMic && userId.equalsIgnoreCase(activity.mUserIdBeingLink)) {
                    activity.stopLinkMic();
                }
                JSONObject obj = new JSONObject();
                obj.put("userid", (Object)userId);
                if (this.countArray.contains((Object)userId)) {
                    this.countArray.remove((Object)userId);
                }
                obj.put("count", (Object)this.countArray.size());
                obj.put("userList", (Object)this.countArray);
                Plug.setAllRteurn(3, obj);
            }
        }

        public void onUserVideoAvailable(final String userId, boolean available) {
            TRTCMainActivity activity = (TRTCMainActivity)this.mContext.get();
            if (activity != null) {
                if (available) {
                    final TXCloudVideoView renderView = activity.mVideoViewLayout.onMemberEnter(userId + 0);
                    if (renderView != null) {
                        activity.trtcCloud.setRemoteViewFillMode(userId, 0);
                        if (activity.mEnableCustomVideoCapture) {
                            activity.trtcCloud.startRemoteView(userId, null);
                        } else {
                            activity.trtcCloud.startRemoteView(userId, renderView);
                        }
                        activity.runOnUiThread(new Runnable(){

                            @Override
                            public void run() {
                                renderView.setUserId(userId + 0);
                            }
                        });
                    }
                    activity.mRoomMembers.add(userId);
                    activity.updateCloudMixtureParams();
                } else {
                    activity.trtcCloud.stopRemoteView(userId);
                    activity.mRoomMembers.remove(userId);
                    activity.updateCloudMixtureParams();
                }
                activity.mVideoViewLayout.updateVideoStatus(userId, available, false, "", "", "", "", "all", "");
            }
        }

        public void onUserSubStreamAvailable(final String userId, boolean available) {
            TRTCMainActivity activity = (TRTCMainActivity)this.mContext.get();
            if (activity != null) {
                if (available) {
                    final TXCloudVideoView renderView = activity.mVideoViewLayout.onMemberEnter(userId + 2);
                    if (renderView != null) {
                        activity.trtcCloud.setRemoteSubStreamViewFillMode(userId, 1);
                        activity.trtcCloud.startRemoteSubStreamView(userId, renderView);
                        activity.runOnUiThread(new Runnable(){

                            @Override
                            public void run() {
                                renderView.setUserId(userId + 2);
                            }
                        });
                    }
                } else {
                    activity.trtcCloud.stopRemoteSubStreamView(userId);
                    activity.mVideoViewLayout.onMemberLeave(userId + 2);
                }
            }
        }

        public void onUserAudioAvailable(String userId, boolean available) {
            TXCloudVideoView renderView;
            TRTCMainActivity activity = (TRTCMainActivity)this.mContext.get();
            if (activity != null && available && (renderView = activity.mVideoViewLayout.onMemberEnter(userId + 0)) != null) {
                renderView.setVisibility(0);
            }
        }

        public void onFirstVideoFrame(String userId, int width, int height) {
            TRTCMainActivity activity = (TRTCMainActivity)this.mContext.get();
            if (activity != null) {
                activity.mVideoViewLayout.freshToolbarLayoutOnMemberEnter(userId + 0);
            }
        }

        public void onStartPublishCDNStream(int err, String errMsg) {
        }

        public void onStopPublishCDNStream(int err, String errMsg) {
        }

        public void onRenderVideoFrame(String userId, int streamType, TRTCCloudDef.TRTCVideoFrame frame) {
        }

        public void onUserVoiceVolume(ArrayList<TRTCCloudDef.TRTCVolumeInfo> userVolumes, int totalVolume) {
        }

        public void onStatistics(TRTCStatistics statics) {
        }

        public void onConnectOtherRoom(String userID, int err, String errMsg) {
            TRTCMainActivity activity = (TRTCMainActivity)this.mContext.get();
            if (activity != null) {
                activity.stopLinkMicLoading();
                if (err == 0) {
                    activity.beingLinkMic = true;
                    activity.moreDlg.updateLinkMicState(true);
                    Toast.makeText((Context)activity.getApplicationContext(), (CharSequence)"\u8fde\u9ea6\u6210\u529f", (int)1).show();
                } else {
                    activity.mUserIdBeingLink = "";
                    activity.beingLinkMic = false;
                    activity.moreDlg.updateLinkMicState(false);
                    Toast.makeText((Context)activity.getApplicationContext(), (CharSequence)"\u8fde\u9ea6\u5931\u8d25", (int)1).show();
                }
            }
        }

        public void onDisConnectOtherRoom(int err, String errMsg) {
            TRTCMainActivity activity = (TRTCMainActivity)this.mContext.get();
            if (activity != null) {
                activity.mUserIdBeingLink = "";
                activity.beingLinkMic = false;
                activity.moreDlg.updateLinkMicState(false);
            }
        }

        public void onNetworkQuality(TRTCCloudDef.TRTCQuality localQuality, ArrayList<TRTCCloudDef.TRTCQuality> remoteQuality) {
        }
    }

    public class TRTCReceiver
    extends BroadcastReceiver {
        public void onReceive(Context context, Intent intent) {
            Log.e((String)"updateVideoStatus", (String)("\u63a5\u6536\u6210\u529f:" + intent.getAction()));
            if (intent.getAction().equals("trtc_close")) {
                TRTCMainActivity.this.isretclose = true;
                TRTCMainActivity.this.finish();
            }
        }
    }
}

