/*
 * Decompiled with CFR 0.152.
 */
package com.html5app.uni_tencent_call;

import android.app.Dialog;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.RadioButton;
import android.widget.TextView;
import com.html5app.uni_tencent_call.R;
import java.lang.ref.WeakReference;

public class TRTCMoreDialog
extends Dialog
implements View.OnClickListener {
    private static final String TAG = "TRTCMoreDialog";
    private static final String KEY_MORE_SETTING_DATA = "KEY_MORE_SETTING_DATA";
    private static final String KEY_CAMERA_FRONT = "KEY_CAMERA_FRONT";
    private static final String KEY_VIDEO_FILL_MODE = "KEY_VIDEO_FILL_MODE";
    private static final String KEY_VIDEO_VERTICAL = "KEY_VIDEO_VERTICAL";
    private static final String KEY_ENABLE_AUDIO_CAPTURE = "KEY_ENABLE_AUDIO_CAPTURE";
    private static final String KEY_AUDIO_HAND_FREE_MODE = "KEY_AUDIO_HAND_FREE_MODE";
    private static final String KEY_LOCAL_VIDEO_MIRROR = "KEY_LOCAL_VIDEO_MIRROR";
    private static final String KEY_REMOTE_VIDEO_MIRROR = "KEY_REMOTE_VIDEO_MIRROR";
    private static final String KEY_ENABLE_GSENSOR_MODE = "KEY_ENABLE_GSENSOR_MODE";
    private static final String KEY_AUDIO_VOLUME_EVALUATION = "KEY_ENABLE_VOLUME_EVALUATION";
    private static final String KEY_ENABLE_CLOUD_MIXTURE = "KEY_ENABLE_CLOUD_MIXTURE";
    private boolean mCameraFront = true;
    private boolean mVideoFillMode = true;
    private boolean mVideoVertical = true;
    private boolean mEnableAudioCapture = true;
    private boolean mAudioHandFreeMode = true;
    private boolean mEnableGSensorMode = false;
    private boolean mAudioVolumeEvaluation = true;
    private boolean mEnableCloudMixture = true;
    private boolean mEnableVideoEncMirror = false;
    private int mLocalVideoViewMirror = 0;
    private RadioButton mRbCameraFront;
    private RadioButton mRbCameraBack;
    private RadioButton mRbVideoFill;
    private RadioButton mRbVideoAdjust;
    private RadioButton mRbVideoVertical;
    private RadioButton mRbVideoHorizontal;
    private RadioButton mRbLocalVideoMirrorAuto;
    private RadioButton mRbLocalVideoMirrorEnable;
    private RadioButton mRbLocalVideoMirrorDisable;
    private CheckBox mCbEnableAudio;
    private CheckBox mCbAudioHandFree;
    private CheckBox mCbVideoEncMirror;
    private CheckBox mCbEnableGSensor;
    private CheckBox mCbAudioVolumeEvaluation;
    private CheckBox mCbEnableCloudMixture;
    private WeakReference<IMoreListener> mMoreListener;

    public TRTCMoreDialog(Context context, IMoreListener listener) {
        super(context, R.style.room_more_dlg);
        this.mMoreListener = new WeakReference<IMoreListener>(listener);
        this.loadLocalCache(context);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.dlg_more);
        this.getWindow().setLayout(-1, -2);
        this.initView();
    }

    private void initView() {
        this.mRbCameraFront = (RadioButton)this.findViewById(R.id.camera_front);
        this.mRbCameraBack = (RadioButton)this.findViewById(R.id.camera_back);
        this.mRbVideoFill = (RadioButton)this.findViewById(R.id.mode_fill);
        this.mRbVideoAdjust = (RadioButton)this.findViewById(R.id.mode_adjust);
        this.mRbVideoVertical = (RadioButton)this.findViewById(R.id.mode_vertical);
        this.mRbVideoHorizontal = (RadioButton)this.findViewById(R.id.mode_horizontal);
        this.mRbLocalVideoMirrorAuto = (RadioButton)this.findViewById(R.id.mirror_auto);
        this.mRbLocalVideoMirrorEnable = (RadioButton)this.findViewById(R.id.mirror_enable);
        this.mRbLocalVideoMirrorDisable = (RadioButton)this.findViewById(R.id.mirror_disable);
        this.mCbEnableAudio = (CheckBox)this.findViewById(R.id.enable_audio);
        this.mCbAudioHandFree = (CheckBox)this.findViewById(R.id.audio_handfree);
        this.mCbVideoEncMirror = (CheckBox)this.findViewById(R.id.video_enc_mirror);
        this.mCbEnableGSensor = (CheckBox)this.findViewById(R.id.enable_gsensor);
        this.mCbAudioVolumeEvaluation = (CheckBox)this.findViewById(R.id.enable_audio_volume_evaluation);
        this.mCbEnableCloudMixture = (CheckBox)this.findViewById(R.id.enable_cloud_mixture);
        this.mRbCameraFront.setChecked(this.mCameraFront);
        this.mRbCameraBack.setChecked(!this.mCameraFront);
        this.mRbVideoFill.setChecked(this.mVideoFillMode);
        this.mRbVideoAdjust.setChecked(!this.mVideoFillMode);
        this.mRbVideoVertical.setChecked(this.mVideoVertical);
        this.mRbVideoHorizontal.setChecked(!this.mVideoVertical);
        this.mCbEnableAudio.setChecked(this.mEnableAudioCapture);
        this.mCbAudioHandFree.setChecked(this.mAudioHandFreeMode);
        this.mCbEnableGSensor.setChecked(this.mEnableGSensorMode);
        this.mCbAudioVolumeEvaluation.setChecked(this.mAudioVolumeEvaluation);
        this.mCbEnableCloudMixture.setChecked(this.mEnableCloudMixture);
        this.mCbVideoEncMirror.setChecked(this.mEnableVideoEncMirror);
        this.mRbCameraFront.setOnClickListener((View.OnClickListener)this);
        this.mRbCameraBack.setOnClickListener((View.OnClickListener)this);
        this.mRbVideoFill.setOnClickListener((View.OnClickListener)this);
        this.mRbVideoAdjust.setOnClickListener((View.OnClickListener)this);
        this.mRbVideoVertical.setOnClickListener((View.OnClickListener)this);
        this.mRbVideoHorizontal.setOnClickListener((View.OnClickListener)this);
        this.mRbLocalVideoMirrorAuto.setOnClickListener((View.OnClickListener)this);
        this.mRbLocalVideoMirrorEnable.setOnClickListener((View.OnClickListener)this);
        this.mRbLocalVideoMirrorDisable.setOnClickListener((View.OnClickListener)this);
        this.mCbEnableAudio.setOnClickListener((View.OnClickListener)this);
        this.mCbAudioHandFree.setOnClickListener((View.OnClickListener)this);
        this.mCbVideoEncMirror.setOnClickListener((View.OnClickListener)this);
        this.mCbVideoEncMirror.setOnClickListener((View.OnClickListener)this);
        this.mCbEnableGSensor.setOnClickListener((View.OnClickListener)this);
        this.mCbAudioVolumeEvaluation.setOnClickListener((View.OnClickListener)this);
        this.mCbEnableCloudMixture.setOnClickListener((View.OnClickListener)this);
        this.findViewById(R.id.btn_get_playurl).setOnClickListener((View.OnClickListener)this);
        this.findViewById(R.id.btn_linkmic).setOnClickListener((View.OnClickListener)this);
    }

    public boolean isCameraFront() {
        return this.mCameraFront;
    }

    public boolean isVideoFillMode() {
        return this.mVideoFillMode;
    }

    public boolean isVideoVertical() {
        return this.mVideoVertical;
    }

    public boolean isEnableAudioCapture() {
        return this.mEnableAudioCapture;
    }

    public boolean isAudioHandFreeMode() {
        return this.mAudioHandFreeMode;
    }

    public int getLocalVideoMirror() {
        return this.mLocalVideoViewMirror;
    }

    public boolean isRemoteVideoMirror() {
        return this.mEnableVideoEncMirror;
    }

    public boolean isEnableGSensorMode() {
        return this.mEnableGSensorMode;
    }

    public boolean isAudioVolumeEvaluation() {
        return this.mAudioVolumeEvaluation;
    }

    public boolean isEnableCloudMixture() {
        return this.mEnableCloudMixture;
    }

    private void loadLocalCache(Context context) {
        try {
            SharedPreferences shareInfo = context.getSharedPreferences(KEY_MORE_SETTING_DATA, 0);
            this.mCameraFront = shareInfo.getBoolean(KEY_CAMERA_FRONT, this.mCameraFront);
            this.mVideoFillMode = shareInfo.getBoolean(KEY_VIDEO_FILL_MODE, this.mVideoFillMode);
            this.mVideoVertical = shareInfo.getBoolean(KEY_VIDEO_VERTICAL, this.mVideoVertical);
            this.mEnableAudioCapture = shareInfo.getBoolean(KEY_ENABLE_AUDIO_CAPTURE, this.mEnableAudioCapture);
            this.mAudioHandFreeMode = shareInfo.getBoolean(KEY_AUDIO_HAND_FREE_MODE, this.mAudioHandFreeMode);
            this.mLocalVideoViewMirror = shareInfo.getInt(KEY_LOCAL_VIDEO_MIRROR, this.mLocalVideoViewMirror);
            this.mEnableVideoEncMirror = shareInfo.getBoolean(KEY_REMOTE_VIDEO_MIRROR, this.mEnableVideoEncMirror);
            this.mEnableGSensorMode = shareInfo.getBoolean(KEY_ENABLE_GSENSOR_MODE, this.mEnableGSensorMode);
            this.mAudioVolumeEvaluation = shareInfo.getBoolean(KEY_AUDIO_VOLUME_EVALUATION, this.mAudioVolumeEvaluation);
            this.mEnableCloudMixture = shareInfo.getBoolean(KEY_ENABLE_CLOUD_MIXTURE, this.mEnableCloudMixture);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void saveData(Context context) {
        try {
            SharedPreferences shareInfo = context.getSharedPreferences(KEY_MORE_SETTING_DATA, 0);
            SharedPreferences.Editor editor = shareInfo.edit();
            editor.putBoolean(KEY_CAMERA_FRONT, this.mCameraFront);
            editor.putBoolean(KEY_VIDEO_FILL_MODE, this.mVideoFillMode);
            editor.putBoolean(KEY_VIDEO_VERTICAL, this.mVideoVertical);
            editor.putBoolean(KEY_ENABLE_AUDIO_CAPTURE, this.mEnableAudioCapture);
            editor.putBoolean(KEY_AUDIO_HAND_FREE_MODE, this.mAudioHandFreeMode);
            editor.putInt(KEY_LOCAL_VIDEO_MIRROR, this.mLocalVideoViewMirror);
            editor.putBoolean(KEY_REMOTE_VIDEO_MIRROR, this.mEnableVideoEncMirror);
            editor.putBoolean(KEY_ENABLE_GSENSOR_MODE, this.mEnableGSensorMode);
            editor.putBoolean(KEY_AUDIO_VOLUME_EVALUATION, this.mAudioVolumeEvaluation);
            editor.putBoolean(KEY_ENABLE_CLOUD_MIXTURE, this.mEnableCloudMixture);
            editor.commit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onClick(View v) {
        IMoreListener listener = (IMoreListener)this.mMoreListener.get();
        int id2 = v.getId();
        if (id2 == R.id.camera_front || id2 == R.id.camera_back) {
            boolean cameraFront;
            boolean bl = cameraFront = id2 == R.id.camera_front;
            if (cameraFront != this.mCameraFront) {
                this.mCameraFront = cameraFront;
                if (listener != null) {
                    listener.onSwitchCamera(this.mCameraFront);
                }
            }
        }
        this.saveData(this.getContext());
    }

    public void show(boolean beingLinkMic) {
        this.updateLinkMicState(beingLinkMic);
        this.show();
    }

    public void updateLinkMicState(boolean beingLinkMic) {
        Button button;
        TextView textView = (TextView)this.findViewById(R.id.text_linkmic);
        if (textView != null) {
            textView.setText((CharSequence)(beingLinkMic ? "\u7ed3\u675f\u8de8\u623f\u8fde\u9ea6" : "\u5f00\u59cb\u8de8\u623f\u8fde\u9ea6"));
        }
        if ((button = (Button)this.findViewById(R.id.btn_linkmic)) != null) {
            button.setText((CharSequence)(beingLinkMic ? "\u7ed3\u675f" : "\u5f00\u59cb"));
        }
    }

    public void updateVideoFillMode(boolean bFillMode) {
        if (this.mRbVideoFill != null) {
            this.mRbVideoFill.setChecked(bFillMode);
        }
        if (this.mRbVideoAdjust != null) {
            this.mRbVideoAdjust.setChecked(!bFillMode);
        }
        this.mVideoFillMode = bFillMode;
        this.saveData(this.getContext());
    }

    public static interface IMoreListener {
        public void onSwitchCamera(boolean var1);

        public void onFillModeChange(boolean var1);

        public void onVideoRotationChange(boolean var1);

        public void onEnableAudioCapture(boolean var1);

        public void onEnableAudioHandFree(boolean var1);

        public void onMirrorLocalVideo(int var1);

        public void onMirrorRemoteVideo(boolean var1);

        public void onEnableGSensor(boolean var1);

        public void onEnableAudioVolumeEvaluation(boolean var1);

        public void onEnableCloudMixture(boolean var1);

        public void onClickButtonGetPlayUrl();

        public void onClickButtonLinkMic();
    }
}

