/*
 * Decompiled with CFR 0.152.
 */
package com.html5app.uni_tencent_call;

import android.app.Dialog;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.CheckBox;
import android.widget.RadioButton;
import android.widget.SeekBar;
import android.widget.Spinner;
import android.widget.SpinnerAdapter;
import android.widget.TextView;
import com.html5app.uni_tencent_call.R;
import java.lang.ref.WeakReference;
import java.util.ArrayList;

public class TRTCSettingDialog
extends Dialog {
    private static final String TAG = TRTCSettingDialog.class.getSimpleName();
    private Spinner spSolution;
    private Spinner spFps;
    private SeekBar sbVideoBitrate;
    private CheckBox cbSave;
    private CheckBox cbPriorSmall;
    private CheckBox cbEnableSmall;
    private RadioButton rbSmooth;
    private RadioButton rbClear;
    private RadioButton rbHorizontal;
    private RadioButton rbVertical;
    private RadioButton rbServer;
    private RadioButton rbClient;
    private RadioButton rbVoiceCall;
    private RadioButton rbLive;
    private TextView tvVideoBitrate;
    private TextView tvSubmit;
    private int curRes = 2;
    private ArrayList<TRTCSettingBitrateTable> paramArray;
    private static final String PER_DATA = "per_data";
    private static final String PER_RESOLUTION = "per_resolution";
    private static final String PER_VIDEOFPS = "per_videofps";
    private static final String PER_VIDEOBITRATE = "per_videobitrate";
    private static final String PER_HIGHQUALITY = "per_highquality";
    private static final String PER_VIDEO_ORIENTATION = "per_video_orientation";
    private static final String PER_QOSTYPE = "per_qos_type";
    private static final String PER_CON_TYPE = "per_control_type";
    private static final String PER_APP_SCENCE = "per_app_scence";
    private static final String PER_SAVEFLAG = "per_save_flag";
    private static final String PER_ENABLE_SMALL = "per_enable_small";
    private static final String PER_PRIOR_SMALL = "per_prior_small";
    static final int DEFAULT_BITRATE = 600;
    static final int DEFAULT_FPS = 15;
    private int videoResolution = 108;
    private int videoFps = 15;
    private int videoBitrate = 600;
    private boolean highQuality = true;
    private boolean videoVertical = true;
    private boolean saveFlag = true;
    public boolean enableSmall = false;
    public boolean priorSmall = false;
    private int qosPreference = 2;
    private int qosMode = 1;
    private int appScene = 0;
    private WeakReference<ISettingListener> settingListener;

    public TRTCSettingDialog(Context context, ISettingListener listener) {
        super(context, R.style.room_setting_dlg);
        this.settingListener = new WeakReference<ISettingListener>(listener);
        this.loadCache(context);
    }

    public int getResolution() {
        return this.videoResolution;
    }

    public int getQosPreference() {
        return this.qosPreference;
    }

    public boolean isVideoVertical() {
        return this.videoVertical;
    }

    public int getQosMode() {
        return this.qosMode;
    }

    public int getVideoFps() {
        return this.videoFps;
    }

    public int getVideoBitrate() {
        return this.videoBitrate;
    }

    public int getAppScene() {
        return this.appScene;
    }

    public void show() {
        super.show();
        this.updateDialogValue();
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.dlg_setting);
        this.getWindow().setLayout(-1, -2);
        this.paramArray = new ArrayList();
        this.paramArray.add(new TRTCSettingBitrateTable(3, 250, 40, 300, 10));
        this.paramArray.add(new TRTCSettingBitrateTable(104, 350, 80, 350, 10));
        this.paramArray.add(new TRTCSettingBitrateTable(56, 400, 100, 400, 10));
        this.paramArray.add(new TRTCSettingBitrateTable(7, 500, 200, 1000, 10));
        this.paramArray.add(new TRTCSettingBitrateTable(108, 600, 200, 1000, 10));
        this.paramArray.add(new TRTCSettingBitrateTable(62, 700, 250, 1000, 50));
        this.paramArray.add(new TRTCSettingBitrateTable(110, 900, 400, 1600, 50));
        this.paramArray.add(new TRTCSettingBitrateTable(112, 1250, 500, 2000, 50));
        this.initView();
    }

    private void initView() {
        this.spSolution = (Spinner)this.findViewById(R.id.sp_solution);
        this.spFps = (Spinner)this.findViewById(R.id.sp_video_fps);
        this.sbVideoBitrate = (SeekBar)this.findViewById(R.id.sk_video_bitrate);
        this.cbEnableSmall = (CheckBox)this.findViewById(R.id.cb_enable_small);
        this.cbPriorSmall = (CheckBox)this.findViewById(R.id.cb_prior_small);
        this.cbSave = (CheckBox)this.findViewById(R.id.cb_save);
        this.tvVideoBitrate = (TextView)this.findViewById(R.id.tv_video_bitrate);
        this.tvSubmit = (TextView)this.findViewById(R.id.tv_submit);
        this.rbSmooth = (RadioButton)this.findViewById(R.id.rb_smooth);
        this.rbClear = (RadioButton)this.findViewById(R.id.rb_clear);
        this.rbHorizontal = (RadioButton)this.findViewById(R.id.rb_horizontal);
        this.rbVertical = (RadioButton)this.findViewById(R.id.rb_vertical);
        this.rbClient = (RadioButton)this.findViewById(R.id.rb_client);
        this.rbServer = (RadioButton)this.findViewById(R.id.rb_server);
        this.rbLive = (RadioButton)this.findViewById(R.id.rb_live);
        this.rbVoiceCall = (RadioButton)this.findViewById(R.id.rb_voicecall);
        ArrayAdapter spinnerAadapter = new ArrayAdapter(this.getContext(), R.layout.textview_spinner, (Object[])this.getContext().getResources().getStringArray(R.array.solution));
        this.spSolution.setAdapter((SpinnerAdapter)spinnerAadapter);
        this.spSolution.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener(){

            public void onItemSelected(AdapterView<?> parent, View view, int position, long id2) {
                TRTCSettingDialog.this.curRes = position;
                TRTCSettingDialog.this.updateSolution(TRTCSettingDialog.this.curRes);
            }

            public void onNothingSelected(AdapterView<?> parent) {
            }
        });
        ArrayAdapter spinnerFpsAadapter = new ArrayAdapter(this.getContext(), R.layout.textview_spinner, (Object[])this.getContext().getResources().getStringArray(R.array.video_fps));
        this.spFps.setAdapter((SpinnerAdapter)spinnerFpsAadapter);
        this.spFps.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener(){

            public void onItemSelected(AdapterView<?> parent, View view, int position, long id2) {
                TRTCSettingDialog.this.tvVideoBitrate.setText((CharSequence)("" + TRTCSettingDialog.this.getBitrate(TRTCSettingDialog.this.sbVideoBitrate.getProgress()) + "kbps"));
            }

            public void onNothingSelected(AdapterView<?> parent) {
            }
        });
        this.sbVideoBitrate.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener(){

            public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
                TRTCSettingDialog.this.tvVideoBitrate.setText((CharSequence)("" + TRTCSettingDialog.this.getBitrate(progress) + "kbps"));
            }

            public void onStartTrackingTouch(SeekBar seekBar) {
            }

            public void onStopTrackingTouch(SeekBar seekBar) {
            }
        });
        this.tvSubmit.setClickable(true);
        this.tvSubmit.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                TRTCSettingDialog.this.videoResolution = TRTCSettingDialog.this.getResolution(TRTCSettingDialog.this.spSolution.getSelectedItemPosition());
                TRTCSettingDialog.this.videoFps = TRTCSettingDialog.this.getFps(TRTCSettingDialog.this.spFps.getSelectedItemPosition());
                TRTCSettingDialog.this.videoBitrate = TRTCSettingDialog.this.getBitrate(TRTCSettingDialog.this.sbVideoBitrate.getProgress());
                TRTCSettingDialog.this.qosPreference = TRTCSettingDialog.this.rbSmooth.isChecked() ? 1 : 2;
                TRTCSettingDialog.this.videoVertical = TRTCSettingDialog.this.rbVertical.isChecked();
                TRTCSettingDialog.this.qosMode = TRTCSettingDialog.this.rbClient.isChecked() ? 0 : 1;
                TRTCSettingDialog.this.appScene = TRTCSettingDialog.this.rbLive.isChecked() ? 1 : 0;
                TRTCSettingDialog.this.enableSmall = TRTCSettingDialog.this.cbEnableSmall.isChecked();
                TRTCSettingDialog.this.priorSmall = TRTCSettingDialog.this.cbPriorSmall.isChecked();
                TRTCSettingDialog.this.saveFlag = TRTCSettingDialog.this.cbSave.isChecked();
                if (TRTCSettingDialog.this.saveFlag) {
                    TRTCSettingDialog.this.saveCache(TRTCSettingDialog.this.getContext());
                } else {
                    try {
                        SharedPreferences shareInfo = TRTCSettingDialog.this.getContext().getSharedPreferences(TRTCSettingDialog.PER_DATA, 0);
                        SharedPreferences.Editor editor = shareInfo.edit();
                        editor.putBoolean(TRTCSettingDialog.PER_SAVEFLAG, TRTCSettingDialog.this.saveFlag);
                        editor.commit();
                    }
                    catch (Exception shareInfo) {
                        // empty catch block
                    }
                }
                ISettingListener api = (ISettingListener)TRTCSettingDialog.this.settingListener.get();
                if (api != null) {
                    api.onComplete();
                }
                TRTCSettingDialog.this.dismiss();
            }
        });
    }

    private void updateDialogValue() {
        this.curRes = this.getResolutionPos(this.videoResolution);
        this.spSolution.setSelection(this.curRes);
        this.cbSave.setChecked(this.saveFlag);
        this.cbPriorSmall.setChecked(this.priorSmall);
        this.cbEnableSmall.setChecked(this.enableSmall);
        this.updateSolution(this.curRes);
        this.spFps.setSelection(this.getFpsPos(this.videoFps));
        this.sbVideoBitrate.setProgress(this.getBitrateProgress(this.videoBitrate));
        this.tvVideoBitrate.setText((CharSequence)("" + this.getBitrate(this.sbVideoBitrate.getProgress()) + "kbps"));
        this.rbVertical.setChecked(this.videoVertical);
        this.rbHorizontal.setChecked(!this.videoVertical);
        if (this.qosPreference == 1) {
            this.rbSmooth.setChecked(true);
        } else {
            this.rbClear.setChecked(true);
        }
        if (this.qosMode == 0) {
            this.rbClient.setChecked(true);
        } else {
            this.rbServer.setChecked(true);
        }
        if (this.appScene == 1) {
            this.rbLive.setChecked(true);
        } else {
            this.rbVoiceCall.setChecked(true);
        }
    }

    private int getResolutionPos(int resolution) {
        for (int i = 0; i < this.paramArray.size(); ++i) {
            if (resolution != this.paramArray.get((int)i).resolution) continue;
            return i;
        }
        return 4;
    }

    private int getResolution(int pos) {
        if (pos >= 0 && pos < this.paramArray.size()) {
            return this.paramArray.get((int)pos).resolution;
        }
        return 108;
    }

    private int getFpsPos(int fps) {
        switch (fps) {
            case 15: {
                return 0;
            }
            case 20: {
                return 1;
            }
        }
        return 0;
    }

    private int getFps(int pos) {
        switch (pos) {
            case 0: {
                return 15;
            }
            case 1: {
                return 20;
            }
        }
        return 15;
    }

    private int getMinBitrate(int pos) {
        if (pos >= 0 && pos < this.paramArray.size()) {
            return this.paramArray.get((int)pos).minBitrate;
        }
        return 300;
    }

    private int getMaxBitrate(int pos) {
        if (pos >= 0 && pos < this.paramArray.size()) {
            return this.paramArray.get((int)pos).maxBitrate;
        }
        return 1000;
    }

    private int getDefBitrate(int pos) {
        if (pos >= 0 && pos < this.paramArray.size()) {
            return this.paramArray.get((int)pos).defaultBitrate;
        }
        return 400;
    }

    private int getStepBitrate(int pos) {
        if (pos >= 0 && pos < this.paramArray.size()) {
            return this.paramArray.get((int)pos).step;
        }
        return 10;
    }

    private int getBitrateProgress(int bitrate) {
        int minBitrate = this.getMinBitrate(this.curRes);
        int stepBitrate = this.getStepBitrate(this.curRes);
        int progress = (bitrate - minBitrate) / stepBitrate;
        Log.e((String)TAG, (String)("getBitrateProgress->progress: " + progress + ", min: " + minBitrate + ", stepBitrate: " + stepBitrate + "/" + bitrate));
        return progress;
    }

    private int getBitrate(int progress) {
        int minBitrate = this.getMinBitrate(this.curRes);
        int maxBitrate = this.getMaxBitrate(this.curRes);
        int stepBitrate = this.getStepBitrate(this.curRes);
        int bit = progress * stepBitrate + minBitrate;
        Log.e((String)TAG, (String)("getBitrate->bit: " + bit + ", min: " + minBitrate + ", max: " + maxBitrate));
        return bit;
    }

    private void updateSolution(int pos) {
        int minBitrate = this.getMinBitrate(this.curRes);
        int maxBitrate = this.getMaxBitrate(this.curRes);
        int stepBitrate = this.getStepBitrate(this.curRes);
        int max = (maxBitrate - minBitrate) / stepBitrate;
        if (this.sbVideoBitrate.getMax() != max) {
            this.sbVideoBitrate.setMax(max);
            int defBitrate = this.getDefBitrate(this.curRes);
            this.sbVideoBitrate.setProgress(this.getBitrateProgress(defBitrate));
        } else {
            this.sbVideoBitrate.setMax(max);
        }
    }

    private void saveCache(Context context) {
        try {
            SharedPreferences shareInfo = context.getSharedPreferences(PER_DATA, 0);
            SharedPreferences.Editor editor = shareInfo.edit();
            editor.putInt(PER_RESOLUTION, this.videoResolution);
            editor.putInt(PER_VIDEOFPS, this.videoFps);
            editor.putInt(PER_VIDEOBITRATE, this.videoBitrate);
            editor.putBoolean(PER_HIGHQUALITY, this.highQuality);
            editor.putBoolean(PER_VIDEO_ORIENTATION, this.videoVertical);
            editor.putInt(PER_QOSTYPE, this.qosPreference);
            editor.putInt(PER_CON_TYPE, this.qosMode);
            editor.putInt(PER_APP_SCENCE, this.appScene);
            editor.putBoolean(PER_SAVEFLAG, this.saveFlag);
            editor.putBoolean(PER_ENABLE_SMALL, this.enableSmall);
            editor.putBoolean(PER_PRIOR_SMALL, this.priorSmall);
            editor.commit();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void loadCache(Context context) {
        try {
            SharedPreferences shareInfo = context.getSharedPreferences(PER_DATA, 0);
            this.videoResolution = shareInfo.getInt(PER_RESOLUTION, 108);
            this.videoFps = shareInfo.getInt(PER_VIDEOFPS, 15);
            this.videoBitrate = shareInfo.getInt(PER_VIDEOBITRATE, 600);
            this.highQuality = shareInfo.getBoolean(PER_HIGHQUALITY, true);
            this.videoVertical = shareInfo.getBoolean(PER_VIDEO_ORIENTATION, this.videoVertical);
            this.qosPreference = shareInfo.getInt(PER_QOSTYPE, 2);
            this.saveFlag = shareInfo.getBoolean(PER_SAVEFLAG, true);
            this.enableSmall = shareInfo.getBoolean(PER_ENABLE_SMALL, false);
            this.priorSmall = shareInfo.getBoolean(PER_PRIOR_SMALL, false);
            this.qosMode = shareInfo.getInt(PER_CON_TYPE, 1);
            this.appScene = shareInfo.getInt(PER_APP_SCENCE, 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static interface ISettingListener {
        public void onComplete();
    }

    static class TRTCSettingBitrateTable {
        public int resolution;
        public int defaultBitrate;
        public int minBitrate;
        public int maxBitrate;
        public int step;

        public TRTCSettingBitrateTable(int resolution, int defaultBitrate, int minBitrate, int maxBitrate, int step) {
            this.resolution = resolution;
            this.defaultBitrate = defaultBitrate;
            this.minBitrate = minBitrate;
            this.maxBitrate = maxBitrate;
            this.step = step;
        }
    }
}

