/*
 * Decompiled with CFR 0.152.
 */
package com.html5app.uni_tencent_call;

import android.content.Context;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestBuilder;
import com.html5app.uni_tencent_call.R;
import com.tencent.rtmp.ui.TXCloudVideoView;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;

public class TRTCVideoViewLayout
extends RelativeLayout {
    private static final String TAG = TRTCVideoViewLayout.class.getSimpleName();
    public static final int MODE_FLOAT = 1;
    public static final int MODE_GRID = 2;
    public static final int MAX_USER = 7;
    private Context mContext;
    private ArrayList<TXCloudVideoView> mVideoViewList;
    private ArrayList<RelativeLayout.LayoutParams> mFloatParamList;
    private ArrayList<RelativeLayout.LayoutParams> mGrid1ParamList;
    private ArrayList<RelativeLayout.LayoutParams> mGrid4ParamList;
    private ArrayList<RelativeLayout.LayoutParams> mGrid9ParamList;
    private RelativeLayout mLayout;
    private int mCount = 0;
    private int mMode;
    private String mSelfUserId;
    private WeakReference<ITRTCVideoViewLayoutListener> mListener = new WeakReference<Object>(null);
    HashMap<Integer, Integer> mapNetworkQuality = null;

    public TRTCVideoViewLayout(Context context) {
        super(context);
        this.initView(context);
    }

    public TRTCVideoViewLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView(context);
    }

    public TRTCVideoViewLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView(context);
    }

    public void setUserId(String userId) {
        this.mSelfUserId = userId;
    }

    public void setListener(ITRTCVideoViewLayoutListener listener) {
        this.mListener = new WeakReference<ITRTCVideoViewLayoutListener>(listener);
    }

    private void initView(Context context) {
        this.mContext = context;
        LayoutInflater.from((Context)context).inflate(R.layout.room_show_view, (ViewGroup)this);
        this.mLayout = (RelativeLayout)this.findViewById(R.id.ll_mainview);
        this.initFloatLayoutParams();
        this.initTXCloudVideoView();
        this.initGridLayoutParams();
        this.showView();
        this.mapNetworkQuality = new HashMap();
        this.mMode = 1;
    }

    private void showView() {
        this.mLayout.removeAllViews();
        for (int i = 0; i < this.mVideoViewList.size(); ++i) {
            TXCloudVideoView cloudVideoView = this.mVideoViewList.get(i);
            RelativeLayout.LayoutParams layoutParams = this.mFloatParamList.get(i);
            cloudVideoView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            this.mLayout.addView((View)cloudVideoView);
        }
    }

    public void initGridLayoutParams() {
        this.mGrid4ParamList = new ArrayList();
        this.mGrid9ParamList = new ArrayList();
        this.mGrid1ParamList = new ArrayList();
        int statusH = this.getStatusBarHeight(this.mContext);
        int screenW = this.getScreenWidth(this.mContext);
        int screenH = this.getScreenHeight(this.mContext);
        int bottomMargin = this.dip2px(50.0f);
        int margin = this.dip2px(10.0f);
        this.initGrid4Param(statusH, screenW, screenH, bottomMargin, margin);
        this.initGrid9Param(statusH, screenW, screenH, bottomMargin, margin);
    }

    private void initGrid1Param(int statusH, int screenW, int screenH, int bottomMargin, int margin) {
        int grid4W = (screenW - margin * 2) / 2;
        int grid4H = (screenH - statusH - margin * 2 - bottomMargin) / 2;
        RelativeLayout.LayoutParams layoutParams0 = new RelativeLayout.LayoutParams(grid4W, grid4H);
        layoutParams0.addRule(11);
        layoutParams0.addRule(10);
        layoutParams0.topMargin = 20;
        layoutParams0.rightMargin = 20;
        this.mGrid1ParamList.add(layoutParams0);
    }

    private void initGrid4Param(int statusH, int screenW, int screenH, int bottomMargin, int margin) {
        int grid4W = (screenW - margin * 2) / 2;
        int grid4H = (screenH - statusH - margin * 2 - bottomMargin) / 2;
        RelativeLayout.LayoutParams layoutParams0 = new RelativeLayout.LayoutParams(grid4W, grid4H);
        layoutParams0.addRule(9);
        layoutParams0.addRule(10);
        layoutParams0.topMargin = margin;
        layoutParams0.leftMargin = margin;
        RelativeLayout.LayoutParams layoutParams1 = new RelativeLayout.LayoutParams(grid4W, grid4H);
        layoutParams1.addRule(11);
        layoutParams1.addRule(10);
        layoutParams1.topMargin = margin;
        layoutParams1.rightMargin = margin;
        RelativeLayout.LayoutParams layoutParams2 = new RelativeLayout.LayoutParams(grid4W, grid4H);
        layoutParams2.addRule(9);
        layoutParams2.addRule(12);
        layoutParams2.bottomMargin = margin + bottomMargin;
        layoutParams2.leftMargin = margin;
        RelativeLayout.LayoutParams layoutParams3 = new RelativeLayout.LayoutParams(grid4W, grid4H);
        layoutParams3.addRule(11);
        layoutParams3.addRule(12);
        layoutParams3.bottomMargin = margin + bottomMargin;
        layoutParams3.rightMargin = margin;
        this.mGrid4ParamList.add(layoutParams0);
        this.mGrid4ParamList.add(layoutParams1);
        this.mGrid4ParamList.add(layoutParams2);
        this.mGrid4ParamList.add(layoutParams3);
    }

    private void initGrid9Param(int statusH, int screenW, int screenH, int bottomMargin, int margin) {
        int grid9W = (screenW - margin * 2) / 3;
        int grid9H = (screenH - statusH - margin * 2 - bottomMargin) / 3;
        RelativeLayout.LayoutParams layoutParams0 = new RelativeLayout.LayoutParams(grid9W, grid9H);
        layoutParams0.addRule(9);
        layoutParams0.addRule(10);
        layoutParams0.topMargin = margin;
        layoutParams0.leftMargin = margin;
        RelativeLayout.LayoutParams layoutParams1 = new RelativeLayout.LayoutParams(grid9W, grid9H);
        layoutParams1.addRule(14);
        layoutParams1.addRule(10);
        layoutParams1.topMargin = margin;
        RelativeLayout.LayoutParams layoutParams2 = new RelativeLayout.LayoutParams(grid9W, grid9H);
        layoutParams2.addRule(11);
        layoutParams2.addRule(10);
        layoutParams2.topMargin = margin;
        layoutParams2.rightMargin = margin;
        RelativeLayout.LayoutParams layoutParams3 = new RelativeLayout.LayoutParams(grid9W, grid9H);
        layoutParams3.addRule(10);
        layoutParams3.addRule(9);
        layoutParams3.leftMargin = margin;
        layoutParams3.topMargin = margin + grid9H;
        RelativeLayout.LayoutParams layoutParams4 = new RelativeLayout.LayoutParams(grid9W, grid9H);
        layoutParams4.addRule(14);
        layoutParams4.topMargin = margin + grid9H;
        RelativeLayout.LayoutParams layoutParams5 = new RelativeLayout.LayoutParams(grid9W, grid9H);
        layoutParams5.addRule(10);
        layoutParams5.addRule(11);
        layoutParams5.topMargin = margin + grid9H;
        layoutParams5.rightMargin = margin;
        RelativeLayout.LayoutParams layoutParams6 = new RelativeLayout.LayoutParams(grid9W, grid9H);
        layoutParams6.addRule(9);
        layoutParams6.addRule(12);
        layoutParams6.bottomMargin = margin + bottomMargin;
        layoutParams6.leftMargin = margin;
        RelativeLayout.LayoutParams layoutParams7 = new RelativeLayout.LayoutParams(grid9W, grid9H);
        layoutParams7.addRule(14);
        layoutParams7.addRule(12);
        layoutParams7.bottomMargin = margin + bottomMargin;
        RelativeLayout.LayoutParams layoutParams8 = new RelativeLayout.LayoutParams(grid9W, grid9H);
        layoutParams8.addRule(11);
        layoutParams8.addRule(12);
        layoutParams8.bottomMargin = margin + bottomMargin;
        layoutParams8.rightMargin = margin;
        this.mGrid9ParamList.add(layoutParams0);
        this.mGrid9ParamList.add(layoutParams1);
        this.mGrid9ParamList.add(layoutParams2);
        this.mGrid9ParamList.add(layoutParams3);
        this.mGrid9ParamList.add(layoutParams4);
        this.mGrid9ParamList.add(layoutParams5);
        this.mGrid9ParamList.add(layoutParams6);
        this.mGrid9ParamList.add(layoutParams7);
        this.mGrid9ParamList.add(layoutParams8);
    }

    public void initFloatLayoutParams() {
        RelativeLayout.LayoutParams layoutParams;
        int i;
        this.mFloatParamList = new ArrayList();
        RelativeLayout.LayoutParams layoutParams0 = new RelativeLayout.LayoutParams(-1, -1);
        this.mFloatParamList.add(layoutParams0);
        int midMargin = this.dip2px(10.0f);
        int lrMargin = this.dip2px(15.0f);
        int bottomMargin = this.dip2px(50.0f);
        int subWidth = this.dip2px(120.0f);
        int subHeight = this.dip2px(180.0f);
        for (i = 2; i >= 0; --i) {
            layoutParams = new RelativeLayout.LayoutParams(subWidth, subHeight);
            layoutParams.addRule(12);
            layoutParams.addRule(11);
            layoutParams.rightMargin = lrMargin;
            layoutParams.bottomMargin = bottomMargin + midMargin * (i + 1) + subHeight * i;
            this.mFloatParamList.add(layoutParams);
        }
        for (i = 0; i < 3; ++i) {
            layoutParams = new RelativeLayout.LayoutParams(subWidth, subHeight);
            layoutParams.addRule(12);
            layoutParams.addRule(9);
            layoutParams.leftMargin = lrMargin;
            layoutParams.bottomMargin = bottomMargin + midMargin * (i + 1) + subHeight * i;
            this.mFloatParamList.add(layoutParams);
        }
    }

    public void initTXCloudVideoView() {
        this.mVideoViewList = new ArrayList();
        for (int i = 0; i < 7; ++i) {
            TXCloudVideoView cloudVideoView = new TXCloudVideoView(this.mContext);
            cloudVideoView.setVisibility(8);
            cloudVideoView.setId(1000 + i);
            cloudVideoView.setClickable(true);
            cloudVideoView.setTag(R.string.str_tag_pos, (Object)i);
            cloudVideoView.setBackgroundColor(-16777216);
            this.addToolbarLayout(cloudVideoView);
            this.mVideoViewList.add(i, cloudVideoView);
        }
    }

    public TXCloudVideoView getCloudVideoViewByIndex(int index) {
        return this.mVideoViewList.get(index);
    }

    public TXCloudVideoView getCloudVideoViewByUseId(String userId) {
        for (TXCloudVideoView videoView : this.mVideoViewList) {
            String tempUserID = videoView.getUserId();
            if (tempUserID == null || !tempUserID.equalsIgnoreCase(userId)) continue;
            return videoView;
        }
        return null;
    }

    public void updateLayoutFloat() {
        for (int i = 0; i < this.mVideoViewList.size(); ++i) {
            TXCloudVideoView cloudVideoView = this.mVideoViewList.get(i);
            if (i < this.mFloatParamList.size()) {
                RelativeLayout.LayoutParams layoutParams = this.mFloatParamList.get(i);
                cloudVideoView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            }
            cloudVideoView.setTag(R.string.str_tag_pos, (Object)i);
            cloudVideoView.setClickable(true);
            cloudVideoView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    Object object = v.getTag(R.string.str_tag_pos);
                    if (object != null) {
                        int pos = (Integer)object;
                        TXCloudVideoView renderView = (TXCloudVideoView)v;
                        if (null != renderView.getUserId()) {
                            TRTCVideoViewLayout.this.swapViewByIndex(0, pos);
                        }
                    }
                }
            });
            if (i == 0) continue;
            this.mLayout.bringChildToFront((View)cloudVideoView);
        }
    }

    public void updateLayoutGrid() {
        ArrayList<RelativeLayout.LayoutParams> paramList = null;
        Log.i((String)"updateLayoutGrid", (String)(this.mCount + ""));
        if (this.mCount <= 4) {
            paramList = this.mGrid4ParamList;
        } else if (this.mCount > 5) {
            paramList = this.mGrid9ParamList;
        }
        int layoutIndex = 1;
        for (int i = 0; i < this.mVideoViewList.size(); ++i) {
            TXCloudVideoView cloudVideoView = this.mVideoViewList.get(i);
            cloudVideoView.setClickable(false);
            cloudVideoView.setOnClickListener(null);
            String userId = cloudVideoView.getUserId();
            if (TextUtils.isEmpty((CharSequence)userId)) continue;
            if (userId.equalsIgnoreCase(this.mSelfUserId)) {
                cloudVideoView.setLayoutParams((ViewGroup.LayoutParams)paramList.get(0));
                continue;
            }
            if (layoutIndex >= paramList.size()) continue;
            cloudVideoView.setLayoutParams((ViewGroup.LayoutParams)paramList.get(layoutIndex++));
        }
    }

    public int changeMode() {
        if (this.mMode == 1) {
            this.mMode = 2;
            this.updateLayoutGrid();
        } else {
            this.mMode = 1;
            this.updateLayoutFloat();
        }
        this.freshToolbarLayout();
        return this.mMode;
    }

    public void swapViewByIndex(int src, int dst) {
        TXCloudVideoView srcView = this.mVideoViewList.get(src);
        TXCloudVideoView dstView = this.mVideoViewList.get(dst);
        this.mVideoViewList.set(src, dstView);
        this.mVideoViewList.set(dst, srcView);
        if (this.mMode == 1) {
            this.updateLayoutFloat();
        } else {
            this.updateLayoutGrid();
        }
    }

    public void appendEventMessage(String userId, String message) {
        for (int i = 0; i < this.mVideoViewList.size(); ++i) {
            if (!userId.equalsIgnoreCase(this.mVideoViewList.get(i).getUserId())) continue;
            this.mVideoViewList.get(i).appendEventInfo(message);
            break;
        }
    }

    public int dip2px(float dpValue) {
        float scale = this.getResources().getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }

    public void showDebugView(int type) {
        for (int i = 0; i < this.mVideoViewList.size(); ++i) {
            String vUserId;
            TXCloudVideoView renderView = this.mVideoViewList.get(i);
            if (renderView == null || TextUtils.isEmpty((CharSequence)(vUserId = renderView.getUserId()))) continue;
            renderView.showVideoDebugLog(type);
        }
    }

    public TXCloudVideoView onMemberEnter(String userId) {
        Log.e((String)TAG, (String)("onMemberEnter: userId = " + userId));
        if (TextUtils.isEmpty((CharSequence)userId)) {
            return null;
        }
        TXCloudVideoView videoView = null;
        int posIdx = 0;
        int posLocal = this.mVideoViewList.size();
        for (int i = 0; i < this.mVideoViewList.size(); ++i) {
            TXCloudVideoView renderView = this.mVideoViewList.get(i);
            if (renderView == null) continue;
            String vUserId = renderView.getUserId();
            if (userId.equalsIgnoreCase(vUserId)) {
                return renderView;
            }
            if (videoView == null && TextUtils.isEmpty((CharSequence)vUserId)) {
                renderView.setUserId(userId);
                videoView = renderView;
                posIdx = i;
                ++this.mCount;
                continue;
            }
            if (TextUtils.isEmpty((CharSequence)vUserId) || !vUserId.equalsIgnoreCase(this.mSelfUserId)) continue;
            posLocal = i;
        }
        if (0 == posLocal) {
            this.swapViewByIndex(posIdx, posLocal);
        }
        if (this.mMode == 1) {
            this.updateLayoutFloat();
        } else {
            this.updateLayoutGrid();
        }
        return videoView;
    }

    public void onMemberLeave(String userId) {
        Log.e((String)TAG, (String)("onMemberLeave: userId = " + userId));
        int posIdx = 0;
        int posLocal = this.mVideoViewList.size();
        for (int i = 0; i < this.mVideoViewList.size(); ++i) {
            TXCloudVideoView renderView = this.mVideoViewList.get(i);
            if (renderView == null || null == renderView.getUserId()) continue;
            if (renderView.getUserId().equals(userId)) {
                renderView.setUserId(null);
                renderView.setVisibility(8);
                this.freshToolbarLayoutOnMemberLeave(renderView);
                posIdx = i;
                --this.mCount;
                continue;
            }
            if (!renderView.getUserId().equalsIgnoreCase(this.mSelfUserId)) continue;
            posLocal = i;
        }
        if (0 == posIdx) {
            this.swapViewByIndex(posIdx, posLocal);
        }
        if (this.mMode == 1) {
            this.updateLayoutFloat();
        } else {
            this.updateLayoutGrid();
        }
    }

    public void onRoomEnter() {
        ++this.mCount;
        if (this.mMode == 1) {
            this.updateLayoutFloat();
        } else {
            this.updateLayoutGrid();
        }
    }

    public int getScreenWidth(Context context) {
        if (context == null) {
            return 0;
        }
        DisplayMetrics dm = context.getResources().getDisplayMetrics();
        return dm.widthPixels;
    }

    public int getScreenHeight(Context context) {
        if (context == null) {
            return 0;
        }
        DisplayMetrics dm = context.getResources().getDisplayMetrics();
        return dm.heightPixels;
    }

    public int getStatusBarHeight(Context context) {
        int statusBarHeight1 = -1;
        int resourceId = context.getResources().getIdentifier("status_bar_height", "dimen", "android");
        if (resourceId > 0) {
            statusBarHeight1 = context.getResources().getDimensionPixelSize(resourceId);
        }
        return statusBarHeight1;
    }

    private void addToolbarLayout(final TXCloudVideoView videoView) {
        View view = videoView.findViewById(R.id.layout_toolbar);
        if (view == null) {
            view = LayoutInflater.from((Context)this.mContext).inflate(R.layout.layout_toolbar, (ViewGroup)videoView);
            view.setVisibility(8);
            final Button btnRemoteVideo = (Button)view.findViewById(R.id.btn_remote_video);
            btnRemoteVideo.setTag((Object)R.mipmap.remote_video_enable);
            btnRemoteVideo.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    String userId = videoView.getUserId();
                    if (userId != null && userId.length() > 0) {
                        userId = userId.substring(0, userId.length() - 1);
                    }
                    if (userId != null && userId.length() > 0) {
                        int currentTag = (Integer)btnRemoteVideo.getTag();
                        boolean enable = currentTag != R.mipmap.remote_video_enable;
                        ITRTCVideoViewLayoutListener listener = (ITRTCVideoViewLayoutListener)TRTCVideoViewLayout.this.mListener.get();
                        if (listener != null) {
                            listener.onEnableRemoteVideo(userId, enable);
                        }
                        btnRemoteVideo.setTag((Object)(enable ? R.mipmap.remote_video_enable : R.mipmap.remote_video_disable));
                        btnRemoteVideo.setBackgroundResource(enable ? R.mipmap.remote_video_enable : R.mipmap.remote_video_disable);
                    }
                }
            });
            final Button btnRemoteAudio = (Button)view.findViewById(R.id.btn_remote_audio);
            btnRemoteAudio.setTag((Object)R.mipmap.remote_audio_enable);
            btnRemoteAudio.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    String userId = videoView.getUserId();
                    if (userId != null && userId.length() > 0) {
                        userId = userId.substring(0, userId.length() - 1);
                    }
                    if (userId != null && userId.length() > 0) {
                        int currentTag = (Integer)btnRemoteAudio.getTag();
                        boolean enable = currentTag != R.mipmap.remote_audio_enable;
                        ITRTCVideoViewLayoutListener listener = (ITRTCVideoViewLayoutListener)TRTCVideoViewLayout.this.mListener.get();
                        if (listener != null) {
                            listener.onEnableRemoteAudio(userId, enable);
                        }
                        btnRemoteAudio.setTag((Object)(enable ? R.mipmap.remote_audio_enable : R.mipmap.remote_audio_disable));
                        btnRemoteAudio.setBackgroundResource(enable ? R.mipmap.remote_audio_enable : R.mipmap.remote_audio_disable);
                    }
                }
            });
            final Button btnFillMode = (Button)view.findViewById(R.id.btn_fill_mode);
            btnFillMode.setTag((Object)R.mipmap.fill_scale);
            btnFillMode.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    String userId = videoView.getUserId();
                    if (userId != null && userId.length() > 0) {
                        userId = userId.substring(0, userId.length() - 1);
                    }
                    if (userId != null && userId.length() > 0) {
                        int currentTag = (Integer)btnFillMode.getTag();
                        boolean adjustMode = currentTag != R.mipmap.fill_scale;
                        ITRTCVideoViewLayoutListener listener = (ITRTCVideoViewLayoutListener)TRTCVideoViewLayout.this.mListener.get();
                        if (listener != null) {
                            listener.onChangeVideoFillMode(userId, adjustMode);
                        }
                        btnFillMode.setTag((Object)(adjustMode ? R.mipmap.fill_scale : R.mipmap.fill_adjust));
                        btnFillMode.setBackgroundResource(adjustMode ? R.mipmap.fill_scale : R.mipmap.fill_adjust);
                    }
                }
            });
        }
    }

    private void clearVideoViewExtraData(TXCloudVideoView videoView) {
        Button btnRemoteVideo = (Button)videoView.findViewById(R.id.btn_remote_video);
        btnRemoteVideo.setTag((Object)R.mipmap.remote_video_enable);
        btnRemoteVideo.setBackgroundResource(R.mipmap.remote_video_enable);
        Button btnRemoteAudio = (Button)videoView.findViewById(R.id.btn_remote_audio);
        btnRemoteAudio.setTag((Object)R.mipmap.remote_audio_enable);
        btnRemoteAudio.setBackgroundResource(R.mipmap.remote_audio_enable);
        Button btnFillMode = (Button)videoView.findViewById(R.id.btn_fill_mode);
        btnFillMode.setTag((Object)R.mipmap.fill_scale);
        btnFillMode.setBackgroundResource(R.mipmap.fill_scale);
    }

    public void freshToolbarLayout() {
        for (TXCloudVideoView videoView : this.mVideoViewList) {
            String userId = videoView.getUserId();
            View layoutToolbar = videoView.findViewById(R.id.layout_toolbar);
            if (userId != null && !userId.isEmpty()) {
                if (userId.equalsIgnoreCase(this.mSelfUserId)) {
                    Object tag;
                    View view = videoView.findViewById(R.id.layout_no_video);
                    if (view != null && (tag = view.getTag()) != null) {
                        if ((Integer)tag == 0) {
                            view.setVisibility(0);
                            if (layoutToolbar != null) {
                                layoutToolbar.bringToFront();
                                layoutToolbar.setVisibility(0);
                            }
                        } else {
                            view.setVisibility(8);
                        }
                    }
                    this.showToolbarButtons(videoView, false);
                    continue;
                }
                if (videoView.getVisibility() == 0) {
                    if (layoutToolbar == null) continue;
                    layoutToolbar.bringToFront();
                    layoutToolbar.setVisibility(0);
                    this.showToolbarButtons(videoView, this.mMode == 2);
                    continue;
                }
                layoutToolbar.setVisibility(8);
                this.freshToolbarLayoutOnMemberLeave(videoView);
                continue;
            }
            layoutToolbar.setVisibility(8);
            this.freshToolbarLayoutOnMemberLeave(videoView);
        }
    }

    public void freshToolbarLayoutOnMemberEnter(String userID) {
        for (TXCloudVideoView videoView : this.mVideoViewList) {
            View layoutToolbar;
            String tempUserID = videoView.getUserId();
            if (tempUserID == null || !tempUserID.equalsIgnoreCase(userID) || (layoutToolbar = videoView.findViewById(R.id.layout_toolbar)) == null) continue;
            layoutToolbar.bringToFront();
            layoutToolbar.setVisibility(0);
            this.showToolbarButtons(videoView, this.mMode == 2);
        }
    }

    private void freshToolbarLayoutOnMemberLeave(TXCloudVideoView videoView) {
        this.showAudioVolumeProgressBar(videoView, false);
        this.showToolbarButtons(videoView, false);
        this.showNoVideoLayout(videoView, false);
        this.clearVideoViewExtraData(videoView);
    }

    private void showToolbarButtons(TXCloudVideoView videoView, boolean bShow) {
        View view = videoView.findViewById(R.id.toolbar_buttons);
        if (view != null) {
            view.setVisibility(bShow ? 0 : 8);
        }
    }

    public void hideAudioVolumeProgressBar() {
        for (TXCloudVideoView videoView : this.mVideoViewList) {
            this.showAudioVolumeProgressBar(videoView, false);
        }
    }

    private void showAudioVolumeProgressBar(TXCloudVideoView videoView, boolean bShow) {
        View view = videoView.findViewById(R.id.audio_volume);
        if (view != null) {
            view.setVisibility(bShow ? 0 : 8);
        }
    }

    private void showNoVideoLayout(TXCloudVideoView videoView, boolean bShow) {
        View view = videoView.findViewById(R.id.layout_no_video);
        if (view != null) {
            view.setVisibility(bShow ? 0 : 8);
            view.setTag((Object)(bShow ? 0 : 8));
        }
    }

    public void updateAudioVolume(String userID, int audioVolume) {
        for (TXCloudVideoView videoView : this.mVideoViewList) {
            ProgressBar progressBar;
            int maxVolume;
            int adjustVolume;
            String tempUserID;
            if (videoView.getVisibility() != 0 || (tempUserID = videoView.getUserId()) == null || !tempUserID.startsWith(userID)) continue;
            View layoutToolbar = videoView.findViewById(R.id.layout_toolbar);
            if (layoutToolbar != null) {
                layoutToolbar.bringToFront();
                layoutToolbar.setVisibility(0);
            }
            if ((adjustVolume = (int)Math.ceil((maxVolume = 15) * audioVolume / maxVolume)) < 0) {
                adjustVolume = 0;
            }
            if (adjustVolume > maxVolume) {
                adjustVolume = maxVolume;
            }
            if ((progressBar = (ProgressBar)videoView.findViewById(R.id.audio_volume)) == null) continue;
            progressBar.setVisibility(0);
            progressBar.setMax(maxVolume);
            progressBar.setProgress(adjustVolume);
        }
    }

    public void updateNetworkQuality(String userID, int quality) {
        for (TXCloudVideoView videoView : this.mVideoViewList) {
            String tempUserID;
            if (videoView.getVisibility() != 0 || (tempUserID = videoView.getUserId()) == null || !tempUserID.startsWith(userID)) continue;
            ImageView imageView = (ImageView)videoView.findViewById(videoView.hashCode());
            if (imageView == null) {
                imageView = new ImageView(this.mContext);
                imageView.setId(videoView.hashCode());
                FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(60, 45, 53);
                params.setMargins(0, 8, 8, 0);
                videoView.addView((View)imageView, (ViewGroup.LayoutParams)params);
            }
            if (quality < 1) {
                quality = 1;
            }
            if (quality > 6) {
                quality = 6;
            }
            if (imageView == null) continue;
            imageView.bringToFront();
            imageView.setVisibility(0);
            imageView.setImageResource(this.mapNetworkQuality.get(quality).intValue());
        }
    }

    public void updateVideoStatus(String userID, boolean bHasVideo, boolean iswting, String username, String avatar, String myname, String myavatar, String join, String promptText) {
        for (TXCloudVideoView videoView : this.mVideoViewList) {
            if (videoView.getVisibility() != 0) continue;
            Log.i((String)"updateVideoStatus", (String)("====videoView===v=" + videoView.getUserId()));
            String tempUserID = videoView.getUserId();
            if (tempUserID == null || !tempUserID.startsWith(userID)) continue;
            TextView textView = (TextView)videoView.findViewById(R.id.textview_userid);
            TextView textview_wting = (TextView)videoView.findViewById(R.id.textview_wting);
            ImageView user_avatar = (ImageView)videoView.findViewById(R.id.user_avatar);
            if (textView != null) {
                if (this.mSelfUserId.equalsIgnoreCase(userID)) {
                    if (!TextUtils.isEmpty((CharSequence)myname)) {
                        userID = myname;
                    } else {
                        userID = "\u60a8\u81ea\u5df1";
                        textview_wting.setText((CharSequence)promptText);
                    }
                    textView.setText((CharSequence)userID);
                    if (!TextUtils.isEmpty((CharSequence)myavatar)) {
                        ((RequestBuilder)Glide.with((View)videoView).load(myavatar).centerCrop()).into(user_avatar);
                    } else {
                        user_avatar.setImageResource(R.drawable.avater);
                    }
                } else {
                    if (!TextUtils.isEmpty((CharSequence)avatar)) {
                        ((RequestBuilder)Glide.with((View)videoView).load(avatar).centerCrop()).into(user_avatar);
                    }
                    if (!TextUtils.isEmpty((CharSequence)username)) {
                        userID = username;
                    }
                    textView.setText((CharSequence)userID);
                }
                if (iswting) {
                    if (!TextUtils.isEmpty((CharSequence)avatar)) {
                        ((RequestBuilder)Glide.with((View)videoView).load(avatar).centerCrop()).into(user_avatar);
                    }
                    Log.i((String)"updateVideoStatus", (String)"====bHasVideo====01");
                } else {
                    Log.i((String)"updateVideoStatus", (String)"====bHasVideo====02");
                    textview_wting.setVisibility(0);
                    textview_wting.setText((CharSequence)promptText);
                }
                user_avatar.setVisibility(0);
            }
            if (!bHasVideo) {
                View layoutToolbar = videoView.findViewById(R.id.layout_toolbar);
                TextView textView01 = (TextView)layoutToolbar.findViewById(R.id.textview_userid);
                TextView textview_wting01 = (TextView)layoutToolbar.findViewById(R.id.textview_wting);
                ImageView user_avatar01 = (ImageView)layoutToolbar.findViewById(R.id.user_avatar);
                Log.i((String)"updateVideoStatus", (String)"====bHasVideo====");
                if (layoutToolbar != null) {
                    layoutToolbar.bringToFront();
                    if (join.equals("join") || !iswting && TextUtils.isEmpty((CharSequence)join)) {
                        Log.i((String)"updateVideoStatus", (String)"====bHasVideo===userID=");
                        if (!TextUtils.isEmpty((CharSequence)myname)) {
                            userID = myname;
                        } else if (!join.equals("all")) {
                            userID = "\u60a8\u81ea\u5df1";
                        }
                        textView01.setText((CharSequence)userID);
                        if (!TextUtils.isEmpty((CharSequence)myavatar)) {
                            ((RequestBuilder)Glide.with((View)layoutToolbar).load(myavatar).centerCrop()).into(user_avatar01);
                        } else {
                            user_avatar.setImageResource(R.drawable.avater);
                        }
                    } else {
                        Log.i((String)"updateVideoStatus", (String)("====bHasVideo===no=userID=avatar==" + avatar));
                        if (!TextUtils.isEmpty((CharSequence)avatar)) {
                            ((RequestBuilder)Glide.with((View)layoutToolbar).load(avatar).centerCrop()).into(user_avatar01);
                        } else {
                            user_avatar01.setImageResource(R.drawable.avater);
                        }
                        userID = join.equals("all") ? "" + userID : username;
                        textView01.setText((CharSequence)userID);
                        user_avatar01.setVisibility(0);
                    }
                    if (!iswting) {
                        textview_wting.setText((CharSequence)promptText);
                        textview_wting01.setText((CharSequence)promptText);
                    }
                    layoutToolbar.setVisibility(0);
                }
                this.showNoVideoLayout(videoView, true);
                continue;
            }
            this.showNoVideoLayout(videoView, false);
        }
    }

    public static interface ITRTCVideoViewLayoutListener {
        public void onEnableRemoteVideo(String var1, boolean var2);

        public void onEnableRemoteAudio(String var1, boolean var2);

        public void onChangeVideoFillMode(String var1, boolean var2);
    }
}

