/*
 * Decompiled with CFR 0.152.
 */
package com.html5app.uni_tencent_call.TestCustomVideo;

import android.media.MediaCodec;
import android.media.MediaExtractor;
import android.media.MediaFormat;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import android.view.Surface;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;

public class MovieVideoFrameReader
extends Thread {
    private static final String TAG = "MovieVideoFrameReader";
    private final String mFilePath;
    private final Surface mSurface;
    private MoviePlayer mMoviePlayer;

    public MovieVideoFrameReader(String filePath, Surface surface) {
        this.mFilePath = filePath;
        this.mSurface = surface;
        try {
            File file = new File(this.mFilePath);
            this.mMoviePlayer = new MoviePlayer(file, this.mSurface, null);
            this.mMoviePlayer.setLoopMode(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void requestStop() {
        this.mMoviePlayer.requestStop();
    }

    public int getVideoWidth() {
        return this.mMoviePlayer.getVideoWidth();
    }

    public int getVideoHeight() {
        return this.mMoviePlayer.getVideoHeight();
    }

    public int getVideoFps() {
        return this.mMoviePlayer.getVideoFps();
    }

    @Override
    public void run() {
        try {
            this.mMoviePlayer.play();
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"movie playback failed", (Throwable)e);
        }
        finally {
            this.mSurface.release();
            Log.d((String)TAG, (String)"PlayMovieThread stopping");
        }
    }

    private static class MoviePlayer {
        private static final String TAG = "MoviePlayer";
        private static final boolean VERBOSE = true;
        private MediaCodec.BufferInfo mBufferInfo = new MediaCodec.BufferInfo();
        private volatile boolean mIsStopRequested;
        private File mSourceFile;
        private Surface mOutputSurface;
        FrameCallback mFrameCallback;
        private boolean mLoop;
        private int mVideoWidth;
        private int mVideoHeight;
        private int mVideoFps;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public MoviePlayer(File sourceFile, Surface outputSurface, FrameCallback frameCallback) throws IOException {
            this.mSourceFile = sourceFile;
            this.mOutputSurface = outputSurface;
            this.mFrameCallback = frameCallback;
            MediaExtractor extractor = null;
            try {
                extractor = new MediaExtractor();
                extractor.setDataSource(sourceFile.toString());
                int trackIndex = MoviePlayer.selectTrack(extractor);
                if (trackIndex < 0) {
                    throw new RuntimeException("No video track found in " + this.mSourceFile);
                }
                extractor.selectTrack(trackIndex);
                MediaFormat format = extractor.getTrackFormat(trackIndex);
                this.mVideoWidth = format.getInteger("width");
                this.mVideoHeight = format.getInteger("height");
                this.mVideoFps = format.getInteger("frame-rate");
                if (this.mVideoFps <= 0) {
                    this.mVideoFps = 15;
                }
                Log.d((String)TAG, (String)("Video size is " + this.mVideoWidth + "x" + this.mVideoHeight));
            }
            finally {
                if (extractor != null) {
                    extractor.release();
                }
            }
        }

        public int getVideoWidth() {
            return this.mVideoWidth;
        }

        public int getVideoHeight() {
            return this.mVideoHeight;
        }

        public int getVideoFps() {
            return this.mVideoFps;
        }

        public void setLoopMode(boolean loopMode) {
            this.mLoop = loopMode;
        }

        public void requestStop() {
            this.mIsStopRequested = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void play() throws IOException {
            MediaExtractor extractor = null;
            MediaCodec decoder = null;
            if (!this.mSourceFile.canRead()) {
                throw new FileNotFoundException("Unable to read " + this.mSourceFile);
            }
            try {
                extractor = new MediaExtractor();
                extractor.setDataSource(this.mSourceFile.toString());
                int trackIndex = MoviePlayer.selectTrack(extractor);
                if (trackIndex < 0) {
                    throw new RuntimeException("No video track found in " + this.mSourceFile);
                }
                extractor.selectTrack(trackIndex);
                MediaFormat format = extractor.getTrackFormat(trackIndex);
                String mime = format.getString("mime");
                decoder = MediaCodec.createDecoderByType((String)mime);
                decoder.configure(format, this.mOutputSurface, null, 0);
                decoder.start();
                this.doExtract(extractor, trackIndex, decoder, this.mFrameCallback);
            }
            finally {
                if (decoder != null) {
                    decoder.stop();
                    decoder.release();
                    decoder = null;
                }
                if (extractor != null) {
                    extractor.release();
                    extractor = null;
                }
            }
        }

        private static int selectTrack(MediaExtractor extractor) {
            int numTracks = extractor.getTrackCount();
            for (int i = 0; i < numTracks; ++i) {
                MediaFormat format = extractor.getTrackFormat(i);
                String mime = format.getString("mime");
                if (!mime.startsWith("video/")) continue;
                Log.d((String)TAG, (String)("Extractor selected track " + i + " (" + mime + "): " + format));
                return i;
            }
            return -1;
        }

        private void doExtract(MediaExtractor extractor, int trackIndex, MediaCodec decoder, FrameCallback frameCallback) {
            int TIMEOUT_USEC = 10000;
            ByteBuffer[] decoderInputBuffers = decoder.getInputBuffers();
            int inputChunk = 0;
            long firstInputTimeNsec = -1L;
            boolean outputDone = false;
            boolean inputDone = false;
            while (!outputDone) {
                boolean doRender;
                Log.d((String)TAG, (String)"loop");
                if (this.mIsStopRequested) {
                    Log.d((String)TAG, (String)"Stop requested");
                    return;
                }
                try {
                    Thread.sleep(1000 / this.mVideoFps);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                if (!inputDone) {
                    int inputBufIndex = decoder.dequeueInputBuffer(10000L);
                    if (inputBufIndex >= 0) {
                        ByteBuffer inputBuf;
                        int chunkSize;
                        if (firstInputTimeNsec == -1L) {
                            firstInputTimeNsec = System.nanoTime();
                        }
                        if ((chunkSize = extractor.readSampleData(inputBuf = decoderInputBuffers[inputBufIndex], 0)) < 0) {
                            decoder.queueInputBuffer(inputBufIndex, 0, 0, 0L, 4);
                            inputDone = true;
                            Log.d((String)TAG, (String)"sent input EOS");
                        } else {
                            if (extractor.getSampleTrackIndex() != trackIndex) {
                                Log.w((String)TAG, (String)("WEIRD: got sample from track " + extractor.getSampleTrackIndex() + ", expected " + trackIndex));
                            }
                            long presentationTimeUs = extractor.getSampleTime();
                            decoder.queueInputBuffer(inputBufIndex, 0, chunkSize, presentationTimeUs, 0);
                            Log.d((String)TAG, (String)("submitted frame " + inputChunk + " to dec, size=" + chunkSize));
                            ++inputChunk;
                            extractor.advance();
                        }
                    } else {
                        Log.d((String)TAG, (String)"input buffer not available");
                    }
                }
                if (outputDone) continue;
                int decoderStatus = decoder.dequeueOutputBuffer(this.mBufferInfo, 10000L);
                if (decoderStatus == -1) {
                    Log.d((String)TAG, (String)"no output from decoder available");
                    continue;
                }
                if (decoderStatus == -3) {
                    Log.d((String)TAG, (String)"decoder output buffers changed");
                    continue;
                }
                if (decoderStatus == -2) {
                    MediaFormat newFormat = decoder.getOutputFormat();
                    Log.d((String)TAG, (String)("decoder output format changed: " + newFormat));
                    continue;
                }
                if (decoderStatus < 0) {
                    throw new RuntimeException("unexpected result from decoder.dequeueOutputBuffer: " + decoderStatus);
                }
                if (firstInputTimeNsec != 0L) {
                    long nowNsec = System.nanoTime();
                    Log.d((String)TAG, (String)("startup lag " + (double)(nowNsec - firstInputTimeNsec) / 1000000.0 + " ms"));
                    firstInputTimeNsec = 0L;
                }
                boolean doLoop = false;
                Log.d((String)TAG, (String)("surface decoder given buffer " + decoderStatus + " (size=" + this.mBufferInfo.size + ")"));
                if ((this.mBufferInfo.flags & 4) != 0) {
                    Log.d((String)TAG, (String)"output EOS");
                    if (this.mLoop) {
                        doLoop = true;
                    } else {
                        outputDone = true;
                    }
                }
                boolean bl = doRender = this.mBufferInfo.size != 0;
                if (doRender && frameCallback != null) {
                    frameCallback.preRender(this.mBufferInfo.presentationTimeUs);
                }
                decoder.releaseOutputBuffer(decoderStatus, doRender);
                if (doRender && frameCallback != null) {
                    frameCallback.postRender();
                }
                if (!doLoop) continue;
                Log.d((String)TAG, (String)"Reached EOS, looping");
                extractor.seekTo(0L, 2);
                inputDone = false;
                decoder.flush();
                if (frameCallback == null) continue;
                frameCallback.loopReset();
            }
        }

        public static class PlayTask
        implements Runnable {
            private static final int MSG_PLAY_STOPPED = 0;
            private MoviePlayer mPlayer;
            private PlayerFeedback mFeedback;
            private boolean mDoLoop;
            private Thread mThread;
            private LocalHandler mLocalHandler;
            private final Object mStopLock = new Object();
            private boolean mStopped = false;

            public PlayTask(MoviePlayer player, PlayerFeedback feedback) {
                this.mPlayer = player;
                this.mFeedback = feedback;
                this.mLocalHandler = new LocalHandler();
            }

            public void setLoopMode(boolean loopMode) {
                this.mDoLoop = loopMode;
            }

            public void execute() {
                this.mPlayer.setLoopMode(this.mDoLoop);
                this.mThread = new Thread((Runnable)this, "Movie Player");
                this.mThread.start();
            }

            public void requestStop() {
                this.mPlayer.requestStop();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void waitForStop() {
                Object object = this.mStopLock;
                synchronized (object) {
                    while (!this.mStopped) {
                        try {
                            this.mStopLock.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    this.mPlayer.play();
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
                finally {
                    Object object = this.mStopLock;
                    synchronized (object) {
                        this.mStopped = true;
                        this.mStopLock.notifyAll();
                    }
                    this.mLocalHandler.sendMessage(this.mLocalHandler.obtainMessage(0, this.mFeedback));
                }
            }

            private static class LocalHandler
            extends Handler {
                private LocalHandler() {
                }

                public void handleMessage(Message msg) {
                    int what = msg.what;
                    switch (what) {
                        case 0: {
                            PlayerFeedback fb = (PlayerFeedback)msg.obj;
                            fb.playbackStopped();
                            break;
                        }
                        default: {
                            throw new RuntimeException("Unknown msg " + what);
                        }
                    }
                }
            }
        }

        public static interface FrameCallback {
            public void preRender(long var1);

            public void postRender();

            public void loopReset();
        }

        public static interface PlayerFeedback {
            public void playbackStopped();
        }
    }
}

