/*
 * Decompiled with CFR 0.152.
 */
package com.html5app.uni_tencent_call.TestCustomVideo.OpenGLBaseModule;

import android.opengl.GLES20;
import android.opengl.Matrix;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;

public class GLI420RenderFilter {
    private static final String TAG = GLI420RenderFilter.class.getSimpleName();
    private static final String mVertexShaderCode = "uniform mat4 uMatrix;uniform mat4 uTextureMatrix;attribute vec2 position;attribute vec2 inputTextureCoordinate;varying vec2 textureCoordinate;void main() {vec4 pos  = vec4(position, 0.0, 1.0);gl_Position = uMatrix * pos;textureCoordinate = (uTextureMatrix*vec4(inputTextureCoordinate, 0.0, 0.0)).xy;}";
    private static final String mFragmentShaderCode = "precision highp float;\nvarying vec2 textureCoordinate;\nuniform sampler2D yTexture;\nuniform sampler2D uTexture;\nuniform mat3 convertMatrix;\nuniform vec3 offset;\n\nvoid main()\n{\n    highp vec3 yuvColor;\n    highp vec3 rgbColor;\n\n    // Get the YUV values\n    yuvColor.x = texture2D(yTexture, textureCoordinate).r;\n    yuvColor.y = texture2D(uTexture, vec2(textureCoordinate.x * 0.5, textureCoordinate.y * 0.5)).r;\n    yuvColor.z = texture2D(uTexture, vec2(textureCoordinate.x * 0.5, textureCoordinate.y * 0.5 + 0.5)).r;\n\n    // Do the color transform   \n    yuvColor += offset;\n    rgbColor = convertMatrix * yuvColor; \n\n    gl_FragColor = vec4(rgbColor, 1.0);\n}\n";
    private static final int BYTES_PER_FLOAT = 4;
    private static final int POSITION_COMPONENT_COUNT = 2;
    private static final int TEXTURE_COORDINATES_COMPONENT_COUNT = 2;
    private float[] mVerticesCoordinates;
    private float[] mTextureCoordinates;
    private short[] mIndices;
    private FloatBuffer mVertexBuffer;
    private FloatBuffer mTextureBuffer;
    private ShortBuffer mIndicesBuffer;
    private float[] mMVPMatrix = new float[16];
    private float[] mTextureMatrix = new float[16];
    private float[] mModeMatrix = new float[16];
    private float[] mProjectionMatrix = new float[16];
    private int[] mTextureIds;
    private int mProgram;
    private int mVertexMatrixHandle;
    private int mTextureMatrixHandle;
    private int mPositionHandle;
    private int mTextureCoordinatesHandle;
    private int mTextureUnitHandle0;
    private int mTextureUnitHandle1;
    private int mConvertMatrixUniform = -1;
    private int mConvertOffsetUniform = -1;
    float[] bt601_fullrange_ffmpeg_offset = new float[]{0.0f, -0.5019608f, -0.5019608f};
    float[] bt601_fullrage_ffmpeg_matrix = new float[]{1.0f, 1.0f, 1.0f, 0.0f, -0.3441f, 1.772f, 1.402f, -0.7141f, 0.0f};

    public GLI420RenderFilter() {
        this.mTextureCoordinates = new float[]{0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f};
        this.mIndices = new short[]{0, 1, 2, 1, 3, 2};
        this.mVerticesCoordinates = new float[]{-1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, 1.0f};
        this.mTextureBuffer = ByteBuffer.allocateDirect(this.mTextureCoordinates.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.mTextureBuffer.put(this.mTextureCoordinates);
        this.mTextureBuffer.position(0);
        this.mVertexBuffer = ByteBuffer.allocateDirect(this.mVerticesCoordinates.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.mVertexBuffer.put(this.mVerticesCoordinates);
        this.mVertexBuffer.position(0);
        this.mIndicesBuffer = ByteBuffer.allocateDirect(this.mIndices.length * 2).order(ByteOrder.nativeOrder()).asShortBuffer();
        this.mIndicesBuffer.put(this.mIndices);
        this.mIndicesBuffer.position(0);
        this.createTexture();
    }

    private void createTexture() {
        int vertexShader = GLES20.glCreateShader((int)35633);
        this.checkError();
        GLES20.glShaderSource((int)vertexShader, (String)mVertexShaderCode);
        this.checkError();
        GLES20.glCompileShader((int)vertexShader);
        this.checkError();
        int fragmentShader = GLES20.glCreateShader((int)35632);
        this.checkError();
        GLES20.glShaderSource((int)fragmentShader, (String)mFragmentShaderCode);
        this.checkError();
        GLES20.glCompileShader((int)fragmentShader);
        this.mProgram = GLES20.glCreateProgram();
        this.checkError();
        GLES20.glAttachShader((int)this.mProgram, (int)vertexShader);
        this.checkError();
        GLES20.glAttachShader((int)this.mProgram, (int)fragmentShader);
        this.checkError();
        GLES20.glLinkProgram((int)this.mProgram);
        this.checkError();
        GLES20.glDeleteShader((int)vertexShader);
        GLES20.glDeleteShader((int)fragmentShader);
        this.mVertexMatrixHandle = GLES20.glGetUniformLocation((int)this.mProgram, (String)"uMatrix");
        this.checkError();
        this.mTextureMatrixHandle = GLES20.glGetUniformLocation((int)this.mProgram, (String)"uTextureMatrix");
        this.checkError();
        this.mPositionHandle = GLES20.glGetAttribLocation((int)this.mProgram, (String)"position");
        this.checkError();
        this.mTextureCoordinatesHandle = GLES20.glGetAttribLocation((int)this.mProgram, (String)"inputTextureCoordinate");
        this.checkError();
        this.mTextureUnitHandle0 = GLES20.glGetUniformLocation((int)this.mProgram, (String)"yTexture");
        this.checkError();
        this.mTextureUnitHandle1 = GLES20.glGetUniformLocation((int)this.mProgram, (String)"uTexture");
        this.checkError();
        this.mConvertOffsetUniform = GLES20.glGetUniformLocation((int)this.mProgram, (String)"offset");
        GLES20.glUniform3fv((int)this.mConvertOffsetUniform, (int)1, (FloatBuffer)FloatBuffer.wrap(this.bt601_fullrange_ffmpeg_offset));
        this.mConvertMatrixUniform = GLES20.glGetUniformLocation((int)this.mProgram, (String)"convertMatrix");
        GLES20.glUniformMatrix3fv((int)this.mConvertMatrixUniform, (int)1, (boolean)false, (float[])this.bt601_fullrage_ffmpeg_matrix, (int)0);
        this.mTextureIds = new int[2];
        GLES20.glGenTextures((int)2, (int[])this.mTextureIds, (int)0);
    }

    public void release() {
        if (this.mTextureIds != null) {
            GLES20.glDeleteTextures((int)2, (int[])this.mTextureIds, (int)0);
            this.mTextureIds = null;
        }
        GLES20.glDeleteProgram((int)this.mProgram);
    }

    public void drawFrame(ByteBuffer yData, ByteBuffer uvData, int videoWidth, int videoHeight, int viewWidth, int viewHeight) {
        GLES20.glViewport((int)0, (int)0, (int)viewWidth, (int)viewHeight);
        GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GLES20.glClear((int)16640);
        Matrix.setIdentityM((float[])this.mMVPMatrix, (int)0);
        Matrix.setIdentityM((float[])this.mTextureMatrix, (int)0);
        GLES20.glUseProgram((int)this.mProgram);
        this.checkError();
        GLES20.glEnableVertexAttribArray((int)this.mPositionHandle);
        this.checkError();
        this.mVertexBuffer.position(0);
        GLES20.glVertexAttribPointer((int)this.mPositionHandle, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)this.mVertexBuffer);
        this.checkError();
        GLES20.glEnableVertexAttribArray((int)this.mTextureCoordinatesHandle);
        this.checkError();
        this.mTextureBuffer.position(0);
        GLES20.glVertexAttribPointer((int)this.mTextureCoordinatesHandle, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)this.mTextureBuffer);
        this.checkError();
        Matrix.setIdentityM((float[])this.mMVPMatrix, (int)0);
        this.fill(this.mMVPMatrix, videoWidth, videoHeight, viewWidth, viewHeight);
        GLES20.glUniformMatrix4fv((int)this.mVertexMatrixHandle, (int)1, (boolean)false, (float[])this.mMVPMatrix, (int)0);
        this.checkError();
        GLES20.glUniformMatrix4fv((int)this.mTextureMatrixHandle, (int)1, (boolean)false, (float[])this.mTextureMatrix, (int)0);
        this.checkError();
        GLES20.glUniform3fv((int)this.mConvertOffsetUniform, (int)1, (FloatBuffer)FloatBuffer.wrap(this.bt601_fullrange_ffmpeg_offset));
        GLES20.glUniformMatrix3fv((int)this.mConvertMatrixUniform, (int)1, (boolean)false, (float[])this.bt601_fullrage_ffmpeg_matrix, (int)0);
        GLES20.glUniform1i((int)this.mTextureUnitHandle0, (int)0);
        this.checkError();
        GLES20.glUniform1i((int)this.mTextureUnitHandle1, (int)1);
        this.checkError();
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)3553, (int)this.mTextureIds[0]);
        GLES20.glTexParameteri((int)3553, (int)10242, (int)33071);
        GLES20.glTexParameteri((int)3553, (int)10243, (int)33071);
        GLES20.glTexParameteri((int)3553, (int)10241, (int)9729);
        GLES20.glTexParameteri((int)3553, (int)10240, (int)9729);
        GLES20.glTexImage2D((int)3553, (int)0, (int)6409, (int)videoWidth, (int)videoHeight, (int)0, (int)6409, (int)5121, (Buffer)yData);
        GLES20.glActiveTexture((int)33985);
        GLES20.glBindTexture((int)3553, (int)this.mTextureIds[1]);
        GLES20.glTexParameteri((int)3553, (int)10242, (int)33071);
        GLES20.glTexParameteri((int)3553, (int)10243, (int)33071);
        GLES20.glTexParameteri((int)3553, (int)10241, (int)9729);
        GLES20.glTexParameteri((int)3553, (int)10240, (int)9729);
        GLES20.glTexImage2D((int)3553, (int)0, (int)6409, (int)videoWidth, (int)(videoHeight / 2), (int)0, (int)6409, (int)5121, (Buffer)uvData);
        GLES20.glDrawElements((int)4, (int)this.mIndices.length, (int)5123, (Buffer)this.mIndicesBuffer);
        GLES20.glDisableVertexAttribArray((int)this.mPositionHandle);
        GLES20.glDisableVertexAttribArray((int)this.mTextureCoordinatesHandle);
    }

    public int checkError() {
        int error = GLES20.glGetError();
        if (error != 0) {
            throw new IllegalStateException("gl error=" + error);
        }
        return error;
    }

    private void fill(float[] MVPMatrix, int videoWidth, int videoHeight, int viewWidth, int viewHeight) {
        int scaleWidth = videoWidth;
        int scaleHeight = videoHeight;
        float ratioWidth = (float)viewWidth * 1.0f / (float)scaleWidth;
        float ratioHeight = (float)viewHeight * 1.0f / (float)scaleHeight;
        float ratio = ratioWidth * (float)scaleHeight > (float)viewHeight ? ratioHeight : ratioWidth;
        Matrix.setIdentityM((float[])this.mModeMatrix, (int)0);
        Matrix.scaleM((float[])this.mModeMatrix, (int)0, (float)((float)scaleWidth * ratio / (float)viewWidth * 1.0f), (float)((float)scaleHeight * ratio / (float)viewHeight * 1.0f), (float)1.0f);
        if (viewWidth > viewHeight) {
            Matrix.orthoM((float[])this.mProjectionMatrix, (int)0, (float)-1.0f, (float)1.0f, (float)-1.0f, (float)1.0f, (float)-1.0f, (float)1.0f);
        } else {
            Matrix.orthoM((float[])this.mProjectionMatrix, (int)0, (float)-1.0f, (float)1.0f, (float)-1.0f, (float)1.0f, (float)-1.0f, (float)1.0f);
        }
        Matrix.multiplyMM((float[])MVPMatrix, (int)0, (float[])this.mProjectionMatrix, (int)0, (float[])this.mModeMatrix, (int)0);
    }
}

