/*
 * Decompiled with CFR 0.152.
 */
package com.html5app.uni_tencent_call.TestCustomVideo.OpenGLBaseModule;

import android.opengl.GLES20;
import android.opengl.Matrix;
import com.html5app.uni_tencent_call.TestCustomVideo.OpenGLBaseModule.EglCore;
import java.nio.Buffer;
import java.nio.FloatBuffer;

public class GLTexture2DFilter {
    private static final String VERTEX_SHADER = "uniform mat4 uMVPMatrix;\nuniform mat4 uTexMatrix;\nattribute vec4 aPosition;\nattribute vec4 aTextureCoord;\nvarying vec2 vTextureCoord;\nvoid main() {\n    gl_Position = uMVPMatrix * aPosition;\n    vTextureCoord = (uTexMatrix * aTextureCoord).xy;\n}\n";
    private static final String FRAGMENT_SHADER_2D = "precision mediump float;\nvarying vec2 vTextureCoord;\nuniform sampler2D sTexture;\nvoid main() {\n    gl_FragColor = texture2D(sTexture, vTextureCoord);\n}\n";
    private static final FloatBuffer DEF_VERTEX_BUF = EglCore.createFloatBuffer(EglCore.CUBE);
    private static final FloatBuffer DEF_TEX_BUF = EglCore.createFloatBuffer(EglCore.TEXTURE_ROTATION_0);
    private int mProgramHandle;
    private int muMVPMatrixLoc;
    private int maPositionLoc;
    private int maTextureCoordLoc;
    private int muTexMatrixLoc;
    private float[] mMVPMatrix = new float[16];
    private float[] mModeMatrix = new float[16];
    private float[] mProjectionMatrix = new float[16];

    public GLTexture2DFilter() {
        this.mProgramHandle = EglCore.createProgram(VERTEX_SHADER, FRAGMENT_SHADER_2D);
        this.maPositionLoc = GLES20.glGetAttribLocation((int)this.mProgramHandle, (String)"aPosition");
        this.maTextureCoordLoc = GLES20.glGetAttribLocation((int)this.mProgramHandle, (String)"aTextureCoord");
        this.muMVPMatrixLoc = GLES20.glGetUniformLocation((int)this.mProgramHandle, (String)"uMVPMatrix");
        this.muTexMatrixLoc = GLES20.glGetUniformLocation((int)this.mProgramHandle, (String)"uTexMatrix");
    }

    public void release() {
        if (this.mProgramHandle != -1) {
            GLES20.glDeleteProgram((int)this.mProgramHandle);
            this.mProgramHandle = -1;
        }
    }

    public void draw(int textureId, int videoWidth, int videoHeight, int viewWidth, int viewHeight) {
        EglCore.checkGlError("draw start");
        GLES20.glViewport((int)0, (int)0, (int)viewWidth, (int)viewHeight);
        GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GLES20.glClear((int)16640);
        GLES20.glUseProgram((int)this.mProgramHandle);
        EglCore.checkGlError("glUseProgram");
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)3553, (int)textureId);
        Matrix.setIdentityM((float[])this.mMVPMatrix, (int)0);
        this.fill(this.mMVPMatrix, videoWidth, videoHeight, viewWidth, viewHeight);
        GLES20.glUniformMatrix4fv((int)this.muMVPMatrixLoc, (int)1, (boolean)false, (float[])this.mMVPMatrix, (int)0);
        EglCore.checkGlError("glUniformMatrix4fv");
        GLES20.glUniformMatrix4fv((int)this.muTexMatrixLoc, (int)1, (boolean)false, (float[])EglCore.IDENTITY_MATRIX, (int)0);
        EglCore.checkGlError("glUniformMatrix4fv");
        GLES20.glEnableVertexAttribArray((int)this.maPositionLoc);
        EglCore.checkGlError("glEnableVertexAttribArray");
        GLES20.glVertexAttribPointer((int)this.maPositionLoc, (int)2, (int)5126, (boolean)false, (int)0, (Buffer)DEF_VERTEX_BUF);
        EglCore.checkGlError("glVertexAttribPointer");
        GLES20.glEnableVertexAttribArray((int)this.maTextureCoordLoc);
        EglCore.checkGlError("glEnableVertexAttribArray");
        GLES20.glVertexAttribPointer((int)this.maTextureCoordLoc, (int)2, (int)5126, (boolean)false, (int)0, (Buffer)DEF_TEX_BUF);
        EglCore.checkGlError("glVertexAttribPointer");
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        EglCore.checkGlError("glDrawArrays");
        GLES20.glDisableVertexAttribArray((int)this.maPositionLoc);
        GLES20.glDisableVertexAttribArray((int)this.maTextureCoordLoc);
        GLES20.glBindTexture((int)3553, (int)0);
        GLES20.glUseProgram((int)0);
    }

    private void fill(float[] MVPMatrix, int videoWidth, int videoHeight, int viewWidth, int viewHeight) {
        int scaleWidth = videoWidth;
        int scaleHeight = videoHeight;
        float ratioWidth = (float)viewWidth * 1.0f / (float)scaleWidth;
        float ratioHeight = (float)viewHeight * 1.0f / (float)scaleHeight;
        float ratio = ratioWidth * (float)scaleHeight > (float)viewHeight ? ratioHeight : ratioWidth;
        Matrix.setIdentityM((float[])this.mModeMatrix, (int)0);
        Matrix.scaleM((float[])this.mModeMatrix, (int)0, (float)((float)scaleWidth * ratio / (float)viewWidth * 1.0f), (float)((float)scaleHeight * ratio / (float)viewHeight * 1.0f), (float)1.0f);
        if (viewWidth > viewHeight) {
            Matrix.orthoM((float[])this.mProjectionMatrix, (int)0, (float)-1.0f, (float)1.0f, (float)-1.0f, (float)1.0f, (float)-1.0f, (float)1.0f);
        } else {
            Matrix.orthoM((float[])this.mProjectionMatrix, (int)0, (float)-1.0f, (float)1.0f, (float)-1.0f, (float)1.0f, (float)-1.0f, (float)1.0f);
        }
        Matrix.multiplyMM((float[])MVPMatrix, (int)0, (float[])this.mProjectionMatrix, (int)0, (float[])this.mModeMatrix, (int)0);
    }
}

