/*
 * Decompiled with CFR 0.152.
 */
package com.html5app.uni_tencent_call.TestCustomVideo.OpenGLBaseModule;

import android.opengl.GLES20;
import android.opengl.Matrix;
import android.util.Log;
import com.html5app.uni_tencent_call.TestCustomVideo.OpenGLBaseModule.EglCore;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;

public class GLTextureOESFilter {
    private static final String TAG = "GLTextureOESFilter";
    private int mOutputWidth = 0;
    private int mOutputHeight = 0;
    private float[] mProjectionMatrix = new float[16];
    private float[] mModeMatrix = new float[16];
    private static final int FLOAT_SIZE_BYTES = 4;
    private static final int TRIANGLE_VERTICES_DATA_STRIDE_BYTES = 20;
    private static final int TRIANGLE_VERTICES_DATA_POS_OFFSET = 0;
    private static final int TRIANGLE_VERTICES_DATA_UV_OFFSET = 3;
    private static final int INVALID_TEXTURE_ID = -12345;
    private final float[] mTriangleVerticesData = new float[]{-1.0f, -1.0f, 0.0f, 0.0f, 0.0f, 1.0f, -1.0f, 0.0f, 1.0f, 0.0f, -1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f};
    private FloatBuffer mTriangleVertices;
    private static final String VERTEX_SHADER = "uniform mat4 uMVPMatrix;\nuniform mat4 uSTMatrix;\nattribute vec4 aPosition;\nattribute vec4 aTextureCoord;\nvarying vec2 vTextureCoord;\nvoid main() {\n  gl_Position = uMVPMatrix * aPosition;\n  vTextureCoord = (uSTMatrix * aTextureCoord).xy;\n}\n";
    private static final String FRAGMENT_SHADER_OESTEX = "#extension GL_OES_EGL_image_external : require\nprecision mediump float;\nvarying vec2 vTextureCoord;\nuniform samplerExternalOES sTexture;\nvoid main() {\n  gl_FragColor = texture2D(sTexture, vTextureCoord);\n}\n";
    private float[] mMVPMatrix = new float[16];
    private float[] mSTMatrix = new float[16];
    private int mProgram;
    private int mFrameBufferTextureID = -12345;
    private int mFrameBufferID = -12345;
    private int muMVPMatrixHandle;
    private int muSTMatrixHandle;
    private int maPositionHandle;
    private int maTextureHandle;

    public GLTextureOESFilter() {
        this.mTriangleVertices = ByteBuffer.allocateDirect(this.mTriangleVerticesData.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.mTriangleVertices.put(this.mTriangleVerticesData).position(0);
        Matrix.setIdentityM((float[])this.mSTMatrix, (int)0);
        this.create();
    }

    public void setMatrix(float[] mtx) {
        this.mSTMatrix = mtx;
    }

    public int drawToTexture(int textureId) {
        if (this.mFrameBufferID == -12345) {
            Log.d((String)TAG, (String)"invalid frame buffer id");
            return textureId;
        }
        GLES20.glBindFramebuffer((int)36160, (int)this.mFrameBufferID);
        this.draw(textureId);
        GLES20.glBindFramebuffer((int)36160, (int)0);
        return this.mFrameBufferTextureID;
    }

    public void release() {
        if (this.mProgram != -1) {
            GLES20.glDeleteProgram((int)this.mProgram);
            this.mProgram = -1;
        }
        this.destroyFrameBuffer();
    }

    private void create() {
        this.mProgram = EglCore.createProgram(VERTEX_SHADER, FRAGMENT_SHADER_OESTEX);
        if (this.mProgram == 0) {
            throw new RuntimeException("failed creating program");
        }
        this.maPositionHandle = GLES20.glGetAttribLocation((int)this.mProgram, (String)"aPosition");
        EglCore.checkGlError("glGetAttribLocation aPosition");
        if (this.maPositionHandle == -1) {
            throw new RuntimeException("Could not get attrib location for aPosition");
        }
        this.maTextureHandle = GLES20.glGetAttribLocation((int)this.mProgram, (String)"aTextureCoord");
        EglCore.checkGlError("glGetAttribLocation aTextureCoord");
        if (this.maTextureHandle == -1) {
            throw new RuntimeException("Could not get attrib location for aTextureCoord");
        }
        this.muMVPMatrixHandle = GLES20.glGetUniformLocation((int)this.mProgram, (String)"uMVPMatrix");
        EglCore.checkGlError("glGetUniformLocation uMVPMatrix");
        if (this.muMVPMatrixHandle == -1) {
            throw new RuntimeException("Could not get attrib location for uMVPMatrix");
        }
        this.muSTMatrixHandle = GLES20.glGetUniformLocation((int)this.mProgram, (String)"uSTMatrix");
        EglCore.checkGlError("glGetUniformLocation uSTMatrix");
        if (this.muSTMatrixHandle == -1) {
            throw new RuntimeException("Could not get attrib location for uSTMatrix");
        }
    }

    public void setOutputResolution(int width, int height) {
        if (width == this.mOutputWidth && height == this.mOutputHeight) {
            return;
        }
        Log.d((String)TAG, (String)("Output resolution change: " + this.mOutputWidth + "*" + this.mOutputHeight + " -> " + width + "*" + height));
        this.mOutputWidth = width;
        this.mOutputHeight = height;
        if (width > height) {
            Matrix.orthoM((float[])this.mProjectionMatrix, (int)0, (float)-1.0f, (float)1.0f, (float)-1.0f, (float)1.0f, (float)-1.0f, (float)1.0f);
        } else {
            Matrix.orthoM((float[])this.mProjectionMatrix, (int)0, (float)-1.0f, (float)1.0f, (float)-1.0f, (float)1.0f, (float)-1.0f, (float)1.0f);
        }
        this.reloadFrameBuffer();
    }

    private void draw(int textureId) {
        GLES20.glViewport((int)0, (int)0, (int)this.mOutputWidth, (int)this.mOutputHeight);
        GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GLES20.glClear((int)16640);
        GLES20.glUseProgram((int)this.mProgram);
        EglCore.checkGlError("glUseProgram");
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)36197, (int)textureId);
        this.mTriangleVertices.position(0);
        GLES20.glVertexAttribPointer((int)this.maPositionHandle, (int)3, (int)5126, (boolean)false, (int)20, (Buffer)this.mTriangleVertices);
        EglCore.checkGlError("glVertexAttribPointer maPosition");
        GLES20.glEnableVertexAttribArray((int)this.maPositionHandle);
        EglCore.checkGlError("glEnableVertexAttribArray maPositionHandle");
        this.mTriangleVertices.position(3);
        GLES20.glVertexAttribPointer((int)this.maTextureHandle, (int)2, (int)5126, (boolean)false, (int)20, (Buffer)this.mTriangleVertices);
        EglCore.checkGlError("glVertexAttribPointer maTextureHandle");
        GLES20.glEnableVertexAttribArray((int)this.maTextureHandle);
        EglCore.checkGlError("glEnableVertexAttribArray maTextureHandle");
        Matrix.setIdentityM((float[])this.mMVPMatrix, (int)0);
        Matrix.setIdentityM((float[])this.mModeMatrix, (int)0);
        Matrix.scaleM((float[])this.mModeMatrix, (int)0, (float)-1.0f, (float)1.0f, (float)1.0f);
        Matrix.rotateM((float[])this.mModeMatrix, (int)0, (float)180.0f, (float)0.0f, (float)0.0f, (float)-1.0f);
        Matrix.multiplyMM((float[])this.mMVPMatrix, (int)0, (float[])this.mProjectionMatrix, (int)0, (float[])this.mModeMatrix, (int)0);
        GLES20.glUniformMatrix4fv((int)this.muMVPMatrixHandle, (int)1, (boolean)false, (float[])this.mMVPMatrix, (int)0);
        GLES20.glUniformMatrix4fv((int)this.muSTMatrixHandle, (int)1, (boolean)false, (float[])this.mSTMatrix, (int)0);
        EglCore.checkGlError("glDrawArrays");
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        EglCore.checkGlError("glDrawArrays");
        GLES20.glBindTexture((int)36197, (int)0);
    }

    private void reloadFrameBuffer() {
        Log.d((String)TAG, (String)("reloadFrameBuffer. size = " + this.mOutputWidth + "*" + this.mOutputHeight));
        this.destroyFrameBuffer();
        int[] textures = new int[1];
        int[] frameBuffers = new int[1];
        GLES20.glGenTextures((int)1, (int[])textures, (int)0);
        GLES20.glGenFramebuffers((int)1, (int[])frameBuffers, (int)0);
        this.mFrameBufferTextureID = textures[0];
        this.mFrameBufferID = frameBuffers[0];
        Log.d((String)TAG, (String)("frameBuffer id = " + this.mFrameBufferID + ", texture id = " + this.mFrameBufferTextureID));
        GLES20.glBindTexture((int)3553, (int)this.mFrameBufferTextureID);
        EglCore.checkGlError("glBindTexture mFrameBufferTextureID");
        GLES20.glTexImage2D((int)3553, (int)0, (int)6408, (int)this.mOutputWidth, (int)this.mOutputHeight, (int)0, (int)6408, (int)5121, null);
        GLES20.glTexParameterf((int)3553, (int)10241, (float)9729.0f);
        GLES20.glTexParameterf((int)3553, (int)10240, (float)9729.0f);
        GLES20.glTexParameteri((int)3553, (int)10242, (int)33071);
        GLES20.glTexParameteri((int)3553, (int)10243, (int)33071);
        EglCore.checkGlError("glTexParameter");
        GLES20.glBindFramebuffer((int)36160, (int)this.mFrameBufferID);
        GLES20.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)this.mFrameBufferTextureID, (int)0);
        GLES20.glBindTexture((int)3553, (int)0);
        GLES20.glBindFramebuffer((int)36160, (int)0);
    }

    private void destroyFrameBuffer() {
        if (this.mFrameBufferID != -12345) {
            int[] frameID = new int[]{this.mFrameBufferID};
            GLES20.glDeleteFramebuffers((int)1, (int[])frameID, (int)0);
            this.mFrameBufferID = -12345;
        }
        if (this.mFrameBufferTextureID != -12345) {
            int[] textureID = new int[]{this.mFrameBufferTextureID};
            GLES20.glDeleteTextures((int)1, (int[])textureID, (int)0);
            this.mFrameBufferTextureID = -12345;
        }
    }
}

