/*
 * Decompiled with CFR 0.152.
 */
package com.html5app.uni_tencent_call.TestCustomVideo.OpenGLBaseModule;

import android.annotation.TargetApi;
import android.graphics.SurfaceTexture;
import android.opengl.EGL14;
import android.opengl.EGLContext;
import android.opengl.GLES20;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.view.Surface;
import com.html5app.uni_tencent_call.TestCustomVideo.OpenGLBaseModule.EglCore;
import com.html5app.uni_tencent_call.TestCustomVideo.OpenGLBaseModule.EglSurfaceBase;
import com.html5app.uni_tencent_call.TestCustomVideo.OpenGLBaseModule.GLTextureOESFilter;
import com.tencent.liteav.basic.log.TXCLog;

public class GLThread {
    private static final String TAG = "GLThread";
    private volatile HandlerThread mGLThread = null;
    private volatile GLThreadHandler mGLHandler = null;
    private GLTextureOESFilter mGLFilter;
    private float[] mSTMatrix;
    private int[] mTextureID = null;
    private SurfaceTexture mSurfaceTexture = null;
    private IGLSurfaceTextureListener mListener;
    private int mInputWidth;
    private int mInputHeight;

    public void start() {
        TXCLog.i((String)TAG, (String)"surface-render: surface render start ");
        this.initGLThread();
    }

    public void stop() {
        TXCLog.i((String)TAG, (String)"surface-render: surface render stop ");
        this.unintGLThread();
    }

    public void setListener(IGLSurfaceTextureListener listener) {
        this.mListener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Surface getSurface() {
        GLThread gLThread = this;
        synchronized (gLThread) {
            return this.mGLHandler != null ? this.mGLHandler.getSurface() : null;
        }
    }

    public void setInputSize(int width, int height) {
        this.mInputWidth = width;
        this.mInputHeight = height;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void post(Runnable task) {
        GLThread gLThread = this;
        synchronized (gLThread) {
            if (this.mGLHandler != null) {
                this.mGLHandler.post(task);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initGLThread() {
        this.unintGLThread();
        GLThread gLThread = this;
        synchronized (gLThread) {
            this.mGLThread = new HandlerThread(TAG);
            this.mGLThread.start();
            this.mGLHandler = new GLThreadHandler(this.mGLThread.getLooper());
            this.mGLHandler.setListener(new IEGLListener(){

                @Override
                public void onEGLCreate() {
                    GLThread.this.initSurfaceTexture();
                    GLThread.this.mGLFilter = new GLTextureOESFilter();
                    GLThread.this.mGLFilter.setOutputResolution(GLThread.this.mInputWidth, GLThread.this.mInputHeight);
                }

                @Override
                public void onTextureProcess(EGLContext eglContext) {
                    if (GLThread.this.mSurfaceTexture != null) {
                        GLThread.this.mSurfaceTexture.updateTexImage();
                        GLThread.this.mSurfaceTexture.getTransformMatrix(GLThread.this.mSTMatrix);
                    }
                    if (GLThread.this.mGLFilter != null) {
                        GLThread.this.mGLFilter.setMatrix(GLThread.this.mSTMatrix);
                        int textureId = GLThread.this.mGLFilter.drawToTexture(GLThread.this.mTextureID[0]);
                        IGLSurfaceTextureListener listener = GLThread.this.mListener;
                        if (listener != null) {
                            listener.onTextureProcess(textureId, eglContext);
                        }
                    }
                }

                @Override
                public void onEGLDestroy() {
                    GLThread.this.destroySurfaceTexture();
                    if (GLThread.this.mGLFilter != null) {
                        GLThread.this.mGLFilter.release();
                        GLThread.this.mGLFilter = null;
                    }
                }
            });
            TXCLog.w((String)TAG, (String)("surface-render: create gl thread " + this.mGLThread.getName()));
        }
        this.sendMsg(100);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unintGLThread() {
        GLThread gLThread = this;
        synchronized (gLThread) {
            if (this.mGLHandler != null) {
                GLThreadHandler.quitGLThread(this.mGLHandler, this.mGLThread);
                TXCLog.w((String)TAG, (String)"surface-render: destroy gl thread");
            }
            this.mGLHandler = null;
            this.mGLThread = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendMsg(int what) {
        GLThread gLThread = this;
        synchronized (gLThread) {
            if (this.mGLHandler != null) {
                this.mGLHandler.sendEmptyMessage(what);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendMsg(int what, Runnable completeTask) {
        GLThread gLThread = this;
        synchronized (gLThread) {
            if (this.mGLHandler != null) {
                Message msg = new Message();
                msg.what = what;
                msg.obj = completeTask;
                this.mGLHandler.sendMessage(msg);
            }
        }
    }

    private void destroySurfaceTexture() {
        TXCLog.w((String)TAG, (String)"destroy surface texture ");
        IGLSurfaceTextureListener listener = this.mListener;
        if (listener != null) {
            listener.onSurfaceTextureDestroy(this.mSurfaceTexture);
        }
        if (this.mSurfaceTexture != null) {
            this.mSurfaceTexture.setOnFrameAvailableListener(null);
            this.mSurfaceTexture.release();
            this.mSurfaceTexture = null;
        }
        if (this.mTextureID != null) {
            GLES20.glDeleteTextures((int)1, (int[])this.mTextureID, (int)0);
            this.mTextureID = null;
        }
    }

    private int createOESTextureID() {
        int[] texture = new int[1];
        GLES20.glGenTextures((int)1, (int[])texture, (int)0);
        GLES20.glBindTexture((int)36197, (int)texture[0]);
        GLES20.glTexParameterf((int)36197, (int)10241, (float)9729.0f);
        GLES20.glTexParameterf((int)36197, (int)10240, (float)9729.0f);
        GLES20.glTexParameteri((int)36197, (int)10242, (int)33071);
        GLES20.glTexParameteri((int)36197, (int)10243, (int)33071);
        return texture[0];
    }

    private void initSurfaceTexture() {
        TXCLog.w((String)TAG, (String)"init surface texture ");
        this.mSTMatrix = new float[16];
        this.mTextureID = new int[1];
        this.mTextureID[0] = this.createOESTextureID();
        this.mSurfaceTexture = new SurfaceTexture(this.mTextureID[0]);
        this.mSurfaceTexture.setDefaultBufferSize(1280, 720);
        this.mSurfaceTexture.setOnFrameAvailableListener(new SurfaceTexture.OnFrameAvailableListener(){

            public void onFrameAvailable(SurfaceTexture surfaceTexture) {
                GLThread.this.sendMsg(103, new Runnable(){

                    @Override
                    public void run() {
                        GLThread.this.sendMsg(102);
                    }
                });
            }
        });
        IGLSurfaceTextureListener listener = this.mListener;
        if (listener != null) {
            listener.onSurfaceTextureAvailable(this.mSurfaceTexture);
        }
    }

    public static class GLThreadHandler
    extends Handler {
        private static final String TAG = "TXGLThreadHandler";
        public static final int MSG_INIT = 100;
        public static final int MSG_END = 101;
        public static final int MSG_REND = 102;
        public static final int MSG_RUN_TASK = 103;
        public int mCaptureWidth = 720;
        public int mCaptureHeight = 1280;
        public Surface mSurface = null;
        public EGLContext mEgl14Context = null;
        private IEGLListener mListener = null;
        private EglSurfaceBase mEglBase;

        public static void quitGLThread(Handler handler, HandlerThread thread) {
            final HandlerThread glThread = thread;
            final Handler glHandler = handler;
            if (glHandler == null || glThread == null) {
                return;
            }
            Message msg = new Message();
            msg.what = 101;
            msg.obj = new Runnable(){

                @Override
                public void run() {
                    Handler mainHandler = new Handler(Looper.getMainLooper());
                    mainHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            if (glHandler != null) {
                                glHandler.removeCallbacksAndMessages(null);
                            }
                            if (glThread != null) {
                                if (Build.VERSION.SDK_INT >= 18) {
                                    glThread.quitSafely();
                                } else {
                                    glThread.quit();
                                }
                            }
                        }
                    });
                }
            };
            glHandler.sendMessage(msg);
        }

        public GLThreadHandler(Looper looper) {
            super(looper);
        }

        public void setListener(IEGLListener listener) {
            this.mListener = listener;
        }

        public Surface getSurface() {
            return this.mSurface;
        }

        public void swap() {
            if (this.mEglBase != null) {
                this.mEglBase.swapBuffers();
            }
        }

        public void handleMessage(Message msg) {
            if (msg == null) {
                return;
            }
            switch (msg.what) {
                case 100: {
                    this.onMsgInit(msg);
                    break;
                }
                case 102: {
                    try {
                        this.onMsgRend(msg);
                    }
                    catch (Exception exception) {}
                    break;
                }
                case 101: {
                    this.onMsgEnd(msg);
                    break;
                }
            }
            if (msg != null && msg.obj != null) {
                Runnable runTask = (Runnable)msg.obj;
                runTask.run();
            }
        }

        private void onMsgInit(Message msg) {
            try {
                this.initGL();
            }
            catch (Exception e) {
                TXCLog.e((String)TAG, (String)("surface-render: init egl context exception " + this.mSurface));
                this.mSurface = null;
            }
        }

        private void onMsgEnd(Message msg) {
            this.destroyGL();
        }

        @TargetApi(value=17)
        private void onMsgRend(Message msg) {
            try {
                if (this.mListener != null) {
                    this.mListener.onTextureProcess(EGL14.eglGetCurrentContext());
                }
            }
            catch (Exception e) {
                TXCLog.e((String)TAG, (String)("onMsgRend Exception " + e.getMessage()));
                e.printStackTrace();
            }
        }

        private boolean initGL() {
            TXCLog.d((String)TAG, (String)String.format("init egl size[%d/%d]", this.mCaptureWidth, this.mCaptureHeight));
            EglCore eglCore = new EglCore(this.mEgl14Context, 0);
            this.mEglBase = new EglSurfaceBase(eglCore);
            if (this.mSurface == null) {
                this.mEglBase.createOffscreenSurface(this.mCaptureWidth, this.mCaptureHeight);
            } else {
                this.mEglBase.createWindowSurface(this.mSurface);
            }
            this.mEglBase.makeCurrent();
            TXCLog.w((String)TAG, (String)("surface-render: create egl context " + this.mSurface));
            if (this.mListener != null) {
                this.mListener.onEGLCreate();
            }
            return true;
        }

        private void destroyGL() {
            TXCLog.w((String)TAG, (String)("surface-render: destroy egl context " + this.mSurface));
            if (this.mListener != null) {
                this.mListener.onEGLDestroy();
            }
            if (this.mEglBase != null) {
                this.mEglBase.releaseEglSurface();
                this.mEglBase = null;
            }
            this.mSurface = null;
        }
    }

    public static interface IEGLListener {
        public void onEGLCreate();

        public void onTextureProcess(EGLContext var1);

        public void onEGLDestroy();
    }

    public static interface IGLSurfaceTextureListener {
        public void onSurfaceTextureAvailable(SurfaceTexture var1);

        public int onTextureProcess(int var1, EGLContext var2);

        public void onSurfaceTextureDestroy(SurfaceTexture var1);
    }
}

