/*
 * Decompiled with CFR 0.152.
 */
package com.html5app.uni_tencent_call.TestCustomVideo;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.opengl.EGLContext;
import android.opengl.GLES20;
import android.os.HandlerThread;
import android.util.Log;
import android.view.Surface;
import android.view.TextureView;
import com.html5app.uni_tencent_call.TestCustomVideo.OpenGLBaseModule.GLI420RenderFilter;
import com.html5app.uni_tencent_call.TestCustomVideo.OpenGLBaseModule.GLTexture2DFilter;
import com.html5app.uni_tencent_call.TestCustomVideo.OpenGLBaseModule.GLThread;
import com.tencent.trtc.TRTCCloudDef;
import com.tencent.trtc.TRTCCloudListener;
import java.nio.ByteBuffer;

public class TestRenderVideoFrame
implements TRTCCloudListener.TRTCVideoRenderListener,
GLThread.IEGLListener {
    public static final String TAG = "TestRenderVideoFrame";
    private static final int RENDER_TYPE_TEXTURE = 0;
    private static final int RENDER_TYPE_I420 = 1;
    private GLThread.GLThreadHandler mGLHandler;
    private HandlerThread mGLThread;
    private TextureView mRenderView;
    private int mVideoWidth;
    private int mVideoHeight;
    private int mRenderType = 0;
    private SurfaceTexture mSurfaceTexture;
    private int mTextureId = -1;
    private GLTexture2DFilter mTextureFilter;
    private ByteBuffer mYdata;
    private ByteBuffer mUVData;
    private GLI420RenderFilter mYUVFilter;

    public TestRenderVideoFrame(Context context) {
    }

    public void start(TextureView videoView) {
        if (videoView == null) {
            Log.w((String)TAG, (String)"start error when render view is null");
            return;
        }
        this.mRenderView = videoView;
        this.mRenderView.setSurfaceTextureListener(new TextureView.SurfaceTextureListener(){

            public void onSurfaceTextureAvailable(SurfaceTexture surface, int width, int height) {
                TestRenderVideoFrame.this.mSurfaceTexture = surface;
            }

            public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
            }

            public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
                TestRenderVideoFrame.this.mSurfaceTexture = null;
                TestRenderVideoFrame.this.destroyGLThread();
                return false;
            }

            public void onSurfaceTextureUpdated(SurfaceTexture surface) {
            }
        });
    }

    public void stop() {
        if (this.mRenderView != null) {
            this.mRenderView.setSurfaceTextureListener(null);
        }
        this.destroyGLThread();
    }

    public void onRenderVideoFrame(String userId, int streamType, TRTCCloudDef.TRTCVideoFrame frame) {
        if (frame.bufferType == 3) {
            this.mVideoWidth = frame.width;
            this.mVideoHeight = frame.height;
            this.renderTexture(frame.texture);
        } else if (frame.pixelFormat == 1 && frame.bufferType == 2) {
            this.mVideoWidth = frame.width;
            this.mVideoHeight = frame.height;
            this.renderI420(frame.data, frame.width, frame.height);
        } else {
            Log.w((String)TAG, (String)"error video frame type");
        }
    }

    @Override
    public void onEGLCreate() {
        this.initGL();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onTextureProcess(EGLContext eglContext) {
        if (this.mRenderView != null) {
            if (this.mTextureId != -1) {
                if (this.mTextureFilter != null) {
                    this.mTextureFilter.draw(this.mTextureId, this.mVideoWidth, this.mVideoHeight, this.mRenderView.getWidth(), this.mRenderView.getHeight());
                }
                this.mGLHandler.swap();
                this.mTextureId = -1;
            } else if (this.mUVData != null && this.mYdata != null) {
                ByteBuffer yData = null;
                ByteBuffer uvData = null;
                TestRenderVideoFrame testRenderVideoFrame = this;
                synchronized (testRenderVideoFrame) {
                    yData = this.mYdata;
                    uvData = this.mUVData;
                    this.mYdata = null;
                    this.mUVData = null;
                }
                if (this.mYUVFilter != null && yData != null && uvData != null) {
                    this.mYUVFilter.drawFrame(yData, uvData, this.mVideoWidth, this.mVideoHeight, this.mRenderView.getWidth(), this.mRenderView.getHeight());
                    this.mGLHandler.swap();
                }
            }
        }
    }

    @Override
    public void onEGLDestroy() {
        this.unInitGL();
    }

    private void renderTexture(TRTCCloudDef.TRTCTexture textureFrame) {
        if (textureFrame == null) {
            return;
        }
        if (this.mGLHandler == null) {
            this.mRenderType = 0;
            this.createGLThread(textureFrame.eglContext14);
        }
        this.mTextureId = textureFrame.textureId;
        GLES20.glFinish();
        this.sendMsg(102);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderI420(byte[] yuvData, int width, int height) {
        if (yuvData == null) {
            return;
        }
        if (this.mGLHandler == null) {
            this.mRenderType = 1;
            this.createGLThread(null);
        }
        TestRenderVideoFrame testRenderVideoFrame = this;
        synchronized (testRenderVideoFrame) {
            this.mYdata = ByteBuffer.wrap(yuvData, 0, width * height);
            this.mUVData = ByteBuffer.allocate(width * height / 2);
            this.mUVData.put(yuvData, width * height, width * height / 2);
            this.mUVData.position(0);
        }
        this.sendMsg(102);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createGLThread(EGLContext eglContext) {
        if (this.mSurfaceTexture == null) {
            return;
        }
        this.destroyGLThread();
        TestRenderVideoFrame testRenderVideoFrame = this;
        synchronized (testRenderVideoFrame) {
            this.mGLThread = new HandlerThread(TAG);
            this.mGLThread.start();
            this.mGLHandler = new GLThread.GLThreadHandler(this.mGLThread.getLooper());
            this.mGLHandler.mSurface = new Surface(this.mSurfaceTexture);
            this.mGLHandler.mEgl14Context = eglContext;
            this.mGLHandler.setListener(this);
            Log.w((String)TAG, (String)("surface-render: create gl thread " + this.mGLThread.getName()));
        }
        this.sendMsg(100);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyGLThread() {
        TestRenderVideoFrame testRenderVideoFrame = this;
        synchronized (testRenderVideoFrame) {
            if (this.mGLHandler != null) {
                GLThread.GLThreadHandler.quitGLThread(this.mGLHandler, this.mGLThread);
                Log.w((String)TAG, (String)"surface-render: destroy gl thread");
            }
            this.mGLHandler = null;
            this.mGLThread = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendMsg(int what) {
        TestRenderVideoFrame testRenderVideoFrame = this;
        synchronized (testRenderVideoFrame) {
            if (this.mGLHandler != null) {
                this.mGLHandler.sendEmptyMessage(what);
            }
        }
    }

    private void initGL() {
        if (this.mRenderType == 0) {
            this.mTextureFilter = new GLTexture2DFilter();
        } else if (this.mRenderType == 1) {
            this.mYUVFilter = new GLI420RenderFilter();
        }
    }

    private void unInitGL() {
        if (this.mTextureFilter != null) {
            this.mTextureFilter.release();
            this.mTextureFilter = null;
        }
        if (this.mYUVFilter != null) {
            this.mYUVFilter.release();
            this.mYUVFilter = null;
        }
    }
}

