/*
 * Decompiled with CFR 0.152.
 */
package com.html5app.uni_tencent_call.TestCustomVideo;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.opengl.EGLContext;
import android.view.Surface;
import com.html5app.uni_tencent_call.TestCustomVideo.MovieVideoFrameReader;
import com.html5app.uni_tencent_call.TestCustomVideo.OpenGLBaseModule.GLThread;
import com.tencent.trtc.TRTCCloud;
import com.tencent.trtc.TRTCCloudDef;

public class TestSendCustomVideoData
implements GLThread.IGLSurfaceTextureListener {
    private static String TAG = "TestSendCustomVideoData";
    private String mVideoFile;
    private Context mContext;
    private TRTCCloud mTRTCCloud;
    private boolean mIsSending;
    private GLThread mGLThread;
    private MovieVideoFrameReader mPlayThread;

    public TestSendCustomVideoData(Context context) {
        this.mContext = context;
        this.mTRTCCloud = TRTCCloud.sharedInstance((Context)this.mContext);
        this.mIsSending = false;
    }

    public synchronized void start(String videoFile) {
        if (this.mIsSending) {
            return;
        }
        this.mVideoFile = videoFile;
        this.mGLThread = new GLThread();
        this.mGLThread.setListener(this);
        this.mGLThread.start();
        this.mIsSending = true;
    }

    public synchronized void stop() {
        if (!this.mIsSending) {
            return;
        }
        this.mIsSending = false;
        if (this.mPlayThread != null) {
            this.mPlayThread.requestStop();
        }
        if (this.mGLThread != null) {
            this.mGLThread.stop();
        }
    }

    @Override
    public void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture) {
        this.mPlayThread = new MovieVideoFrameReader(this.mVideoFile, new Surface(surfaceTexture));
        this.mGLThread.setInputSize(this.mPlayThread.getVideoWidth(), this.mPlayThread.getVideoHeight());
        this.mPlayThread.start();
    }

    @Override
    public int onTextureProcess(int textureId, EGLContext eglContext) {
        if (!this.mIsSending) {
            return textureId;
        }
        TRTCCloudDef.TRTCVideoFrame videoFrame = new TRTCCloudDef.TRTCVideoFrame();
        videoFrame.texture = new TRTCCloudDef.TRTCTexture();
        videoFrame.texture.textureId = textureId;
        videoFrame.texture.eglContext14 = eglContext;
        videoFrame.width = this.mPlayThread.getVideoWidth();
        videoFrame.height = this.mPlayThread.getVideoHeight();
        videoFrame.pixelFormat = 2;
        videoFrame.bufferType = 3;
        this.mTRTCCloud.sendCustomVideoData(videoFrame);
        return textureId;
    }

    @Override
    public void onSurfaceTextureDestroy(SurfaceTexture surfaceTexture) {
    }
}

