/*
 * Decompiled with CFR 0.152.
 */
package com.html5app.uni_tencent_call.utils;

import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.provider.Settings;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import java.util.HashMap;
import java.util.Map;

public class FloatingWindowHelper {
    private WindowManager mWindowManager;
    private Map<View, WindowManager.LayoutParams> mChildViewMap;

    public FloatingWindowHelper(Context context) {
        this.mWindowManager = (WindowManager)context.getSystemService("window");
    }

    private WindowManager.LayoutParams createLayoutParams() {
        WindowManager.LayoutParams layoutParams = new WindowManager.LayoutParams();
        layoutParams.type = Build.VERSION.SDK_INT >= 26 ? 2038 : 2002;
        layoutParams.format = 1;
        layoutParams.gravity = 0x800033;
        layoutParams.flags = 40;
        layoutParams.width = -2;
        layoutParams.height = -2;
        return layoutParams;
    }

    public void addView(View view) {
        if (this.mWindowManager == null) {
            return;
        }
        if (this.mChildViewMap == null) {
            this.mChildViewMap = new HashMap<View, WindowManager.LayoutParams>();
        }
        if (!this.mChildViewMap.containsKey(view)) {
            WindowManager.LayoutParams layoutParams = this.createLayoutParams();
            this.mChildViewMap.put(view, layoutParams);
            this.mWindowManager.addView(view, (ViewGroup.LayoutParams)layoutParams);
        }
    }

    public void addView(View view, int x, int y) {
        if (this.mWindowManager == null) {
            return;
        }
        if (this.mChildViewMap == null) {
            this.mChildViewMap = new HashMap<View, WindowManager.LayoutParams>();
        }
        if (!this.mChildViewMap.containsKey(view)) {
            WindowManager.LayoutParams layoutParams = this.createLayoutParams();
            layoutParams.x = x;
            layoutParams.y = y;
            this.mChildViewMap.put(view, layoutParams);
            this.mWindowManager.addView(view, (ViewGroup.LayoutParams)layoutParams);
        }
    }

    public void addView(View view, boolean canMove) {
        if (this.mWindowManager == null) {
            return;
        }
        if (this.mChildViewMap == null) {
            this.mChildViewMap = new HashMap<View, WindowManager.LayoutParams>();
        }
        if (!this.mChildViewMap.containsKey(view)) {
            WindowManager.LayoutParams layoutParams = this.createLayoutParams();
            this.mChildViewMap.put(view, layoutParams);
            this.mWindowManager.addView(view, (ViewGroup.LayoutParams)layoutParams);
            if (canMove) {
                view.setOnTouchListener((View.OnTouchListener)new FloatingOnTouchListener());
            }
        }
    }

    public void addView(View view, int x, int y, boolean canMove) {
        if (this.mWindowManager == null) {
            return;
        }
        if (this.mChildViewMap == null) {
            this.mChildViewMap = new HashMap<View, WindowManager.LayoutParams>();
        }
        if (!this.mChildViewMap.containsKey(view)) {
            WindowManager.LayoutParams layoutParams = this.createLayoutParams();
            layoutParams.x = x;
            layoutParams.y = y;
            this.mChildViewMap.put(view, layoutParams);
            this.mWindowManager.addView(view, (ViewGroup.LayoutParams)layoutParams);
            if (canMove) {
                view.setOnTouchListener((View.OnTouchListener)new FloatingOnTouchListener());
            }
        }
    }

    public void addView(View view, WindowManager.LayoutParams layoutParams) {
        if (this.mWindowManager == null) {
            return;
        }
        if (this.mChildViewMap == null) {
            this.mChildViewMap = new HashMap<View, WindowManager.LayoutParams>();
        }
        if (!this.mChildViewMap.containsKey(view)) {
            this.mChildViewMap.put(view, layoutParams);
            this.mWindowManager.addView(view, (ViewGroup.LayoutParams)layoutParams);
        }
    }

    public boolean contains(View view) {
        if (this.mChildViewMap != null) {
            return this.mChildViewMap.containsKey(view);
        }
        return false;
    }

    public void removeView(View view) {
        if (this.mWindowManager == null) {
            return;
        }
        if (this.mChildViewMap != null) {
            this.mChildViewMap.remove(view);
        }
        this.mWindowManager.removeView(view);
    }

    public void updateViewLayout(View view, WindowManager.LayoutParams layoutParams) {
        if (this.mWindowManager == null) {
            return;
        }
        if (this.mChildViewMap != null && this.mChildViewMap.containsKey(view)) {
            this.mChildViewMap.put(view, layoutParams);
            this.mWindowManager.updateViewLayout(view, (ViewGroup.LayoutParams)layoutParams);
        }
    }

    public WindowManager.LayoutParams getLayoutParams(View view) {
        if (this.mChildViewMap.containsKey(view)) {
            return this.mChildViewMap.get(view);
        }
        return null;
    }

    public void clear() {
        if (this.mWindowManager == null) {
            return;
        }
        for (View view : this.mChildViewMap.keySet()) {
            this.mWindowManager.removeView(view);
        }
        this.mChildViewMap.clear();
    }

    public void destroy() {
        if (this.mWindowManager == null) {
            return;
        }
        for (View view : this.mChildViewMap.keySet()) {
            this.mWindowManager.removeView(view);
        }
        this.mChildViewMap.clear();
        this.mChildViewMap = null;
        this.mWindowManager = null;
    }

    public static boolean canDrawOverlays(Context context, boolean isApplyAuthorization) {
        if (Build.VERSION.SDK_INT >= 23) {
            if (Settings.canDrawOverlays((Context)context)) {
                return true;
            }
            if (isApplyAuthorization) {
                Intent intent = new Intent("android.settings.action.MANAGE_OVERLAY_PERMISSION", Uri.parse((String)("package:" + context.getPackageName())));
                if (context instanceof Service) {
                    intent.setFlags(0x10000000);
                }
                context.startActivity(intent);
                return false;
            }
            return false;
        }
        return true;
    }

    public class FloatingOnTouchListener
    implements View.OnTouchListener {
        private int x;
        private int y;

        public boolean onTouch(View view, MotionEvent event) {
            if (FloatingWindowHelper.this.mChildViewMap.containsKey(view)) {
                switch (event.getAction()) {
                    case 0: {
                        this.x = (int)event.getRawX();
                        this.y = (int)event.getRawY();
                        break;
                    }
                    case 2: {
                        int nowX = (int)event.getRawX();
                        int nowY = (int)event.getRawY();
                        int movedX = nowX - this.x;
                        int movedY = nowY - this.y;
                        this.x = nowX;
                        this.y = nowY;
                        WindowManager.LayoutParams layoutParams = (WindowManager.LayoutParams)FloatingWindowHelper.this.mChildViewMap.get(view);
                        layoutParams.x += movedX;
                        layoutParams.y += movedY;
                        if (layoutParams.x < 0) {
                            layoutParams.x = 0;
                        }
                        if (layoutParams.y < 0) {
                            layoutParams.y = 0;
                        }
                        FloatingWindowHelper.this.mWindowManager.updateViewLayout(view, (ViewGroup.LayoutParams)layoutParams);
                        break;
                    }
                }
            }
            return view.onTouchEvent(event);
        }
    }
}

