/*
 * Decompiled with CFR 0.152.
 */
package com.html5app.uni_tencent_call.widgets;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Xfermode;
import android.graphics.drawable.BitmapDrawable;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import com.html5app.uni_tencent_call.R;

public class VoiceFloatingView
extends View {
    private final String TAG = VoiceFloatingView.class.getSimpleName();
    private int mDefaultWidth;
    private int mDefaultHeight;
    private int mWidth;
    private int mHeight;
    private Paint mPaint;
    private Bitmap mBitmap;
    private PorterDuffXfermode mPorterDuffXfermode;
    private Direction mDirection = Direction.right;
    private int mOrientation;
    private int mWidthPixels;
    private WindowManager mWindowManager;
    private WindowManager.LayoutParams mLayoutParams;
    private boolean mIsShow;
    private int numisT = 0;
    public boolean isMome = false;
    private int x;
    private int y;

    public VoiceFloatingView(Context context) {
        super(context);
        this.init();
    }

    private void init() {
        this.mWindowManager = (WindowManager)this.getContext().getSystemService("window");
        this.mLayoutParams = new WindowManager.LayoutParams();
        this.mLayoutParams.type = Build.VERSION.SDK_INT >= 26 ? 2038 : 2002;
        this.mLayoutParams.format = 1;
        this.mLayoutParams.gravity = 0x800033;
        this.mLayoutParams.flags = 40;
        this.mLayoutParams.width = -2;
        this.mLayoutParams.height = -2;
        this.mPaint = new Paint();
        this.mPaint.setAntiAlias(true);
        this.mPorterDuffXfermode = new PorterDuffXfermode(PorterDuff.Mode.DST_ATOP);
        this.mBitmap = ((BitmapDrawable)this.getResources().getDrawable(R.mipmap.b8e)).getBitmap();
        this.mDefaultHeight = 180;
        this.mDefaultWidth = 180;
        this.recordScreenWidth();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.mWidth = this.measureSize(this.mDefaultWidth, heightMeasureSpec);
        this.mHeight = this.measureSize(this.mDefaultHeight, widthMeasureSpec);
        this.setMeasuredDimension(this.mWidth, this.mHeight);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        canvas.drawColor(0, PorterDuff.Mode.CLEAR);
        int d = 20;
        int r = 30;
        this.mPaint.setColor(Color.parseColor((String)"#D9E1E1E1"));
        if (Build.VERSION.SDK_INT >= 21) {
            canvas.drawRoundRect(0.0f, 0.0f, (float)this.mWidth, (float)this.mHeight, (float)r, (float)r, this.mPaint);
        }
        switch (this.mDirection) {
            default: {
                this.mPaint.setXfermode((Xfermode)this.mPorterDuffXfermode);
                if (Build.VERSION.SDK_INT < 21) break;
                canvas.drawRoundRect((float)(this.mWidth / 2), 0.0f, (float)this.mWidth, (float)this.mHeight, 0.0f, 0.0f, this.mPaint);
                break;
            }
            case left: {
                this.mPaint.setXfermode((Xfermode)this.mPorterDuffXfermode);
                if (Build.VERSION.SDK_INT < 21) break;
                canvas.drawRoundRect(0.0f, 0.0f, (float)(this.mWidth / 2), (float)this.mHeight, 0.0f, 0.0f, this.mPaint);
            }
            case move: 
        }
        this.mPaint.setXfermode(null);
        this.mPaint.setColor(-1);
        if (Build.VERSION.SDK_INT >= 21) {
            canvas.drawRoundRect((float)d, (float)d, (float)(this.mWidth - d), (float)(this.mHeight - d), (float)r, (float)r, this.mPaint);
        }
        canvas.drawBitmap(this.mBitmap, (float)((this.mWidth - this.mBitmap.getWidth()) / 2), (float)((this.mHeight - this.mBitmap.getHeight()) / 2), this.mPaint);
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.mWindowManager != null) {
            if (this.getResources().getConfiguration().orientation != this.mOrientation) {
                this.recordScreenWidth();
            }
            switch (event.getAction()) {
                case 0: {
                    this.x = (int)event.getRawX();
                    this.y = (int)event.getRawY();
                    this.isMome = false;
                    this.numisT = 0;
                    Log.i((String)"VoiceFloatingView", (String)"===\u6309\u4e0b");
                    break;
                }
                case 2: {
                    int nowX = (int)event.getRawX();
                    int nowY = (int)event.getRawY();
                    int movedX = nowX - this.x;
                    int movedY = nowY - this.y;
                    this.x = nowX;
                    this.y = nowY;
                    this.mLayoutParams.x += movedX;
                    this.mLayoutParams.y += movedY;
                    if (this.mLayoutParams.x < 0) {
                        this.mLayoutParams.x = 0;
                    }
                    if (this.mLayoutParams.y < 0) {
                        this.mLayoutParams.y = 0;
                    }
                    if (this.mDirection != Direction.move) {
                        this.mDirection = Direction.move;
                        this.invalidate();
                    }
                    Log.i((String)"VoiceFloatingView", (String)"===\u79fb\u52a8");
                    ++this.numisT;
                    if (this.numisT > 3) {
                        this.isMome = true;
                    }
                    this.mWindowManager.updateViewLayout((View)this, (ViewGroup.LayoutParams)this.mLayoutParams);
                    break;
                }
                case 1: {
                    Log.i((String)"VoiceFloatingView", (String)"===\u677e\u5f00");
                    this.handleDirection((int)event.getRawX(), (int)event.getRawY());
                    this.invalidate();
                    this.mWindowManager.updateViewLayout((View)this, (ViewGroup.LayoutParams)this.mLayoutParams);
                    break;
                }
            }
        }
        return super.onTouchEvent(event);
    }

    private int measureSize(int defaultSize, int measureSpec) {
        int result = defaultSize;
        int specMode = View.MeasureSpec.getMode((int)measureSpec);
        int specSize = View.MeasureSpec.getSize((int)measureSpec);
        if (specMode == 0x40000000) {
            result = specSize;
        } else if (specMode == Integer.MIN_VALUE) {
            result = Math.min(result, specSize);
        }
        return result;
    }

    private void recordScreenWidth() {
        this.mOrientation = this.getResources().getConfiguration().orientation;
        DisplayMetrics outMetrics = new DisplayMetrics();
        this.mWindowManager.getDefaultDisplay().getMetrics(outMetrics);
        this.mWidthPixels = outMetrics.widthPixels;
    }

    private void handleDirection(int x, int y) {
        if (x > this.mWidthPixels / 2) {
            this.mDirection = Direction.right;
            this.mLayoutParams.x = this.mWidthPixels - this.getMeasuredWidth();
        } else {
            this.mDirection = Direction.left;
            this.mLayoutParams.x = 0;
        }
    }

    public void show() {
        if (!this.mIsShow) {
            if (this.mLayoutParams.x == 0 && this.mLayoutParams.y == 0 && this.mDirection == Direction.right) {
                this.mLayoutParams.x = this.mWidthPixels - this.mDefaultWidth;
                this.mLayoutParams.y = 180;
            }
            if (this.mDirection == Direction.move) {
                this.handleDirection(this.mLayoutParams.x, this.mLayoutParams.y);
            }
            this.mWindowManager.addView((View)this, (ViewGroup.LayoutParams)this.mLayoutParams);
            this.mIsShow = true;
        }
    }

    public void updateViewLayout(int x, int y) {
        if (this.mIsShow) {
            this.handleDirection(x, y);
            this.invalidate();
            this.mLayoutParams.y = y;
            this.mWindowManager.updateViewLayout((View)this, (ViewGroup.LayoutParams)this.mLayoutParams);
        }
    }

    public void dismiss() {
        if (this.mIsShow) {
            this.mWindowManager.removeView((View)this);
            this.mIsShow = false;
        }
    }

    public static enum Direction {
        left,
        right,
        move;

    }
}

