/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import android.os.Bundle;
import android.view.Surface;
import com.tencent.liteav.basic.d.g;
import com.tencent.liteav.basic.log.TXCLog;
import com.tencent.liteav.basic.module.TXCEventRecorderProxy;
import com.tencent.liteav.basic.module.TXCKeyPointReportProxy;
import com.tencent.liteav.basic.structs.TXSNALPacket;
import com.tencent.liteav.basic.structs.TXSVideoFrame;
import com.tencent.liteav.basic.util.TXCTimeUtil;
import com.tencent.liteav.basic.util.d;
import com.tencent.liteav.beauty.b.o;
import com.tencent.liteav.g;
import com.tencent.liteav.n;
import com.tencent.liteav.renderer.a;
import com.tencent.liteav.renderer.e;
import com.tencent.liteav.renderer.f;
import com.tencent.liteav.videodecoder.TXCVideoDecoder;
import com.tencent.liteav.videodecoder.c;
import java.lang.ref.WeakReference;

public class TXCRenderAndDec
extends com.tencent.liteav.basic.module.a
implements com.tencent.liteav.basic.c.a,
a.a,
f,
c {
    public static final String TAG = "TXCRenderAndDec";
    private Context mContext = null;
    private g mConfig = null;
    private TXCVideoDecoder mVideoDecoder = null;
    private boolean mEnableDecoderChange = false;
    private e mVideoRender = null;
    private WeakReference<com.tencent.liteav.basic.c.a> mNotifyListener;
    private WeakReference<b> mRenderAndDecDelegate;
    private com.tencent.liteav.basic.d.g mVideoFrameFilter = null;
    public static final int VIDEO_PIXEL_FORMAT_I420 = 1;
    public static final int VIDEO_PIXEL_FORMAT_Texture_2D = 2;
    public static final int VIDEO_PIXEL_FORMAT_TEXTURE_EXTERNAL_OES = 3;
    public static final int VIDEO_PIXEL_FORMAT_NV21 = 4;
    private int mVideoFrameFormat = 1;
    private n mVideoFrameListener;
    private boolean mRealTime = false;
    private boolean mIsRendering = false;
    private int mStreamType = 0;
    private long mFrameDecErrCnt = 0L;
    private long mLastReqKeyFrameTS = 0L;
    private boolean mFirstRender = false;
    private int mRenderMode = 0;
    private int mRenderRotation = 0;
    private long mLastRenderCalculateTS = 0L;
    private long mRenderFrameCount = 0L;
    private long mLastRenderFrameCount = 0L;
    private a mDecListener = null;

    public TXCRenderAndDec(Context context) {
        this.mContext = context;
        com.tencent.liteav.basic.e.b.a().a(this.mContext);
    }

    public void setVideoRender(e e2) {
        TXCLog.i(TAG, "set video render " + e2 + " id " + this.getID() + ", " + this.mStreamType);
        this.mVideoRender = e2;
        if (this.mVideoRender == null) {
            return;
        }
        this.mVideoRender.setID(this.getID());
        this.mVideoRender.a(this.mStreamType);
        this.mVideoRender.a(this);
        this.mVideoRender.c(this.mRenderMode);
        this.mVideoRender.d(this.mRenderRotation);
        if (this.mVideoRender instanceof com.tencent.liteav.renderer.a) {
            ((com.tencent.liteav.renderer.a)this.mVideoRender).b(this);
        }
        if (this.mConfig != null) {
            this.mVideoRender.b(this.mConfig.d);
        }
    }

    public void setNotifyListener(com.tencent.liteav.basic.c.a a2) {
        this.mNotifyListener = new WeakReference<com.tencent.liteav.basic.c.a>(a2);
    }

    public void setRenderAndDecDelegate(b b2) {
        this.mRenderAndDecDelegate = new WeakReference<b>(b2);
    }

    public void setVideoFrameListener(n n2, int n3) {
        this.mVideoFrameListener = n2;
        this.mVideoFrameFormat = n3;
        TXCLog.i(TAG, "setVideoFrameListener->enter listener: " + n2 + ", format: " + n3);
    }

    public void setConfig(g g2) {
        this.mConfig = g2;
        if (this.mVideoRender != null) {
            this.mVideoRender.b(this.mConfig.d);
        }
    }

    public g getConfig() {
        return this.mConfig;
    }

    @Override
    public void setID(String string) {
        super.setID(string);
        if (this.mVideoRender != null) {
            this.mVideoRender.setID(this.getID());
        }
        if (this.mVideoDecoder != null) {
            this.mVideoDecoder.setUserId(string);
        }
    }

    public void setDecListener(a a2) {
        this.mDecListener = a2;
    }

    public void enableDecoderChange(boolean bl) {
        this.mEnableDecoderChange = bl;
    }

    public void start(boolean bl) {
        TXCLog.i(TAG, "start render dec " + this.getID() + ", " + this.mStreamType);
        this.mRealTime = bl;
        this.mFrameDecErrCnt = 0L;
        this.mLastReqKeyFrameTS = 0L;
        if (this.mVideoRender != null) {
            this.mVideoRender.a(this);
            this.mVideoRender.g();
            this.mVideoRender.setID(this.getID());
        }
        this.mVideoDecoder = new TXCVideoDecoder();
        this.mVideoDecoder.setUserId(this.getID());
        this.mVideoDecoder.setStreamType(this.mStreamType);
        this.mVideoDecoder.setListener(this);
        this.mVideoDecoder.setNotifyListener(this);
        this.mVideoDecoder.enableChange(this.mEnableDecoderChange);
        this.startDecode();
        this.mIsRendering = true;
    }

    public void startVideo() {
        this.stopVideo();
        this.mRealTime = true;
        this.mFrameDecErrCnt = 0L;
        this.mLastReqKeyFrameTS = 0L;
        if (this.mVideoRender != null) {
            this.mVideoRender.a(this);
            this.mVideoRender.g();
            this.mVideoRender.setID(this.getID());
        }
        TXCLog.i(TAG, "start video dec " + this.getID() + ", " + this.mStreamType);
        this.mVideoDecoder = new TXCVideoDecoder();
        this.mVideoDecoder.setUserId(this.getID());
        this.mVideoDecoder.setStreamType(this.mStreamType);
        this.mVideoDecoder.setListener(this);
        this.mVideoDecoder.setNotifyListener(this);
        this.mVideoDecoder.enableChange(this.mEnableDecoderChange);
        this.startDecode();
        this.mIsRendering = true;
    }

    public void stopVideo() {
        this.mIsRendering = false;
        if (this.mVideoDecoder != null) {
            TXCLog.i(TAG, "stop video dec " + this.getID() + ", " + this.mStreamType);
            this.mVideoDecoder.setListener(null);
            this.mVideoDecoder.setNotifyListener(null);
            this.mVideoDecoder.stop();
        }
        if (this.mVideoRender != null) {
            this.mVideoRender.a(false);
            this.mVideoRender.a((f)null);
        }
    }

    public void stop() {
        TXCLog.i(TAG, "stop video render dec " + this.getID() + ", " + this.mStreamType);
        this.mIsRendering = false;
        this.mRealTime = false;
        if (this.mVideoDecoder != null) {
            this.mVideoDecoder.setListener(null);
            this.mVideoDecoder.setNotifyListener(null);
            this.mVideoDecoder.stop();
        }
        if (this.mVideoRender != null) {
            this.mVideoRender.a(true);
            this.mVideoRender.a((f)null);
        }
    }

    public boolean isRendering() {
        return this.mIsRendering;
    }

    public void decVideo(TXSNALPacket tXSNALPacket) {
    }

    public void setRenderMode(int n2) {
        this.mRenderMode = n2;
        if (this.mVideoRender != null) {
            this.mVideoRender.c(n2);
        }
    }

    public void setRenderRotation(int n2) {
        TXCLog.i(TAG, "vrotation setRenderRotation " + n2);
        this.mRenderRotation = n2;
        if (this.mVideoRender != null) {
            this.mVideoRender.d(n2);
        }
    }

    public void setBlockInterval(int n2) {
        if (this.mVideoRender != null) {
            this.mVideoRender.e(n2);
        }
    }

    public long getVideoCacheDuration() {
        int n2 = this.getIntValue(6010, 2);
        return n2;
    }

    public long getVideoCacheFrameCount() {
        int n2 = this.getIntValue(6011, 2);
        return n2;
    }

    public int getVideoDecCacheFrameCount() {
        int n2 = this.getIntValue(6012, 2);
        return n2;
    }

    public long getAVPlayInterval() {
        long l2 = this.getLongValue(6013, 2);
        return l2;
    }

    public long getAVNetRecvInterval() {
        long l2 = this.getLongValue(6014, 2);
        return l2;
    }

    public int getVideoGop() {
        return this.getIntValue(7120);
    }

    public void updateLoadInfo() {
        if (this.mVideoDecoder != null) {
            this.setStatusValue(5002, this.mStreamType, this.mVideoDecoder.isHardwareDecode() ? 1L : 0L);
        }
        if (this.mVideoRender != null) {
            this.mVideoRender.o();
        } else {
            long l2 = System.currentTimeMillis();
            long l3 = l2 - this.mLastRenderCalculateTS;
            if (l3 >= 1000L) {
                double d2 = (double)(this.mRenderFrameCount - this.mLastRenderFrameCount) * 1000.0 / (double)l3;
                this.mLastRenderFrameCount = this.mRenderFrameCount;
                this.mLastRenderCalculateTS = l2;
                this.setStatusValue(6002, this.mStreamType, d2);
            }
        }
    }

    public e getVideoRender() {
        return this.mVideoRender;
    }

    public void setStreamType(int n2) {
        this.mStreamType = n2;
        if (this.mVideoRender != null) {
            this.mVideoRender.a(this.mStreamType);
        }
        if (this.mVideoDecoder != null) {
            this.mVideoDecoder.setStreamType(this.mStreamType);
        }
    }

    public int getStreamType() {
        return this.mStreamType;
    }

    private void startDecode(SurfaceTexture surfaceTexture) {
        TXCVideoDecoder tXCVideoDecoder = this.mVideoDecoder;
        if (tXCVideoDecoder != null) {
            tXCVideoDecoder.stop();
            tXCVideoDecoder.enableHWDec(this.mConfig.h);
            TXCLog.i(TAG, "trtc_ start decode " + surfaceTexture + ", hw: " + this.mConfig.h + ", id " + this.getID() + "_" + this.mStreamType);
            if (surfaceTexture != null) {
                tXCVideoDecoder.setup(surfaceTexture, null, null, !this.mRealTime);
                tXCVideoDecoder.setUserId(this.getID());
                tXCVideoDecoder.start();
            } else if (!this.mConfig.h) {
                tXCVideoDecoder.setup((Surface)null, null, null, !this.mRealTime);
                tXCVideoDecoder.setUserId(this.getID());
                tXCVideoDecoder.start();
            }
        }
    }

    private void startDecode() {
        SurfaceTexture surfaceTexture = this.mVideoRender != null ? this.mVideoRender.a() : null;
        this.startDecode(surfaceTexture);
    }

    private void notifyEvent(int n2, String string) {
        Bundle bundle = new Bundle();
        bundle.putString("EVT_USERID", this.getID());
        bundle.putInt("EVT_ID", n2);
        bundle.putLong("EVT_TIME", TXCTimeUtil.getTimeTick());
        if (string != null) {
            bundle.putCharSequence("EVT_MSG", (CharSequence)string);
        }
        bundle.putInt("EVT_STREAM_TYPE", this.mStreamType);
        d.a(this.mNotifyListener, n2, bundle);
    }

    private void switchToSoftDecoder() {
        TXCVideoDecoder tXCVideoDecoder = this.mVideoDecoder;
        if (tXCVideoDecoder != null) {
            TXCLog.w(TAG, "switch to soft decoder when hw error");
            tXCVideoDecoder.stop();
            this.mConfig.h = false;
            tXCVideoDecoder.enableChange(false);
            this.startDecode();
        }
    }

    public void restartDecoder() {
        TXCVideoDecoder tXCVideoDecoder = this.mVideoDecoder;
        if (tXCVideoDecoder != null && tXCVideoDecoder.isHevc()) {
            tXCVideoDecoder.restart(true);
        }
    }

    @Override
    public void onNotifyEvent(int n2, Bundle bundle) {
        if (n2 == 2106) {
            this.switchToSoftDecoder();
        } else if (n2 == 2020) {
            TXCLog.e(TAG, "decoding too many frame(>40) without output! request key frame now.");
            this.requestKeyFrame();
            return;
        }
        bundle.putInt("EVT_STREAM_TYPE", this.mStreamType);
        d.a(this.mNotifyListener, n2, bundle);
    }

    @Override
    public void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture) {
        TXCLog.w(TAG, "play decode when surface texture create hw " + this.mConfig.h);
        TXCVideoDecoder tXCVideoDecoder = this.mVideoDecoder;
        if (tXCVideoDecoder != null) {
            tXCVideoDecoder.setup(surfaceTexture, null, null, !this.mRealTime);
        }
        if (this.mConfig.h) {
            this.startDecode(surfaceTexture);
        }
    }

    @Override
    public void onSurfaceTextureDestroy(SurfaceTexture surfaceTexture) {
        try {
            TXCLog.w(TAG, "play:stop decode when surface texture release");
            if (this.mConfig.h && this.mVideoDecoder != null) {
                this.mVideoDecoder.stop();
            }
            if (this.mVideoFrameFilter != null) {
                this.mVideoFrameFilter.d();
                this.mVideoFrameFilter = null;
            }
            if (this.mDecListener != null) {
                this.mDecListener.a(surfaceTexture);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void onDecodeFrame(TXSVideoFrame tXSVideoFrame, int n2, int n3, long l2, long l3, int n4) {
        n n5;
        if (n4 == 0 || n4 == 1 || n4 == 2 || n4 == 3) {
            n4 = 360 - n4 * 90;
        }
        if ((n5 = this.mVideoFrameListener) != null) {
            TXSVideoFrame tXSVideoFrame2 = tXSVideoFrame;
            if (this.mVideoRender != null && tXSVideoFrame2 != null) {
                tXSVideoFrame2 = tXSVideoFrame.clone();
            }
            tXSVideoFrame2.rotation = (n4 + this.mRenderRotation) % 360;
            if (this.mVideoFrameFormat == 4) {
                tXSVideoFrame2.loadNV21BufferFromI420Buffer();
            }
            n5.onRenderVideoFrame(this.getID(), this.mStreamType, tXSVideoFrame2);
        }
        if (!this.mFirstRender) {
            this.mFirstRender = true;
            TXCKeyPointReportProxy.a(this.getID(), 32004);
            TXCEventRecorderProxy.a(this.getID(), 5007, -1, -1, "", this.mStreamType);
        }
        if (this.mVideoRender != null) {
            this.mVideoRender.a(tXSVideoFrame, n2, n3, n4);
        } else if (this.mLastRenderCalculateTS == 0L) {
            this.mLastRenderCalculateTS = System.currentTimeMillis();
            this.mLastRenderFrameCount = 0L;
            this.mRenderFrameCount = 0L;
        } else {
            ++this.mRenderFrameCount;
        }
    }

    @Override
    public void onVideoSizeChange(int n2, int n3) {
        if (this.mVideoRender != null) {
            this.mVideoRender.b(n2, n3);
        }
        Bundle bundle = new Bundle();
        bundle.putCharSequence("EVT_MSG", (CharSequence)("\u5206\u8fa8\u7387\u6539\u53d8\u4e3a" + n2 + "x" + n3));
        bundle.putInt("EVT_PARAM1", n2);
        bundle.putInt("EVT_PARAM2", n3);
        bundle.putString("EVT_USERID", this.getID());
        bundle.putLong("EVT_TIME", TXCTimeUtil.getTimeTick());
        this.onNotifyEvent(2009, bundle);
        this.setStatusValue(5003, this.mStreamType, n2 << 16 | n3);
        TXCEventRecorderProxy.a(this.getID(), 4003, n2, n3, "", this.mStreamType);
        TXCKeyPointReportProxy.a(this.getID(), 40002, n2);
        TXCKeyPointReportProxy.a(this.getID(), 40003, n3);
    }

    @Override
    public void onDecodeFailed(int n2) {
        TXCLog.e(TAG, "video decode failed " + n2);
        this.requestKeyFrame();
        this.setStatusValue(17014, this.mStreamType, ++this.mFrameDecErrCnt);
    }

    @Override
    public void onTextureProcess(int n2, int n3, int n4, final int n5) {
        n n6 = this.mVideoFrameListener;
        if (n6 != null) {
            if (this.mVideoFrameFilter == null) {
                this.mVideoFrameFilter = this.mVideoFrameFormat == 4 ? new o(3) : new o(1);
                this.mVideoFrameFilter.a(true);
                if (this.mVideoFrameFilter.a()) {
                    this.mVideoFrameFilter.a(n3, n4);
                    this.mVideoFrameFilter.a(new g.a(){

                        @Override
                        public void a(int n2) {
                            com.tencent.liteav.basic.d.g g2 = TXCRenderAndDec.this.mVideoFrameFilter;
                            n n3 = TXCRenderAndDec.this.mVideoFrameListener;
                            if (g2 != null && n3 != null) {
                                TXSVideoFrame tXSVideoFrame = new TXSVideoFrame();
                                tXSVideoFrame.width = g2.n();
                                tXSVideoFrame.height = g2.o();
                                tXSVideoFrame.pts = TXCTimeUtil.getTimeTick();
                                tXSVideoFrame.rotation = (n5 + TXCRenderAndDec.this.mRenderRotation) % 360;
                                n3.onRenderVideoFrame(TXCRenderAndDec.this.getID(), TXCRenderAndDec.this.mStreamType, tXSVideoFrame);
                            }
                        }
                    });
                } else {
                    TXCLog.i(TAG, "throwVideoFrame->release mVideoFrameFilter");
                    this.mVideoFrameFilter = null;
                }
            }
            if (this.mVideoFrameFilter != null) {
                GLES20.glViewport((int)0, (int)0, (int)n3, (int)n4);
                this.mVideoFrameFilter.a(n3, n4);
                this.mVideoFrameFilter.b(n2);
            }
        }
    }

    private void requestKeyFrame() {
        long l2 = TXCTimeUtil.getTimeTick();
        if (l2 > this.mLastReqKeyFrameTS + 3000L) {
            b b2;
            this.mLastReqKeyFrameTS = l2;
            TXCLog.e(TAG, "requestKeyFrame: " + this.getID());
            if (this.mRenderAndDecDelegate != null && (b2 = (b)this.mRenderAndDecDelegate.get()) != null) {
                b2.onRequestKeyFrame(this.getID(), this.mStreamType);
            }
        }
    }

    public static interface a {
        public void a(SurfaceTexture var1);
    }

    public static interface b {
        public void onRequestKeyFrame(String var1, int var2);
    }
}

