/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.audio;

import android.content.Context;
import com.tencent.liteav.audio.d;
import com.tencent.liteav.audio.impl.a.a;
import com.tencent.liteav.audio.impl.a.e;
import com.tencent.liteav.audio.impl.a.f;
import com.tencent.liteav.basic.log.TXCLog;
import java.lang.ref.WeakReference;
import java.util.Arrays;

public class TXCAudioUGCRecorder
implements f {
    private static final String TAG = "AudioCenter:TXCAudioUGCRecorder";
    private WeakReference<d> mWeakRecordListener;
    protected int mSampleRate = 48000;
    protected int mChannels = 1;
    protected int mBits = 16;
    protected int mReverbType = 0;
    protected boolean mIsMute = false;
    protected int mAECType = 0;
    protected Context mContext;
    protected boolean mIsEarphoneOn = false;
    private long mEffectorObj = 0L;
    private long mLastPTS = 0L;
    private float mVolume = 1.0f;
    private a mBGMRecorder = null;
    private boolean mEnableBGMRecord = false;
    private boolean mCurBGMRecordFlag = false;
    private float mSpeedRate = 1.0f;
    private boolean mIsPause = false;
    static TXCAudioUGCRecorder instance;
    private int mVoiceKind = -1;
    private int mVoiceEnvironment = -1;

    public static TXCAudioUGCRecorder getInstance() {
        return instance;
    }

    private TXCAudioUGCRecorder() {
    }

    public int startRecord(Context context) {
        TXCLog.i(TAG, "startRecord");
        if (this.isRecording()) {
            if (this.mEnableBGMRecord == this.mCurBGMRecordFlag) {
                TXCLog.e(TAG, "startRecord failed! recorder is still running!");
                return -1;
            }
            TXCLog.e(TAG, "recorder is still running. will restart record! bgm record flag = " + this.mEnableBGMRecord);
            this.stopRecord();
            this.enableBGMRecord(!this.mCurBGMRecordFlag);
        }
        if (context != null) {
            this.mContext = context.getApplicationContext();
        }
        this.initEffector();
        if (this.mEnableBGMRecord) {
            TXCLog.i(TAG, "\u5f55\u5236BGM");
            this.mCurBGMRecordFlag = true;
            this.mBGMRecorder = new a();
            this.mBGMRecorder.a(this);
            this.setEarphoneOn(true);
            this.mBGMRecorder.a(this.mContext, this.mSampleRate, this.mChannels, this.mBits);
        } else {
            TXCLog.i(TAG, "\u5f55\u5236\u4eba\u58f0");
            this.mCurBGMRecordFlag = false;
            this.setEarphoneOn(false);
            e.a().a(this);
            e.a().a(this.mContext, this.mSampleRate, this.mChannels, this.mBits, this.mAECType);
        }
        return 0;
    }

    public int stopRecord() {
        TXCLog.i(TAG, "stopRecord");
        if (this.mBGMRecorder != null) {
            this.mBGMRecorder.a();
            this.mBGMRecorder = null;
        }
        e.a().a(true);
        this.enableBGMRecord(false);
        this.mIsPause = false;
        this.uninitEffector();
        return 0;
    }

    public void pause() {
        TXCLog.i(TAG, "pause");
        this.mIsPause = true;
        if (!this.mEnableBGMRecord && this.isRecording()) {
            TXCLog.i(TAG, "\u505c\u6b62\u7cfb\u7edf\u5f55\u97f3");
            e.a().a(true);
        }
    }

    public void resume() {
        TXCLog.i(TAG, "resume");
        this.mIsPause = false;
        if (!this.mEnableBGMRecord && !this.isRecording()) {
            TXCLog.i(TAG, "\u6062\u590d\u7cfb\u7edf\u5f55\u97f3");
            this.mCurBGMRecordFlag = false;
            this.setEarphoneOn(false);
            e.a().a(this);
            e.a().a(this.mContext, this.mSampleRate, this.mChannels, this.mBits, this.mAECType);
        }
    }

    public synchronized void setListener(d d2) {
        this.mWeakRecordListener = d2 == null ? null : new WeakReference<d>(d2);
    }

    public synchronized d getListener() {
        if (this.mWeakRecordListener != null) {
            return (d)this.mWeakRecordListener.get();
        }
        return null;
    }

    public void setChannels(int n2) {
        TXCLog.i(TAG, "setChannels: " + n2);
        this.mChannels = n2;
    }

    public int getChannels() {
        return this.mChannels;
    }

    public void setSampleRate(int n2) {
        TXCLog.i(TAG, "setSampleRate: " + n2);
        this.mSampleRate = n2;
    }

    public int getSampleRate() {
        return this.mSampleRate;
    }

    public synchronized void setReverbType(int n2) {
        TXCLog.i(TAG, "setReverbType: " + n2);
        this.mReverbType = n2;
        if (this.mEffectorObj > 0L) {
            this.nativeSetReverbType(this.mEffectorObj, n2);
        }
    }

    public void setAECType(int n2, Context context) {
        TXCLog.i(TAG, "setAECType: " + n2);
        this.mAECType = n2;
        if (context != null) {
            this.mContext = context.getApplicationContext();
        }
    }

    public void setMute(boolean bl) {
        TXCLog.i(TAG, "setMute: " + bl);
        this.mIsMute = bl;
    }

    public void enableBGMRecord(boolean bl) {
        TXCLog.i(TAG, "enableBGMRecord: " + bl);
        this.mEnableBGMRecord = bl;
    }

    public synchronized void setEarphoneOn(boolean bl) {
        TXCLog.i(TAG, "setEarphoneOn: " + bl);
        this.mIsEarphoneOn = bl;
        if (this.mEffectorObj > 0L) {
            boolean bl2 = false;
            if (bl || this.mAECType == 1) {
                bl2 = true;
            }
            this.nativeMixBGM(this.mEffectorObj, bl2);
        }
    }

    public boolean isRecording() {
        if (this.mBGMRecorder != null) {
            return this.mBGMRecorder.b();
        }
        return e.a().b();
    }

    public void sendCustomPCMData(byte[] byArray) {
    }

    public synchronized long getPcmCacheLen() {
        if (this.mEffectorObj <= 0L) {
            return 0L;
        }
        return this.nativeGetPcmCacheLen(this.mEffectorObj);
    }

    public synchronized void setVolume(float f2) {
        TXCLog.i(TAG, "setVolume: " + f2);
        this.mVolume = f2;
        if (this.mEffectorObj <= 0L) {
            return;
        }
        this.nativeSetVolume(this.mEffectorObj, f2);
    }

    public synchronized void setSpeedRate(float f2) {
        TXCLog.i(TAG, "setSpeedRate: " + f2);
        this.mSpeedRate = f2;
        if (this.mEffectorObj <= 0L) {
            return;
        }
        this.nativeSetSpeedRate(this.mEffectorObj, this.mSpeedRate);
    }

    public synchronized void clearCache() {
        TXCLog.i(TAG, "clearCache");
        if (this.mEffectorObj <= 0L) {
            return;
        }
        this.nativeClearCache(this.mEffectorObj);
    }

    @Override
    public void onAudioRecordStart() {
        TXCLog.i(TAG, "sys audio record start");
    }

    @Override
    public void onAudioRecordStop() {
        TXCLog.i(TAG, "sys audio record stop");
        e.a().a(null);
    }

    @Override
    public void onAudioRecordError(int n2, String string) {
        TXCLog.e(TAG, "sys audio record error: " + n2 + ", " + string);
        d d2 = this.getListener();
        if (d2 != null) {
            d2.onRecordError(n2, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onAudioRecordPCM(byte[] byArray, int n2, long l2) {
        if (this.mIsPause) {
            return;
        }
        if (this.mEffectorObj > 0L) {
            if (this.mIsMute) {
                Arrays.fill(byArray, (byte)0);
            }
            long l3 = l2;
            if (this.mLastPTS >= l2) {
                l3 = this.mLastPTS + 2L;
            }
            Object object = this;
            synchronized (object) {
                this.nativeProcess(this.mEffectorObj, byArray, n2);
            }
            object = null;
            do {
                Object object2 = this;
                synchronized (object2) {
                    object = this.nativeReadOneFrame(this.mEffectorObj);
                }
                if (object != null) {
                    this.mLastPTS = l3;
                    object2 = this.getListener();
                    if (object2 != null) {
                        object2.onRecordEncData((byte[])object, l3, this.mSampleRate, this.mChannels, this.mBits);
                    }
                }
                object2 = this;
                synchronized (object2) {
                    l3 += (long)(1024000.0f / (float)this.mSampleRate * this.mSpeedRate);
                }
            } while (object != null);
        } else {
            TXCLog.e(TAG, "effectorObj is null");
        }
    }

    private synchronized void initEffector() {
        this.uninitEffector();
        this.mEffectorObj = this.nativeCreateEffector(this.mSampleRate, this.mChannels, this.mBits);
        boolean bl = false;
        if (this.mIsEarphoneOn || this.mAECType == 1) {
            bl = true;
        }
        this.nativeSetReverbType(this.mEffectorObj, this.mReverbType);
        this.nativeSetChangerType(this.mEffectorObj, this.mVoiceKind, this.mVoiceEnvironment);
        this.nativeMixBGM(this.mEffectorObj, bl);
        this.nativeSetVolume(this.mEffectorObj, this.mVolume);
        this.nativeSetSpeedRate(this.mEffectorObj, this.mSpeedRate);
        this.nativeEnableEncoder(this.mEffectorObj, true);
        this.mLastPTS = 0L;
    }

    private synchronized void uninitEffector() {
        if (this.mEffectorObj > 0L) {
            this.nativeDestroyEffector(this.mEffectorObj);
            this.mEffectorObj = 0L;
        }
    }

    private native long nativeCreateEffector(int var1, int var2, int var3);

    private native void nativeEnableEncoder(long var1, boolean var3);

    private native void nativeSetReverbType(long var1, int var3);

    private native void nativeProcess(long var1, byte[] var3, int var4);

    private native byte[] nativeReadOneFrame(long var1);

    private native void nativeMixBGM(long var1, boolean var3);

    private native void nativeSetSpeedRate(long var1, float var3);

    private native long nativeGetPcmCacheLen(long var1);

    private native void nativeSetVolume(long var1, float var3);

    private native void nativeClearCache(long var1);

    private native void nativeDestroyEffector(long var1);

    public synchronized void setChangerType(int n2, int n3) {
        TXCLog.i(TAG, "setChangerType: " + n2 + " " + n3);
        this.mVoiceKind = n2;
        this.mVoiceEnvironment = n3;
        if (this.mEffectorObj <= 0L) {
            return;
        }
        this.nativeSetChangerType(this.mEffectorObj, n2, n3);
    }

    private native void nativeSetChangerType(long var1, int var3, int var4);

    static {
        com.tencent.liteav.basic.util.d.f();
        instance = new TXCAudioUGCRecorder();
    }
}

