/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.audio;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import com.tencent.liteav.audio.e;
import com.tencent.liteav.audio.impl.TXCTraeJNI;
import com.tencent.liteav.basic.log.TXCLog;
import com.tencent.liteav.basic.util.d;
import java.lang.ref.WeakReference;

public class TXCLiveBGMPlayer {
    private static final String TAG;
    private static final int PLAY_SUCCESS = 0;
    private static final int PLAY_ERR_OPEN = -1;
    private static final int PLAY_ERR_FILE_NOTFOUND = -2;
    private static final int PLAY_ERR_AUDIO_TRACK = -3;
    private static final int PLAY_ERR_AUDIO_TRACK_PLAY = -4;
    private static TXCLiveBGMPlayer instance;
    private String mFilePath = null;
    private boolean mIsRunning = false;
    private boolean mIsPause = false;
    private WeakReference<e> mWeakListener = null;
    private Context mContext = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TXCLiveBGMPlayer getInstance() {
        if (instance != null) return instance;
        Class<TXCLiveBGMPlayer> clazz = TXCLiveBGMPlayer.class;
        synchronized (TXCLiveBGMPlayer.class) {
            if (instance != null) return instance;
            instance = new TXCLiveBGMPlayer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private TXCLiveBGMPlayer() {
    }

    public synchronized void setOnPlayListener(e e2) {
        if (e2 == null) {
            this.mWeakListener = null;
        }
        this.mWeakListener = new WeakReference<e>(e2);
    }

    public void setContext(Context context) {
        this.mContext = context;
    }

    public boolean startPlay(String string) {
        if (string == null || string.isEmpty()) {
            TXCLog.e(TAG, "start live bgm failed! invalid params!");
            return false;
        }
        this.stopPlay();
        this.mFilePath = string;
        this.mIsRunning = true;
        boolean bl = this.nativeStartPlay(this.mFilePath, this);
        if (!bl) {
            this.onPlayEnd(-1);
            return false;
        }
        TXCTraeJNI.traeStartPlay(this.mContext);
        this.onPlayStart();
        TXCLog.i(TAG, "start bgm play : filePath = " + string);
        return true;
    }

    public boolean stopPlay() {
        this.mIsRunning = false;
        long l2 = System.currentTimeMillis();
        this.nativeStopPlay();
        TXCTraeJNI.traeStopPlay();
        this.mFilePath = null;
        this.mContext = null;
        this.mIsPause = false;
        TXCLog.i(TAG, "stopBGMPlay cost(MS): " + (System.currentTimeMillis() - l2));
        return true;
    }

    public boolean isRunning() {
        return this.mIsRunning && !this.mIsPause;
    }

    public boolean isPlaying() {
        return this.mIsRunning;
    }

    public boolean pause() {
        TXCLog.i(TAG, "pause");
        this.mIsPause = true;
        this.nativePause();
        return true;
    }

    public boolean resume() {
        TXCLog.i(TAG, "resume");
        this.mIsPause = false;
        this.nativeResume();
        return true;
    }

    public boolean setVolume(float f2) {
        this.nativeSetVolume(f2);
        return true;
    }

    public int getBGMDuration(String string) {
        if (string == null) {
            return this.nativeGetCurDurationMS();
        }
        return this.nativeGetDurationMS(string);
    }

    public int setBGMPosition(int n2) {
        if (n2 >= this.getBGMDuration(null)) {
            TXCLog.e(TAG, "setMusicPosition with position out of current music duration , finish play!");
            this.stopPlay();
            this.onPlayEnd(0);
            return 0;
        }
        return this.nativeSetCurPtsMS(n2);
    }

    public void setPitch(float f2) {
        this.nativeSetPitch(f2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onPlayStart() {
        e e2 = null;
        Object object = this;
        synchronized (object) {
            if (this.mWeakListener != null) {
                e2 = (e)this.mWeakListener.get();
            }
        }
        object = e2;
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(new Runnable((e)object){
            final /* synthetic */ e a;
            {
                this.a = e2;
            }

            @Override
            public void run() {
                if (this.a != null) {
                    this.a.onPlayStart();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onPlayEnd(int n2) {
        e e2 = null;
        Object object = this;
        synchronized (object) {
            if (this.mWeakListener != null) {
                e2 = (e)this.mWeakListener.get();
            }
        }
        object = e2;
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(new Runnable((e)object, n2){
            final /* synthetic */ e a;
            final /* synthetic */ int b;
            {
                this.a = e2;
                this.b = n2;
            }

            @Override
            public void run() {
                if (this.a != null) {
                    this.a.onPlayEnd(this.b);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onPlayProgress(long l2, long l3) {
        e e2 = null;
        TXCLiveBGMPlayer tXCLiveBGMPlayer = this;
        synchronized (tXCLiveBGMPlayer) {
            if (this.mWeakListener != null) {
                e2 = (e)this.mWeakListener.get();
            }
        }
        if (e2 != null) {
            e2.onPlayProgress(l2, l3);
        }
    }

    private void nativeOPlayProgress(long l2, long l3) {
        this.onPlayProgress(l2, l3);
        if (l2 == l3) {
            this.onPlayEnd(0);
        }
    }

    private native boolean nativeStartPlay(String var1, TXCLiveBGMPlayer var2);

    private native void nativeStopPlay();

    private native void nativePause();

    private native void nativeResume();

    private native void nativeSetVolume(float var1);

    private native void nativeSetPitch(float var1);

    private native int nativeGetSampleRate();

    private native int nativeGetChannels();

    private native int nativeGetBitsPerChannel();

    private native int nativeGetCurPtsMS();

    private native int nativeGetCurDurationMS();

    private native int nativeGetDurationMS(String var1);

    private native int nativeSetCurPtsMS(int var1);

    static {
        d.f();
        TAG = "AudioCenter:" + TXCLiveBGMPlayer.class.getSimpleName();
    }
}

