/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.audio;

import android.media.AudioTrack;
import com.tencent.liteav.audio.e;
import com.tencent.liteav.basic.log.TXCLog;
import com.tencent.liteav.basic.util.d;
import java.lang.ref.WeakReference;

public class TXCUGCBGMPlayer
implements Runnable {
    private static final String TAG = "AudioCenter:TXCUGCBGMPlayer";
    private static final int PLAY_SUCCESS = 0;
    private static final int PLAY_ERR_OPEN = -1;
    private static final int PLAY_ERR_FILE_NOTFOUND = -2;
    private static final int PLAY_ERR_AUDIO_TRACK = -3;
    private static final int PLAY_ERR_AUDIO_TRACK_PLAY = -4;
    private static TXCUGCBGMPlayer instance;
    private String mFilePath = null;
    private boolean mIsRunning = false;
    private Thread mThread = null;
    private boolean mIsPause = false;
    private WeakReference<e> mWeakListener = null;
    private float mVolume = 1.0f;
    private float mSpeedRate = 1.0f;
    private long mStartTimeMS = 0L;
    private long mEndTimeMS = 0L;
    private long mSeekBytes = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TXCUGCBGMPlayer getInstance() {
        if (instance != null) return instance;
        Class<TXCUGCBGMPlayer> clazz = TXCUGCBGMPlayer.class;
        synchronized (TXCUGCBGMPlayer.class) {
            if (instance != null) return instance;
            instance = new TXCUGCBGMPlayer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private TXCUGCBGMPlayer() {
    }

    public synchronized void setOnPlayListener(e e2) {
        if (e2 == null) {
            this.mWeakListener = null;
        }
        this.mWeakListener = new WeakReference<e>(e2);
    }

    public void startPlay(String string) {
        TXCLog.i(TAG, "startPlay:" + string);
        if (string == null || string.isEmpty()) {
            return;
        }
        if (this.mIsRunning) {
            TXCLog.w(TAG, "BGM\u6b63\u5728\u64ad\u653e\u4e2d\uff0c\u5c06\u91cd\u65b0\u542f\u52a8");
            this.stopPlay();
        }
        this.mIsPause = false;
        this.mSeekBytes = 0L;
        this.mFilePath = string;
        this.mIsRunning = true;
        this.mThread = new Thread((Runnable)this, "UGCBGMPlayer");
        this.mThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopPlay() {
        TXCLog.i(TAG, "stopPlay");
        this.mIsRunning = false;
        long l2 = System.currentTimeMillis();
        if (this.mThread != null && this.mThread.isAlive() && Thread.currentThread().getId() != this.mThread.getId()) {
            try {
                this.mThread.join();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        this.mThread = null;
        TXCUGCBGMPlayer tXCUGCBGMPlayer = this;
        synchronized (tXCUGCBGMPlayer) {
            this.nativeStopPlay();
        }
        TXCLog.i(TAG, "stopBGMPlay cost(MS): " + (System.currentTimeMillis() - l2));
    }

    public void pause() {
        TXCLog.i(TAG, "pause");
        this.mIsPause = true;
        this.nativePause();
    }

    public void resume() {
        TXCLog.i(TAG, "resume");
        this.mIsPause = false;
        this.nativeResume();
    }

    public void setVolume(float f2) {
        this.mVolume = f2;
        this.nativeSetVolume(f2);
    }

    public void setSpeedRate(float f2) {
        TXCLog.i(TAG, "setSpeedRate:" + f2);
        this.mSpeedRate = f2;
        this.nativeSetSpeedRate(f2);
    }

    public void playFromTime(long l2, long l3) {
        TXCLog.i(TAG, "playFromTime:" + l2 + ", " + l3);
        this.mStartTimeMS = l2;
        this.mEndTimeMS = l3;
        this.nativePlayFromTime(l2, l3);
    }

    public void seekBytes(long l2) {
        TXCLog.i(TAG, "seekBytes:" + l2);
        if (l2 < 0L) {
            l2 = 0L;
            TXCLog.e(TAG, "seek bytes can not be negative. change to 0");
        }
        this.mSeekBytes = l2;
        this.nativeSeekBytes(l2);
    }

    public long getCurPosition() {
        long l2 = this.nativeGetCurPosition();
        TXCLog.i(TAG, "getCurPosition:" + l2);
        return l2;
    }

    public static long getDurationMS(String string) {
        return TXCUGCBGMPlayer.nativeGetDurationMS(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onPlayStart() {
        e e2 = null;
        TXCUGCBGMPlayer tXCUGCBGMPlayer = this;
        synchronized (tXCUGCBGMPlayer) {
            if (this.mWeakListener != null) {
                e2 = (e)this.mWeakListener.get();
            }
        }
        if (e2 != null) {
            e2.onPlayStart();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onPlayEnd(int n2) {
        e e2 = null;
        TXCUGCBGMPlayer tXCUGCBGMPlayer = this;
        synchronized (tXCUGCBGMPlayer) {
            if (this.mWeakListener != null) {
                e2 = (e)this.mWeakListener.get();
            }
        }
        if (e2 != null) {
            e2.onPlayEnd(n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onPlayProgress(long l2, long l3) {
        e e2 = null;
        TXCUGCBGMPlayer tXCUGCBGMPlayer = this;
        synchronized (tXCUGCBGMPlayer) {
            if (this.mWeakListener != null) {
                e2 = (e)this.mWeakListener.get();
            }
        }
        if (e2 != null) {
            e2.onPlayProgress(l2, l3);
        }
    }

    private native boolean nativeStartPlay(String var1);

    private native void nativeStopPlay();

    private native int nativeRead(byte[] var1, int var2);

    private native void nativePause();

    private native void nativeResume();

    private native void nativeSetVolume(float var1);

    private native int nativeGetSampleRate();

    private native int nativeGetChannels();

    private native int nativeGetBitsPerChannel();

    private native void nativeSetSpeedRate(float var1);

    private native long nativeGetCurPtsMS();

    private native long nativeGetCurDurationMS();

    private native void nativePlayFromTime(long var1, long var3);

    private native void nativeSeekBytes(long var1);

    private native long nativeGetCurPosition();

    private static native long nativeGetDurationMS(String var0);

    @Override
    public void run() {
        int n2;
        AudioTrack audioTrack;
        long l2;
        block22: {
            l2 = System.currentTimeMillis();
            audioTrack = null;
            this.onPlayStart();
            n2 = 0;
            if (this.mFilePath == null || this.mFilePath.isEmpty()) {
                TXCLog.e(TAG, "file path = " + this.mFilePath);
                n2 = -2;
            } else {
                this.nativeSetVolume(this.mVolume);
                this.nativeSetSpeedRate(this.mSpeedRate);
                this.nativePlayFromTime(this.mStartTimeMS, this.mEndTimeMS);
                this.nativeSeekBytes(this.mSeekBytes);
                boolean bl = this.nativeStartPlay(this.mFilePath);
                if (!bl) {
                    n2 = -1;
                } else {
                    int n3;
                    int n4;
                    if (this.mIsPause) {
                        this.nativePause();
                    } else {
                        this.nativeResume();
                    }
                    TXCLog.i(TAG, "start play bgm: path = " + this.mFilePath + "volume = " + this.mVolume + ", speedRate = " + this.mSpeedRate + ", startTime = " + this.mStartTimeMS + ", endTime = " + this.mEndTimeMS + ", seekBytes = " + this.mSeekBytes + ", pause = " + this.mIsPause);
                    int n5 = this.nativeGetSampleRate();
                    int n6 = this.nativeGetChannels();
                    int n7 = this.nativeGetBitsPerChannel();
                    try {
                        n4 = 3;
                        if (n6 == 1) {
                            n4 = 2;
                        }
                        int n8 = 2;
                        if (n7 == 8) {
                            n8 = 3;
                        }
                        n3 = AudioTrack.getMinBufferSize((int)n5, (int)n4, (int)n8);
                        audioTrack = new AudioTrack(3, n5, n4, n8, n3, 1);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        TXCLog.e(TAG, "new AudioTrack Exception: " + exception.getMessage());
                        n2 = -3;
                        break block22;
                    }
                    try {
                        audioTrack.play();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        TXCLog.e(TAG, "AudioTrack play Exception: " + exception.getMessage());
                        n2 = -4;
                        break block22;
                    }
                    n4 = 2 * (2048 * n6);
                    byte[] byArray = new byte[n4];
                    n3 = 0;
                    while (this.mIsRunning && !Thread.interrupted()) {
                        int n9 = this.nativeRead(byArray, byArray.length);
                        if (n9 < 0) {
                            TXCLog.i(TAG, "UGC BGM\u64ad\u653e\u7ed3\u675f");
                            this.onPlayProgress(this.nativeGetCurDurationMS(), this.nativeGetCurDurationMS());
                            break;
                        }
                        if (n9 == 0) {
                            if (!this.mIsPause) continue;
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException interruptedException) {
                                interruptedException.printStackTrace();
                            }
                            continue;
                        }
                        audioTrack.write(byArray, 0, n9);
                        if (n3 % 5 == 0) {
                            n3 = 0;
                            this.onPlayProgress(this.nativeGetCurPtsMS(), this.nativeGetCurDurationMS());
                            continue;
                        }
                        ++n3;
                    }
                }
            }
        }
        if (audioTrack != null) {
            try {
                audioTrack.pause();
                audioTrack.flush();
                audioTrack.stop();
                audioTrack.release();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        TXCLog.i(TAG, "UGC BGM player play time: " + (System.currentTimeMillis() - l2));
        if (this.mIsRunning) {
            this.onPlayEnd(n2);
        }
    }

    static {
        d.f();
    }
}

