/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.audio.impl;

import com.tencent.liteav.audio.c;
import com.tencent.liteav.basic.e.b;
import com.tencent.liteav.basic.log.TXCLog;
import com.tencent.liteav.basic.util.d;
import java.lang.ref.WeakReference;

public class TXCJitter {
    private static final String TAG = "TXCJitter";
    protected c mListener;
    protected float mCacheTime = 5.0f;
    protected boolean mIsAutoAdjustCache = true;
    protected float mAutoAdjustMaxCache = 5.0f;
    protected float mAutoAdjustMinCache = 1.0f;
    protected boolean mIsRealTimePlay = false;
    protected boolean mIsPlayMute = false;
    protected boolean mMuteInSpeaker = false;
    protected int mPlayVolume = 100;
    protected int mSmoothMode = 0;
    protected long mJitterBuffer = 0L;
    protected String mUserID = null;
    protected boolean mEnableVolumeLevelCal = false;
    protected volatile boolean mIsPlaying = false;
    private static WeakReference<c> mAudioCoreListener;

    public TXCJitter(String string) {
        this.mUserID = string;
    }

    protected void finalize() {
        if (this.mJitterBuffer != 0L) {
            this.nativeDestoryJitterBuffer(this.mJitterBuffer);
            this.mJitterBuffer = 0L;
        }
    }

    public static void setAudioCorePlayListener(c c2) {
        mAudioCoreListener = new WeakReference<c>(c2);
        TXCLog.i(TAG, " setAudioCorePlayListener: " + (null != c2));
        TXCJitter.nativeSetCorePlayListener(null != c2);
    }

    public static void onCorePlayPcmData(byte[] byArray, long l2, int n2, int n3) {
        c c2;
        if (mAudioCoreListener != null && (c2 = (c)mAudioCoreListener.get()) != null) {
            c2.onPlayPcmData(null, byArray, l2, n2, n3);
        }
    }

    public void setListener(c c2) {
        this.mListener = c2;
        TXCLog.i(TAG, " setListener: " + (null != this.mListener));
        this.nativeSetJitterListener(null != this.mListener);
    }

    public void setCacheTime(float f2) {
        TXCLog.i(TAG, "set cache time to " + f2);
        if (this.mJitterBuffer == 0L) {
            this.mCacheTime = f2;
        }
    }

    public void enableAutojustCache(boolean bl) {
        TXCLog.i(TAG, "set auto adjust cache to " + bl);
        if (this.mJitterBuffer == 0L) {
            this.mIsAutoAdjustCache = bl;
        }
    }

    public void setAutoAdjustMaxCache(float f2) {
        TXCLog.i(TAG, "set auto adjust max cache to " + f2);
        if (this.mJitterBuffer == 0L) {
            this.mAutoAdjustMaxCache = f2;
        }
    }

    public void setAutoAdjustMinCache(float f2) {
        TXCLog.i(TAG, "set auto adjust min cache to " + f2);
        if (this.mJitterBuffer == 0L) {
            this.mAutoAdjustMinCache = f2;
        }
    }

    public void enableRealTimePlay(boolean bl) {
        if (bl == this.mIsRealTimePlay) {
            return;
        }
        TXCLog.i(TAG, "set real-time play to " + bl);
        if (this.mJitterBuffer == 0L) {
            this.mIsRealTimePlay = bl;
        }
    }

    public void setUserID(String string) {
        this.mUserID = string;
    }

    public void enableVolumeLevelCal(boolean bl) {
        this.mEnableVolumeLevelCal = bl;
        if (this.mJitterBuffer != 0L) {
            this.nativeEnableVolumeLevelCal(this.mJitterBuffer, bl);
        }
    }

    public int getVolumeLevel() {
        if (this.mJitterBuffer != 0L && this.mEnableVolumeLevelCal) {
            return this.nativeGetVolumeLevel(this.mJitterBuffer);
        }
        return 0;
    }

    public boolean isPlaying() {
        return this.mIsPlaying;
    }

    public int startPlay() {
        this.mIsPlaying = true;
        if (this.mJitterBuffer == 0L) {
            this.mJitterBuffer = this.nativeCreateJitterBuffer(this, this.mIsRealTimePlay);
            if (this.mJitterBuffer != 0L) {
                this.nativeSetUserID(this.mJitterBuffer, this.mUserID);
                this.nativeSetCacheTime(this.mJitterBuffer, this.mCacheTime);
                this.nativeEnableAutoAdjustCache(this.mJitterBuffer, this.mIsAutoAdjustCache);
                this.nativeSetAutoAdjustMaxCache(this.mJitterBuffer, this.mAutoAdjustMaxCache);
                this.nativeSetAutoAdjustMinCache(this.mJitterBuffer, this.mAutoAdjustMinCache);
                this.nativeSetMute(this.mJitterBuffer, this.mIsPlayMute);
                this.nativeMuteInSpeaker(this.mJitterBuffer, this.mMuteInSpeaker);
                this.nativeEnableVolumeLevelCal(this.mJitterBuffer, this.mEnableVolumeLevelCal);
                this.nativeSetJitterCycle(this.mJitterBuffer, b.a().a("Audio", "LIVE_JitterCycle"));
                this.nativeSetLoadingThreshold(this.mJitterBuffer, b.a().a("Audio", "LoadingThreshold"));
                this.nativeSetRtcPlayHungryTimeThreshold(this.mJitterBuffer, (int)b.a().a("Audio", "RtcPlayHungryTimeThreshold"));
            } else {
                TXCLog.e(TAG, "soft dec, create jitterbuffer failed!!");
            }
            TXCLog.e(TAG, "soft dec, create jitterbuffer with id " + this.mJitterBuffer);
        }
        return 0;
    }

    public int stopPlay() {
        this.mIsPlaying = false;
        if (this.mJitterBuffer != 0L) {
            this.nativeDestoryJitterBuffer(this.mJitterBuffer);
            this.mJitterBuffer = 0L;
        }
        this.mListener = null;
        this.mCacheTime = 5.0f;
        this.mIsAutoAdjustCache = true;
        this.mAutoAdjustMaxCache = 5.0f;
        this.mAutoAdjustMinCache = 1.0f;
        this.mIsRealTimePlay = false;
        this.mIsPlayMute = false;
        this.mMuteInSpeaker = false;
        this.mSmoothMode = 0;
        this.mUserID = null;
        return 0;
    }

    public void setPlayMute(boolean bl) {
        if (this.mJitterBuffer != 0L && bl != this.mIsPlayMute) {
            this.nativeSetMute(this.mJitterBuffer, bl);
        }
        TXCLog.i(TAG, "set mute to " + bl);
        this.mIsPlayMute = bl;
    }

    public void muteInSpeaker(boolean bl) {
        if (bl != this.mMuteInSpeaker) {
            this.mMuteInSpeaker = bl;
            if (this.mJitterBuffer != 0L) {
                this.nativeMuteInSpeaker(this.mJitterBuffer, bl);
            }
        }
    }

    public void setPlayVolume(int n2) {
        if (this.mJitterBuffer != 0L && n2 != this.mPlayVolume) {
            this.nativeSetVolume(this.mJitterBuffer, n2);
        }
        TXCLog.i(TAG, "set volume to " + n2);
        this.mPlayVolume = n2;
    }

    public void onPlayPcmData(byte[] byArray, long l2, int n2, int n3) {
        c c2 = this.mListener;
        if (null != c2) {
            c2.onPlayPcmData(this.mUserID, byArray, l2, n2, n3);
        }
    }

    public void onPlayError(int n2, String string) {
        c c2 = this.mListener;
        if (c2 != null) {
            c2.onPlayError(n2, string);
        }
    }

    public void onPlayJitterStateNotify(int n2) {
        TXCLog.e(TAG, "onPlayJitterStateNotify  cur state " + n2);
        c c2 = this.mListener;
        if (c2 != null) {
            c2.onPlayJitterStateNotify(n2);
        }
    }

    protected native long nativeCreateJitterBuffer(TXCJitter var1, boolean var2);

    protected native void nativeDestoryJitterBuffer(long var1);

    protected native void nativeSetUserID(long var1, String var3);

    protected native void nativeSetCacheTime(long var1, float var3);

    protected native void nativeEnableAutoAdjustCache(long var1, boolean var3);

    protected native void nativeSetAutoAdjustMaxCache(long var1, float var3);

    protected native void nativeSetAutoAdjustMinCache(long var1, float var3);

    protected native void nativeSetJitterCycle(long var1, long var3);

    protected native void nativeSetLoadingThreshold(long var1, long var3);

    protected native void nativeSetRtcPlayHungryTimeThreshold(long var1, int var3);

    protected native void nativeSetMute(long var1, boolean var3);

    protected native void nativeMuteInSpeaker(long var1, boolean var3);

    protected native void nativeSetVolume(long var1, int var3);

    protected native void nativeEnableVolumeLevelCal(long var1, boolean var3);

    protected native void nativeSetJitterListener(boolean var1);

    protected native int nativeGetVolumeLevel(long var1);

    public static native void nativeEnableCoreplayVolumeLevelCal(boolean var0);

    public static native boolean nativeIsTracksEmpty();

    public static native boolean nativeStopAllTracks();

    public static native int nativeGetCorePlayVolumeLevel();

    public static native void nativeSetCorePlayListener(boolean var0);

    public static native void nativePlayAfterCorePlayCallback(byte[] var0, int var1);

    public static int GetCorePlayVolumeLevel() {
        return TXCJitter.nativeGetCorePlayVolumeLevel();
    }

    public static void EnableCoreplayVolumeLevelCal(boolean bl) {
        TXCJitter.nativeEnableCoreplayVolumeLevelCal(bl);
    }

    static {
        d.f();
        mAudioCoreListener = null;
    }
}

