/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.basic.structs;

import java.nio.ByteBuffer;

public class TXSVideoFrame {
    public ByteBuffer buffer;
    public byte[] data;
    public int width;
    public int height;
    public int frameType;
    public int rotation;
    public long pts;
    public int textureId;
    public Object eglContext;

    public void finalize() throws Throwable {
        this.release();
        super.finalize();
    }

    public TXSVideoFrame clone() {
        TXSVideoFrame tXSVideoFrame = new TXSVideoFrame();
        tXSVideoFrame.width = this.width;
        tXSVideoFrame.height = this.height;
        tXSVideoFrame.frameType = this.frameType;
        tXSVideoFrame.rotation = this.rotation;
        tXSVideoFrame.pts = this.pts;
        tXSVideoFrame.data = this.data;
        tXSVideoFrame.textureId = this.textureId;
        tXSVideoFrame.eglContext = this.eglContext;
        tXSVideoFrame.nativeClone(this.buffer);
        return tXSVideoFrame;
    }

    public void loadYUVArray(byte[] byArray) {
        if (byArray == null || byArray.length < this.width * this.height * 3 / 2) {
            return;
        }
        if (this.buffer == null) {
            this.nativeLoadArrayFromGL(byArray, this.width, this.height);
        } else {
            this.nativeLoadArrayFromBuffer(byArray, this.width * this.height * 3 / 2);
        }
    }

    public void loadYUVBufferFromGL() {
        this.nativeLoadBufferFromGL(this.width, this.height);
    }

    public void loadNV21BufferFromI420Buffer() {
        this.nativeLoadNV21BufferFromI420Buffer(this.width, this.height);
    }

    public byte[] I420toNV21(byte[] byArray, byte[] byArray2, int n2, int n3) {
        if (byArray2 == null) {
            byArray2 = new byte[byArray.length];
        }
        int n4 = n2 * n3;
        int n5 = n4 / 4;
        int n6 = n4 + n5;
        System.arraycopy(byArray, 0, byArray2, 0, n4);
        int n7 = n4;
        int n8 = n6;
        int n9 = n4;
        while (n7 < n6) {
            byArray2[n9] = byArray[n8];
            byArray2[n9 + 1] = byArray[n7];
            ++n7;
            ++n8;
            n9 += 2;
        }
        return byArray2;
    }

    private native void nativeLoadNV21BufferFromI420Buffer(int var1, int var2);

    private native void nativeLoadArrayFromBuffer(byte[] var1, int var2);

    public native void release();

    public native void nativeClone(ByteBuffer var1);

    private native void nativeLoadBufferFromGL(int var1, int var2);

    private native void nativeLoadArrayFromGL(byte[] var1, int var2, int var3);
}

