/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.network;

import android.content.Context;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import com.tencent.liteav.basic.log.TXCLog;
import com.tencent.liteav.basic.util.TXCTimeUtil;
import com.tencent.liteav.network.TXCStreamDownloader;
import com.tencent.liteav.network.TXIStreamDownloader;
import com.tencent.liteav.network.e;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.Map;
import java.util.Vector;
import javax.net.ssl.SSLException;

public class TXCFLVDownloader
extends TXIStreamDownloader {
    public final String TAG = "network.TXCFLVDownloader";
    private final int FLV_HEAD_SIZE = 9;
    private final int MAX_FRAME_SIZE = 0x100000;
    private final int MSG_CONNECT = 100;
    private final int MSG_RECV_DATA = 101;
    private final int MSG_DISCONNECT = 102;
    private final int MSG_RECONNECT = 103;
    private final int MSG_SEEK = 104;
    private final int MSG_RESUME = 105;
    private final int MSG_QUIT = 106;
    private final int CONNECT_TIMEOUT = 8000;
    private final int READ_STREAM_SIZE = 1388;
    private HandlerThread mFlvThread = null;
    private Handler mFlvHandler = null;
    private InputStream mInputStream = null;
    private HttpURLConnection mConnection = null;
    private byte[] mPacketBytes = null;
    private boolean mRecvData = false;
    private long mContentLength = 0L;
    private long mDownloadedSize = 0L;
    private boolean mHandleDataInJava = false;
    private long mFLVParser = 0L;
    private long mRefFLVParser = 0L;
    private long mCurrentNalTs = 0L;
    private long mLastIFramelTs = 0L;
    private boolean mStopJitter = true;
    private String mPlayUrl = "";
    private boolean mbFirstVideo = false;
    private boolean mbFirstAudio = false;
    private TXCStreamDownloader.DownloadStats mStats = new TXCStreamDownloader.DownloadStats();

    public TXCFLVDownloader(Context context) {
        super(context);
        this.mStats.afterParseAudioBytes = 0L;
        this.mStats.dnsTS = 0L;
        this.mStats.startTS = TXCTimeUtil.getTimeTick();
        TXCLog.i("network.TXCFLVDownloader", "new flv download " + this);
    }

    public TXCFLVDownloader(Context context, TXCFLVDownloader tXCFLVDownloader) {
        super(context);
        this.mStats.afterParseAudioBytes = 0L;
        this.mStats.dnsTS = 0L;
        this.mStats.startTS = TXCTimeUtil.getTimeTick();
        if (tXCFLVDownloader != null) {
            this.mRefFLVParser = tXCFLVDownloader.mFLVParser;
            tXCFLVDownloader.mStopJitter = false;
        }
        TXCLog.i("network.TXCFLVDownloader", "new multi flv download " + this);
    }

    public void recvData(boolean bl) {
        this.mHandleDataInJava = bl;
    }

    @Override
    public void PushVideoFrame(byte[] byArray, int n2, long l2, long l3, int n3) {
        this.nativePushVideoFrame(this.mFLVParser, byArray, n2, l2, l3, n3);
    }

    @Override
    public void PushAudioFrame(byte[] byArray, int n2, long l2, int n3) {
        this.nativePushAudioFrame(this.mFLVParser, byArray, n2, l2, n3);
    }

    @Override
    public long getCurrentTS() {
        return this.mCurrentNalTs;
    }

    @Override
    public long getLastIFrameTS() {
        return this.mLastIFramelTs;
    }

    private void processMsgConnect() {
        try {
            this.connect();
        }
        catch (SocketTimeoutException socketTimeoutException) {
            TXCLog.e("network.TXCFLVDownloader", "socket timeout, reconnect");
            this.postReconnectMsg();
            return;
        }
        catch (FileNotFoundException fileNotFoundException) {
            TXCLog.e("network.TXCFLVDownloader", "file not found, reconnect");
            fileNotFoundException.printStackTrace();
            this.postReconnectMsg();
            return;
        }
        catch (Exception exception) {
            TXCLog.e("network.TXCFLVDownloader", "exception, reconnect");
            exception.printStackTrace();
            this.postReconnectMsg();
            return;
        }
        catch (Error error) {
            TXCLog.e("network.TXCFLVDownloader", "error, reconnect");
            error.printStackTrace();
            this.postReconnectMsg();
            return;
        }
        if (this.mFLVParser == 0L) {
            if (this.mRefFLVParser != 0L) {
                this.mFLVParser = this.nativeInitFlvHanderByRef(this.mRefFLVParser);
                this.mRefFLVParser = 0L;
            } else {
                this.mFLVParser = this.nativeInitFlvHander(this.mUserID, 0, this.mEnableMessage, this.mEnableMetaData);
            }
        }
        if (this.mFlvHandler != null) {
            this.mFlvHandler.sendEmptyMessage(101);
        }
    }

    private void processMsgRecvData() {
        if (this.mInputStream != null) {
            try {
                int n2 = this.mInputStream.read(this.mPacketBytes, 0, 1388);
                if (n2 > 0) {
                    this.mDownloadedSize += (long)n2;
                    if (!this.mRecvData) {
                        TXCLog.w("network.TXCFLVDownloader", "flv play receive first data " + this);
                        this.mRecvData = true;
                    }
                    int n3 = 0;
                    if (this.mFLVParser != 0L) {
                        this.mStats.beforeParseVideoBytes += (long)n2;
                        n3 = this.nativeParseData(this.mFLVParser, this.mPacketBytes, n2);
                        this.mStats.afterParseVideoBytes = this.nativeGetVideoBytes(this.mFLVParser);
                        this.mStats.afterParseAudioBytes = this.nativeGetAudioBytes(this.mFLVParser);
                        this.mStats.videoGop = this.nativeGetVideoGop(this.mFLVParser);
                    }
                    if (n3 > 0x100000) {
                        TXCLog.e("network.TXCFLVDownloader", "flv play parse frame: " + n3 + " > " + 0x100000 + ",sart reconnect");
                        this.postReconnectMsg();
                        return;
                    }
                } else if (n2 < 0) {
                    TXCLog.w("network.TXCFLVDownloader", "http read: " + n2 + " < 0, start reconnect");
                    this.postReconnectMsg();
                    return;
                }
                if (this.mFlvHandler != null) {
                    this.mFlvHandler.sendEmptyMessage(101);
                }
            }
            catch (SocketTimeoutException socketTimeoutException) {
                TXCLog.w("network.TXCFLVDownloader", "socket timeout start reconnect");
                this.postReconnectMsg();
            }
            catch (SocketException socketException) {
                TXCLog.w("network.TXCFLVDownloader", "socket exception start reconnect");
                this.postReconnectMsg();
            }
            catch (SSLException sSLException) {
                TXCLog.w("network.TXCFLVDownloader", "ssl exception start reconnect");
                this.postReconnectMsg();
            }
            catch (EOFException eOFException) {
                TXCLog.w("network.TXCFLVDownloader", "eof exception start reconnect");
                this.postReconnectMsg();
            }
            catch (Exception exception) {
                TXCLog.e("network.TXCFLVDownloader", "exception");
                exception.printStackTrace();
                this.mInputStream = null;
                this.mConnection = null;
            }
            catch (Error error) {
                TXCLog.e("network.TXCFLVDownloader", "error");
                error.printStackTrace();
                this.mInputStream = null;
                this.mConnection = null;
            }
        }
    }

    private void processMsgDisConnect() {
        try {
            this.disconnect();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this.mFLVParser != 0L) {
            this.nativeUninitFlvhander(this.mFLVParser, this.mStopJitter);
            this.mFLVParser = 0L;
        }
    }

    private void processMsgReconnect() {
        if (this.mStopJitter) {
            this.reconnect();
        } else {
            TXCLog.i("network.TXCFLVDownloader", "ignore processMsgReconnect when start multi stream switch" + this);
            if (this.mRestartListener != null) {
                this.mRestartListener.onOldStreamStop();
            }
        }
    }

    private void startInternal() {
        if (this.mFlvThread == null) {
            this.mFlvThread = new HandlerThread("FlvThread");
            this.mFlvThread.start();
        }
        if (this.mFlvHandler == null) {
            this.mFlvHandler = new Handler(this.mFlvThread.getLooper()){

                public void handleMessage(Message message) {
                    switch (message.what) {
                        case 100: {
                            TXCFLVDownloader.this.processMsgConnect();
                            break;
                        }
                        case 101: {
                            TXCFLVDownloader.this.processMsgRecvData();
                            break;
                        }
                        case 102: {
                            TXCFLVDownloader.this.processMsgDisConnect();
                            break;
                        }
                        case 103: {
                            TXCFLVDownloader.this.processMsgReconnect();
                            break;
                        }
                        case 106: {
                            try {
                                Looper.myLooper().quit();
                            }
                            catch (Exception exception) {}
                            break;
                        }
                    }
                }
            };
        }
        this.postConnectMsg();
    }

    private void reconnect() {
        this.processMsgDisConnect();
        if (this.connectRetryTimes < this.connectRetryLimit) {
            ++this.connectRetryTimes;
            TXCLog.i("network.TXCFLVDownloader", "reconnect retry time:" + this.connectRetryTimes + ", limit:" + this.connectRetryLimit);
            this.processMsgConnect();
            this.sendNotifyEvent(2103);
        } else {
            TXCLog.e("network.TXCFLVDownloader", "reconnect all times retried, send failed event ");
            this.sendNotifyEvent(-2301);
        }
    }

    private void postReconnectMsg() {
        if (this.mFlvHandler != null) {
            this.mFlvHandler.sendEmptyMessageDelayed(103, (long)(this.connectRetryInterval * 1000));
        }
    }

    private void postDisconnectMsg() {
        if (this.mFlvHandler != null) {
            this.mFlvHandler.sendEmptyMessage(102);
        }
    }

    private void postConnectMsg() {
        this.mInputStream = null;
        if (this.mConnection != null) {
            this.mConnection.disconnect();
            this.mConnection = null;
        }
        Message message = new Message();
        message.what = 100;
        message.arg1 = 0;
        if (this.mFlvHandler != null) {
            this.mFlvHandler.sendMessage(message);
        }
    }

    private void connect() throws Exception {
        if (this.mConnection != null) {
            this.mConnection.disconnect();
            this.mConnection = null;
        }
        URL uRL = new URL(this.mPlayUrl);
        this.mConnection = (HttpURLConnection)uRL.openConnection();
        this.mStats.dnsTS = TXCTimeUtil.getTimeTick();
        this.mConnection.setConnectTimeout(8000);
        this.mConnection.setReadTimeout(8000);
        this.mConnection.setRequestProperty("Accept-Encoding", "identity");
        this.mConnection.setInstanceFollowRedirects(true);
        if (this.mHeaders != null) {
            for (Map.Entry entry : this.mHeaders.entrySet()) {
                this.mConnection.setRequestProperty((String)entry.getKey(), (String)entry.getValue());
            }
        }
        this.mConnection.connect();
        this.mInputStream = this.mConnection.getInputStream();
        this.mPacketBytes = new byte[1388];
        this.mRecvData = false;
        this.mContentLength = this.mConnection.getContentLength();
        this.mDownloadedSize = 0L;
        this.mStats.serverIP = InetAddress.getByName(this.mConnection.getURL().getHost()).getHostAddress();
        this.mStats.connTS = TXCTimeUtil.getTimeTick();
        this.sendNotifyEvent(2001);
    }

    @Override
    public String getRealStreamUrl() {
        if (this.mConnection != null) {
            return this.mConnection.getURL().toString();
        }
        return null;
    }

    private void disconnect() throws Exception {
        if (this.mConnection != null) {
            this.mConnection.disconnect();
            this.mConnection = null;
        }
        if (this.mInputStream != null) {
            this.mInputStream.close();
            this.mInputStream = null;
        }
    }

    private native long nativeInitFlvHander(String var1, int var2, boolean var3, boolean var4);

    private native long nativeInitFlvHanderByRef(long var1);

    private native void nativeUninitFlvhander(long var1, boolean var3);

    private native int nativeParseData(long var1, byte[] var3, int var4);

    private native int nativeGetVideoBytes(long var1);

    private native int nativeGetAudioBytes(long var1);

    private native int nativeGetVideoGop(long var1);

    private native void nativeCleanData(long var1);

    public native void nativePushVideoFrame(long var1, byte[] var3, int var4, long var5, long var7, int var9);

    public native void nativePushAudioFrame(long var1, byte[] var3, int var4, long var5, int var7);

    @Override
    public TXCStreamDownloader.DownloadStats getDownloadStats() {
        TXCStreamDownloader.DownloadStats downloadStats = new TXCStreamDownloader.DownloadStats();
        downloadStats.afterParseAudioBytes = this.mStats.afterParseAudioBytes;
        downloadStats.afterParseVideoBytes = this.mStats.afterParseVideoBytes;
        downloadStats.beforeParseVideoBytes = this.mStats.beforeParseVideoBytes;
        downloadStats.beforeParseAudioBytes = this.mStats.beforeParseAudioBytes;
        downloadStats.videoGop = this.mStats.videoGop;
        downloadStats.startTS = this.mStats.startTS;
        downloadStats.dnsTS = this.mStats.dnsTS;
        downloadStats.connTS = this.mStats.connTS;
        downloadStats.firstAudioTS = this.mStats.firstAudioTS;
        downloadStats.firstVideoTS = this.mStats.firstVideoTS;
        downloadStats.serverIP = this.mStats.serverIP;
        return downloadStats;
    }

    @Override
    public void startDownload(Vector<e> vector, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        if (this.mIsRunning) {
            return;
        }
        if (vector == null || vector.isEmpty()) {
            return;
        }
        this.mEnableMessage = bl3;
        this.mEnableMetaData = bl4;
        this.mIsRunning = true;
        this.mPlayUrl = vector.get((int)0).a;
        TXCLog.i("network.TXCFLVDownloader", "start pull with url " + this.mPlayUrl);
        this.startInternal();
    }

    @Override
    public void stopDownload() {
        if (!this.mIsRunning) {
            return;
        }
        this.mIsRunning = false;
        TXCLog.i("network.TXCFLVDownloader", "stop pull");
        try {
            if (this.mFlvHandler != null) {
                this.mFlvHandler.removeCallbacksAndMessages(null);
                this.mFlvHandler.sendEmptyMessage(102);
                this.mFlvHandler.sendEmptyMessage(106);
                this.mFlvHandler = null;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void onRecvVideoData(byte[] byArray, int n2, long l2, long l3, int n3) {
        if (!this.mbFirstVideo) {
            this.mbFirstVideo = true;
            this.mStats.firstVideoTS = TXCTimeUtil.getTimeTick();
            TXCLog.i("network.TXCFLVDownloader", "receive first video with ts " + this.mStats.firstVideoTS);
        }
        this.mStats.afterParseVideoBytes += (long)byArray.length;
        super.onRecvVideoData(byArray, n2, l2, l3, n3);
    }

    @Override
    public void onRecvAudioData(byte[] byArray, int n2, int n3, int n4) {
        if (!this.mbFirstAudio) {
            this.mbFirstAudio = true;
            this.mStats.firstAudioTS = TXCTimeUtil.getTimeTick();
            TXCLog.i("network.TXCFLVDownloader", "receive first audio with ts " + this.mStats.firstAudioTS);
        }
        this.mStats.afterParseAudioBytes += (long)byArray.length;
        super.onRecvAudioData(byArray, n2, n3, n4);
    }
}

