/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.network;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import com.tencent.liteav.basic.datareport.TXCDRApi;
import com.tencent.liteav.basic.log.TXCLog;
import com.tencent.liteav.basic.structs.TXSNALPacket;
import com.tencent.liteav.basic.util.TXCTimeUtil;
import com.tencent.liteav.network.TXCFLVDownloader;
import com.tencent.liteav.network.TXCRTMPDownloader;
import com.tencent.liteav.network.TXIStreamDownloader;
import com.tencent.liteav.network.d;
import com.tencent.liteav.network.e;
import com.tencent.liteav.network.f;
import com.tencent.liteav.network.g;
import java.util.Map;
import java.util.Vector;

public class TXCStreamDownloader
extends com.tencent.liteav.basic.module.a
implements com.tencent.liteav.basic.c.a,
TXIStreamDownloader.a,
d.a,
f {
    public static final String TAG = "TXCStreamDownloader";
    private TXIStreamDownloader mDownloader = null;
    private f mListener = null;
    private byte[] mListenerLock = new byte[0];
    private com.tencent.liteav.basic.c.a mNotifyListener = null;
    private boolean mDownloaderRunning = false;
    private String mOriginPlayUrl = "";
    private boolean mEnableNearestIP = false;
    private int mChannelType = 0;
    private boolean mEnableMessage = false;
    private boolean mEnableMetaData = false;
    private int mDownloadFormat = 1;
    private g mAccUrlFetcher;
    private Context mApplicationContext;
    private Handler mHandler = null;
    private long mLastTimeStamp = 0L;
    private DownloadStats mLastDownloadStats = null;
    private boolean mRecvFirstNal = false;
    private long mSwitchStartTime = 0L;
    private long mCurrentNalTs = 0L;
    private long mLastIFramelTs = 0L;
    private d mStreamSwitcher = null;
    private Runnable mReportNetStatusRunnalbe = new Runnable(){

        @Override
        public void run() {
            TXCStreamDownloader.this.reportNetStatus();
        }
    };
    protected Map<String, String> mHeaders;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onNotifyEvent(int n2, Bundle bundle) {
        byte[] byArray = this.mListenerLock;
        synchronized (this.mListenerLock) {
            if (this.mNotifyListener != null) {
                Object object;
                Bundle bundle2 = new Bundle();
                int n3 = n2;
                switch (n2) {
                    case 3003: {
                        bundle2.putString("EVT_MSG", "RTMP\u670d\u52a1\u5668\u63e1\u624b\u5931\u8d25");
                        break;
                    }
                    case -2301: {
                        bundle2.putString("EVT_MSG", "\u7ecf\u591a\u6b21\u81ea\u52a8\u91cd\u8fde\u5931\u8d25\uff0c\u653e\u5f03\u8fde\u63a5");
                        break;
                    }
                    case 3010: {
                        bundle2.putString("EVT_MSG", "\u8be5\u6d41\u5730\u5740\u65e0\u89c6\u9891");
                        break;
                    }
                    case 3007: {
                        bundle2.putString("EVT_MSG", "\u8bfb\u6570\u636e\u9519\u8bef\uff0c\u7f51\u7edc\u8fde\u63a5\u65ad\u5f00");
                        break;
                    }
                    case 3006: {
                        bundle2.putString("EVT_MSG", "\u5199\u6570\u636e\u9519\u8bef\uff0c\u7f51\u7edc\u8fde\u63a5\u65ad\u5f00");
                        break;
                    }
                    case -2302: {
                        bundle2.putString("EVT_MSG", "\u83b7\u53d6\u52a0\u901f\u62c9\u6d41\u5730\u5740\u5931\u8d25");
                        break;
                    }
                    case 2001: {
                        bundle2.putString("EVT_MSG", "\u5df2\u8fde\u63a5\u670d\u52a1\u5668");
                        break;
                    }
                    case 3002: {
                        bundle2.putString("EVT_MSG", "\u8fde\u63a5\u670d\u52a1\u5668\u5931\u8d25");
                        break;
                    }
                    case 2103: {
                        bundle2.putString("EVT_MSG", "\u542f\u52a8\u7f51\u7edc\u91cd\u8fde");
                        break;
                    }
                    case 2002: {
                        bundle2.putString("EVT_MSG", "\u5f00\u59cb\u62c9\u6d41");
                        break;
                    }
                    case -2308: {
                        bundle2.putString("EVT_MSG", "\u670d\u52a1\u5668\u62d2\u7edd\u8fde\u63a5\u8bf7\u6c42");
                        break;
                    }
                    case 2012: {
                        object = bundle.getByteArray("EVT_GET_MSG");
                        if (object == null || ((byte[])object).length <= 0) break;
                        bundle2.putByteArray("EVT_GET_MSG", (byte[])object);
                        break;
                    }
                    case 2028: {
                        bundle2 = bundle;
                        break;
                    }
                    default: {
                        bundle2.putString("EVT_MSG", "UNKNOWN event = " + n2);
                    }
                }
                object = "";
                if (bundle != null) {
                    object = bundle.getString("EVT_MSG", "");
                }
                if (object != null && !((String)object).isEmpty()) {
                    bundle2.putString("EVT_MSG", (String)object);
                }
                bundle2.putLong("EVT_TIME", TXCTimeUtil.getTimeTick());
                this.mNotifyListener.onNotifyEvent(n3, bundle2);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (n2 == 2001) {
                this.reportNetStatusInternal();
            }
            return;
        }
    }

    private void tryResetRetryCount() {
        if (this.mDownloader != null) {
            this.mDownloader.connectRetryTimes = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onPullAudio(com.tencent.liteav.basic.structs.a a2) {
        this.tryResetRetryCount();
        byte[] byArray = this.mListenerLock;
        synchronized (this.mListenerLock) {
            if (this.mListener != null) {
                this.mListener.onPullAudio(a2);
            }
            if (this.mDownloader != null) {
                this.mDownloader.PushAudioFrame(a2.f, a2.h, a2.e, a2.g);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onPullNAL(TXSNALPacket tXSNALPacket) {
        this.tryResetRetryCount();
        if (!this.mRecvFirstNal) {
            this.reportNetStatusInternal();
            this.mRecvFirstNal = true;
        }
        byte[] byArray = this.mListenerLock;
        synchronized (this.mListenerLock) {
            this.mCurrentNalTs = tXSNALPacket.pts;
            if (tXSNALPacket.nalType == 0) {
                this.mLastIFramelTs = tXSNALPacket.pts;
            }
            if (this.mListener != null) {
                this.mListener.onPullNAL(tXSNALPacket);
            }
            if (this.mDownloader != null) {
                this.mDownloader.PushVideoFrame(tXSNALPacket.nalData, tXSNALPacket.nalType, tXSNALPacket.dts, tXSNALPacket.pts, tXSNALPacket.codecId);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void onRestartDownloader() {
        if (this.mHandler != null) {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    TXCStreamDownloader.this.stop();
                    TXCStreamDownloader.this.start(TXCStreamDownloader.this.mOriginPlayUrl, TXCStreamDownloader.this.mEnableNearestIP, TXCStreamDownloader.this.mChannelType, TXCStreamDownloader.this.mEnableMessage, TXCStreamDownloader.this.mEnableMetaData);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onOldStreamStop() {
        byte[] byArray = this.mListenerLock;
        synchronized (this.mListenerLock) {
            if (this.mStreamSwitcher != null) {
                this.mStreamSwitcher.b();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setListener(f f2) {
        byte[] byArray = this.mListenerLock;
        synchronized (this.mListenerLock) {
            this.mListener = f2;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNotifyListener(com.tencent.liteav.basic.c.a a2) {
        byte[] byArray = this.mListenerLock;
        synchronized (this.mListenerLock) {
            this.mNotifyListener = a2;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void setID(String string) {
        super.setID(string);
        if (this.mDownloader != null) {
            this.mDownloader.setUserID(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSwitchFinish(TXIStreamDownloader tXIStreamDownloader, boolean bl) {
        byte[] byArray = this.mListenerLock;
        synchronized (this.mListenerLock) {
            int n2 = (int)(System.currentTimeMillis() - this.mSwitchStartTime);
            this.mSwitchStartTime = 0L;
            Bundle bundle = new Bundle();
            bundle.putLong("EVT_TIME", TXCTimeUtil.getTimeTick());
            if (bl) {
                this.mDownloader = tXIStreamDownloader;
                this.mDownloader.setListener(this);
                this.mDownloader.setNotifyListener(this);
                this.mDownloader.setRestartListener(this);
                bundle.putInt("EVT_ID", 2015);
                bundle.putCharSequence("EVT_MSG", (CharSequence)"\u5207\u6362\u5206\u8fa8\u7387\u6210\u529f");
                if (this.mNotifyListener != null) {
                    this.mNotifyListener.onNotifyEvent(2015, bundle);
                }
                TXCDRApi.txReportDAU(this.mApplicationContext, com.tencent.liteav.basic.datareport.a.bu, n2, "");
            } else {
                bundle.putInt("EVT_ID", 2015);
                bundle.putCharSequence("EVT_MSG", (CharSequence)"\u5207\u6362\u5206\u8fa8\u7387\u5931\u8d25");
                if (this.mNotifyListener != null) {
                    this.mNotifyListener.onNotifyEvent(2015, bundle);
                }
                TXCDRApi.txReportDAU(this.mApplicationContext, com.tencent.liteav.basic.datareport.a.bv);
            }
            this.mStreamSwitcher = null;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public TXCStreamDownloader(Context context, int n2) {
        if (n2 == 0) {
            this.mDownloader = new TXCFLVDownloader(context);
        } else if (n2 == 1 || n2 == 4) {
            this.mDownloader = new TXCRTMPDownloader(context);
        }
        if (this.mDownloader != null) {
            this.mDownloader.setListener(this);
            this.mDownloader.setNotifyListener(this);
            this.mDownloader.setRestartListener(this);
        }
        this.mDownloadFormat = n2;
        this.mAccUrlFetcher = new g(context);
        this.mApplicationContext = context;
        if (this.mApplicationContext != null) {
            this.mHandler = new Handler(this.mApplicationContext.getMainLooper());
        }
    }

    public void setRetryTimes(int n2) {
        if (this.mDownloader != null) {
            this.mDownloader.connectRetryLimit = n2;
        }
    }

    public void setRetryInterval(int n2) {
        if (this.mDownloader != null) {
            this.mDownloader.connectRetryInterval = n2;
        }
    }

    public int start(final String string, boolean bl, int n2, final boolean bl2, final boolean bl3) {
        this.mDownloaderRunning = true;
        this.mRecvFirstNal = false;
        this.mOriginPlayUrl = string;
        this.mEnableNearestIP = bl;
        this.mChannelType = n2;
        this.mEnableMessage = bl2;
        this.mEnableMetaData = bl3;
        this.setStatusValue(7113, 0L);
        this.setStatusValue(7114, 0L);
        this.setStatusValue(7115, 0L);
        if (string.startsWith("room")) {
            this.setStatusValue(7113, 1L);
            this.setStatusValue(7112, 2L);
            if (this.mDownloader != null) {
                Vector<e> vector = new Vector<e>();
                vector.add(new e(string, true));
                this.mDownloader.setOriginUrl(string);
                this.mDownloader.setUserID(this.getID());
                this.mDownloader.startDownload(vector, false, false, bl2, bl3);
            }
            if (this.mHandler != null) {
                this.mHandler.postDelayed(this.mReportNetStatusRunnalbe, 2000L);
            }
            return 0;
        }
        if (bl && this.mDownloadFormat == 4) {
            int n3 = this.mAccUrlFetcher.a(string, n2, new g.a(){

                @Override
                public void a(int n2, String string3, Vector<e> vector) {
                    if (n2 == 0 && vector != null && !vector.isEmpty()) {
                        if (TXCStreamDownloader.this.mDownloaderRunning) {
                            if (TXCStreamDownloader.this.mDownloader != null) {
                                int n3 = 0;
                                for (e e2 : vector) {
                                    if (e2 == null || !e2.b || e2.a == null || e2.a.length() <= 0) continue;
                                    ++n3;
                                }
                                TXCStreamDownloader.this.setStatusValue(7113, n3);
                                TXCStreamDownloader.this.setStatusValue(7112, 2L);
                                TXCStreamDownloader.this.mDownloader.setOriginUrl(string);
                                TXCStreamDownloader.this.mDownloader.startDownload(vector, true, true, bl2, bl3);
                            }
                            if (TXCStreamDownloader.this.mHandler != null) {
                                TXCStreamDownloader.this.mHandler.postDelayed(TXCStreamDownloader.this.mReportNetStatusRunnalbe, 2000L);
                            }
                            String string2 = TXCStreamDownloader.this.mAccUrlFetcher.b();
                            TXCDRApi.txReportDAU(TXCStreamDownloader.this.mApplicationContext, com.tencent.liteav.basic.datareport.a.at, n2, string2);
                        } else {
                            TXCDRApi.txReportDAU(TXCStreamDownloader.this.mApplicationContext, com.tencent.liteav.basic.datareport.a.at, -4, "livePlayer have been stopped");
                        }
                    } else {
                        TXCStreamDownloader.this.onNotifyEvent(-2302, null);
                        TXCDRApi.txReportDAU(TXCStreamDownloader.this.mApplicationContext, com.tencent.liteav.basic.datareport.a.at, n2, string3);
                        TXCLog.e(TXCStreamDownloader.TAG, "getAccelerateStreamPlayUrl failed, play stream with raw url");
                        if (TXCStreamDownloader.this.mDownloaderRunning) {
                            TXCStreamDownloader.this.onNotifyEvent(-2301, null);
                        }
                    }
                }
            });
            if (n3 != 0) {
                if (n3 == -1) {
                    TXCDRApi.txReportDAU(this.mApplicationContext, com.tencent.liteav.basic.datareport.a.at, n3, "invalid playUrl");
                } else if (n3 == -2) {
                    TXCDRApi.txReportDAU(this.mApplicationContext, com.tencent.liteav.basic.datareport.a.at, n3, "invalid streamID");
                } else if (n3 == -3) {
                    TXCDRApi.txReportDAU(this.mApplicationContext, com.tencent.liteav.basic.datareport.a.at, n3, "invalid signature");
                }
                TXCLog.e(TAG, "getAccelerateStreamPlayUrl failed, result = " + n3 + ", play stream with raw url");
                this.onNotifyEvent(-2302, null);
                this.onNotifyEvent(-2301, null);
            }
            return 0;
        }
        if (this.mDownloader != null) {
            this.setStatusValue(7112, 1L);
            Vector<e> vector = new Vector<e>();
            vector.add(new e(string, false));
            this.mDownloader.setOriginUrl(string);
            this.mDownloader.startDownload(vector, this.mDownloadFormat == 4, bl, bl2, bl3);
            if (this.mHandler != null) {
                this.mHandler.postDelayed(this.mReportNetStatusRunnalbe, 2000L);
            }
        }
        return 0;
    }

    private void playStreamWithRawUrl(String string, boolean bl) {
        if (this.mDownloader != null) {
            if (string != null && (string.startsWith("http://") || string.startsWith("https://")) && string.contains(".flv")) {
                int n2 = this.mDownloader.connectRetryLimit;
                int n3 = this.mDownloader.connectRetryInterval;
                this.mDownloader = null;
                this.mDownloader = new TXCFLVDownloader(this.mApplicationContext);
                this.mDownloader.setListener(this);
                this.mDownloader.setNotifyListener(this);
                this.mDownloader.setRestartListener(this);
                this.mDownloader.connectRetryLimit = n2;
                this.mDownloader.connectRetryInterval = n3;
                this.mDownloader.setHeaders(this.mHeaders);
                this.mDownloader.setUserID(this.getID());
            }
            this.setStatusValue(7112, 1L);
            Vector<e> vector = new Vector<e>();
            vector.add(new e(string, false));
            this.mDownloader.setOriginUrl(string);
            this.mDownloader.startDownload(vector, false, false, bl, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.mDownloaderRunning = false;
        this.mRecvFirstNal = false;
        if (this.mDownloader != null) {
            this.mDownloader.stopDownload();
        }
        if (this.mHandler != null) {
            this.mHandler.removeCallbacks(this.mReportNetStatusRunnalbe);
        }
        byte[] byArray = this.mListenerLock;
        synchronized (this.mListenerLock) {
            if (this.mStreamSwitcher != null) {
                this.mStreamSwitcher.a(null);
                this.mStreamSwitcher.a();
                this.mStreamSwitcher = null;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean switchStream(String string) {
        byte[] byArray = this.mListenerLock;
        synchronized (this.mListenerLock) {
            if (this.mStreamSwitcher != null || this.mDownloader == null || !(this.mDownloader instanceof TXCFLVDownloader)) {
                TXCLog.w(TAG, "stream_switch stream is changing ignore this change");
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return false;
            }
            TXCFLVDownloader tXCFLVDownloader = new TXCFLVDownloader(this.mApplicationContext, (TXCFLVDownloader)this.mDownloader);
            tXCFLVDownloader.connectRetryLimit = this.mDownloader.connectRetryLimit;
            tXCFLVDownloader.connectRetryInterval = this.mDownloader.connectRetryInterval;
            tXCFLVDownloader.setHeaders(this.mHeaders);
            tXCFLVDownloader.setUserID(this.getID());
            this.mStreamSwitcher = new d(this);
            this.mStreamSwitcher.a(this);
            this.mStreamSwitcher.a(this.mDownloader, tXCFLVDownloader, this.mCurrentNalTs, this.mLastIFramelTs, string);
            this.mSwitchStartTime = System.currentTimeMillis();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return true;
        }
    }

    public void requestKeyFrame(String string) {
        if (this.mDownloaderRunning && string != null && string.startsWith("room") && this.mDownloader != null) {
            this.mDownloader.requestKeyFrame(string);
        }
    }

    private DownloadStats getDownloadStats() {
        if (this.mDownloader != null) {
            return this.mDownloader.getDownloadStats();
        }
        return null;
    }

    private a getRealTimeStreamInfo() {
        a a2 = new a();
        if (this.mAccUrlFetcher != null) {
            a2.b = this.mAccUrlFetcher.a();
            a2.c = this.mAccUrlFetcher.b();
            a2.d = this.mAccUrlFetcher.c();
            a2.e = this.mAccUrlFetcher.d();
        }
        if (this.mDownloader != null) {
            a2.a = this.mDownloader.getCurrentStreamUrl();
            a2.f = this.mDownloader.isQuicChannel();
        }
        return a2;
    }

    private void reportNetStatus() {
        this.reportNetStatusInternal();
        this.mHandler.postDelayed(this.mReportNetStatusRunnalbe, 2000L);
    }

    private void reportNetStatusInternal() {
        long l2 = TXCTimeUtil.getTimeTick();
        long l3 = l2 - this.mLastTimeStamp;
        DownloadStats downloadStats = this.getDownloadStats();
        a a2 = this.getRealTimeStreamInfo();
        long l4 = 0L;
        long l5 = 0L;
        if (downloadStats != null) {
            if (this.mLastDownloadStats != null) {
                l4 = this.getSpeed(this.mLastDownloadStats.afterParseVideoBytes, downloadStats.afterParseVideoBytes, l3);
                l5 = this.getSpeed(this.mLastDownloadStats.afterParseAudioBytes, downloadStats.afterParseAudioBytes, l3);
            }
            this.setStatusValue(7101, l4);
            this.setStatusValue(7102, l5);
            this.setStatusValue(7103, downloadStats.firstVideoTS);
            this.setStatusValue(7104, downloadStats.firstAudioTS);
            this.setStatusValue(7120, downloadStats.videoGop);
            if (a2 != null) {
                this.setStatusValue(7105, a2.d);
                this.setStatusValue(7106, a2.e);
                this.setStatusValue(7111, a2.f ? 2L : 1L);
                this.setStatusValue(7116, a2.a);
                this.setStatusValue(7117, a2.b);
                this.setStatusValue(7118, a2.c);
            }
            this.setStatusValue(7107, downloadStats.startTS);
            this.setStatusValue(7108, downloadStats.dnsTS);
            this.setStatusValue(7109, downloadStats.connTS);
            this.setStatusValue(7110, String.valueOf(downloadStats.serverIP));
        }
        if (this.mDownloader != null) {
            int n2 = this.mDownloader.getConnectCountQuic();
            int n3 = this.mDownloader.getConnectCountTcp();
            this.setStatusValue(7114, ++n2);
            this.setStatusValue(7115, ++n3);
            this.setStatusValue(7119, this.mDownloader.getRealStreamUrl());
        }
        this.mLastTimeStamp = l2;
        this.mLastDownloadStats = downloadStats;
    }

    private Long getSpeed(long l2, long l3, long l4) {
        long l5 = 0L;
        l5 = l2 > l3 ? l3 : l3 - l2;
        long l6 = 0L;
        if (l4 > 0L) {
            l6 = l5 * 8L * 1000L / (l4 * 1024L);
        }
        return l6;
    }

    public void setHeaders(Map<String, String> map) {
        this.mHeaders = map;
        if (this.mDownloader != null) {
            this.mDownloader.setHeaders(this.mHeaders);
        }
    }

    static {
        com.tencent.liteav.basic.util.d.f();
    }

    public static class a {
        public String a;
        public String b;
        public String c;
        public int d;
        public String e;
        public boolean f;
    }

    public static class DownloadStats {
        public long beforeParseVideoBytes;
        public long beforeParseAudioBytes;
        public long afterParseVideoBytes;
        public long afterParseAudioBytes;
        public long videoGop;
        public long startTS;
        public long dnsTS;
        public long connTS;
        public long firstVideoTS;
        public long firstAudioTS;
        public String serverIP;
    }
}

