/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.rtmp.sharp.jni;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothProfile;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.media.AudioManager;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Process;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.Log;
import com.tencent.rtmp.sharp.jni.AudioDeviceInterface;
import com.tencent.rtmp.sharp.jni.QLog;
import com.tencent.rtmp.sharp.jni.TraeAudioSession;
import com.tencent.rtmp.sharp.jni.TraeAudioSessionHost;
import com.tencent.rtmp.sharp.jni.TraeMediaPlayer;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;

@SuppressLint(value={"NewApi"})
public class TraeAudioManager
extends BroadcastReceiver {
    public static final String ACTION_TRAEAUDIOMANAGER_REQUEST = "com.tencent.sharp.ACTION_TRAEAUDIOMANAGER_REQUEST";
    public static final String ACTION_TRAEAUDIOMANAGER_RES = "com.tencent.sharp.ACTION_TRAEAUDIOMANAGER_RES";
    public static final String ACTION_TRAEAUDIOMANAGER_NOTIFY = "com.tencent.sharp.ACTION_TRAEAUDIOMANAGER_NOTIFY";
    public static final String PARAM_OPERATION = "PARAM_OPERATION";
    public static final String PARAM_SESSIONID = "PARAM_SESSIONID";
    public static final String PARAM_ISHOSTSIDE = "PARAM_ISHOSTSIDE";
    public static final String PARAM_RES_ERRCODE = "PARAM_RES_ERRCODE";
    public static final int RES_ERRCODE_NONE = 0;
    public static final int RES_ERRCODE_SERVICE_OFF = 1;
    public static final int RES_ERRCODE_VOICECALL_EXIST = 2;
    public static final int RES_ERRCODE_VOICECALL_NOT_EXIST = 3;
    public static final int RES_ERRCODE_STOPRING_INTERRUPT = 4;
    public static final int RES_ERRCODE_RING_NOT_EXIST = 5;
    public static final int RES_ERRCODE_VOICECALLPOST_INTERRUPT = 6;
    public static final int RES_ERRCODE_DEVICE_UNKOWN = 7;
    public static final int RES_ERRCODE_DEVICE_NOT_VISIABLE = 8;
    public static final int RES_ERRCODE_DEVICE_UNCHANGEABLE = 9;
    public static final int RES_ERRCODE_DEVICE_BTCONNCECTED_TIMEOUT = 10;
    public static final String PARAM_STATUS = "PARAM_STATUS";
    public static final String PARAM_DEVICE = "PARAM_DEVICE";
    public static final String PARAM_ERROR = "PARAM_ERROR";
    public static final String PARAM_MODEPOLICY = "PARAM_MODEPOLICY";
    public static final String PARAM_STREAMTYPE = "PARAM_STREAMTYPE";
    public static final String PARAM_RING_DATASOURCE = "PARAM_RING_DATASOURCE";
    public static final String PARAM_RING_RSID = "PARAM_RING_RSID";
    public static final String PARAM_RING_URI = "PARAM_RING_URI";
    public static final String PARAM_RING_FILEPATH = "PARAM_RING_FILEPATH";
    public static final String PARAM_RING_LOOP = "PARAM_RING_LOOP";
    public static final String PARAM_RING_LOOPCOUNT = "PARAM_RING_LOOPCOUNT";
    public static final String PARAM_RING_MODE = "PARAM_RING_MODE";
    public static final String PARAM_RING_USERDATA_STRING = "PARAM_RING_USERDATA_STRING";
    public static final String OPERATION_STARTSERVICE = "OPERATION_STARTSERVICE";
    public static final String EXTRA_DATA_DEVICECONFIG = "EXTRA_DATA_DEVICECONFIG";
    public static final String OPERATION_STOPSERVICE = "OPERATION_STOPSERVICE";
    public static final String OPERATION_REGISTERAUDIOSESSION = "OPERATION_REGISTERAUDIOSESSION";
    public static final String REGISTERAUDIOSESSION_ISREGISTER = "REGISTERAUDIOSESSION_ISREGISTER";
    public static final String OPERATION_GETDEVICELIST = "OPERATION_GETDEVICELIST";
    public static final String OPERATION_GETSTREAMTYPE = "OPERATION_GETSTREAMTYPE";
    public static final String OPERATION_CONNECTDEVICE = "OPERATION_CONNECTDEVICE";
    public static final String CONNECTDEVICE_DEVICENAME = "CONNECTDEVICE_DEVICENAME";
    public static final String CONNECTDEVICE_RESULT_DEVICENAME = "CONNECTDEVICE_RESULT_DEVICENAME";
    public static final String OPERATION_CONNECT_HIGHEST_PRIORITY_DEVICE = "OPERATION_CONNECT_HIGHEST_PRIORITY_DEVICE";
    public static final String OPERATION_ISDEVICECHANGABLED = "OPERATION_ISDEVICECHANGABLED";
    public static final String ISDEVICECHANGABLED_RESULT_ISCHANGABLED = "ISDEVICECHANGABLED_REULT_ISCHANGABLED";
    public static final String OPERATION_GETCONNECTEDDEVICE = "OPERATION_GETCONNECTEDDEVICE";
    public static final String GETCONNECTEDDEVICE_RESULT_LIST = "GETCONNECTEDDEVICE_REULT_LIST";
    public static final String OPERATION_GETCONNECTINGDEVICE = "OPERATION_GETCONNECTINGDEVICE";
    public static final String GETCONNECTINGDEVICE_RESULT_LIST = "GETCONNECTINGDEVICE_REULT_LIST";
    public static final String EXTRA_DATA_STREAMTYPE = "EXTRA_DATA_STREAMTYPE";
    public static final String OPERATION_VOICECALL_PREPROCESS = "OPERATION_VOICECALL_PREPROCESS";
    public static final String OPERATION_VOICECALL_POSTPROCESS = "OPERATION_VOICECALL_POSTROCESS";
    public static final String OPERATION_STARTRING = "OPERATION_STARTRING";
    public static final String OPERATION_STOPRING = "OPERATION_STOPRING";
    public static final String OPERATION_REQUEST_RELEASE_AUDIO_FOCUS = "OPERATION_REQUEST_RELEASE_AUDIO_FOCUS";
    public static final String OPERATION_RECOVER_AUDIO_FOCUS = "OPERATION_RECOVER_AUDIO_FOCUS";
    public static final String OPERATION_VOICECALL_AUDIOPARAM_CHANGED = "OPERATION_VOICECALL_AUDIOPARAM_CHANGED";
    public static final String NOTIFY_SERVICE_STATE = "NOTIFY_SERVICE_STATE";
    public static final String NOTIFY_SERVICE_STATE_DATE = "NOTIFY_SERVICE_STATE_DATE";
    public static final String NOTIFY_DEVICELIST_UPDATE = "NOTIFY_DEVICELISTUPDATE";
    public static final String EXTRA_DATA_AVAILABLEDEVICE_LIST = "EXTRA_DATA_AVAILABLEDEVICE_LIST";
    public static final String EXTRA_DATA_PREV_CONNECTEDDEVICE = "EXTRA_DATA_PREV_CONNECTEDDEVICE";
    public static final String EXTRA_DATA_CONNECTEDDEVICE = "EXTRA_DATA_CONNECTEDDEVICE";
    public static final String EXTRA_DATA_IF_HAS_BLUETOOTH_THIS_IS_NAME = "EXTRA_DATA_IF_HAS_BLUETOOTH_THIS_IS_NAME";
    public static final String NOTIFY_DEVICECHANGABLE_UPDATE = "NOTIFY_DEVICECHANGABLE_UPDATE";
    public static final String NOTIFY_DEVICECHANGABLE_UPDATE_DATE = "NOTIFY_DEVICECHANGABLE_UPDATE_DATE";
    public static final String NOTIFY_RING_COMPLETION = "NOTIFY_RING_COMPLETION";
    public static final String NOTIFY_STREAMTYPE_UPDATE = "NOTIFY_STREAMTYPE_UPDATE";
    public static final String NOTIFY_ROUTESWITCHSTART = "NOTIFY_ROUTESWITCHSTART";
    public static final String EXTRA_DATA_ROUTESWITCHSTART_FROM = "EXTRA_DATA_ROUTESWITCHSTART_FROM";
    public static final String EXTRA_DATA_ROUTESWITCHSTART_TO = "EXTRA_DATA_ROUTESWITCHSTART_TO";
    public static final String NOTIFY_ROUTESWITCHEND = "NOTIFY_ROUTESWITCHEND";
    public static final String EXTRA_DATA_ROUTESWITCHEND_DEV = "EXTRA_DATA_ROUTESWITCHEND_DEV";
    public static final String EXTRA_DATA_ROUTESWITCHEND_TIME = "EXTRA_DATA_ROUTESWITCHEND_TIME";
    public static final int EARACTION_AWAY = 0;
    public static final int EARACTION_CLOSE = 1;
    public static final String OPERATION_EARACTION = "OPERATION_EARACTION";
    public static final String EXTRA_EARACTION = "EXTRA_EARACTION";
    public static final String DEVICE_NONE = "DEVICE_NONE";
    public static final String DEVICE_EARPHONE = "DEVICE_EARPHONE";
    public static final String DEVICE_SPEAKERPHONE = "DEVICE_SPEAKERPHONE";
    public static final String DEVICE_WIREDHEADSET = "DEVICE_WIREDHEADSET";
    public static final String DEVICE_BLUETOOTHHEADSET = "DEVICE_BLUETOOTHHEADSET";
    public static final int DEVICE_STATUS_ERROR = -1;
    public static final int DEVICE_STATUS_DISCONNECTED = 0;
    public static final int DEVICE_STATUS_CONNECTING = 1;
    public static final int DEVICE_STATUS_CONNECTED = 2;
    public static final int DEVICE_STATUS_DISCONNECTING = 3;
    public static final int DEVICE_STATUS_UNCHANGEABLE = 4;
    public static final int AUDIO_MANAGER_ACTIVE_NONE = 0;
    public static final int AUDIO_MANAGER_ACTIVE_VOICECALL = 1;
    public static final int AUDIO_MANAGER_ACTIVE_RING = 2;
    public static final int MODE_VOICE_CHAT = 0;
    public static final int MODE_MUSIC_PLAY_RECORD = 1;
    public static final int MODE_MUSIC_PLAYBACK = 2;
    public static final int MODE_MUSIC_PLAY_RECORD_HIGH_QUALITY = 3;
    public static final int MODE_VOICE_PLAYBACK = 4;
    public static final int MODE_MUSIC_PLAY_RECORD_LOW_QUALITY = 5;
    AudioManager _am = null;
    Context _context = null;
    int _activeMode = 0;
    int _prevMode = 0;
    int _streamType = 0;
    int _modePolicy = -1;
    public static boolean IsMusicScene = false;
    public static boolean IsEarPhoneSupported = false;
    public static boolean IsUpdateSceneFlag = false;
    public static boolean enableDeviceSwitchFlag = true;
    boolean IsBluetoothA2dpExisted = true;
    public static final String VOICECALL_CONFIG = "DEVICE_SPEAKERPHONE;DEVICE_EARPHONE;DEVICE_BLUETOOTHHEADSET;DEVICE_WIREDHEADSET;";
    public static final String VIDEO_CONFIG = "DEVICE_EARPHONE;DEVICE_SPEAKERPHONE;DEVICE_BLUETOOTHHEADSET;DEVICE_WIREDHEADSET;";
    public static final String MUSIC_CONFIG = "DEVICE_SPEAKERPHONE;DEVICE_WIREDHEADSET;DEVICE_BLUETOOTHHEADSET;";
    TraeAudioSessionHost _audioSessionHost = null;
    DeviceConfigManager _deviceConfigManager = null;
    BluetoohHeadsetCheckInterface _bluetoothCheck = null;
    String sessionConnectedDev = "DEVICE_NONE";
    static ReentrantLock _glock = new ReentrantLock();
    static TraeAudioManager _ginstance = null;
    static int _gHostProcessId = -1;
    TraeAudioManagerLooper mTraeAudioManagerLooper = null;
    ReentrantLock _lock = new ReentrantLock();
    static final String AUDIO_PARAMETER_STREAM_ROUTING = "routing";
    static final int AUDIO_DEVICE_OUT_EARPIECE = 1;
    static final int AUDIO_DEVICE_OUT_SPEAKER = 2;
    static final int AUDIO_DEVICE_OUT_WIRED_HEADSET = 4;
    static final int AUDIO_DEVICE_OUT_WIRED_HEADPHONE = 8;
    static final int AUDIO_DEVICE_OUT_BLUETOOTH_SCO = 16;
    static final int AUDIO_DEVICE_OUT_BLUETOOTH_SCO_HEADSET = 32;
    static final int AUDIO_DEVICE_OUT_BLUETOOTH_SCO_CARKIT = 64;
    static final int AUDIO_DEVICE_OUT_BLUETOOTH_A2DP = 128;
    static final int AUDIO_DEVICE_OUT_BLUETOOTH_A2DP_HEADPHONES = 256;
    static final int AUDIO_DEVICE_OUT_BLUETOOTH_A2DP_SPEAKER = 512;
    switchThread _switchThread = null;
    public static final int FORCE_NONE = 0;
    public static final int FORCE_SPEAKER = 1;
    public static final int FORCE_HEADPHONES = 2;
    public static final int FORCE_BT_SCO = 3;
    public static final int FORCE_BT_A2DP = 4;
    public static final int FORCE_WIRED_ACCESSORY = 5;
    public static final int FORCE_BT_CAR_DOCK = 6;
    public static final int FORCE_BT_DESK_DOCK = 7;
    public static final int FORCE_ANALOG_DOCK = 8;
    public static final int FORCE_DIGITAL_DOCK = 9;
    public static final int FORCE_NO_BT_A2DP = 10;
    private static final int NUM_FORCE_CONFIG = 11;
    public static final int FORCE_DEFAULT = 0;
    public static final int FOR_COMMUNICATION = 0;
    public static final int FOR_MEDIA = 1;
    public static final int FOR_RECORD = 2;
    public static final int FOR_DOCK = 3;
    private static final int NUM_FORCE_USE = 4;
    static final String[] forceName = new String[]{"FORCE_NONE", "FORCE_SPEAKER", "FORCE_HEADPHONES", "FORCE_BT_SCO", "FORCE_BT_A2DP", "FORCE_WIRED_ACCESSORY", "FORCE_BT_CAR_DOCK", "FORCE_BT_DESK_DOCK", "FORCE_ANALOG_DOCK", "FORCE_NO_BT_A2DP", "FORCE_DIGITAL_DOCK"};

    public static boolean checkDevName(String string) {
        if (string == null) {
            return false;
        }
        return DEVICE_SPEAKERPHONE.equals(string) || DEVICE_EARPHONE.equals(string) || DEVICE_WIREDHEADSET.equals(string) || DEVICE_BLUETOOTHHEADSET.equals(string);
    }

    public static boolean isHandfree(String string) {
        if (!TraeAudioManager.checkDevName(string)) {
            return false;
        }
        return DEVICE_SPEAKERPHONE.equals(string);
    }

    void printDevices() {
        AudioDeviceInterface.LogTraceEntry("");
        int n2 = this._deviceConfigManager.getDeviceNumber();
        if (QLog.isColorLevel()) {
            QLog.w("TRAE", 2, "   ConnectedDevice:" + this._deviceConfigManager.getConnectedDevice());
        }
        if (QLog.isColorLevel()) {
            QLog.w("TRAE", 2, "   ConnectingDevice:" + this._deviceConfigManager.getConnectingDevice());
        }
        if (QLog.isColorLevel()) {
            QLog.w("TRAE", 2, "   prevConnectedDevice:" + this._deviceConfigManager.getPrevConnectedDevice());
        }
        if (QLog.isColorLevel()) {
            QLog.w("TRAE", 2, "   AHPDevice:" + this._deviceConfigManager.getAvailabledHighestPriorityDevice());
        }
        if (QLog.isColorLevel()) {
            QLog.w("TRAE", 2, "   deviceNamber:" + n2);
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = this._deviceConfigManager.getDeviceName(i2);
            if (!QLog.isColorLevel()) continue;
            QLog.w("TRAE", 2, "      " + i2 + " devName:" + string + " Visible:" + this._deviceConfigManager.getVisible(string) + " Priority:" + this._deviceConfigManager.getPriority(string));
        }
        String[] stringArray = this._deviceConfigManager.getAvailableDeviceList().toArray(new String[0]);
        if (QLog.isColorLevel()) {
            QLog.w("TRAE", 2, "   AvailableNamber:" + stringArray.length);
        }
        for (int i3 = 0; i3 < stringArray.length; ++i3) {
            String string = stringArray[i3];
            if (!QLog.isColorLevel()) continue;
            QLog.w("TRAE", 2, "      " + i3 + " devName:" + string + " Visible:" + this._deviceConfigManager.getVisible(string) + " Priority:" + this._deviceConfigManager.getPriority(string));
        }
        AudioDeviceInterface.LogTraceExit();
    }

    static boolean isCloseSystemAPM(int n2) {
        if (n2 != -1) {
            return false;
        }
        if (Build.MANUFACTURER.equals("Xiaomi")) {
            if (Build.MODEL.equals("MI 2")) {
                return true;
            }
            if (Build.MODEL.equals("MI 2A")) {
                return true;
            }
            if (Build.MODEL.equals("MI 2S")) {
                return true;
            }
            if (Build.MODEL.equals("MI 2SC")) {
                return true;
            }
        } else if (Build.MANUFACTURER.equals("samsung") && Build.MODEL.equals("SCH-I959")) {
            return true;
        }
        return false;
    }

    public static boolean IsEabiLowVersionByAbi(String string) {
        if (string == null) {
            return true;
        }
        if (string.contains("x86")) {
            return false;
        }
        if (string.contains("mips")) {
            return false;
        }
        if (string.equalsIgnoreCase("armeabi")) {
            return true;
        }
        if (string.equalsIgnoreCase("armeabi-v7a")) {
            return false;
        }
        return !string.equalsIgnoreCase("arm64-v8a");
    }

    static boolean IsEabiLowVersion() {
        String string = Build.CPU_ABI;
        String string2 = "unknown";
        if (Build.VERSION.SDK_INT >= 8) {
            try {
                string2 = (String)Build.class.getDeclaredField("CPU_ABI2").get(null);
            }
            catch (Exception exception) {
                return TraeAudioManager.IsEabiLowVersionByAbi(string);
            }
        }
        if (QLog.isColorLevel()) {
            QLog.w("TRAE", 2, "IsEabiVersion CPU_ABI:" + string + " CPU_ABI2:" + string2);
        }
        return TraeAudioManager.IsEabiLowVersionByAbi(string) && TraeAudioManager.IsEabiLowVersionByAbi(string2);
    }

    static int getAudioSource(int n2) {
        int n3 = 0;
        if (IsMusicScene) {
            return n3;
        }
        if (TraeAudioManager.IsEabiLowVersion()) {
            if (QLog.isColorLevel()) {
                QLog.w("TRAE", 2, "[Config] armeabi low Version, getAudioSource _audioSourcePolicy:" + n2 + " source:" + n3);
            }
            return n3;
        }
        int n4 = Build.VERSION.SDK_INT;
        if (n2 >= 0) {
            n3 = n2;
            if (QLog.isColorLevel()) {
                QLog.w("TRAE", 2, "[Config] getAudioSource _audioSourcePolicy:" + n2 + " source:" + n3);
            }
            return n2;
        }
        if (n4 >= 11) {
            n3 = 7;
        }
        if (QLog.isColorLevel()) {
            QLog.w("TRAE", 2, "[Config] getAudioSource _audioSourcePolicy:" + n2 + " source:" + n3);
        }
        return n3;
    }

    static int getAudioStreamType(int n2) {
        int n3 = 3;
        if (IsMusicScene) {
            return n3;
        }
        if (TraeAudioManager.IsEabiLowVersion()) {
            if (QLog.isColorLevel()) {
                QLog.w("TRAE", 2, "[Config] armeabi low Version, getAudioStreamType audioStreamTypePolicy:" + n2 + " streamType:" + n3);
            }
            return n3;
        }
        int n4 = Build.VERSION.SDK_INT;
        if (n2 >= 0) {
            n3 = n2;
        } else if (n4 >= 9) {
            n3 = 0;
        }
        if (QLog.isColorLevel()) {
            QLog.w("TRAE", 2, "[Config] getAudioStreamType audioStreamTypePolicy:" + n2 + " streamType:" + n3);
        }
        return n3;
    }

    static int getCallAudioMode(int n2) {
        int n3 = 0;
        if (IsMusicScene) {
            return n3;
        }
        if (TraeAudioManager.IsEabiLowVersion()) {
            if (QLog.isColorLevel()) {
                QLog.w("TRAE", 2, "[Config] armeabi low Version, getCallAudioMode modePolicy:" + n2 + " mode:" + n3);
            }
            return n3;
        }
        int n4 = Build.VERSION.SDK_INT;
        if (n2 >= 0) {
            n3 = n2;
            if (QLog.isColorLevel()) {
                QLog.w("TRAE", 2, "[Config] getCallAudioMode modePolicy:" + n2 + " mode:" + n3);
            }
            return n3;
        }
        if (n4 >= 11) {
            n3 = 3;
        }
        if (QLog.isColorLevel()) {
            QLog.w("TRAE", 2, "[Config] getCallAudioMode _modePolicy:" + n2 + " mode:" + n3 + "facturer:" + Build.MANUFACTURER + " model:" + Build.MODEL);
        }
        return n3;
    }

    void updateDeviceStatus() {
        int n2 = this._deviceConfigManager.getDeviceNumber();
        for (int i2 = 0; i2 < n2; ++i2) {
            boolean bl = false;
            String string = this._deviceConfigManager.getDeviceName(i2);
            if (string != null) {
                if (string.equals(DEVICE_BLUETOOTHHEADSET)) {
                    bl = this._bluetoothCheck == null ? this._deviceConfigManager.setVisible(string, false) : this._deviceConfigManager.setVisible(string, this._bluetoothCheck.isConnected());
                } else if (string.equals(DEVICE_WIREDHEADSET)) {
                    bl = this._deviceConfigManager.setVisible(string, this._am.isWiredHeadsetOn());
                } else if (string.equals(DEVICE_SPEAKERPHONE)) {
                    this._deviceConfigManager.setVisible(string, true);
                }
            }
            if (!bl || !QLog.isColorLevel()) continue;
            QLog.w("TRAE", 2, "pollUpdateDevice dev:" + string + " Visible:" + this._deviceConfigManager.getVisible(string));
        }
        this.checkAutoDeviceListUpdate();
    }

    void _updateEarphoneVisable() {
        if (this._deviceConfigManager.getVisible(DEVICE_WIREDHEADSET)) {
            if (QLog.isColorLevel()) {
                QLog.w("TRAE", 2, " detected headset plugin,so disable earphone");
            }
            this._deviceConfigManager.setVisible(DEVICE_EARPHONE, false);
        } else {
            if (QLog.isColorLevel()) {
                QLog.w("TRAE", 2, " detected headset plugout,so enable earphone");
            }
            this._deviceConfigManager.setVisible(DEVICE_EARPHONE, true);
        }
    }

    void checkAutoDeviceListUpdate() {
        if (this._deviceConfigManager.getVisiableUpdateFlag()) {
            if (QLog.isColorLevel()) {
                QLog.w("TRAE", 2, "checkAutoDeviceListUpdate got update!");
            }
            this._updateEarphoneVisable();
            this._deviceConfigManager.resetVisiableUpdateFlag();
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            this.internalSendMessage(32785, hashMap);
        }
    }

    void checkDevicePlug(String string, boolean bl) {
        if (this._deviceConfigManager.getVisiableUpdateFlag()) {
            if (QLog.isColorLevel()) {
                QLog.w("TRAE", 2, "checkDevicePlug got update dev:" + string + (bl ? " piugin" : " plugout") + " connectedDev:" + this._deviceConfigManager.getConnectedDevice());
            }
            this._updateEarphoneVisable();
            this._deviceConfigManager.resetVisiableUpdateFlag();
            if (bl) {
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                hashMap.put(PARAM_DEVICE, string);
                this.internalSendMessage(32786, hashMap);
            } else {
                String string2 = this._deviceConfigManager.getConnectedDevice();
                if (string2.equals(string) || string2.equals(DEVICE_NONE)) {
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    hashMap.put(PARAM_DEVICE, string);
                    this.internalSendMessage(32787, hashMap);
                } else {
                    if (QLog.isColorLevel()) {
                        QLog.w("TRAE", 2, " ---No switch,plugout:" + string + " connectedDev:" + string2);
                    }
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    this.internalSendMessage(32785, hashMap);
                }
            }
        }
    }

    public static int SetSpeakerForTest(Context context, boolean bl) {
        int n2 = -1;
        _glock.lock();
        if (null != _ginstance) {
            n2 = _ginstance.InternalSetSpeaker(context, bl);
        } else if (QLog.isColorLevel()) {
            QLog.w("TRAE", 2, "TraeAudioManager|static SetSpeakerForTest|null == _ginstance");
        }
        _glock.unlock();
        return n2;
    }

    int InternalSetSpeaker(Context context, boolean bl) {
        int n2;
        if (context == null) {
            if (QLog.isColorLevel()) {
                QLog.e("TRAE", 2, "Could not InternalSetSpeaker - no context");
            }
            return -1;
        }
        AudioManager audioManager = (AudioManager)context.getSystemService("audio");
        if (audioManager == null) {
            if (QLog.isColorLevel()) {
                QLog.e("TRAE", 2, "Could not InternalSetSpeaker - no audio manager");
            }
            return -1;
        }
        if (QLog.isColorLevel()) {
            QLog.w("TRAE", 2, "InternalSetSpeaker entry:speaker:" + (audioManager.isSpeakerphoneOn() ? "Y" : "N") + "-->:" + (bl ? "Y" : "N"));
        }
        if (TraeAudioManager.isCloseSystemAPM(this._modePolicy) && this._activeMode != 2) {
            return this.InternalSetSpeakerSpe(audioManager, bl);
        }
        if (audioManager.isSpeakerphoneOn() != bl) {
            audioManager.setSpeakerphoneOn(bl);
        }
        int n3 = n2 = audioManager.isSpeakerphoneOn() == bl ? 0 : -1;
        if (QLog.isColorLevel()) {
            QLog.w("TRAE", 2, "InternalSetSpeaker exit:" + bl + " res:" + n2 + " mode:" + audioManager.getMode());
        }
        return n2;
    }

    int InternalSetSpeakerSpe(AudioManager audioManager, boolean bl) {
        int n2;
        if (QLog.isColorLevel()) {
            QLog.w("TRAE", 2, "InternalSetSpeakerSpe fac:" + Build.MANUFACTURER + " model:" + Build.MODEL + " st:" + this._streamType + " media_force_use:" + TraeAudioManager.getForceUse(1));
        }
        if (bl) {
            this.InternalSetMode(0);
            audioManager.setSpeakerphoneOn(true);
            TraeAudioManager.setForceUse(1, 1);
        } else {
            this.InternalSetMode(3);
            audioManager.setSpeakerphoneOn(false);
            TraeAudioManager.setForceUse(1, 0);
        }
        int n3 = n2 = audioManager.isSpeakerphoneOn() == bl ? 0 : -1;
        if (QLog.isColorLevel()) {
            QLog.w("TRAE", 2, "InternalSetSpeakerSpe exit:" + bl + " res:" + n2 + " mode:" + audioManager.getMode());
        }
        return n2;
    }

    void InternalSetMode(int n2) {
        if (QLog.isColorLevel()) {
            QLog.w("TRAE", 2, "SetMode entry:" + n2);
        }
        if (this._am == null) {
            if (QLog.isColorLevel()) {
                QLog.w("TRAE", 2, "setMode:" + n2 + " fail am=null");
            }
            return;
        }
        this._am.setMode(n2);
        if (QLog.isColorLevel()) {
            QLog.w("TRAE", 2, "setMode:" + n2 + (this._am.getMode() != n2 ? "fail" : "success"));
        }
    }

    public static int registerAudioSession(TraeAudioSession traeAudioSession, boolean bl, long l2, Context context) {
        int n2 = -1;
        _glock.lock();
        if (null != _ginstance) {
            if (bl) {
                TraeAudioManager._ginstance._audioSessionHost.add(traeAudioSession, l2, context);
            } else {
                TraeAudioManager._ginstance._audioSessionHost.remove(l2);
            }
            n2 = 0;
        }
        _glock.unlock();
        return n2;
    }

    public static int sendMessage(int n2, HashMap<String, Object> hashMap) {
        int n3 = -1;
        _glock.lock();
        if (null != _ginstance) {
            n3 = _ginstance.internalSendMessage(n2, hashMap);
        }
        _glock.unlock();
        return n3;
    }

    public static int init(Context context) {
        Log.w((String)"TRAE", (String)("TraeAudioManager init _ginstance:" + (Object)((Object)_ginstance)));
        AudioDeviceInterface.LogTraceEntry(" _ginstance:" + (Object)((Object)_ginstance));
        _glock.lock();
        if (null == _ginstance) {
            _ginstance = new TraeAudioManager(context);
        }
        _glock.unlock();
        AudioDeviceInterface.LogTraceExit();
        return 0;
    }

    public static void uninit() {
        Log.w((String)"TRAE", (String)("TraeAudioManager uninit _ginstance:" + (Object)((Object)_ginstance)));
        AudioDeviceInterface.LogTraceEntry(" _ginstance:" + (Object)((Object)_ginstance));
        _glock.lock();
        if (null != _ginstance) {
            _ginstance.release();
            _ginstance = null;
        }
        _glock.unlock();
        AudioDeviceInterface.LogTraceExit();
    }

    TraeAudioManager(Context context) {
        AudioDeviceInterface.LogTraceEntry(" context:" + context);
        if (context == null) {
            return;
        }
        this._context = context;
        this.mTraeAudioManagerLooper = new TraeAudioManagerLooper(this);
        if (this.mTraeAudioManagerLooper != null) {
            // empty if block
        }
        AudioDeviceInterface.LogTraceExit();
    }

    public void release() {
        AudioDeviceInterface.LogTraceEntry("");
        if (null != this.mTraeAudioManagerLooper) {
            this.mTraeAudioManagerLooper.quit();
            this.mTraeAudioManagerLooper = null;
        }
        AudioDeviceInterface.LogTraceExit();
    }

    public void onReceive(Context context, Intent intent) {
        if (intent == null || context == null) {
            if (QLog.isColorLevel()) {
                QLog.d("TRAE", 2, "onReceive intent or context is null!");
            }
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        try {
            String string = intent.getAction();
            String string2 = intent.getStringExtra(PARAM_OPERATION);
            if (QLog.isColorLevel()) {
                QLog.w("TRAE", 2, "TraeAudioManager|onReceive::Action:" + intent.getAction());
            }
            if (this._deviceConfigManager == null) {
                if (QLog.isColorLevel()) {
                    QLog.d("TRAE", 2, "_deviceConfigManager null!");
                }
                return;
            }
            bl = this._deviceConfigManager.getVisible(DEVICE_WIREDHEADSET);
            bl2 = this._deviceConfigManager.getVisible(DEVICE_BLUETOOTHHEADSET);
            if ("android.intent.action.HEADSET_PLUG".equals(intent.getAction())) {
                this.onHeadsetPlug(context, intent);
                if (!bl && this._deviceConfigManager.getVisible(DEVICE_WIREDHEADSET)) {
                    this.checkDevicePlug(DEVICE_WIREDHEADSET, true);
                }
                if (bl && !this._deviceConfigManager.getVisible(DEVICE_WIREDHEADSET)) {
                    this.checkDevicePlug(DEVICE_WIREDHEADSET, false);
                }
            } else if (!"android.media.AUDIO_BECOMING_NOISY".equals(intent.getAction())) {
                if (ACTION_TRAEAUDIOMANAGER_REQUEST.equals(string)) {
                    if (QLog.isColorLevel()) {
                        QLog.w("TRAE", 2, "   OPERATION:" + string2);
                    }
                    if (OPERATION_STARTSERVICE.equals(string2)) {
                        TraeAudioManager.startService(string2, intent.getLongExtra(PARAM_SESSIONID, Long.MIN_VALUE), false, intent.getStringExtra(EXTRA_DATA_DEVICECONFIG));
                    } else if (OPERATION_STOPSERVICE.equals(string2)) {
                        TraeAudioManager.stopService(string2, intent.getLongExtra(PARAM_SESSIONID, Long.MIN_VALUE), false);
                    } else if (OPERATION_GETDEVICELIST.equals(string2)) {
                        TraeAudioManager.getDeviceList(string2, intent.getLongExtra(PARAM_SESSIONID, Long.MIN_VALUE), false);
                    } else if (OPERATION_GETSTREAMTYPE.equals(string2)) {
                        TraeAudioManager.getStreamType(string2, intent.getLongExtra(PARAM_SESSIONID, Long.MIN_VALUE), false);
                    } else if (OPERATION_CONNECTDEVICE.equals(string2)) {
                        TraeAudioManager.connectDevice(string2, intent.getLongExtra(PARAM_SESSIONID, Long.MIN_VALUE), false, intent.getStringExtra(CONNECTDEVICE_DEVICENAME));
                    } else if (OPERATION_CONNECT_HIGHEST_PRIORITY_DEVICE.equals(string2)) {
                        TraeAudioManager.connectHighestPriorityDevice(string2, intent.getLongExtra(PARAM_SESSIONID, Long.MIN_VALUE), false);
                    } else if (OPERATION_EARACTION.equals(string2)) {
                        TraeAudioManager.earAction(string2, intent.getLongExtra(PARAM_SESSIONID, Long.MIN_VALUE), false, intent.getIntExtra(EXTRA_EARACTION, -1));
                    } else if (OPERATION_ISDEVICECHANGABLED.equals(string2)) {
                        TraeAudioManager.isDeviceChangabled(string2, intent.getLongExtra(PARAM_SESSIONID, Long.MIN_VALUE), false);
                    } else if (OPERATION_GETCONNECTEDDEVICE.equals(string2)) {
                        TraeAudioManager.getConnectedDevice(string2, intent.getLongExtra(PARAM_SESSIONID, Long.MIN_VALUE), false);
                    } else if (OPERATION_GETCONNECTINGDEVICE.equals(string2)) {
                        TraeAudioManager.getConnectingDevice(string2, intent.getLongExtra(PARAM_SESSIONID, Long.MIN_VALUE), false);
                    } else if (OPERATION_VOICECALL_PREPROCESS.equals(string2)) {
                        int n2 = intent.getIntExtra(PARAM_MODEPOLICY, -1);
                        int n3 = intent.getIntExtra(PARAM_STREAMTYPE, -1);
                        TraeAudioManager.voicecallPreprocess(string2, intent.getLongExtra(PARAM_SESSIONID, Long.MIN_VALUE), false, n2, n3);
                    } else if (OPERATION_VOICECALL_POSTPROCESS.equals(string2)) {
                        TraeAudioManager.voicecallPostprocess(string2, intent.getLongExtra(PARAM_SESSIONID, Long.MIN_VALUE), false);
                    } else if (OPERATION_VOICECALL_AUDIOPARAM_CHANGED.equals(string2)) {
                        int n4 = intent.getIntExtra(PARAM_MODEPOLICY, -1);
                        int n5 = intent.getIntExtra(PARAM_STREAMTYPE, -1);
                        TraeAudioManager.voiceCallAudioParamChanged(string2, intent.getLongExtra(PARAM_SESSIONID, Long.MIN_VALUE), false, n4, n5);
                    } else if (OPERATION_STARTRING.equals(string2)) {
                        Uri uri = null;
                        String string3 = null;
                        String string4 = null;
                        int n6 = intent.getIntExtra(PARAM_RING_DATASOURCE, -1);
                        int n7 = intent.getIntExtra(PARAM_RING_RSID, -1);
                        uri = (Uri)intent.getParcelableExtra(PARAM_RING_URI);
                        string3 = intent.getStringExtra(PARAM_RING_FILEPATH);
                        boolean bl3 = intent.getBooleanExtra(PARAM_RING_LOOP, false);
                        string4 = intent.getStringExtra(PARAM_RING_USERDATA_STRING);
                        int n8 = intent.getIntExtra(PARAM_RING_LOOPCOUNT, 1);
                        boolean bl4 = intent.getBooleanExtra(PARAM_RING_MODE, false);
                        TraeAudioManager.startRing(string2, intent.getLongExtra(PARAM_SESSIONID, Long.MIN_VALUE), false, n6, n7, uri, string3, bl3, n8, string4, bl4);
                    } else if (OPERATION_STOPRING.equals(string2)) {
                        TraeAudioManager.stopRing(string2, intent.getLongExtra(PARAM_SESSIONID, Long.MIN_VALUE), false);
                    }
                } else if (this._deviceConfigManager != null) {
                    if (this._bluetoothCheck != null) {
                        this._bluetoothCheck.onReceive(context, intent, this._deviceConfigManager);
                    }
                    if (!bl2 && this._deviceConfigManager.getVisible(DEVICE_BLUETOOTHHEADSET)) {
                        this.checkDevicePlug(DEVICE_BLUETOOTHHEADSET, true);
                    }
                    if (bl2 && !this._deviceConfigManager.getVisible(DEVICE_BLUETOOTHHEADSET)) {
                        this.checkDevicePlug(DEVICE_BLUETOOTHHEADSET, false);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void onHeadsetPlug(Context context, Intent intent) {
        String string = "";
        String string2 = intent.getStringExtra("name");
        if (string2 == null) {
            string2 = "unkonw";
        }
        string = string + " [" + string2 + "] ";
        int n2 = intent.getIntExtra("state", -1);
        if (n2 != -1) {
            string = string + (n2 == 0 ? "unplugged" : "plugged");
        }
        string = string + " mic:";
        int n3 = intent.getIntExtra("microphone", -1);
        if (n3 != -1) {
            string = string + (n3 == 1 ? "Y" : "unkown");
        }
        if (QLog.isColorLevel()) {
            QLog.w("TRAE", 2, "onHeadsetPlug:: " + string);
        }
        this._deviceConfigManager.setVisible(DEVICE_WIREDHEADSET, 1 == n2);
        if (QLog.isColorLevel()) {
            QLog.w("TRAE", 2, "onHeadsetPlug exit");
        }
    }

    int internalSendMessage(int n2, HashMap<String, Object> hashMap) {
        int n3 = -1;
        if (null != this.mTraeAudioManagerLooper) {
            n3 = this.mTraeAudioManagerLooper.sendMessage(n2, hashMap);
        }
        return n3;
    }

    static int getDeviceList(String string, long l2, boolean bl) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(PARAM_SESSIONID, l2);
        hashMap.put(PARAM_OPERATION, string);
        hashMap.put(PARAM_ISHOSTSIDE, bl);
        return TraeAudioManager.sendMessage(32774, hashMap);
    }

    static int getStreamType(String string, long l2, boolean bl) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(PARAM_SESSIONID, l2);
        hashMap.put(PARAM_OPERATION, string);
        hashMap.put(PARAM_ISHOSTSIDE, bl);
        return TraeAudioManager.sendMessage(32784, hashMap);
    }

    static int startService(String string, long l2, boolean bl, String string2) {
        if (string2.length() <= 0) {
            return -1;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(PARAM_SESSIONID, l2);
        hashMap.put(PARAM_OPERATION, string);
        hashMap.put(PARAM_ISHOSTSIDE, bl);
        hashMap.put(EXTRA_DATA_DEVICECONFIG, string2);
        return TraeAudioManager.sendMessage(32772, hashMap);
    }

    static int stopService(String string, long l2, boolean bl) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(PARAM_SESSIONID, l2);
        hashMap.put(PARAM_OPERATION, string);
        hashMap.put(PARAM_ISHOSTSIDE, bl);
        return TraeAudioManager.sendMessage(32773, hashMap);
    }

    static int disableDeviceSwitch() {
        enableDeviceSwitchFlag = false;
        return 0;
    }

    static int connectDevice(String string, long l2, boolean bl, String string2) {
        if (string2 == null) {
            return -1;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(PARAM_SESSIONID, l2);
        hashMap.put(PARAM_OPERATION, string);
        hashMap.put(PARAM_ISHOSTSIDE, bl);
        hashMap.put(CONNECTDEVICE_DEVICENAME, string2);
        hashMap.put(PARAM_DEVICE, string2);
        return TraeAudioManager.sendMessage(32775, hashMap);
    }

    static int connectHighestPriorityDevice(String string, long l2, boolean bl) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(PARAM_SESSIONID, l2);
        hashMap.put(PARAM_OPERATION, string);
        hashMap.put(PARAM_ISHOSTSIDE, bl);
        return TraeAudioManager.sendMessage(32789, hashMap);
    }

    static int earAction(String string, long l2, boolean bl, int n2) {
        if (n2 != 0 && n2 != 1) {
            return -1;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(PARAM_SESSIONID, l2);
        hashMap.put(PARAM_OPERATION, string);
        hashMap.put(PARAM_ISHOSTSIDE, bl);
        hashMap.put(EXTRA_EARACTION, n2);
        return TraeAudioManager.sendMessage(32776, hashMap);
    }

    static int isDeviceChangabled(String string, long l2, boolean bl) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(PARAM_SESSIONID, l2);
        hashMap.put(PARAM_OPERATION, string);
        hashMap.put(PARAM_ISHOSTSIDE, bl);
        return TraeAudioManager.sendMessage(32777, hashMap);
    }

    static int getConnectedDevice(String string, long l2, boolean bl) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(PARAM_SESSIONID, l2);
        hashMap.put(PARAM_OPERATION, string);
        hashMap.put(PARAM_ISHOSTSIDE, bl);
        return TraeAudioManager.sendMessage(32778, hashMap);
    }

    static int getConnectingDevice(String string, long l2, boolean bl) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(PARAM_SESSIONID, l2);
        hashMap.put(PARAM_OPERATION, string);
        hashMap.put(PARAM_ISHOSTSIDE, bl);
        return TraeAudioManager.sendMessage(32779, hashMap);
    }

    static int voicecallPreprocess(String string, long l2, boolean bl, int n2, int n3) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(PARAM_SESSIONID, l2);
        hashMap.put(PARAM_OPERATION, string);
        hashMap.put(PARAM_ISHOSTSIDE, bl);
        hashMap.put(PARAM_MODEPOLICY, n2);
        hashMap.put(PARAM_STREAMTYPE, n3);
        return TraeAudioManager.sendMessage(32780, hashMap);
    }

    static int voicecallPostprocess(String string, long l2, boolean bl) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(PARAM_SESSIONID, l2);
        hashMap.put(PARAM_OPERATION, string);
        hashMap.put(PARAM_ISHOSTSIDE, bl);
        return TraeAudioManager.sendMessage(32781, hashMap);
    }

    static int voiceCallAudioParamChanged(String string, long l2, boolean bl, int n2, int n3) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(PARAM_SESSIONID, l2);
        hashMap.put(PARAM_OPERATION, string);
        hashMap.put(PARAM_ISHOSTSIDE, bl);
        hashMap.put(PARAM_MODEPOLICY, n2);
        hashMap.put(PARAM_STREAMTYPE, n3);
        return TraeAudioManager.sendMessage(32788, hashMap);
    }

    static int startRing(String string, long l2, boolean bl, int n2, int n3, Uri uri, String string2, boolean bl2, int n4, String string3, boolean bl3) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(PARAM_SESSIONID, l2);
        hashMap.put(PARAM_OPERATION, string);
        hashMap.put(PARAM_ISHOSTSIDE, bl);
        hashMap.put(PARAM_RING_DATASOURCE, n2);
        hashMap.put(PARAM_RING_RSID, n3);
        hashMap.put(PARAM_RING_URI, uri);
        hashMap.put(PARAM_RING_FILEPATH, string2);
        hashMap.put(PARAM_RING_LOOP, bl2);
        hashMap.put(PARAM_RING_LOOPCOUNT, n4);
        hashMap.put(PARAM_RING_MODE, bl3);
        hashMap.put(PARAM_RING_USERDATA_STRING, string3);
        return TraeAudioManager.sendMessage(32782, hashMap);
    }

    static int stopRing(String string, long l2, boolean bl) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(PARAM_SESSIONID, l2);
        hashMap.put(PARAM_OPERATION, string);
        hashMap.put(PARAM_ISHOSTSIDE, bl);
        return TraeAudioManager.sendMessage(32783, hashMap);
    }

    static int requestReleaseAudioFocus(String string, long l2, boolean bl) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(PARAM_SESSIONID, l2);
        hashMap.put(PARAM_OPERATION, string);
        hashMap.put(PARAM_ISHOSTSIDE, bl);
        return TraeAudioManager.sendMessage(32790, hashMap);
    }

    static int recoverAudioFocus(String string, long l2, boolean bl) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(PARAM_SESSIONID, l2);
        hashMap.put(PARAM_OPERATION, string);
        hashMap.put(PARAM_ISHOSTSIDE, bl);
        return TraeAudioManager.sendMessage(32791, hashMap);
    }

    int InternalSessionConnectDevice(HashMap<String, Object> hashMap) {
        AudioDeviceInterface.LogTraceEntry("");
        if (null == hashMap || this._context == null) {
            return -1;
        }
        if (IsMusicScene) {
            if (QLog.isColorLevel()) {
                QLog.w("TRAE", 2, "MusicScene: InternalSessionConnectDevice failed");
            }
            return -1;
        }
        String string = "unkown";
        string = (String)hashMap.get(PARAM_DEVICE);
        Log.w((String)"TRAE", (String)("ConnectDevice: " + string));
        if (!IsEarPhoneSupported && string.equals(DEVICE_EARPHONE)) {
            if (QLog.isColorLevel()) {
                QLog.e("TRAE", 2, "InternalSessionConnectDevice IsEarPhoneSupported = false, Connect device:" + string + " failed");
            }
            return -1;
        }
        int n2 = 0;
        boolean bl = this.InternalIsDeviceChangeable();
        if (!TraeAudioManager.checkDevName(string)) {
            n2 = 7;
        } else if (!this._deviceConfigManager.getVisible(string)) {
            n2 = 8;
        } else if (!bl) {
            n2 = 9;
        }
        if (QLog.isColorLevel()) {
            QLog.w("TRAE", 2, "sessonID:" + (Long)hashMap.get(PARAM_SESSIONID) + " devName:" + string + " bChangabled:" + (bl ? "Y" : "N") + " err:" + n2);
        }
        if (n2 != 0) {
            Intent intent = new Intent();
            intent.putExtra(CONNECTDEVICE_RESULT_DEVICENAME, (String)hashMap.get(PARAM_DEVICE));
            this.sendResBroadcast(intent, hashMap, n2);
            return -1;
        }
        if (string.equals(this._deviceConfigManager.getConnectedDevice())) {
            if (QLog.isColorLevel()) {
                QLog.e("TRAE", 2, " --has connected!");
            }
            Intent intent = new Intent();
            intent.putExtra(CONNECTDEVICE_RESULT_DEVICENAME, (String)hashMap.get(PARAM_DEVICE));
            this.sendResBroadcast(intent, hashMap, n2);
            return 0;
        }
        if (QLog.isColorLevel()) {
            QLog.w("TRAE", 2, " --connecting...");
        }
        this.InternalConnectDevice(string, hashMap, false);
        AudioDeviceInterface.LogTraceExit();
        return 0;
    }

    int InternalSessionEarAction(HashMap<String, Object> hashMap) {
        return 0;
    }

    int InternalConnectDevice(String string, HashMap<String, Object> hashMap, boolean bl) {
        AudioDeviceInterface.LogTraceEntry(" devName:" + string);
        if (string == null) {
            return -1;
        }
        if (IsMusicScene && string.equals(DEVICE_EARPHONE)) {
            if (QLog.isColorLevel()) {
                QLog.e("TRAE", 2, "MusicScene, Connect device:" + string + " failed");
            }
            return -1;
        }
        if (!IsEarPhoneSupported && string.equals(DEVICE_EARPHONE)) {
            if (QLog.isColorLevel()) {
                QLog.e("TRAE", 2, "IsEarPhoneSupported = false, Connect device:" + string + " failed");
            }
            return -1;
        }
        if (!bl && !this._deviceConfigManager.getConnectedDevice().equals(DEVICE_NONE) && string.equals(this._deviceConfigManager.getConnectedDevice())) {
            return 0;
        }
        if (!TraeAudioManager.checkDevName(string) || !this._deviceConfigManager.getVisible(string)) {
            if (QLog.isColorLevel()) {
                QLog.e("TRAE", 2, " checkDevName fail");
            }
            return -1;
        }
        if (!this.InternalIsDeviceChangeable()) {
            if (QLog.isColorLevel()) {
                QLog.e("TRAE", 2, " InternalIsDeviceChangeable fail");
            }
            return -1;
        }
        if (this._switchThread != null) {
            if (QLog.isColorLevel()) {
                QLog.w("TRAE", 2, "_switchThread:" + this._switchThread.getDeviceName());
            }
            this._switchThread.quit();
            this._switchThread = null;
        }
        if (string.equals(DEVICE_EARPHONE)) {
            this._switchThread = new earphoneSwitchThread();
        } else if (string.equals(DEVICE_SPEAKERPHONE)) {
            this._switchThread = new speakerSwitchThread();
        } else if (string.equals(DEVICE_WIREDHEADSET)) {
            this._switchThread = new headsetSwitchThread();
        } else if (string.equals(DEVICE_BLUETOOTHHEADSET)) {
            this._switchThread = new bluetoothHeadsetSwitchThread();
        }
        if (this._switchThread != null) {
            this._switchThread.setDeviceConnectParam(hashMap);
            this._switchThread.start();
        }
        AudioDeviceInterface.LogTraceExit();
        return 0;
    }

    int InternalSessionIsDeviceChangabled(HashMap<String, Object> hashMap) {
        Intent intent = new Intent();
        intent.putExtra(ISDEVICECHANGABLED_RESULT_ISCHANGABLED, this.InternalIsDeviceChangeable());
        this.sendResBroadcast(intent, hashMap, 0);
        return 0;
    }

    boolean InternalIsDeviceChangeable() {
        String string = null;
        string = this._deviceConfigManager.getConnectingDevice();
        return string == null || string.equals(DEVICE_NONE) || string.equals("");
    }

    int InternalSessionGetConnectedDevice(HashMap<String, Object> hashMap) {
        Intent intent = new Intent();
        intent.putExtra(GETCONNECTEDDEVICE_RESULT_LIST, this._deviceConfigManager.getConnectedDevice());
        this.sendResBroadcast(intent, hashMap, 0);
        return 0;
    }

    int InternalSessionGetConnectingDevice(HashMap<String, Object> hashMap) {
        Intent intent = new Intent();
        intent.putExtra(GETCONNECTINGDEVICE_RESULT_LIST, this._deviceConfigManager.getConnectingDevice());
        this.sendResBroadcast(intent, hashMap, 0);
        return 0;
    }

    int sendResBroadcast(Intent intent, HashMap<String, Object> hashMap, int n2) {
        if (this._context == null) {
            return -1;
        }
        Long l2 = (Long)hashMap.get(PARAM_SESSIONID);
        if (QLog.isColorLevel()) {
            QLog.w("TRAE", 2, " sessonID:" + l2 + " " + (String)hashMap.get(PARAM_OPERATION));
        }
        if (l2 == null || l2 == Long.MIN_VALUE) {
            this.InternalNotifyDeviceListUpdate();
            if (QLog.isColorLevel()) {
                QLog.e("TRAE", 2, "sendResBroadcast sid null,don't send res");
            }
            return -1;
        }
        final Intent intent2 = intent;
        final Long l3 = (Long)hashMap.get(PARAM_SESSIONID);
        final String string = (String)hashMap.get(PARAM_OPERATION);
        final int n3 = n2;
        if (OPERATION_VOICECALL_PREPROCESS.equals(string)) {
            intent2.setAction(ACTION_TRAEAUDIOMANAGER_RES);
            intent2.putExtra(PARAM_SESSIONID, (Serializable)l3);
            intent2.putExtra(PARAM_OPERATION, string);
            intent2.putExtra(PARAM_RES_ERRCODE, n3);
            if (this._audioSessionHost != null) {
                this._audioSessionHost.sendToAudioSessionMessage(intent2);
            }
        } else {
            Handler handler = new Handler(Looper.getMainLooper());
            handler.post(new Runnable(){

                @Override
                public void run() {
                    intent2.setAction(TraeAudioManager.ACTION_TRAEAUDIOMANAGER_RES);
                    intent2.putExtra(TraeAudioManager.PARAM_SESSIONID, (Serializable)l3);
                    intent2.putExtra(TraeAudioManager.PARAM_OPERATION, string);
                    intent2.putExtra(TraeAudioManager.PARAM_RES_ERRCODE, n3);
                    if (TraeAudioManager.this._context != null) {
                        TraeAudioManager.this._context.sendBroadcast(intent2);
                    }
                }
            });
        }
        return 0;
    }

    int InternalNotifyDeviceListUpdate() {
        AudioDeviceInterface.LogTraceEntry("");
        if (null == this._context) {
            return -1;
        }
        HashMap<String, Object> hashMap = this._deviceConfigManager.getSnapParams();
        final ArrayList arrayList = (ArrayList)hashMap.get(EXTRA_DATA_AVAILABLEDEVICE_LIST);
        final String string = (String)hashMap.get(EXTRA_DATA_CONNECTEDDEVICE);
        final String string2 = (String)hashMap.get(EXTRA_DATA_PREV_CONNECTEDDEVICE);
        final String string3 = this._deviceConfigManager.getBluetoothName();
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(new Runnable(){

            @Override
            public void run() {
                Intent intent = new Intent();
                intent.setAction(TraeAudioManager.ACTION_TRAEAUDIOMANAGER_NOTIFY);
                intent.putExtra(TraeAudioManager.PARAM_OPERATION, TraeAudioManager.NOTIFY_DEVICELIST_UPDATE);
                intent.putExtra(TraeAudioManager.EXTRA_DATA_AVAILABLEDEVICE_LIST, arrayList.toArray(new String[0]));
                intent.putExtra(TraeAudioManager.EXTRA_DATA_CONNECTEDDEVICE, string);
                intent.putExtra(TraeAudioManager.EXTRA_DATA_PREV_CONNECTEDDEVICE, string2);
                intent.putExtra(TraeAudioManager.EXTRA_DATA_IF_HAS_BLUETOOTH_THIS_IS_NAME, string3);
                if (TraeAudioManager.this._context != null) {
                    TraeAudioManager.this._context.sendBroadcast(intent);
                }
            }
        });
        AudioDeviceInterface.LogTraceExit();
        return 0;
    }

    int InternalNotifyDeviceChangableUpdate() {
        if (null == this._context) {
            return -1;
        }
        final boolean bl = this.InternalIsDeviceChangeable();
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(new Runnable(){

            @Override
            public void run() {
                Intent intent = new Intent();
                intent.setAction(TraeAudioManager.ACTION_TRAEAUDIOMANAGER_NOTIFY);
                intent.putExtra(TraeAudioManager.PARAM_OPERATION, TraeAudioManager.NOTIFY_DEVICECHANGABLE_UPDATE);
                intent.putExtra(TraeAudioManager.NOTIFY_DEVICECHANGABLE_UPDATE_DATE, bl);
                if (TraeAudioManager.this._context != null) {
                    TraeAudioManager.this._context.sendBroadcast(intent);
                }
            }
        });
        return 0;
    }

    public BluetoohHeadsetCheckInterface CreateBluetoothCheck(Context context, DeviceConfigManager deviceConfigManager) {
        BluetoohHeadsetCheckInterface bluetoohHeadsetCheckInterface = null;
        bluetoohHeadsetCheckInterface = Build.VERSION.SDK_INT >= 11 ? new BluetoohHeadsetCheck() : (Build.VERSION.SDK_INT != 18 ? new BluetoohHeadsetCheckFor2x() : new BluetoohHeadsetCheckFake());
        if (!bluetoohHeadsetCheckInterface.init(context, deviceConfigManager)) {
            bluetoohHeadsetCheckInterface = new BluetoohHeadsetCheckFake();
        }
        if (QLog.isColorLevel()) {
            QLog.w("TRAE", 2, "CreateBluetoothCheck:" + bluetoohHeadsetCheckInterface.interfaceDesc() + " skip android4.3:" + (Build.VERSION.SDK_INT == 18 ? "Y" : "N"));
        }
        return bluetoohHeadsetCheckInterface;
    }

    static String getForceConfigName(int n2) {
        if (n2 >= 0 && n2 < forceName.length) {
            return forceName[n2];
        }
        return "unknow";
    }

    public static Object invokeMethod(Object object, String string, Object[] objectArray, Class[] classArray) {
        Object object2;
        block2: {
            object2 = null;
            try {
                Class<?> clazz = object.getClass();
                Method method = clazz.getMethod(string, classArray);
                object2 = method.invoke(object, objectArray);
            }
            catch (Exception exception) {
                if (!QLog.isColorLevel()) break block2;
                QLog.w("TRAE", 2, "invokeMethod Exception:" + exception.getMessage());
            }
        }
        return object2;
    }

    public static Object invokeStaticMethod(String string, String string2, Object[] objectArray, Class[] classArray) {
        Object object;
        block12: {
            object = null;
            try {
                Class<?> clazz = Class.forName(string);
                Method method = clazz.getMethod(string2, classArray);
                object = method.invoke(null, objectArray);
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (QLog.isColorLevel()) {
                    QLog.w("TRAE", 2, "ClassNotFound:" + string);
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                if (QLog.isColorLevel()) {
                    QLog.w("TRAE", 2, "NoSuchMethod:" + string2);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (QLog.isColorLevel()) {
                    QLog.w("TRAE", 2, "IllegalArgument:" + string2);
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                if (QLog.isColorLevel()) {
                    QLog.w("TRAE", 2, "IllegalAccess:" + string2);
                }
            }
            catch (InvocationTargetException invocationTargetException) {
                if (QLog.isColorLevel()) {
                    QLog.w("TRAE", 2, "InvocationTarget:" + string2);
                }
            }
            catch (Exception exception) {
                if (!QLog.isColorLevel()) break block12;
                QLog.w("TRAE", 2, "invokeStaticMethod Exception:" + exception.getMessage());
            }
        }
        return object;
    }

    static void setParameters(String string) {
        Object[] objectArray = new Object[]{string};
        Class[] classArray = new Class[objectArray.length];
        classArray[0] = String.class;
        if (QLog.isColorLevel()) {
            QLog.w("TRAE", 2, "setParameters  :" + string);
        }
        TraeAudioManager.invokeStaticMethod("android.media.AudioSystem", "setParameters", objectArray, classArray);
    }

    static void setPhoneState(int n2) {
        Object[] objectArray = new Object[]{n2};
        Class[] classArray = new Class[objectArray.length];
        classArray[0] = Integer.TYPE;
        TraeAudioManager.invokeStaticMethod("android.media.AudioSystem", "setPhoneState", objectArray, classArray);
    }

    static void setForceUse(int n2, int n3) {
        Object[] objectArray = new Object[]{n2, n3};
        Class[] classArray = new Class[objectArray.length];
        classArray[0] = Integer.TYPE;
        classArray[1] = Integer.TYPE;
        Object object = TraeAudioManager.invokeStaticMethod("android.media.AudioSystem", "setForceUse", objectArray, classArray);
        if (QLog.isColorLevel()) {
            QLog.w("TRAE", 2, "setForceUse  usage:" + n2 + " config:" + n3 + " ->" + TraeAudioManager.getForceConfigName(n3) + " res:" + object);
        }
    }

    static int getForceUse(int n2) {
        Integer n3 = 0;
        Object[] objectArray = new Object[]{n2};
        Class[] classArray = new Class[objectArray.length];
        classArray[0] = Integer.TYPE;
        Object object = TraeAudioManager.invokeStaticMethod("android.media.AudioSystem", "getForceUse", objectArray, classArray);
        if (object != null) {
            n3 = (Integer)object;
        }
        if (QLog.isColorLevel()) {
            QLog.w("TRAE", 2, "getForceUse  usage:" + n2 + " config:" + n3 + " ->" + TraeAudioManager.getForceConfigName(n3));
        }
        return n3;
    }

    static void forceVolumeControlStream(AudioManager audioManager, int n2) {
        if (Build.MANUFACTURER.equals("Google")) {
            if (QLog.isColorLevel()) {
                QLog.w("TRAE", 2, "forceVolumeControlStream, Google phone nothing to do");
            }
            return;
        }
        Object[] objectArray = new Object[]{n2};
        Class[] classArray = new Class[objectArray.length];
        classArray[0] = Integer.TYPE;
        Object object = TraeAudioManager.invokeMethod(audioManager, "forceVolumeControlStream", objectArray, classArray);
        if (QLog.isColorLevel()) {
            QLog.w("TRAE", 2, "forceVolumeControlStream  streamType:" + n2 + " res:" + object);
        }
    }

    class BluetoohHeadsetCheckFor2x
    extends BluetoohHeadsetCheckInterface {
        public static final String ACTION_BLUETOOTHHEADSET_AUDIO_STATE_CHANGED = "android.bluetooth.headset.action.AUDIO_STATE_CHANGED";
        public static final String ACTION_BLUETOOTHHEADSET_STATE_CHANGED = "android.bluetooth.headset.action.STATE_CHANGED";
        static final int STATE_CONNECTED = 2;
        static final int STATE_DISCONNECTED = 0;
        public static final int AUDIO_STATE_DISCONNECTED = 0;
        public static final int AUDIO_STATE_CONNECTED = 1;
        Class<?> BluetoothHeadsetClass;
        Class<?> ListenerClass;
        Object BluetoothHeadsetObj;
        Method getCurrentHeadsetMethod;
        Context _ctx;
        DeviceConfigManager _devCfg;

        BluetoohHeadsetCheckFor2x() {
            this.BluetoothHeadsetClass = null;
            this.ListenerClass = null;
            this.BluetoothHeadsetObj = null;
            this.getCurrentHeadsetMethod = null;
            this._ctx = null;
            this._devCfg = null;
        }

        @Override
        public boolean init(Context context, DeviceConfigManager deviceConfigManager) {
            block26: {
                block25: {
                    block24: {
                        block23: {
                            AudioDeviceInterface.LogTraceEntry("");
                            Object var3_3 = null;
                            this._ctx = context;
                            this._devCfg = deviceConfigManager;
                            if (this._ctx == null || this._devCfg == null) {
                                return false;
                            }
                            try {
                                this.BluetoothHeadsetClass = Class.forName("android.bluetooth.BluetoothHeadset");
                            }
                            catch (Exception exception) {
                                if (!QLog.isColorLevel()) break block23;
                                QLog.e("TRAE", 2, "BTLooperThread BluetoothHeadset class not found");
                            }
                        }
                        if (this.BluetoothHeadsetClass == null) {
                            return false;
                        }
                        try {
                            this.ListenerClass = Class.forName("android.bluetooth.BluetoothHeadset$ServiceListener");
                        }
                        catch (Exception exception) {
                            if (!QLog.isColorLevel()) break block24;
                            QLog.e("TRAE", 2, "BTLooperThread BluetoothHeadset.ServiceListener class not found:" + exception);
                        }
                    }
                    if (this.ListenerClass == null) {
                        // empty if block
                    }
                    try {
                        this.getCurrentHeadsetMethod = this.BluetoothHeadsetClass.getDeclaredMethod("getCurrentHeadset", new Class[0]);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        if (!QLog.isColorLevel()) break block25;
                        QLog.e("TRAE", 2, "BTLooperThread BluetoothHeadset method getCurrentHeadset NoSuchMethodException");
                    }
                }
                if (this.getCurrentHeadsetMethod == null) {
                    return false;
                }
                try {
                    this.BluetoothHeadsetObj = this.BluetoothHeadsetClass.getConstructor(Context.class, this.ListenerClass).newInstance(context, null);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if (QLog.isColorLevel()) {
                        QLog.e("TRAE", 2, "BTLooperThread BluetoothHeadset getConstructor IllegalArgumentException");
                    }
                }
                catch (InstantiationException instantiationException) {
                    if (QLog.isColorLevel()) {
                        QLog.e("TRAE", 2, "BTLooperThread BluetoothHeadset getConstructor InstantiationException");
                    }
                }
                catch (IllegalAccessException illegalAccessException) {
                    if (QLog.isColorLevel()) {
                        QLog.e("TRAE", 2, "BTLooperThread BluetoothHeadset getConstructor IllegalAccessException");
                    }
                }
                catch (InvocationTargetException invocationTargetException) {
                    if (QLog.isColorLevel()) {
                        QLog.e("TRAE", 2, "BTLooperThread BluetoothHeadset getConstructor InvocationTargetException");
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    if (!QLog.isColorLevel()) break block26;
                    QLog.e("TRAE", 2, "BTLooperThread BluetoothHeadset getConstructor NoSuchMethodException");
                }
            }
            if (this.BluetoothHeadsetObj == null) {
                return false;
            }
            this._devCfg.setVisible(TraeAudioManager.DEVICE_BLUETOOTHHEADSET, this.isConnected());
            if (this.isConnected()) {
                this._devCfg.setVisible(TraeAudioManager.DEVICE_BLUETOOTHHEADSET, true);
                TraeAudioManager.this.checkDevicePlug(TraeAudioManager.DEVICE_BLUETOOTHHEADSET, true);
            } else {
                this._devCfg.setVisible(TraeAudioManager.DEVICE_BLUETOOTHHEADSET, false);
            }
            AudioDeviceInterface.LogTraceExit();
            return true;
        }

        @Override
        public void release() {
            Method method;
            block8: {
                AudioDeviceInterface.LogTraceEntry("");
                method = null;
                if (this.BluetoothHeadsetObj == null) {
                    return;
                }
                try {
                    method = this.BluetoothHeadsetClass.getDeclaredMethod("close", new Class[0]);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    if (!QLog.isColorLevel()) break block8;
                    QLog.e("TRAE", 2, "BTLooperThread _uninitHeadsetfor2x method close NoSuchMethodException");
                }
            }
            if (method == null) {
                return;
            }
            try {
                method.invoke(this.BluetoothHeadsetObj, new Object[0]);
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
            this.BluetoothHeadsetClass = null;
            this.ListenerClass = null;
            this.BluetoothHeadsetObj = null;
            this.getCurrentHeadsetMethod = null;
            AudioDeviceInterface.LogTraceExit();
        }

        @Override
        public boolean isConnected() {
            Object object;
            block8: {
                object = null;
                if (this.getCurrentHeadsetMethod == null || this.getCurrentHeadsetMethod == null) {
                    return false;
                }
                try {
                    object = this.getCurrentHeadsetMethod.invoke(this.BluetoothHeadsetObj, new Object[0]);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if (QLog.isColorLevel()) {
                        QLog.w("TRAE", 2, "BTLooperThread BluetoothHeadset method getCurrentHeadset IllegalArgumentException");
                    }
                }
                catch (IllegalAccessException illegalAccessException) {
                    if (QLog.isColorLevel()) {
                        QLog.w("TRAE", 2, "BTLooperThread BluetoothHeadset method getCurrentHeadset IllegalAccessException");
                    }
                }
                catch (InvocationTargetException invocationTargetException) {
                    if (!QLog.isColorLevel()) break block8;
                    QLog.w("TRAE", 2, "BTLooperThread BluetoothHeadset method getCurrentHeadset InvocationTargetException");
                }
            }
            if (QLog.isColorLevel()) {
                QLog.w("TRAE", 2, "BTLooperThread BluetoothHeadset method getCurrentHeadset res:" + (object != null ? " Y" : "N"));
            }
            return object != null;
        }

        @Override
        void _addAction(IntentFilter intentFilter) {
            if (QLog.isColorLevel()) {
                QLog.w("TRAE", 2, " " + this.interfaceDesc() + " _addAction");
            }
            intentFilter.addAction(ACTION_BLUETOOTHHEADSET_AUDIO_STATE_CHANGED);
            intentFilter.addAction(ACTION_BLUETOOTHHEADSET_STATE_CHANGED);
        }

        @Override
        void _onReceive(Context context, Intent intent) {
            int n2 = -1;
            int n3 = -1;
            int n4 = -1;
            if (ACTION_BLUETOOTHHEADSET_AUDIO_STATE_CHANGED.equals(intent.getAction())) {
                n2 = intent.getIntExtra("android.bluetooth.headset.extra.STATE", -2);
                n3 = intent.getIntExtra("android.bluetooth.headset.extra.PREVIOUS_STATE", -2);
                n4 = intent.getIntExtra("android.bluetooth.headset.extra.AUDIO_STATE", -2);
                if (QLog.isColorLevel()) {
                    QLog.w("TRAE", 2, "++ AUDIO_STATE_CHANGED|  STATE " + n2);
                }
                if (QLog.isColorLevel()) {
                    QLog.w("TRAE", 2, "       PREVIOUS_STATE " + n3);
                }
                if (QLog.isColorLevel()) {
                    QLog.w("TRAE", 2, "       AUDIO_STATE " + n4);
                }
                if (n4 == 2) {
                    this._devCfg.setVisible(TraeAudioManager.DEVICE_BLUETOOTHHEADSET, true);
                } else if (n4 == 0) {
                    this._devCfg.setVisible(TraeAudioManager.DEVICE_BLUETOOTHHEADSET, false);
                }
            } else if (ACTION_BLUETOOTHHEADSET_STATE_CHANGED.equals(intent.getAction())) {
                n2 = intent.getIntExtra("android.bluetooth.headset.extra.STATE", -2);
                n3 = intent.getIntExtra("android.bluetooth.headset.extra.PREVIOUS_STATE", -2);
                n4 = intent.getIntExtra("android.bluetooth.headset.extra.AUDIO_STATE", -2);
                if (QLog.isColorLevel()) {
                    QLog.w("TRAE", 2, "++ STATE_CHANGED|  STATE " + n2);
                }
                if (QLog.isColorLevel()) {
                    QLog.w("TRAE", 2, "       PREVIOUS_STATE " + n3);
                }
                if (QLog.isColorLevel()) {
                    QLog.w("TRAE", 2, "       AUDIO_STATE " + n4);
                }
                if (n4 == 2) {
                    this._devCfg.setVisible(TraeAudioManager.DEVICE_BLUETOOTHHEADSET, true);
                } else if (n4 == 0) {
                    this._devCfg.setVisible(TraeAudioManager.DEVICE_BLUETOOTHHEADSET, false);
                }
            }
        }

        @Override
        public String interfaceDesc() {
            return "BluetoohHeadsetCheckFor2x";
        }
    }

    @TargetApi(value=11)
    class BluetoohHeadsetCheck
    extends BluetoohHeadsetCheckInterface
    implements BluetoothProfile.ServiceListener {
        Context _ctx;
        DeviceConfigManager _devCfg;
        BluetoothAdapter _adapter;
        BluetoothProfile _profile;
        private final ReentrantLock _profileLock;

        BluetoohHeadsetCheck() {
            this._ctx = null;
            this._devCfg = null;
            this._adapter = null;
            this._profile = null;
            this._profileLock = new ReentrantLock();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @TargetApi(value=11)
        public boolean init(Context context, DeviceConfigManager deviceConfigManager) {
            AudioDeviceInterface.LogTraceEntry("");
            if (context == null || deviceConfigManager == null) {
                if (QLog.isColorLevel()) {
                    QLog.e("TRAE", 2, " err ctx==null||_devCfg==null");
                }
                return false;
            }
            this._ctx = context;
            this._devCfg = deviceConfigManager;
            this._adapter = BluetoothAdapter.getDefaultAdapter();
            if (this._adapter == null) {
                if (QLog.isColorLevel()) {
                    QLog.e("TRAE", 2, " err getDefaultAdapter fail!");
                }
                return false;
            }
            this._profileLock.lock();
            try {
                if (this._adapter.isEnabled() && this._profile == null && !this._adapter.getProfileProxy(this._ctx, (BluetoothProfile.ServiceListener)this, 1)) {
                    if (QLog.isColorLevel()) {
                        QLog.e("TRAE", 2, "BluetoohHeadsetCheck: getProfileProxy HEADSET fail!");
                    }
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                this._profileLock.unlock();
            }
            AudioDeviceInterface.LogTraceExit();
            return true;
        }

        @Override
        public void release() {
            AudioDeviceInterface.LogTraceEntry("_profile:" + this._profile);
            this._profileLock.lock();
            try {
                if (this._adapter != null) {
                    if (this._profile != null) {
                        this._adapter.closeProfileProxy(1, this._profile);
                    }
                    this._profile = null;
                }
            }
            catch (Exception exception) {
                if (QLog.isColorLevel()) {
                    QLog.w("TRAE", 2, " closeProfileProxy:e:" + exception.getMessage());
                }
            }
            finally {
                this._profileLock.unlock();
            }
            AudioDeviceInterface.LogTraceExit();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isConnected() {
            boolean bl = false;
            this._profileLock.lock();
            try {
                if (this._profile != null) {
                    List list = this._profile.getConnectedDevices();
                    if (list == null) {
                        boolean bl2 = false;
                        return bl2;
                    }
                    bl = list.size() > 0;
                }
            }
            finally {
                this._profileLock.unlock();
            }
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @TargetApi(value=11)
        public void onServiceConnected(int n2, BluetoothProfile bluetoothProfile) {
            AudioDeviceInterface.LogTraceEntry("_profile:" + this._profile + " profile:" + n2 + " proxy:" + bluetoothProfile);
            if (n2 == 1) {
                Object object;
                block19: {
                    this._profileLock.lock();
                    try {
                        if (this._profile != null && this._profile != bluetoothProfile) {
                            if (QLog.isColorLevel()) {
                                QLog.w("TRAE", 2, "BluetoohHeadsetCheck: HEADSET Connected proxy:" + bluetoothProfile + " _profile:" + this._profile);
                            }
                            this._adapter.closeProfileProxy(1, this._profile);
                            this._profile = null;
                        }
                        this._profile = bluetoothProfile;
                        object = null;
                        if (this._profile != null) {
                            object = this._profile.getConnectedDevices();
                        }
                        if (object == null || this._profile == null) break block19;
                        if (QLog.isColorLevel()) {
                            QLog.w("TRAE", 2, "TRAEBluetoohProxy: HEADSET Connected devs:" + object.size() + " _profile:" + this._profile);
                        }
                        for (int i2 = 0; i2 < object.size(); ++i2) {
                            BluetoothDevice bluetoothDevice = (BluetoothDevice)object.get(i2);
                            int n3 = 0;
                            try {
                                if (this._profile != null) {
                                    n3 = this._profile.getConnectionState(bluetoothDevice);
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            if (n3 == 2) {
                                this._devCfg.setBluetoothName(bluetoothDevice.getName());
                            }
                            if (!QLog.isColorLevel()) continue;
                            QLog.w("TRAE", 2, "   " + i2 + " " + bluetoothDevice.getName() + " ConnectionState:" + n3);
                        }
                    }
                    finally {
                        this._profileLock.unlock();
                    }
                }
                if (this._devCfg != null) {
                    object = null;
                    if (TraeAudioManager.this._deviceConfigManager != null) {
                        object = TraeAudioManager.this._deviceConfigManager.getBluetoothName();
                    }
                    if (TextUtils.isEmpty((CharSequence)object)) {
                        this._devCfg.setVisible(TraeAudioManager.DEVICE_BLUETOOTHHEADSET, false);
                    } else if (this.isConnected()) {
                        this._devCfg.setVisible(TraeAudioManager.DEVICE_BLUETOOTHHEADSET, true);
                        TraeAudioManager.this.checkDevicePlug(TraeAudioManager.DEVICE_BLUETOOTHHEADSET, true);
                    } else {
                        this._devCfg.setVisible(TraeAudioManager.DEVICE_BLUETOOTHHEADSET, false);
                    }
                }
            }
            AudioDeviceInterface.LogTraceExit();
        }

        @TargetApi(value=11)
        public void onServiceDisconnected(int n2) {
            AudioDeviceInterface.LogTraceEntry("_profile:" + this._profile + " profile:" + n2);
            if (n2 == 1) {
                if (QLog.isColorLevel()) {
                    QLog.w("TRAE", 2, "TRAEBluetoohProxy: HEADSET Disconnected");
                }
                if (this.isConnected()) {
                    TraeAudioManager.this.checkDevicePlug(TraeAudioManager.DEVICE_BLUETOOTHHEADSET, false);
                }
                this._profileLock.lock();
                try {
                    if (this._profile != null) {
                        this._adapter.closeProfileProxy(1, this._profile);
                        this._profile = null;
                    }
                }
                finally {
                    this._profileLock.unlock();
                }
            }
            AudioDeviceInterface.LogTraceExit();
        }

        @Override
        void _addAction(IntentFilter intentFilter) {
            if (QLog.isColorLevel()) {
                QLog.w("TRAE", 2, " " + this.interfaceDesc() + " _addAction");
            }
            intentFilter.addAction("android.bluetooth.adapter.action.CONNECTION_STATE_CHANGED");
            intentFilter.addAction("android.media.ACTION_SCO_AUDIO_STATE_UPDATED");
            intentFilter.addAction("android.bluetooth.a2dp.profile.action.CONNECTION_STATE_CHANGED");
        }

        @Override
        void _onReceive(Context context, Intent intent) {
            int n2 = -1;
            int n3 = -1;
            BluetoothDevice bluetoothDevice = null;
            int n4 = -1;
            int n5 = -1;
            if ("android.bluetooth.adapter.action.CONNECTION_STATE_CHANGED".equals(intent.getAction())) {
                n2 = intent.getIntExtra("android.bluetooth.adapter.extra.CONNECTION_STATE", -1);
                n3 = intent.getIntExtra("android.bluetooth.adapter.extra.PREVIOUS_CONNECTION_STATE", -1);
                bluetoothDevice = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                if (QLog.isColorLevel()) {
                    QLog.w("TRAE", 2, "BT ACTION_CONNECTION_STATE_CHANGED|   EXTRA_CONNECTION_STATE " + this.getBTAdapterConnectionState(n2));
                }
                if (QLog.isColorLevel()) {
                    QLog.w("TRAE", 2, "    EXTRA_PREVIOUS_CONNECTION_STATE " + this.getBTAdapterConnectionState(n3));
                }
                if (QLog.isColorLevel()) {
                    QLog.w("TRAE", 2, "    EXTRA_DEVICE " + bluetoothDevice + " " + (bluetoothDevice != null ? bluetoothDevice.getName() : " "));
                }
                if (n2 == 2) {
                    if (QLog.isColorLevel()) {
                        QLog.w("TRAE", 2, "   dev:" + bluetoothDevice.getName() + " connected,start sco...");
                    }
                    this._devCfg.setVisible(TraeAudioManager.DEVICE_BLUETOOTHHEADSET, true);
                    this._devCfg.setBluetoothName(bluetoothDevice != null ? bluetoothDevice.getName() : "unkown");
                } else if (n2 == 0) {
                    this._devCfg.setVisible(TraeAudioManager.DEVICE_BLUETOOTHHEADSET, false);
                }
            } else if ("android.media.ACTION_SCO_AUDIO_STATE_UPDATED".equals(intent.getAction())) {
                n4 = intent.getIntExtra("android.media.extra.SCO_AUDIO_STATE", -1);
                n5 = intent.getIntExtra("android.media.extra.SCO_AUDIO_PREVIOUS_STATE", -1);
                bluetoothDevice = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                if (QLog.isColorLevel()) {
                    QLog.w("TRAE", 2, "BT ACTION_SCO_AUDIO_STATE_UPDATED|   EXTRA_CONNECTION_STATE  dev:" + bluetoothDevice);
                }
                if (QLog.isColorLevel()) {
                    QLog.w("TRAE", 2, "   EXTRA_SCO_AUDIO_STATE " + this.getSCOAudioStateExtraString(n4));
                }
                if (QLog.isColorLevel()) {
                    QLog.w("TRAE", 2, "   EXTRA_SCO_AUDIO_PREVIOUS_STATE " + this.getSCOAudioStateExtraString(n5));
                }
            } else if ("android.bluetooth.a2dp.profile.action.CONNECTION_STATE_CHANGED".equals(intent.getAction())) {
                BluetoothAdapter bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
                switch (bluetoothAdapter.getProfileConnectionState(2)) {
                    case 2: {
                        QLog.w("TRAE", 2, "BluetoothA2dp STATE_CONNECTED");
                        TraeAudioManager.this.IsBluetoothA2dpExisted = true;
                        break;
                    }
                    case 0: {
                        QLog.w("TRAE", 2, "BluetoothA2dp STATE_DISCONNECTED");
                        TraeAudioManager.this.IsBluetoothA2dpExisted = false;
                        break;
                    }
                    default: {
                        QLog.w("TRAE", 2, "BluetoothA2dp" + bluetoothAdapter.getProfileConnectionState(2));
                    }
                }
            }
        }

        @Override
        public String interfaceDesc() {
            return "BluetoohHeadsetCheck";
        }
    }

    class BluetoohHeadsetCheckFake
    extends BluetoohHeadsetCheckInterface {
        BluetoohHeadsetCheckFake() {
        }

        @Override
        public boolean init(Context context, DeviceConfigManager deviceConfigManager) {
            return true;
        }

        @Override
        public void release() {
        }

        @Override
        public boolean isConnected() {
            return false;
        }

        @Override
        void _addAction(IntentFilter intentFilter) {
        }

        @Override
        void _onReceive(Context context, Intent intent) {
        }

        @Override
        public String interfaceDesc() {
            return "BluetoohHeadsetCheckFake";
        }
    }

    abstract class BluetoohHeadsetCheckInterface {
        BluetoohHeadsetCheckInterface() {
        }

        public abstract String interfaceDesc();

        public abstract boolean init(Context var1, DeviceConfigManager var2);

        public abstract void release();

        public abstract boolean isConnected();

        public void addAction(IntentFilter intentFilter) {
            intentFilter.addAction("android.bluetooth.adapter.action.STATE_CHANGED");
            intentFilter.addAction("android.bluetooth.device.action.ACL_CONNECTED");
            intentFilter.addAction("android.bluetooth.device.action.ACL_DISCONNECTED");
            this._addAction(intentFilter);
        }

        abstract void _addAction(IntentFilter var1);

        abstract void _onReceive(Context var1, Intent var2);

        public void onReceive(Context context, Intent intent, DeviceConfigManager deviceConfigManager) {
            if ("android.bluetooth.adapter.action.STATE_CHANGED".equals(intent.getAction())) {
                int n2 = intent.getIntExtra("android.bluetooth.adapter.extra.STATE", -1);
                int n3 = intent.getIntExtra("android.bluetooth.adapter.extra.PREVIOUS_STATE", -1);
                if (QLog.isColorLevel()) {
                    QLog.w("TRAE", 2, "BT ACTION_STATE_CHANGED|   EXTRA_STATE " + this.getBTActionStateChangedExtraString(n2));
                }
                if (QLog.isColorLevel()) {
                    QLog.w("TRAE", 2, "BT ACTION_STATE_CHANGED|   EXTRA_PREVIOUS_STATE " + this.getBTActionStateChangedExtraString(n3));
                }
                if (n2 == 10) {
                    if (QLog.isColorLevel()) {
                        QLog.w("TRAE", 2, "    BT off");
                    }
                    deviceConfigManager.setVisible(TraeAudioManager.DEVICE_BLUETOOTHHEADSET, false);
                } else if (n2 == 12 && QLog.isColorLevel()) {
                    QLog.w("TRAE", 2, "BT OFF-->ON,Visiable it...");
                }
            } else if (!("android.bluetooth.device.action.ACL_CONNECTED".equals(intent.getAction()) && Build.VERSION.SDK_INT < 11 || "android.bluetooth.device.action.ACL_DISCONNECTED".equals(intent.getAction()) && Build.VERSION.SDK_INT < 11)) {
                this._onReceive(context, intent);
            }
        }

        String getBTActionStateChangedExtraString(int n2) {
            String string;
            switch (n2) {
                case 10: {
                    string = "STATE_OFF";
                    break;
                }
                case 11: {
                    string = "STATE_TURNING_ON";
                    break;
                }
                case 12: {
                    string = "STATE_ON";
                    break;
                }
                case 13: {
                    string = "STATE_TURNING_OFF";
                    break;
                }
                default: {
                    string = "unknow";
                }
            }
            return string + ":" + n2;
        }

        String getSCOAudioStateExtraString(int n2) {
            String string;
            switch (n2) {
                case 0: {
                    string = "SCO_AUDIO_STATE_DISCONNECTED";
                    break;
                }
                case 1: {
                    string = "SCO_AUDIO_STATE_CONNECTED";
                    break;
                }
                case 2: {
                    string = "SCO_AUDIO_STATE_CONNECTING";
                    break;
                }
                case -1: {
                    string = "SCO_AUDIO_STATE_ERROR";
                    break;
                }
                default: {
                    string = "unknow";
                }
            }
            return string + ":" + n2;
        }

        String getBTAdapterConnectionState(int n2) {
            String string;
            switch (n2) {
                case 0: {
                    string = "STATE_DISCONNECTED";
                    break;
                }
                case 1: {
                    string = "STATE_CONNECTING";
                    break;
                }
                case 2: {
                    string = "STATE_CONNECTED";
                    break;
                }
                case 3: {
                    string = "STATE_DISCONNECTING";
                    break;
                }
                default: {
                    string = "unknow";
                }
            }
            return string + ":" + n2;
        }

        String getBTHeadsetConnectionState(int n2) {
            String string;
            switch (n2) {
                case 0: {
                    string = "STATE_DISCONNECTED";
                    break;
                }
                case 1: {
                    string = "STATE_CONNECTING";
                    break;
                }
                case 2: {
                    string = "STATE_CONNECTED";
                    break;
                }
                case 3: {
                    string = "STATE_DISCONNECTING";
                    break;
                }
                default: {
                    string = "unknow";
                }
            }
            return string + ":" + n2;
        }

        String getBTHeadsetAudioState(int n2) {
            String string;
            switch (n2) {
                case 12: {
                    string = "STATE_AUDIO_CONNECTED";
                    break;
                }
                case 10: {
                    string = "STATE_AUDIO_DISCONNECTED";
                    break;
                }
                default: {
                    string = "unknow:" + n2;
                }
            }
            return string + ":" + n2;
        }
    }

    class bluetoothHeadsetSwitchThread
    extends switchThread {
        bluetoothHeadsetSwitchThread() {
        }

        @Override
        public void _run() {
            if (IsMusicScene || !IsUpdateSceneFlag) {
                if (QLog.isColorLevel()) {
                    QLog.w("TRAE", 2, "connect bluetoothHeadset: do nothing, IsMusicScene:" + IsMusicScene + " ,IsUpdateSceneFlag:" + IsUpdateSceneFlag);
                }
                this.updateStatus();
                return;
            }
            if (!enableDeviceSwitchFlag) {
                if (QLog.isColorLevel()) {
                    QLog.w("TRAE", 2, "connect bluetoothHeadset: disableDeviceSwitchFlag");
                }
                return;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            boolean bl = false;
            if (!bl) {
                this._startBluetoothSco();
            }
            int n2 = 0;
            while (this._running && n2++ < 10 && !bl) {
                if (QLog.isColorLevel()) {
                    QLog.w("TRAE", 2, "bluetoothHeadsetSwitchThread i:" + n2 + " sco:" + (TraeAudioManager.this._am.isBluetoothScoOn() ? "Y" : "N") + " :" + TraeAudioManager.this._deviceConfigManager.getBluetoothName());
                }
                if (TraeAudioManager.this._am.isBluetoothScoOn()) {
                    this.updateStatus();
                    break;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (!TraeAudioManager.this._am.isBluetoothScoOn()) {
                if (QLog.isColorLevel() && !bl) {
                    QLog.e("TRAE", 2, "bluetoothHeadsetSwitchThread sco fail,remove btheadset");
                }
                TraeAudioManager.this._deviceConfigManager.setVisible(this.getDeviceName(), false);
                this.processDeviceConnectRes(10);
                TraeAudioManager.this.checkAutoDeviceListUpdate();
            }
        }

        @Override
        public String getDeviceName() {
            return TraeAudioManager.DEVICE_BLUETOOTHHEADSET;
        }

        @Override
        @TargetApi(value=8)
        public void _quit() {
            if (TraeAudioManager.this._am == null) {
                return;
            }
            this._stopBluetoothSco();
        }

        @TargetApi(value=8)
        void _startBluetoothSco() {
            TraeAudioManager.this._am.setBluetoothScoOn(true);
            if (Build.VERSION.SDK_INT > 8) {
                TraeAudioManager.this._am.startBluetoothSco();
            }
        }

        @TargetApi(value=8)
        void _stopBluetoothSco() {
            if (Build.VERSION.SDK_INT > 8) {
                TraeAudioManager.this._am.stopBluetoothSco();
            }
            TraeAudioManager.this._am.setBluetoothScoOn(false);
        }
    }

    class headsetSwitchThread
    extends switchThread {
        headsetSwitchThread() {
        }

        @Override
        public void _run() {
            int n2 = 0;
            if (!IsMusicScene && IsUpdateSceneFlag && enableDeviceSwitchFlag) {
                TraeAudioManager.this.InternalSetSpeaker(TraeAudioManager.this._context, false);
                TraeAudioManager.this._am.setWiredHeadsetOn(true);
            }
            this.updateStatus();
            if (IsMusicScene || !IsUpdateSceneFlag) {
                if (QLog.isColorLevel()) {
                    QLog.w("TRAE", 2, "connect headset: do nothing");
                }
                return;
            }
            if (!enableDeviceSwitchFlag) {
                if (QLog.isColorLevel()) {
                    QLog.w("TRAE", 2, "connect headset: disableDeviceSwitchFlag");
                }
                return;
            }
            while (this._running) {
                if (TraeAudioManager.this._am.isSpeakerphoneOn()) {
                    TraeAudioManager.this.InternalSetSpeaker(TraeAudioManager.this._context, false);
                }
                try {
                    Thread.sleep(n2 < 5 ? 1000L : 4000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++n2;
            }
        }

        @Override
        public String getDeviceName() {
            return TraeAudioManager.DEVICE_WIREDHEADSET;
        }

        @Override
        public void _quit() {
        }
    }

    class speakerSwitchThread
    extends switchThread {
        speakerSwitchThread() {
        }

        @Override
        public void _run() {
            int n2 = 0;
            if (!IsMusicScene && IsUpdateSceneFlag && enableDeviceSwitchFlag) {
                TraeAudioManager.this.InternalSetSpeaker(TraeAudioManager.this._context, true);
            }
            this.updateStatus();
            if (IsMusicScene || !IsUpdateSceneFlag) {
                if (QLog.isColorLevel()) {
                    QLog.w("TRAE", 2, "connect speakerPhone: do nothing");
                }
                return;
            }
            if (!enableDeviceSwitchFlag) {
                if (QLog.isColorLevel()) {
                    QLog.w("TRAE", 2, "connect speakerPhone: disableDeviceSwitchFlag");
                }
                return;
            }
            if (QLog.isColorLevel()) {
                QLog.w("TRAE", 2, " _run:" + this.getDeviceName() + " _running:" + this._running);
            }
            while (this._running) {
                if (!TraeAudioManager.this._am.isSpeakerphoneOn()) {
                    TraeAudioManager.this.InternalSetSpeaker(TraeAudioManager.this._context, true);
                }
                try {
                    Thread.sleep(n2 < 5 ? 1000L : 4000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++n2;
            }
        }

        @Override
        public String getDeviceName() {
            return TraeAudioManager.DEVICE_SPEAKERPHONE;
        }

        @Override
        public void _quit() {
        }
    }

    class earphoneSwitchThread
    extends switchThread {
        earphoneSwitchThread() {
        }

        @Override
        public void _run() {
            int n2 = 0;
            if (IsUpdateSceneFlag && enableDeviceSwitchFlag) {
                TraeAudioManager.this.InternalSetSpeaker(TraeAudioManager.this._context, false);
            }
            this.updateStatus();
            if (!IsUpdateSceneFlag) {
                if (QLog.isColorLevel()) {
                    QLog.w("TRAE", 2, "connect earphone: do nothing");
                }
                return;
            }
            if (!enableDeviceSwitchFlag) {
                if (QLog.isColorLevel()) {
                    QLog.w("TRAE", 2, "connect earphone: disableDeviceSwitchFlag");
                }
                return;
            }
            while (this._running) {
                if (TraeAudioManager.this._am.isSpeakerphoneOn()) {
                    TraeAudioManager.this.InternalSetSpeaker(TraeAudioManager.this._context, false);
                }
                try {
                    Thread.sleep(n2 < 5 ? 1000L : 4000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++n2;
            }
        }

        @Override
        public String getDeviceName() {
            return TraeAudioManager.DEVICE_EARPHONE;
        }

        @Override
        public void _quit() {
        }
    }

    abstract class switchThread
    extends Thread {
        boolean _running = true;
        boolean[] _exited = new boolean[]{false};
        HashMap<String, Object> _params = null;
        long _usingtime = 0L;

        switchThread() {
            if (QLog.isColorLevel()) {
                QLog.w("TRAE", 2, " ++switchThread:" + this.getDeviceName());
            }
        }

        public void setDeviceConnectParam(HashMap<String, Object> hashMap) {
            this._params = hashMap;
        }

        void updateStatus() {
            TraeAudioManager.this._deviceConfigManager.setConnected(this.getDeviceName());
            this.processDeviceConnectRes(0);
        }

        void processDeviceConnectRes(int n2) {
            TraeAudioManager.this.InternalNotifyDeviceChangableUpdate();
            AudioDeviceInterface.LogTraceEntry(this.getDeviceName() + " err:" + n2);
            if (this._params == null) {
                TraeAudioManager.this.InternalNotifyDeviceListUpdate();
                return;
            }
            TraeAudioManager.this.sessionConnectedDev = TraeAudioManager.this._deviceConfigManager.getConnectedDevice();
            Long l2 = (Long)this._params.get(TraeAudioManager.PARAM_SESSIONID);
            if (QLog.isColorLevel()) {
                QLog.w("TRAE", 2, " sessonID:" + l2);
            }
            if (l2 == null || l2 == Long.MIN_VALUE) {
                TraeAudioManager.this.InternalNotifyDeviceListUpdate();
                if (QLog.isColorLevel()) {
                    QLog.w("TRAE", 2, "processDeviceConnectRes sid null,don't send res");
                }
                return;
            }
            Intent intent = new Intent();
            intent.putExtra(TraeAudioManager.CONNECTDEVICE_RESULT_DEVICENAME, (String)this._params.get(TraeAudioManager.PARAM_DEVICE));
            if (TraeAudioManager.this.sendResBroadcast(intent, this._params, n2) == 0) {
                TraeAudioManager.this.InternalNotifyDeviceListUpdate();
            }
            AudioDeviceInterface.LogTraceExit();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            AudioDeviceInterface.LogTraceEntry(this.getDeviceName());
            TraeAudioManager.this._deviceConfigManager.setConnecting(this.getDeviceName());
            TraeAudioManager.this.InternalNotifyDeviceChangableUpdate();
            this._run();
            boolean[] blArray = this._exited;
            synchronized (this._exited) {
                this._exited[0] = true;
                this._exited.notifyAll();
                // ** MonitorExit[var1_1] (shouldn't be in output)
                AudioDeviceInterface.LogTraceExit();
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void quit() {
            AudioDeviceInterface.LogTraceEntry(this.getDeviceName());
            this._running = false;
            if (QLog.isColorLevel()) {
                QLog.w("TRAE", 2, " quit:" + this.getDeviceName() + " _running:" + this._running);
            }
            this.interrupt();
            this._quit();
            boolean[] blArray = this._exited;
            synchronized (this._exited) {
                if (!this._exited[0]) {
                    try {
                        this._exited.wait(10000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                AudioDeviceInterface.LogTraceExit();
                return;
            }
        }

        public abstract String getDeviceName();

        public abstract void _run();

        public abstract void _quit();
    }

    class TraeAudioManagerLooper
    extends Thread {
        public static final int MESSAGE_BEGIN = 32768;
        public static final int MESSAGE_ENABLE = 32772;
        public static final int MESSAGE_DISABLE = 32773;
        public static final int MESSAGE_GETDEVICELIST = 32774;
        public static final int MESSAGE_CONNECTDEVICE = 32775;
        public static final int MESSAGE_EARACTION = 32776;
        public static final int MESSAGE_ISDEVICECHANGABLED = 32777;
        public static final int MESSAGE_GETCONNECTEDDEVICE = 32778;
        public static final int MESSAGE_GETCONNECTINGDEVICE = 32779;
        public static final int MESSAGE_VOICECALLPREPROCESS = 32780;
        public static final int MESSAGE_VOICECALLPOSTPROCESS = 32781;
        public static final int MESSAGE_STARTRING = 32782;
        public static final int MESSAGE_STOPRING = 32783;
        public static final int MESSAGE_GETSTREAMTYPE = 32784;
        public static final int MESSAGE_AUTO_DEVICELIST_UPDATE = 32785;
        public static final int MESSAGE_AUTO_DEVICELIST_PLUGIN_UPDATE = 32786;
        public static final int MESSAGE_AUTO_DEVICELIST_PLUGOUT_UPDATE = 32787;
        public static final int MESSAGE_VOICECALL_AUIDOPARAM_CHANGED = 32788;
        public static final int MESSAGE_CONNECT_HIGHEST_PRIORITY_DEVICE = 32789;
        public static final int MESSAGE_REQUEST_RELEASE_AUDIO_FOCUS = 32790;
        public static final int MESSAGE_RECOVER_AUDIO_FOCUS = 32791;
        Handler mMsgHandler = null;
        TraeMediaPlayer _ringPlayer = null;
        long _ringSessionID = -1L;
        String _ringOperation = "";
        String _ringUserdata = "";
        final boolean[] _started = new boolean[]{false};
        boolean _enabled = false;
        TraeAudioManager _parent = null;
        String _lastCfg = "";
        int _preServiceMode = 0;
        int _preRingMode = 0;
        long _voiceCallSessionID = -1L;
        String _voiceCallOperation = "";
        AudioManager.OnAudioFocusChangeListener mAudioFocusChangeListener = null;
        int _focusSteamType = 0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TraeAudioManagerLooper(TraeAudioManager traeAudioManager2) {
            this._parent = traeAudioManager2;
            long l2 = SystemClock.elapsedRealtime();
            if (QLog.isColorLevel()) {
                QLog.e("TRAE", 2, "TraeAudioManagerLooper start...");
            }
            this.start();
            boolean[] blArray = this._started;
            synchronized (this._started) {
                if (!this._started[0]) {
                    try {
                        this._started.wait(3000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                // ** MonitorExit[var5_4] (shouldn't be in output)
                if (QLog.isColorLevel()) {
                    QLog.e("TRAE", 2, "  start used:" + (SystemClock.elapsedRealtime() - l2) + "ms");
                }
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void quit() {
            AudioDeviceInterface.LogTraceEntry("");
            if (null == this.mMsgHandler) {
                return;
            }
            long l2 = SystemClock.elapsedRealtime();
            this.mMsgHandler.getLooper().quit();
            boolean[] blArray = this._started;
            synchronized (this._started) {
                if (this._started[0]) {
                    try {
                        this._started.wait(10000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                // ** MonitorExit[var3_2] (shouldn't be in output)
                if (QLog.isColorLevel()) {
                    QLog.e("TRAE", 2, "  quit used:" + (SystemClock.elapsedRealtime() - l2) + "ms");
                }
                this.mMsgHandler = null;
                AudioDeviceInterface.LogTraceExit();
                return;
            }
        }

        public int sendMessage(int n2, HashMap<String, Object> hashMap) {
            if (null == this.mMsgHandler) {
                AudioDeviceInterface.LogTraceEntry(" fail mMsgHandler==null _enabled:" + (this._enabled ? "Y" : "N") + " activeMode:" + TraeAudioManager.this._activeMode + " msg:" + n2);
                return -1;
            }
            Message message = Message.obtain((Handler)this.mMsgHandler, (int)n2, hashMap);
            return this.mMsgHandler.sendMessage(message) ? 0 : -1;
        }

        void startService(HashMap<String, Object> hashMap) {
            String string = (String)hashMap.get(TraeAudioManager.EXTRA_DATA_DEVICECONFIG);
            Log.w((String)"TRAE", (String)("startService cfg:" + string));
            AudioDeviceInterface.LogTraceEntry(" _enabled:" + (this._enabled ? "Y" : "N") + " activeMode:" + TraeAudioManager.this._activeMode + " cfg:" + string);
            if (TraeAudioManager.this._context == null) {
                return;
            }
            QLog.w("TRAE", 2, "   startService:" + string);
            if (this._enabled && this._lastCfg.equals(string) || TraeAudioManager.this._activeMode != 0) {
                return;
            }
            if (this._enabled) {
                this.stopService();
            }
            this._prev_startService();
            AudioManager audioManager = (AudioManager)TraeAudioManager.this._context.getSystemService("audio");
            TraeAudioManager.this._deviceConfigManager.clearConfig();
            TraeAudioManager.this._deviceConfigManager.init(string);
            this._lastCfg = string;
            if (TraeAudioManager.this._am != null) {
                this._preServiceMode = TraeAudioManager.this._am.getMode();
            }
            this._enabled = true;
            if (this._ringPlayer == null) {
                this._ringPlayer = new TraeMediaPlayer(TraeAudioManager.this._context, new TraeMediaPlayer.OnCompletionListener(){

                    @Override
                    public void onCompletion() {
                        if (QLog.isColorLevel()) {
                            QLog.w("TRAE", 2, "_ringPlayer onCompletion _activeMode:" + TraeAudioManager.this._activeMode + " _preRingMode:" + TraeAudioManagerLooper.this._preRingMode);
                        }
                        HashMap<String, Object> hashMap = new HashMap<String, Object>();
                        hashMap.put(TraeAudioManager.PARAM_ISHOSTSIDE, true);
                        TraeAudioManagerLooper.this.sendMessage(32783, hashMap);
                        TraeAudioManagerLooper.this.notifyRingCompletion();
                    }
                });
            }
            this.notifyServiceState(this._enabled);
            TraeAudioManager.this.updateDeviceStatus();
            AudioDeviceInterface.LogTraceExit();
        }

        boolean isNeedForceVolumeType() {
            if (Build.MANUFACTURER.equals("Xiaomi")) {
                if (Build.MODEL.equals("MI 5")) {
                    return true;
                }
                if (Build.MODEL.equals("MI 5s")) {
                    return true;
                }
                if (Build.MODEL.equals("MI 5s Plus")) {
                    return true;
                }
            }
            return false;
        }

        void stopService() {
            AudioDeviceInterface.LogTraceEntry(" _enabled:" + (this._enabled ? "Y" : "N") + " activeMode:" + TraeAudioManager.this._activeMode);
            if (!this._enabled) {
                return;
            }
            if (TraeAudioManager.this._activeMode == 1) {
                this.interruptVoicecallPostprocess();
            } else if (TraeAudioManager.this._activeMode == 2) {
                this.interruptRing();
            }
            if (TraeAudioManager.this._switchThread != null) {
                if (QLog.isColorLevel()) {
                    QLog.w("TRAE", 2, "_switchThread:" + TraeAudioManager.this._switchThread.getDeviceName());
                }
                TraeAudioManager.this._switchThread.quit();
                TraeAudioManager.this._switchThread = null;
            }
            if (this._ringPlayer != null) {
                this._ringPlayer.stopRing();
            }
            this._ringPlayer = null;
            this._enabled = false;
            this.notifyServiceState(this._enabled);
            if (TraeAudioManager.this._am != null && TraeAudioManager.this._context != null) {
                try {
                    TraeAudioManager.this.InternalSetMode(0);
                    if (this.isNeedForceVolumeType()) {
                        QLog.w("TRAE", 2, "NeedForceVolumeType: AudioManager.STREAM_MUSIC");
                        TraeAudioManager.forceVolumeControlStream(TraeAudioManager.this._am, 3);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this._post_stopService();
            AudioDeviceInterface.LogTraceExit();
        }

        int notifyServiceState(boolean bl) {
            if (null == TraeAudioManager.this._context) {
                return -1;
            }
            Intent intent = new Intent();
            intent.setAction(TraeAudioManager.ACTION_TRAEAUDIOMANAGER_NOTIFY);
            intent.putExtra(TraeAudioManager.PARAM_OPERATION, TraeAudioManager.NOTIFY_SERVICE_STATE);
            intent.putExtra(TraeAudioManager.NOTIFY_SERVICE_STATE_DATE, bl);
            if (TraeAudioManager.this._context != null) {
                TraeAudioManager.this._context.sendBroadcast(intent);
            }
            return 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            AudioDeviceInterface.LogTraceEntry("");
            Looper.prepare();
            this.mMsgHandler = new Handler(){

                public void handleMessage(Message message) {
                    String string = null;
                    String string2 = null;
                    String string3 = null;
                    boolean bl = true;
                    HashMap hashMap = null;
                    try {
                        hashMap = (HashMap)message.obj;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (QLog.isColorLevel()) {
                        QLog.w("TRAE", 2, "TraeAudioManagerLooper msg:" + message.what + " _enabled:" + (TraeAudioManagerLooper.this._enabled ? "Y" : "N"));
                    }
                    if (message.what == 32772) {
                        TraeAudioManagerLooper.this.startService(hashMap);
                    } else if (!TraeAudioManagerLooper.this._enabled) {
                        if (QLog.isColorLevel()) {
                            QLog.w("TRAE", 2, "******* disabled ,skip msg******");
                        }
                        Intent intent = new Intent();
                        TraeAudioManager.this.sendResBroadcast(intent, hashMap, 1);
                    } else {
                        switch (message.what) {
                            case 32773: {
                                TraeAudioManagerLooper.this.stopService();
                                break;
                            }
                            case 32774: {
                                TraeAudioManagerLooper.this.InternalSessionGetDeviceList(hashMap);
                                break;
                            }
                            case 32777: {
                                TraeAudioManager.this.InternalSessionIsDeviceChangabled(hashMap);
                                break;
                            }
                            case 32778: {
                                TraeAudioManager.this.InternalSessionGetConnectedDevice(hashMap);
                                break;
                            }
                            case 32779: {
                                TraeAudioManager.this.InternalSessionGetConnectingDevice(hashMap);
                                break;
                            }
                            case 32780: {
                                TraeAudioManagerLooper.this.InternalVoicecallPreprocess(hashMap);
                                break;
                            }
                            case 32781: {
                                TraeAudioManagerLooper.this.InternalVoicecallPostprocess(hashMap);
                                break;
                            }
                            case 32788: {
                                Integer n2 = (Integer)hashMap.get(TraeAudioManager.PARAM_STREAMTYPE);
                                if (n2 == null) {
                                    if (!QLog.isColorLevel()) break;
                                    QLog.e("TRAE", 2, " MESSAGE_VOICECALL_AUIDOPARAM_CHANGED params.get(PARAM_STREAMTYPE)==null!!");
                                    break;
                                }
                                TraeAudioManager.this._streamType = n2;
                                TraeAudioManagerLooper.this.InternalNotifyStreamTypeUpdate(n2);
                                break;
                            }
                            case 32782: {
                                TraeAudioManagerLooper.this.InternalStartRing(hashMap);
                                break;
                            }
                            case 32783: {
                                TraeAudioManagerLooper.this.InternalStopRing(hashMap);
                                break;
                            }
                            case 32790: {
                                TraeAudioManagerLooper.this.abandonAudioFocus();
                                break;
                            }
                            case 32791: {
                                TraeAudioManagerLooper.this.requestAudioFocus(TraeAudioManager.this._streamType);
                                break;
                            }
                            case 32784: {
                                TraeAudioManagerLooper.this.InternalGetStreamType(hashMap);
                                break;
                            }
                            case 32775: {
                                TraeAudioManager.this.InternalSessionConnectDevice(hashMap);
                                break;
                            }
                            case 32776: {
                                TraeAudioManager.this.InternalSessionEarAction(hashMap);
                                break;
                            }
                            case 32785: 
                            case 32789: {
                                string = TraeAudioManager.this._deviceConfigManager.getAvailabledHighestPriorityDevice();
                                string2 = TraeAudioManager.this._deviceConfigManager.getConnectedDevice();
                                if (QLog.isColorLevel()) {
                                    QLog.w("TRAE", 2, "MESSAGE_AUTO_DEVICELIST_UPDATE  connectedDev:" + string2 + " highestDev" + string);
                                }
                                if (IsUpdateSceneFlag && bl) {
                                    bl = false;
                                    if (IsMusicScene && !TraeAudioManager.this.IsBluetoothA2dpExisted) {
                                        TraeAudioManager.this.InternalConnectDevice(TraeAudioManager.this._deviceConfigManager.getAvailabledHighestPriorityDevice(TraeAudioManager.DEVICE_BLUETOOTHHEADSET), null, true);
                                        break;
                                    }
                                    TraeAudioManager.this.InternalConnectDevice(string, null, true);
                                    break;
                                }
                                if (!string.equals(string2)) {
                                    TraeAudioManager.this.InternalConnectDevice(string, null, false);
                                    break;
                                }
                                TraeAudioManager.this.InternalNotifyDeviceListUpdate();
                                break;
                            }
                            case 32786: {
                                string3 = (String)hashMap.get(TraeAudioManager.PARAM_DEVICE);
                                if (TraeAudioManager.this.InternalConnectDevice(string3, null, false) == 0) break;
                                if (QLog.isColorLevel()) {
                                    QLog.w("TRAE", 2, " plugin dev:" + string3 + " sessionConnectedDev:" + TraeAudioManager.this.sessionConnectedDev + " connected fail,auto switch!");
                                }
                                TraeAudioManager.this.InternalConnectDevice(TraeAudioManager.this._deviceConfigManager.getAvailabledHighestPriorityDevice(), null, false);
                                break;
                            }
                            case 32787: {
                                if (TraeAudioManager.this.InternalConnectDevice(TraeAudioManager.this.sessionConnectedDev, null, false) == 0) break;
                                string3 = (String)hashMap.get(TraeAudioManager.PARAM_DEVICE);
                                if (QLog.isColorLevel()) {
                                    QLog.w("TRAE", 2, " plugout dev:" + string3 + " sessionConnectedDev:" + TraeAudioManager.this.sessionConnectedDev + " connected fail,auto switch!");
                                }
                                TraeAudioManager.this.InternalConnectDevice(TraeAudioManager.this._deviceConfigManager.getAvailabledHighestPriorityDevice(), null, false);
                                break;
                            }
                        }
                    }
                }
            };
            this._init();
            boolean[] blArray = this._started;
            synchronized (this._started) {
                this._started[0] = true;
                this._started.notifyAll();
                // ** MonitorExit[var1_1] (shouldn't be in output)
                Looper.loop();
                this._uninit();
                blArray = this._started;
                synchronized (this._started) {
                    this._started[0] = false;
                    this._started.notifyAll();
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    AudioDeviceInterface.LogTraceExit();
                    return;
                }
            }
        }

        void _init() {
            block2: {
                AudioDeviceInterface.LogTraceEntry("");
                try {
                    TraeAudioManager.this._audioSessionHost = new TraeAudioSessionHost();
                    TraeAudioManager.this._deviceConfigManager = new DeviceConfigManager();
                    _gHostProcessId = Process.myPid();
                    TraeAudioManager.this._am = (AudioManager)TraeAudioManager.this._context.getSystemService("audio");
                    TraeAudioManager.this._bluetoothCheck = TraeAudioManager.this.CreateBluetoothCheck(TraeAudioManager.this._context, TraeAudioManager.this._deviceConfigManager);
                    IntentFilter intentFilter = new IntentFilter();
                    intentFilter.addAction("android.intent.action.HEADSET_PLUG");
                    intentFilter.addAction("android.media.AUDIO_BECOMING_NOISY");
                    TraeAudioManager.this._bluetoothCheck.addAction(intentFilter);
                    intentFilter.addAction(TraeAudioManager.ACTION_TRAEAUDIOMANAGER_REQUEST);
                    TraeAudioManager.this._context.registerReceiver((BroadcastReceiver)this._parent, intentFilter);
                }
                catch (Exception exception) {
                    if (!QLog.isColorLevel()) break block2;
                    QLog.w("TRAE", 2, "======7");
                }
            }
            AudioDeviceInterface.LogTraceExit();
        }

        void _prev_startService() {
            try {
                TraeAudioManager.this._am = (AudioManager)TraeAudioManager.this._context.getSystemService("audio");
                if (TraeAudioManager.this._bluetoothCheck == null) {
                    TraeAudioManager.this._bluetoothCheck = TraeAudioManager.this.CreateBluetoothCheck(TraeAudioManager.this._context, TraeAudioManager.this._deviceConfigManager);
                }
                TraeAudioManager.this._context.unregisterReceiver((BroadcastReceiver)this._parent);
                IntentFilter intentFilter = new IntentFilter();
                intentFilter.addAction("android.intent.action.HEADSET_PLUG");
                intentFilter.addAction("android.media.AUDIO_BECOMING_NOISY");
                TraeAudioManager.this._bluetoothCheck.addAction(intentFilter);
                intentFilter.addAction(TraeAudioManager.ACTION_TRAEAUDIOMANAGER_REQUEST);
                TraeAudioManager.this._context.registerReceiver((BroadcastReceiver)this._parent, intentFilter);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        void _post_stopService() {
            try {
                if (TraeAudioManager.this._bluetoothCheck != null) {
                    TraeAudioManager.this._bluetoothCheck.release();
                }
                TraeAudioManager.this._bluetoothCheck = null;
                if (TraeAudioManager.this._context != null) {
                    TraeAudioManager.this._context.unregisterReceiver((BroadcastReceiver)this._parent);
                    IntentFilter intentFilter = new IntentFilter();
                    intentFilter.addAction(TraeAudioManager.ACTION_TRAEAUDIOMANAGER_REQUEST);
                    TraeAudioManager.this._context.registerReceiver((BroadcastReceiver)this._parent, intentFilter);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        void _uninit() {
            AudioDeviceInterface.LogTraceEntry("");
            try {
                this.stopService();
                if (TraeAudioManager.this._bluetoothCheck != null) {
                    TraeAudioManager.this._bluetoothCheck.release();
                }
                TraeAudioManager.this._bluetoothCheck = null;
                if (null != TraeAudioManager.this._context) {
                    TraeAudioManager.this._context.unregisterReceiver((BroadcastReceiver)this._parent);
                    TraeAudioManager.this._context = null;
                }
                if (TraeAudioManager.this._deviceConfigManager != null) {
                    TraeAudioManager.this._deviceConfigManager.clearConfig();
                }
                TraeAudioManager.this._deviceConfigManager = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
            AudioDeviceInterface.LogTraceExit();
        }

        int InternalSessionGetDeviceList(HashMap<String, Object> hashMap) {
            Intent intent = new Intent();
            HashMap<String, Object> hashMap2 = TraeAudioManager.this._deviceConfigManager.getSnapParams();
            ArrayList arrayList = (ArrayList)hashMap2.get(TraeAudioManager.EXTRA_DATA_AVAILABLEDEVICE_LIST);
            String string = (String)hashMap2.get(TraeAudioManager.EXTRA_DATA_CONNECTEDDEVICE);
            String string2 = (String)hashMap2.get(TraeAudioManager.EXTRA_DATA_PREV_CONNECTEDDEVICE);
            intent.putExtra(TraeAudioManager.EXTRA_DATA_AVAILABLEDEVICE_LIST, arrayList.toArray(new String[0]));
            intent.putExtra(TraeAudioManager.EXTRA_DATA_CONNECTEDDEVICE, string);
            intent.putExtra(TraeAudioManager.EXTRA_DATA_PREV_CONNECTEDDEVICE, string2);
            intent.putExtra(TraeAudioManager.EXTRA_DATA_IF_HAS_BLUETOOTH_THIS_IS_NAME, TraeAudioManager.this._deviceConfigManager.getBluetoothName());
            TraeAudioManager.this.sendResBroadcast(intent, hashMap, 0);
            return 0;
        }

        @TargetApi(value=8)
        void requestAudioFocus(int n2) {
            block7: {
                if (Build.VERSION.SDK_INT <= 8) {
                    return;
                }
                if (this.mAudioFocusChangeListener == null) {
                    this.mAudioFocusChangeListener = new AudioManager.OnAudioFocusChangeListener(){

                        @TargetApi(value=8)
                        public void onAudioFocusChange(int n2) {
                            if (QLog.isColorLevel()) {
                                QLog.w("TRAE", 2, "focusChange:" + n2 + " _focusSteamType:" + TraeAudioManagerLooper.this._focusSteamType + " currMode:" + TraeAudioManager.this._am.getMode() + " _activeMode:" + TraeAudioManager.this._activeMode);
                            }
                            if (n2 == -1 || n2 == -2 || n2 == -3 || n2 == 1) {
                                // empty if block
                            }
                        }
                    };
                    if (TraeAudioManager.this._am != null) {
                        try {
                            int n3 = TraeAudioManager.this._am.requestAudioFocus(this.mAudioFocusChangeListener, n2, 1);
                            if (n3 != 1 && QLog.isColorLevel()) {
                                QLog.e("TRAE", 2, "request audio focus fail. " + n3 + " mode:" + TraeAudioManager.this._am.getMode());
                            }
                            this._focusSteamType = n2;
                            if (QLog.isColorLevel()) {
                                QLog.w("TRAE", 2, "-------requestAudioFocus _focusSteamType:" + this._focusSteamType);
                            }
                        }
                        catch (SecurityException securityException) {
                            if (!QLog.isColorLevel()) break block7;
                            QLog.e("TRAE", 2, "request audio focus exception. " + securityException);
                        }
                    }
                }
            }
        }

        @TargetApi(value=8)
        void abandonAudioFocus() {
            if (Build.VERSION.SDK_INT <= 8) {
                return;
            }
            if (TraeAudioManager.this._am != null && this.mAudioFocusChangeListener != null) {
                if (QLog.isColorLevel()) {
                    QLog.w("TRAE", 2, "-------abandonAudioFocus _focusSteamType:" + this._focusSteamType);
                }
                TraeAudioManager.this._am.abandonAudioFocus(this.mAudioFocusChangeListener);
                this.mAudioFocusChangeListener = null;
            }
        }

        int InternalVoicecallPreprocess(HashMap<String, Object> hashMap) {
            AudioDeviceInterface.LogTraceEntry(" activeMode:" + TraeAudioManager.this._activeMode);
            if (null == hashMap) {
                return -1;
            }
            if (TraeAudioManager.this._am == null) {
                if (QLog.isColorLevel()) {
                    QLog.e("TRAE", 2, " InternalVoicecallPreprocess am==null!!");
                }
                return -1;
            }
            if (TraeAudioManager.this._activeMode == 1) {
                Intent intent = new Intent();
                TraeAudioManager.this.sendResBroadcast(intent, hashMap, 2);
                return -1;
            }
            this._voiceCallSessionID = (Long)hashMap.get(TraeAudioManager.PARAM_SESSIONID);
            this._voiceCallOperation = (String)hashMap.get(TraeAudioManager.PARAM_OPERATION);
            TraeAudioManager.this._activeMode = 1;
            TraeAudioManager.this._prevMode = TraeAudioManager.this._am.getMode();
            Integer n2 = -1;
            Integer n3 = 0;
            n2 = (Integer)hashMap.get(TraeAudioManager.PARAM_MODEPOLICY);
            if (n2 == null) {
                if (QLog.isColorLevel()) {
                    QLog.e("TRAE", 2, " params.get(PARAM_MODEPOLICY)==null!!");
                }
                TraeAudioManager.this._modePolicy = -1;
            } else {
                TraeAudioManager.this._modePolicy = n2;
            }
            if (QLog.isColorLevel()) {
                QLog.e("TRAE", 2, "  _modePolicy:" + TraeAudioManager.this._modePolicy);
            }
            if ((n3 = (Integer)hashMap.get(TraeAudioManager.PARAM_STREAMTYPE)) == null) {
                if (QLog.isColorLevel()) {
                    QLog.e("TRAE", 2, " params.get(PARAM_STREAMTYPE)==null!!");
                }
                TraeAudioManager.this._streamType = 0;
            } else {
                TraeAudioManager.this._streamType = n3;
            }
            if (TraeAudioManager.isCloseSystemAPM(TraeAudioManager.this._modePolicy) && TraeAudioManager.this._activeMode != 2 && TraeAudioManager.this._deviceConfigManager != null) {
                if (TraeAudioManager.this._deviceConfigManager.getConnectedDevice().equals(TraeAudioManager.DEVICE_SPEAKERPHONE)) {
                    TraeAudioManager.this.InternalSetMode(0);
                    this.requestAudioFocus(3);
                } else {
                    TraeAudioManager.this.InternalSetMode(3);
                    this.requestAudioFocus(0);
                }
            } else {
                TraeAudioManager.this.InternalSetMode(TraeAudioManager.getCallAudioMode(TraeAudioManager.this._modePolicy));
                this.requestAudioFocus(TraeAudioManager.this._streamType);
            }
            Intent intent = new Intent();
            TraeAudioManager.this.sendResBroadcast(intent, hashMap, 0);
            AudioDeviceInterface.LogTraceExit();
            return 0;
        }

        int InternalVoicecallPostprocess(HashMap<String, Object> hashMap) {
            AudioDeviceInterface.LogTraceEntry(" activeMode:" + TraeAudioManager.this._activeMode);
            if (TraeAudioManager.this._am == null) {
                if (QLog.isColorLevel()) {
                    QLog.e("TRAE", 2, " InternalVoicecallPostprocess am==null!!");
                }
                return -1;
            }
            if (TraeAudioManager.this._activeMode != 1) {
                if (QLog.isColorLevel()) {
                    QLog.e("TRAE", 2, " not ACTIVE_VOICECALL!!");
                }
                Intent intent = new Intent();
                TraeAudioManager.this.sendResBroadcast(intent, hashMap, 3);
                return -1;
            }
            TraeAudioManager.this._activeMode = 0;
            this.abandonAudioFocus();
            AudioDeviceInterface.LogTraceExit();
            return 0;
        }

        int interruptVoicecallPostprocess() {
            AudioDeviceInterface.LogTraceEntry(" activeMode:" + TraeAudioManager.this._activeMode);
            if (TraeAudioManager.this._am == null) {
                if (QLog.isColorLevel()) {
                    QLog.e("TRAE", 2, " am==null!!");
                }
                return -1;
            }
            if (TraeAudioManager.this._activeMode != 1) {
                if (QLog.isColorLevel()) {
                    QLog.e("TRAE", 2, " not ACTIVE_RING!!");
                }
                return -1;
            }
            TraeAudioManager.this._activeMode = 0;
            if (TraeAudioManager.this._prevMode != -1) {
                TraeAudioManager.this.InternalSetMode(TraeAudioManager.this._prevMode);
            }
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put(TraeAudioManager.PARAM_SESSIONID, this._voiceCallSessionID);
            hashMap.put(TraeAudioManager.PARAM_OPERATION, this._voiceCallOperation);
            Intent intent = new Intent();
            TraeAudioManager.this.sendResBroadcast(intent, hashMap, 6);
            AudioDeviceInterface.LogTraceExit();
            return 0;
        }

        int InternalStartRing(HashMap<String, Object> hashMap) {
            AudioDeviceInterface.LogTraceEntry(" activeMode:" + TraeAudioManager.this._activeMode);
            if (TraeAudioManager.this._am == null) {
                if (QLog.isColorLevel()) {
                    QLog.e("TRAE", 2, " InternalStartRing am==null!!");
                }
                return -1;
            }
            if (TraeAudioManager.this._activeMode == 2) {
                this.interruptRing();
            }
            int n2 = 0;
            int n3 = -1;
            Uri uri = null;
            String string = null;
            boolean bl = false;
            int n4 = 1;
            boolean bl2 = false;
            try {
                this._ringSessionID = (Long)hashMap.get(TraeAudioManager.PARAM_SESSIONID);
                this._ringOperation = (String)hashMap.get(TraeAudioManager.PARAM_OPERATION);
                this._ringUserdata = (String)hashMap.get(TraeAudioManager.PARAM_RING_USERDATA_STRING);
                n2 = (Integer)hashMap.get(TraeAudioManager.PARAM_RING_DATASOURCE);
                if (QLog.isColorLevel()) {
                    QLog.w("TRAE", 2, "  dataSource:" + n2);
                }
                n3 = (Integer)hashMap.get(TraeAudioManager.PARAM_RING_RSID);
                uri = (Uri)hashMap.get(TraeAudioManager.PARAM_RING_URI);
                string = (String)hashMap.get(TraeAudioManager.PARAM_RING_FILEPATH);
                bl = (Boolean)hashMap.get(TraeAudioManager.PARAM_RING_LOOP);
                n4 = (Integer)hashMap.get(TraeAudioManager.PARAM_RING_LOOPCOUNT);
                bl2 = (Boolean)hashMap.get(TraeAudioManager.PARAM_RING_MODE);
            }
            catch (Exception exception) {
                if (QLog.isColorLevel()) {
                    QLog.e("TRAE", 2, " startRing err params");
                }
                return -1;
            }
            if (TraeAudioManager.this._activeMode != 1) {
                TraeAudioManager.this._activeMode = 2;
            }
            Intent intent = new Intent();
            intent.putExtra(TraeAudioManager.PARAM_RING_USERDATA_STRING, this._ringUserdata);
            TraeAudioManager.this.sendResBroadcast(intent, hashMap, 0);
            this._preRingMode = TraeAudioManager.this._am.getMode();
            this._ringPlayer.playRing(n2, n3, uri, string, bl, n4, bl2, TraeAudioManager.this._activeMode == 1, TraeAudioManager.this._streamType);
            if (QLog.isColorLevel()) {
                QLog.w("TRAE", 2, " _ringUserdata:" + this._ringUserdata + " DurationMS:" + this._ringPlayer.getDuration());
            }
            if (!this._ringPlayer.hasCall()) {
                this.requestAudioFocus(this._ringPlayer.getStreamType());
            }
            this.InternalNotifyStreamTypeUpdate(this._ringPlayer.getStreamType());
            AudioDeviceInterface.LogTraceExit();
            return 0;
        }

        int InternalStopRing(HashMap<String, Object> hashMap) {
            AudioDeviceInterface.LogTraceEntry(" activeMode:" + TraeAudioManager.this._activeMode + " _preRingMode:" + this._preRingMode);
            if (TraeAudioManager.this._am == null || this._ringPlayer == null) {
                if (QLog.isColorLevel()) {
                    QLog.e("TRAE", 2, " InternalStopRing am==null!!");
                }
                return -1;
            }
            this._ringPlayer.stopRing();
            if (!this._ringPlayer.hasCall() && TraeAudioManager.this._activeMode == 2) {
                this.abandonAudioFocus();
                TraeAudioManager.this._activeMode = 0;
            }
            Intent intent = new Intent();
            intent.putExtra(TraeAudioManager.PARAM_RING_USERDATA_STRING, this._ringUserdata);
            TraeAudioManager.this.sendResBroadcast(intent, hashMap, 0);
            AudioDeviceInterface.LogTraceExit();
            return 0;
        }

        int InternalGetStreamType(HashMap<String, Object> hashMap) {
            AudioDeviceInterface.LogTraceEntry(" activeMode:" + TraeAudioManager.this._activeMode + " _preRingMode:" + this._preRingMode);
            if (TraeAudioManager.this._am == null) {
                if (QLog.isColorLevel()) {
                    QLog.e("TRAE", 2, " InternalStopRing am==null!!");
                }
                return -1;
            }
            int n2 = -1;
            n2 = TraeAudioManager.this._activeMode == 2 ? this._ringPlayer.getStreamType() : TraeAudioManager.this._streamType;
            Intent intent = new Intent();
            intent.putExtra(TraeAudioManager.EXTRA_DATA_STREAMTYPE, n2);
            TraeAudioManager.this.sendResBroadcast(intent, hashMap, 0);
            AudioDeviceInterface.LogTraceExit();
            return 0;
        }

        int InternalNotifyStreamTypeUpdate(int n2) {
            if (null == TraeAudioManager.this._context) {
                return -1;
            }
            final int n3 = n2;
            Handler handler = new Handler(Looper.getMainLooper());
            handler.post(new Runnable(){

                @Override
                public void run() {
                    Intent intent = new Intent();
                    intent.setAction(TraeAudioManager.ACTION_TRAEAUDIOMANAGER_NOTIFY);
                    intent.putExtra(TraeAudioManager.PARAM_OPERATION, TraeAudioManager.NOTIFY_STREAMTYPE_UPDATE);
                    intent.putExtra(TraeAudioManager.EXTRA_DATA_STREAMTYPE, n3);
                    if (TraeAudioManager.this._context != null) {
                        TraeAudioManager.this._context.sendBroadcast(intent);
                    }
                }
            });
            return 0;
        }

        int interruptRing() {
            AudioDeviceInterface.LogTraceEntry(" activeMode:" + TraeAudioManager.this._activeMode + " _preRingMode:" + this._preRingMode);
            if (TraeAudioManager.this._am == null) {
                if (QLog.isColorLevel()) {
                    QLog.e("TRAE", 2, " interruptRing am==null!!");
                }
                return -1;
            }
            if (TraeAudioManager.this._activeMode != 2) {
                if (QLog.isColorLevel()) {
                    QLog.e("TRAE", 2, " not ACTIVE_RING!!");
                }
                return -1;
            }
            this._ringPlayer.stopRing();
            this.abandonAudioFocus();
            TraeAudioManager.this._activeMode = 0;
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put(TraeAudioManager.PARAM_SESSIONID, this._ringSessionID);
            hashMap.put(TraeAudioManager.PARAM_OPERATION, this._ringOperation);
            Intent intent = new Intent();
            intent.putExtra(TraeAudioManager.PARAM_RING_USERDATA_STRING, this._ringUserdata);
            TraeAudioManager.this.sendResBroadcast(intent, hashMap, 4);
            AudioDeviceInterface.LogTraceExit();
            return 0;
        }

        void notifyRingCompletion() {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put(TraeAudioManager.PARAM_SESSIONID, this._ringSessionID);
            hashMap.put(TraeAudioManager.PARAM_OPERATION, TraeAudioManager.NOTIFY_RING_COMPLETION);
            Intent intent = new Intent();
            intent.putExtra(TraeAudioManager.PARAM_RING_USERDATA_STRING, this._ringUserdata);
            TraeAudioManager.this.sendResBroadcast(intent, hashMap, 0);
        }
    }

    class DeviceConfigManager {
        HashMap<String, DeviceConfig> deviceConfigs = new HashMap();
        String prevConnectedDevice = "DEVICE_NONE";
        String connectedDevice = "DEVICE_NONE";
        String connectingDevice = "DEVICE_NONE";
        ReentrantLock mLock = new ReentrantLock();
        boolean visiableUpdate = false;
        String _bluetoothDevName = "unknow";

        public boolean init(String string) {
            String[] stringArray;
            AudioDeviceInterface.LogTraceEntry(" strConfigs:" + string);
            if (null == string || string.length() <= 0) {
                return false;
            }
            string = string.replace("\n", "");
            if (null == (string = string.replace("\r", "")) || string.length() <= 0) {
                return false;
            }
            if (0 > string.indexOf(";")) {
                string = string + ";";
            }
            if (null == (stringArray = string.split(";")) || 1 > stringArray.length) {
                return false;
            }
            this.mLock.lock();
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                this._addConfig(stringArray[i2], i2);
            }
            this.mLock.unlock();
            TraeAudioManager.this.printDevices();
            return true;
        }

        boolean _addConfig(String string, int n2) {
            AudioDeviceInterface.LogTraceEntry(" devName:" + string + " priority:" + n2);
            DeviceConfig deviceConfig = new DeviceConfig();
            if (deviceConfig.init(string, n2)) {
                if (this.deviceConfigs.containsKey(string)) {
                    if (QLog.isColorLevel()) {
                        QLog.e("TRAE", 2, "err dev exist!");
                    }
                    return false;
                }
                this.deviceConfigs.put(string, deviceConfig);
                this.visiableUpdate = true;
                if (QLog.isColorLevel()) {
                    QLog.w("TRAE", 2, " n" + this.getDeviceNumber() + " 0:" + this.getDeviceName(0));
                }
                AudioDeviceInterface.LogTraceExit();
                return true;
            }
            if (QLog.isColorLevel()) {
                QLog.e("TRAE", 2, " err dev init!");
            }
            return false;
        }

        public void clearConfig() {
            this.mLock.lock();
            this.deviceConfigs.clear();
            this.prevConnectedDevice = TraeAudioManager.DEVICE_NONE;
            this.connectedDevice = TraeAudioManager.DEVICE_NONE;
            this.connectingDevice = TraeAudioManager.DEVICE_NONE;
            this.mLock.unlock();
        }

        public boolean getVisiableUpdateFlag() {
            boolean bl = false;
            this.mLock.lock();
            bl = this.visiableUpdate;
            this.mLock.unlock();
            return bl;
        }

        public void resetVisiableUpdateFlag() {
            this.mLock.lock();
            this.visiableUpdate = false;
            this.mLock.unlock();
        }

        public boolean setVisible(String string, boolean bl) {
            boolean bl2 = false;
            this.mLock.lock();
            DeviceConfig deviceConfig = this.deviceConfigs.get(string);
            if (deviceConfig != null && deviceConfig.getVisible() != bl) {
                deviceConfig.setVisible(bl);
                this.visiableUpdate = true;
                if (QLog.isColorLevel()) {
                    QLog.w("TRAE", 2, " ++setVisible:" + string + (bl ? " Y" : " N"));
                }
                bl2 = true;
            }
            this.mLock.unlock();
            return bl2;
        }

        public void setBluetoothName(String string) {
            if (string == null) {
                this._bluetoothDevName = "unknow";
                return;
            }
            this._bluetoothDevName = string.isEmpty() ? "unknow" : string;
        }

        public String getBluetoothName() {
            return this._bluetoothDevName;
        }

        public boolean getVisible(String string) {
            boolean bl = false;
            this.mLock.lock();
            DeviceConfig deviceConfig = this.deviceConfigs.get(string);
            if (null != deviceConfig) {
                bl = deviceConfig.getVisible();
            }
            this.mLock.unlock();
            return bl;
        }

        public int getPriority(String string) {
            int n2 = -1;
            this.mLock.lock();
            DeviceConfig deviceConfig = this.deviceConfigs.get(string);
            if (null != deviceConfig) {
                n2 = deviceConfig.getPriority();
            }
            this.mLock.unlock();
            return n2;
        }

        public int getDeviceNumber() {
            this.mLock.lock();
            int n2 = this.deviceConfigs.size();
            this.mLock.unlock();
            return n2;
        }

        public String getDeviceName(int n2) {
            String string = TraeAudioManager.DEVICE_NONE;
            int n3 = 0;
            this.mLock.lock();
            DeviceConfig deviceConfig = null;
            for (Map.Entry<String, DeviceConfig> entry : this.deviceConfigs.entrySet()) {
                if (n3 == n2) {
                    deviceConfig = entry.getValue();
                    break;
                }
                ++n3;
            }
            if (deviceConfig != null) {
                string = deviceConfig.getDeviceName();
            }
            this.mLock.unlock();
            return string;
        }

        public String getAvailabledHighestPriorityDevice(String string) {
            DeviceConfig deviceConfig = null;
            this.mLock.lock();
            DeviceConfig deviceConfig2 = null;
            for (Map.Entry<String, DeviceConfig> entry : this.deviceConfigs.entrySet()) {
                String string2 = entry.getKey();
                DeviceConfig deviceConfig3 = entry.getValue();
                deviceConfig2 = entry.getValue();
                if (deviceConfig2 == null || !deviceConfig2.getVisible() || deviceConfig2.getDeviceName().equals(string)) continue;
                if (deviceConfig == null) {
                    deviceConfig = deviceConfig2;
                    continue;
                }
                if (deviceConfig2.getPriority() < deviceConfig.getPriority()) continue;
                deviceConfig = deviceConfig2;
            }
            this.mLock.unlock();
            return deviceConfig != null ? deviceConfig.getDeviceName() : TraeAudioManager.DEVICE_SPEAKERPHONE;
        }

        public String getAvailabledHighestPriorityDevice() {
            DeviceConfig deviceConfig = null;
            this.mLock.lock();
            DeviceConfig deviceConfig2 = null;
            for (Map.Entry<String, DeviceConfig> entry : this.deviceConfigs.entrySet()) {
                String string = entry.getKey();
                DeviceConfig deviceConfig3 = entry.getValue();
                deviceConfig2 = entry.getValue();
                if (deviceConfig2 == null || !deviceConfig2.getVisible()) continue;
                if (deviceConfig == null) {
                    deviceConfig = deviceConfig2;
                    continue;
                }
                if (deviceConfig2.getPriority() < deviceConfig.getPriority()) continue;
                deviceConfig = deviceConfig2;
            }
            this.mLock.unlock();
            return deviceConfig != null ? deviceConfig.getDeviceName() : TraeAudioManager.DEVICE_SPEAKERPHONE;
        }

        public String getConnectingDevice() {
            String string = TraeAudioManager.DEVICE_NONE;
            this.mLock.lock();
            string = null;
            DeviceConfig deviceConfig = this.deviceConfigs.get(this.connectingDevice);
            if (null != deviceConfig && deviceConfig.getVisible()) {
                string = this.connectingDevice;
            }
            this.mLock.unlock();
            return string;
        }

        public String getConnectedDevice() {
            String string = TraeAudioManager.DEVICE_NONE;
            this.mLock.lock();
            string = this._getConnectedDevice();
            this.mLock.unlock();
            return string;
        }

        public String getPrevConnectedDevice() {
            String string = TraeAudioManager.DEVICE_NONE;
            this.mLock.lock();
            string = this._getPrevConnectedDevice();
            this.mLock.unlock();
            return string;
        }

        public boolean setConnecting(String string) {
            boolean bl = false;
            this.mLock.lock();
            DeviceConfig deviceConfig = this.deviceConfigs.get(string);
            if (deviceConfig != null && deviceConfig.getVisible()) {
                this.connectingDevice = string;
                bl = true;
            }
            this.mLock.unlock();
            return bl;
        }

        public boolean setConnected(String string) {
            boolean bl = false;
            this.mLock.lock();
            DeviceConfig deviceConfig = this.deviceConfigs.get(string);
            if (deviceConfig != null && deviceConfig.getVisible()) {
                if (this.connectedDevice != null && !this.connectedDevice.equals(string)) {
                    this.prevConnectedDevice = this.connectedDevice;
                }
                this.connectedDevice = string;
                this.connectingDevice = "";
                bl = true;
            }
            this.mLock.unlock();
            return bl;
        }

        public boolean isConnected(String string) {
            boolean bl = false;
            this.mLock.lock();
            DeviceConfig deviceConfig = this.deviceConfigs.get(string);
            if (deviceConfig != null && deviceConfig.getVisible()) {
                bl = this.connectedDevice.equals(string);
            }
            this.mLock.unlock();
            return bl;
        }

        public HashMap<String, Object> getSnapParams() {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            this.mLock.lock();
            hashMap.put(TraeAudioManager.EXTRA_DATA_AVAILABLEDEVICE_LIST, this._getAvailableDeviceList());
            hashMap.put(TraeAudioManager.EXTRA_DATA_CONNECTEDDEVICE, this._getConnectedDevice());
            hashMap.put(TraeAudioManager.EXTRA_DATA_PREV_CONNECTEDDEVICE, this._getPrevConnectedDevice());
            this.mLock.unlock();
            return hashMap;
        }

        public ArrayList<String> getAvailableDeviceList() {
            ArrayList<String> arrayList = new ArrayList();
            this.mLock.lock();
            arrayList = this._getAvailableDeviceList();
            this.mLock.unlock();
            return arrayList;
        }

        ArrayList<String> _getAvailableDeviceList() {
            ArrayList<String> arrayList = new ArrayList<String>();
            DeviceConfig deviceConfig = null;
            for (Map.Entry<String, DeviceConfig> entry : this.deviceConfigs.entrySet()) {
                deviceConfig = entry.getValue();
                if (deviceConfig == null || !deviceConfig.getVisible()) continue;
                arrayList.add(deviceConfig.getDeviceName());
            }
            return arrayList;
        }

        String _getConnectedDevice() {
            String string = TraeAudioManager.DEVICE_NONE;
            DeviceConfig deviceConfig = this.deviceConfigs.get(this.connectedDevice);
            if (null != deviceConfig && deviceConfig.getVisible()) {
                string = this.connectedDevice;
            }
            return string;
        }

        String _getPrevConnectedDevice() {
            String string = TraeAudioManager.DEVICE_NONE;
            DeviceConfig deviceConfig = this.deviceConfigs.get(this.prevConnectedDevice);
            if (null != deviceConfig && deviceConfig.getVisible()) {
                string = this.prevConnectedDevice;
            }
            return string;
        }

        public class DeviceConfig {
            String deviceName = "DEVICE_NONE";
            boolean visible = false;
            int priority = 0;

            public boolean init(String string, int n2) {
                if (null == string || string.length() <= 0) {
                    return false;
                }
                if (!TraeAudioManager.checkDevName(string)) {
                    return false;
                }
                this.deviceName = string;
                this.priority = n2;
                return true;
            }

            public String getDeviceName() {
                return this.deviceName;
            }

            public boolean getVisible() {
                return this.visible;
            }

            public int getPriority() {
                return this.priority;
            }

            public void setVisible(boolean bl) {
                this.visible = bl;
            }
        }
    }

    public class Parameters {
        public static final String CONTEXT = "com.tencent.sharp.TraeAudioManager.Parameters.CONTEXT";
        public static final String MODEPOLICY = "com.tencent.sharp.TraeAudioManager.Parameters.MODEPOLICY";
        public static final String BLUETOOTHPOLICY = "com.tencent.sharp.TraeAudioManager.Parameters.BLUETOOTHPOLICY";
        public static final String DEVICECONFIG = "com.tencent.sharp.TraeAudioManager.Parameters.DEVICECONFIG";
    }
}

