/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.rtmp.ui;

import android.content.Context;
import android.graphics.Rect;
import android.os.Bundle;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.SurfaceView;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.tencent.liteav.j;
import com.tencent.liteav.renderer.TXCFocusIndicatorView;
import com.tencent.liteav.renderer.TXCGLSurfaceView;
import com.tencent.rtmp.ui.TXDashBoard;

public class TXCloudVideoView
extends FrameLayout
implements View.OnTouchListener {
    private static final String TAG = "TXCloudVideoView";
    protected TXDashBoard mDashBoard;
    private int mCaptureWidth = 0;
    private int mCaptureHeight = 0;
    private float mLeft = 0.0f;
    private float mRight = 0.0f;
    private float mTop = 0.0f;
    private float mBottom = 0.0f;
    protected TextureView mVideoView;
    protected TXCGLSurfaceView mGLSurfaceView;
    protected TXCFocusIndicatorView mFocusIndicatorView;
    protected SurfaceView mSurfaceView;
    private int mFocusAreaSize = 0;
    private static final int FOCUS_AREA_SIZE_DP = 70;
    private String mUserId = "";
    private boolean mFocus = false;
    private boolean mZoom = false;
    private j mCapture;
    private int mCurrentScale = 1;
    private ScaleGestureDetector mScaleGestureDetector = null;
    private ScaleGestureDetector.OnScaleGestureListener mScaleGestureListener = new ScaleGestureDetector.OnScaleGestureListener(){

        public boolean onScale(ScaleGestureDetector scaleGestureDetector) {
            int n2;
            int n3 = n2 = TXCloudVideoView.this.mCapture != null ? TXCloudVideoView.this.mCapture.d() : 0;
            if (n2 > 0) {
                int n4;
                float f2 = scaleGestureDetector.getScaleFactor();
                if (f2 > 1.0f) {
                    f2 = 1.0f + 0.2f / (float)n2 * (float)(n2 - TXCloudVideoView.this.mCurrentScale);
                    if (f2 <= 1.1f) {
                        f2 = 1.1f;
                    }
                } else if (f2 < 1.0f && (f2 = 1.0f - 0.2f / (float)n2 * (float)TXCloudVideoView.this.mCurrentScale) >= 0.9f) {
                    f2 = 0.9f;
                }
                if ((n4 = Math.round((float)TXCloudVideoView.this.mCurrentScale * f2)) == TXCloudVideoView.this.mCurrentScale) {
                    if (f2 > 1.0f) {
                        ++n4;
                    } else if (f2 < 1.0f) {
                        --n4;
                    }
                }
                if (n4 >= n2) {
                    n4 = n2;
                }
                if (n4 <= 1) {
                    n4 = 1;
                }
                if (f2 > 1.0f) {
                    if (n4 < TXCloudVideoView.this.mCurrentScale) {
                        n4 = TXCloudVideoView.this.mCurrentScale;
                    }
                } else if (f2 < 1.0f && n4 > TXCloudVideoView.this.mCurrentScale) {
                    n4 = TXCloudVideoView.this.mCurrentScale;
                }
                TXCloudVideoView.this.mCurrentScale = n4;
                if (TXCloudVideoView.this.mCapture != null) {
                    TXCloudVideoView.this.mCapture.a(TXCloudVideoView.this.mCurrentScale);
                }
            }
            return false;
        }

        public boolean onScaleBegin(ScaleGestureDetector scaleGestureDetector) {
            return true;
        }

        public void onScaleEnd(ScaleGestureDetector scaleGestureDetector) {
        }
    };
    private a mTouchFocusRunnable = new a();

    public TXCloudVideoView(Context context) {
        this(context, null);
    }

    public TXCloudVideoView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.mDashBoard = new TXDashBoard(context);
        this.mScaleGestureDetector = new ScaleGestureDetector(context, this.mScaleGestureListener);
    }

    public TXCloudVideoView(SurfaceView surfaceView) {
        this(surfaceView.getContext(), null);
        this.mSurfaceView = surfaceView;
    }

    public void onResume() {
    }

    public void onPause() {
    }

    public void addVideoView(TXCGLSurfaceView tXCGLSurfaceView) {
        if (this.mGLSurfaceView != null) {
            this.removeView((View)this.mGLSurfaceView);
        }
        this.mGLSurfaceView = tXCGLSurfaceView;
        this.addView((View)this.mGLSurfaceView);
        this.resetLogView();
    }

    public void addVideoView(TextureView textureView) {
        if (this.mVideoView != null) {
            this.removeView((View)this.mVideoView);
        }
        this.mVideoView = textureView;
        this.addView((View)this.mVideoView);
        this.resetLogView();
    }

    public void removeVideoView() {
        if (this.mVideoView != null) {
            this.removeView((View)this.mVideoView);
            this.mVideoView = null;
        }
        if (this.mGLSurfaceView != null) {
            this.removeView((View)this.mGLSurfaceView);
            this.mGLSurfaceView = null;
        }
        this.mSurfaceView = null;
    }

    public void removeFocusIndicatorView() {
        if (this.mFocusIndicatorView != null) {
            this.removeView(this.mFocusIndicatorView);
            this.mFocusIndicatorView = null;
        }
    }

    public void onDestroy() {
    }

    public TextureView getVideoView() {
        return this.mVideoView;
    }

    public TXCGLSurfaceView getGLSurfaceView() {
        return this.mGLSurfaceView;
    }

    public SurfaceView getSurfaceView() {
        return this.mSurfaceView;
    }

    public void setRenderMode(int n2) {
    }

    public void setRenderRotation(int n2) {
    }

    public TextureView getHWVideoView() {
        return this.mVideoView;
    }

    public void clearLastFrame(boolean bl) {
        if (bl) {
            this.setVisibility(8);
        }
    }

    public void onTouchFocus(int n2, int n3) {
        if (this.mGLSurfaceView == null) {
            return;
        }
        if (n2 < 0 || n3 < 0) {
            if (this.mFocusIndicatorView != null) {
                this.mFocusIndicatorView.setVisibility(8);
            }
            return;
        }
        if (this.mFocusIndicatorView == null) {
            this.mFocusIndicatorView = new TXCFocusIndicatorView(this.getContext());
            this.mFocusIndicatorView.setVisibility(0);
            this.addView(this.mFocusIndicatorView);
        } else {
            int n4 = this.indexOfChild(this.mFocusIndicatorView);
            if (n4 != this.getChildCount() - 1) {
                this.removeView(this.mFocusIndicatorView);
                this.addView(this.mFocusIndicatorView);
            }
        }
        Rect rect = this.getTouchRect(n2, n3, this.mGLSurfaceView.getWidth(), this.mGLSurfaceView.getHeight(), 1.0f);
        this.mFocusIndicatorView.show(rect.left, rect.top, rect.right - rect.left);
    }

    private Rect getTouchRect(int n2, int n3, int n4, int n5, float f2) {
        if (this.mFocusAreaSize == 0 && this.mGLSurfaceView != null) {
            this.mFocusAreaSize = (int)(70.0f * this.mGLSurfaceView.getResources().getDisplayMetrics().density + 0.5f);
        }
        int n6 = Float.valueOf((float)this.mFocusAreaSize * f2).intValue();
        int n7 = this.clamp(n2 - n6 / 2, 0, n4 - n6);
        int n8 = this.clamp(n3 - n6 / 2, 0, n5 - n6);
        return new Rect(n7, n8, n7 + n6, n8 + n6);
    }

    private int clamp(int n2, int n3, int n4) {
        if (n2 > n4) {
            return n4;
        }
        if (n2 < n3) {
            return n3;
        }
        return n2;
    }

    public void setMirror(boolean bl) {
    }

    public void disableLog(boolean bl) {
        if (this.mDashBoard != null) {
            this.mDashBoard.a(bl);
        }
    }

    public void showLog(boolean bl) {
        if (this.mDashBoard != null) {
            this.mDashBoard.setShowLevel(bl ? 2 : 0);
        }
    }

    public void clearLog() {
        if (this.mDashBoard != null) {
            this.mDashBoard.a();
        }
    }

    public void setLogText(Bundle bundle, Bundle bundle2, int n2) {
        if (this.mDashBoard != null) {
            this.mDashBoard.a(bundle, bundle2, n2);
        }
    }

    protected void resetLogView() {
        if (this.mDashBoard != null) {
            this.removeView((View)this.mDashBoard);
            this.addView((View)this.mDashBoard);
        }
    }

    protected void onLayout(boolean bl, int n2, int n3, int n4, int n5) {
        super.onLayout(bl, n2, n3, n4, n5);
        this.updateDbMargin();
        if (this.mDashBoard != null) {
            this.mDashBoard.setStatusTextSize((float)((double)TXCloudVideoView.px2dip(this.getContext(), this.getWidth()) / 30.0));
            this.mDashBoard.setEventTextSize((float)((double)TXCloudVideoView.px2dip(this.getContext(), this.getWidth()) / 25.0));
        }
        if (0 != this.mCaptureWidth && 0 != this.mCaptureHeight) {
            this.updateVideoViewSize(this.mCaptureWidth, this.mCaptureHeight);
        }
    }

    public void updateVideoViewSize(int n2, int n3) {
        FrameLayout.LayoutParams layoutParams = null;
        TXCGLSurfaceView tXCGLSurfaceView = null;
        if (null != this.mGLSurfaceView) {
            tXCGLSurfaceView = this.mGLSurfaceView;
        } else if (null != this.mVideoView) {
            tXCGLSurfaceView = this.mVideoView;
        } else {
            return;
        }
        int n4 = this.getWidth();
        int n5 = this.getHeight();
        if (0 == n3 || 0 == n5) {
            return;
        }
        this.mCaptureWidth = n2;
        this.mCaptureHeight = n3;
        float f2 = (float)n2 * 1.0f / (float)n3;
        float f3 = (float)n4 * 1.0f / (float)n5;
        int n6 = 0;
        int n7 = 0;
        int n8 = n4;
        int n9 = n5;
        if (f2 > f3) {
            n9 = (int)((float)n8 / f2);
            n7 = (this.getHeight() - n9) / 2;
        } else {
            n8 = (int)((float)n9 * f2);
            n6 = (this.getWidth() - n8) / 2;
        }
        ViewGroup.LayoutParams layoutParams2 = tXCGLSurfaceView.getLayoutParams();
        if (layoutParams2 != null) {
            layoutParams = (FrameLayout.LayoutParams)layoutParams2;
            if (layoutParams.width == n8 && layoutParams.height == n9) {
                return;
            }
            layoutParams.width = n8;
            layoutParams.height = n9;
        } else {
            layoutParams = new FrameLayout.LayoutParams(n8, n9);
        }
        layoutParams.leftMargin = n6;
        layoutParams.topMargin = n7;
        tXCGLSurfaceView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    public void setDashBoardStatusInfo(CharSequence charSequence) {
        if (this.mDashBoard != null) {
            this.mDashBoard.a(charSequence);
        }
    }

    public void appendEventInfo(String string) {
        if (this.mDashBoard != null) {
            this.mDashBoard.a(string);
        }
    }

    public void showVideoDebugLog(int n2) {
        if (this.mDashBoard != null) {
            this.mDashBoard.setShowLevel(n2);
        }
    }

    public void setLogMargin(float f2, float f3, float f4, float f5) {
        this.mLeft = f2;
        this.mRight = f3;
        this.mTop = f4;
        this.mBottom = f5;
        if (this.mDashBoard != null) {
            this.mDashBoard.a((int)this.mLeft, (int)this.mTop, (int)this.mRight, (int)this.mBottom);
        }
    }

    public void setLogMarginRatio(final float f2, final float f3, final float f4, final float f5) {
        int n2 = this.getWidth();
        int n3 = this.getHeight();
        this.postDelayed(new Runnable(){

            @Override
            public void run() {
                TXCloudVideoView.this.mLeft = (float)TXCloudVideoView.this.getWidth() * f2;
                TXCloudVideoView.this.mRight = (float)TXCloudVideoView.this.getWidth() * f3;
                TXCloudVideoView.this.mTop = (float)TXCloudVideoView.this.getHeight() * f4;
                TXCloudVideoView.this.mBottom = (float)TXCloudVideoView.this.getHeight() * f5;
                if (TXCloudVideoView.this.mDashBoard != null) {
                    TXCloudVideoView.this.mDashBoard.a((int)TXCloudVideoView.this.mLeft, (int)TXCloudVideoView.this.mTop, (int)TXCloudVideoView.this.mRight, (int)TXCloudVideoView.this.mBottom);
                }
            }
        }, 100L);
    }

    public String getUserId() {
        return this.mUserId;
    }

    public void setUserId(String string) {
        this.mUserId = string;
    }

    public static int px2dip(Context context, float f2) {
        float f3 = context.getResources().getDisplayMetrics().density;
        return (int)(f2 / f3 + 0.5f);
    }

    private void updateDbMargin() {
        if (this.mDashBoard != null) {
            this.mDashBoard.a((int)this.mLeft, (int)this.mTop, (int)this.mRight, (int)this.mBottom);
        }
    }

    public void start(boolean bl, boolean bl2, j j2) {
        this.mFocus = bl;
        this.mZoom = bl2;
        if (this.mFocus || this.mZoom) {
            this.setOnTouchListener(this);
            this.mCapture = j2;
        }
        if (this.mGLSurfaceView != null) {
            this.mGLSurfaceView.setVisibility(0);
        }
    }

    public void stop(boolean bl) {
        if (this.mFocus || this.mZoom) {
            this.setOnTouchListener(null);
        }
        this.mCapture = null;
        if (bl && this.mGLSurfaceView != null) {
            this.mGLSurfaceView.setVisibility(8);
        }
    }

    public boolean onTouch(View view, MotionEvent motionEvent) {
        if (motionEvent.getPointerCount() == 1 && motionEvent.getAction() == 0) {
            this.mTouchFocusRunnable.a(view);
            this.mTouchFocusRunnable.a(motionEvent);
            this.postDelayed(this.mTouchFocusRunnable, 100L);
        } else if (motionEvent.getPointerCount() > 1 && motionEvent.getAction() == 2) {
            this.removeCallbacks(this.mTouchFocusRunnable);
            this.onTouchFocus(-1, -1);
            if (this.mScaleGestureDetector != null && this.mZoom) {
                this.mScaleGestureDetector.onTouchEvent(motionEvent);
            }
        }
        if (this.mZoom && motionEvent.getAction() == 0) {
            this.performClick();
        }
        return this.mZoom;
    }

    private class a
    implements Runnable {
        private View b;
        private MotionEvent c;

        private a() {
        }

        public void a(View view) {
            this.b = view;
        }

        public void a(MotionEvent motionEvent) {
            this.c = motionEvent;
        }

        @Override
        public void run() {
            if (TXCloudVideoView.this.mCapture != null && TXCloudVideoView.this.mFocus) {
                TXCloudVideoView.this.mCapture.a(this.c.getX() / (float)this.b.getWidth(), this.c.getY() / (float)this.b.getHeight());
            }
            if (TXCloudVideoView.this.mFocus) {
                TXCloudVideoView.this.onTouchFocus((int)this.c.getX(), (int)this.c.getY());
            }
        }
    }
}

