/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.trtc.impl;

import android.opengl.GLES20;
import android.os.Build;
import android.os.HandlerThread;
import com.tencent.liteav.basic.d.f;
import com.tencent.liteav.basic.d.g;
import com.tencent.liteav.basic.log.TXCLog;
import com.tencent.liteav.beauty.b.k;
import com.tencent.liteav.c;
import com.tencent.trtc.TRTCCloudDef;

public class TRTCCustomTextureUtil {
    private static final String TAG = TRTCCustomTextureUtil.class.getSimpleName();
    private f mGLThreadHandler = null;
    private HandlerThread mEGLThread = null;
    private Object mGLLock = new Object();
    private Object mEGLContext = null;
    private long mLastGLThreadId;
    private g mRotateFilter;
    private k mI4202RGBAFilter = null;
    private c mCaptureAndEnc;

    public TRTCCustomTextureUtil(c c2) {
        this.mCaptureAndEnc = c2;
    }

    public void release() {
        this.stopThread();
    }

    public void sendCustomTexture(TRTCCloudDef.TRTCVideoFrame tRTCVideoFrame) {
        this.checkEGLContext(tRTCVideoFrame);
        this.sendCustomTextureInternal(tRTCVideoFrame);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendCustomTextureInternal(final TRTCCloudDef.TRTCVideoFrame tRTCVideoFrame) {
        TRTCCustomTextureUtil tRTCCustomTextureUtil = this;
        synchronized (tRTCCustomTextureUtil) {
            if (this.mGLThreadHandler != null) {
                GLES20.glFinish();
                this.mGLThreadHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        f f2 = TRTCCustomTextureUtil.this.mGLThreadHandler;
                        if (f2 != null) {
                            if (f2.d) {
                                if (tRTCVideoFrame.texture != null) {
                                    tRTCVideoFrame.texture.textureId = TRTCCustomTextureUtil.this.checkRotate(tRTCVideoFrame.texture.textureId, tRTCVideoFrame);
                                    TRTCCustomTextureUtil.this.mCaptureAndEnc.a(tRTCVideoFrame.texture.textureId, tRTCVideoFrame.width, tRTCVideoFrame.height, f2.e, tRTCVideoFrame.timestamp, tRTCVideoFrame.rotation);
                                }
                            } else if (tRTCVideoFrame.texture != null) {
                                tRTCVideoFrame.texture.textureId = TRTCCustomTextureUtil.this.checkRotate(tRTCVideoFrame.texture.textureId, tRTCVideoFrame);
                                TRTCCustomTextureUtil.this.mCaptureAndEnc.a(tRTCVideoFrame.texture.textureId, tRTCVideoFrame.width, tRTCVideoFrame.height, f2.g, tRTCVideoFrame.timestamp, tRTCVideoFrame.rotation);
                            } else {
                                int n2 = 3;
                                if (tRTCVideoFrame.pixelFormat == 1) {
                                    n2 = 1;
                                } else if (tRTCVideoFrame.pixelFormat == 4) {
                                    n2 = 3;
                                }
                                if (TRTCCustomTextureUtil.this.mI4202RGBAFilter == null) {
                                    TRTCCustomTextureUtil.this.mI4202RGBAFilter = new k(n2);
                                    TRTCCustomTextureUtil.this.mI4202RGBAFilter.a(true);
                                    if (!TRTCCustomTextureUtil.this.mI4202RGBAFilter.a()) {
                                        TXCLog.e(TAG, "mI4202RGBAFilter init failed!!, break init");
                                    }
                                    TRTCCustomTextureUtil.this.mI4202RGBAFilter.a(tRTCVideoFrame.width, tRTCVideoFrame.height);
                                }
                                if (TRTCCustomTextureUtil.this.mI4202RGBAFilter != null) {
                                    GLES20.glViewport((int)0, (int)0, (int)tRTCVideoFrame.width, (int)tRTCVideoFrame.height);
                                    TRTCCustomTextureUtil.this.mI4202RGBAFilter.a(tRTCVideoFrame.data);
                                    int n3 = TRTCCustomTextureUtil.this.mI4202RGBAFilter.q();
                                    n3 = TRTCCustomTextureUtil.this.checkRotate(n3, tRTCVideoFrame);
                                    TRTCCustomTextureUtil.this.mCaptureAndEnc.a(n3, tRTCVideoFrame.width, tRTCVideoFrame.height, f2.f.c(), tRTCVideoFrame.timestamp, tRTCVideoFrame.rotation);
                                } else {
                                    TRTCCustomTextureUtil.this.mCaptureAndEnc.a(tRTCVideoFrame.data, n2, tRTCVideoFrame.width, tRTCVideoFrame.height, f2.f.c(), tRTCVideoFrame.timestamp, tRTCVideoFrame.rotation);
                                }
                            }
                        }
                    }
                });
            }
        }
    }

    private void checkEGLContext(TRTCCloudDef.TRTCVideoFrame tRTCVideoFrame) {
        if (tRTCVideoFrame == null) {
            return;
        }
        boolean bl = false;
        if (this.mLastGLThreadId == Thread.currentThread().getId()) {
            if (tRTCVideoFrame.texture != null) {
                if (tRTCVideoFrame.texture.eglContext10 != null) {
                    boolean bl2 = bl = !tRTCVideoFrame.texture.eglContext10.equals(this.mEGLContext);
                    if (bl) {
                        this.apiLog("CustomTexture egl10Context change!");
                    }
                }
                if (tRTCVideoFrame.texture.eglContext14 != null) {
                    boolean bl3 = bl = !tRTCVideoFrame.texture.eglContext14.equals(this.mEGLContext);
                    if (bl) {
                        this.apiLog("CustomTexture egl14Context change!");
                    }
                }
            }
        } else {
            bl = true;
            this.apiLog("CustomTexture eglContext's thread change!");
        }
        this.mLastGLThreadId = Thread.currentThread().getId();
        if (tRTCVideoFrame.texture != null) {
            this.mEGLContext = tRTCVideoFrame.texture.eglContext10 != null ? tRTCVideoFrame.texture.eglContext10 : tRTCVideoFrame.texture.eglContext14;
        }
        if (bl) {
            this.stopThread();
            this.startThread(tRTCVideoFrame);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startThread(TRTCCloudDef.TRTCVideoFrame tRTCVideoFrame) {
        if (tRTCVideoFrame == null) {
            return;
        }
        TRTCCustomTextureUtil tRTCCustomTextureUtil = this;
        synchronized (tRTCCustomTextureUtil) {
            if (this.mEGLThread == null) {
                this.mEGLThread = new HandlerThread("customCaptureGLThread");
                this.mEGLThread.start();
                this.mGLThreadHandler = new f(this.mEGLThread.getLooper());
                if (tRTCVideoFrame.texture == null) {
                    this.mGLThreadHandler.d = false;
                    this.mGLThreadHandler.g = null;
                    this.mGLThreadHandler.a = 1280;
                    this.mGLThreadHandler.b = 720;
                    this.mGLThreadHandler.sendEmptyMessage(100);
                } else if (tRTCVideoFrame.texture.eglContext10 != null) {
                    this.apiLog("CustomTexture start egl10 thread");
                    this.mGLThreadHandler.d = false;
                    this.mGLThreadHandler.g = tRTCVideoFrame.texture.eglContext10;
                    this.mGLThreadHandler.a = 1280;
                    this.mGLThreadHandler.b = 720;
                    this.mGLThreadHandler.sendEmptyMessage(100);
                } else if (tRTCVideoFrame.texture.eglContext14 != null && Build.VERSION.SDK_INT >= 17) {
                    this.apiLog("CustomTexture start egl14 thread");
                    this.mGLThreadHandler.d = true;
                    this.mGLThreadHandler.e = tRTCVideoFrame.texture.eglContext14;
                    this.mGLThreadHandler.a = 1280;
                    this.mGLThreadHandler.b = 720;
                    this.mGLThreadHandler.sendEmptyMessage(100);
                }
            }
        }
    }

    private synchronized void stopThread() {
        if (this.mGLThreadHandler != null) {
            this.mGLThreadHandler.post(new Runnable(){

                @Override
                public void run() {
                    if (TRTCCustomTextureUtil.this.mRotateFilter != null) {
                        TRTCCustomTextureUtil.this.mRotateFilter.d();
                        TRTCCustomTextureUtil.this.mRotateFilter = null;
                    }
                    if (TRTCCustomTextureUtil.this.mCaptureAndEnc != null) {
                        TRTCCustomTextureUtil.this.apiLog("CustomTexture releasePreprocessorAndEncoder");
                        TRTCCustomTextureUtil.this.mCaptureAndEnc.l();
                    }
                }
            });
            f.a(this.mGLThreadHandler, this.mEGLThread);
            this.apiLog("CustomTexture destroy egl thread");
        }
        this.mGLThreadHandler = null;
        this.mEGLThread = null;
    }

    private void apiLog(String string) {
        TXCLog.i(TAG, "trtc_api " + string);
    }

    private int checkRotate(int n2, TRTCCloudDef.TRTCVideoFrame tRTCVideoFrame) {
        if (tRTCVideoFrame == null || tRTCVideoFrame.rotation == 0) {
            return n2;
        }
        int n3 = tRTCVideoFrame.rotation * 90;
        if (this.mRotateFilter == null) {
            this.mRotateFilter = new g();
            this.mRotateFilter.a();
            this.mRotateFilter.a(true);
            this.mRotateFilter.a(tRTCVideoFrame.width, tRTCVideoFrame.height);
        }
        int n4 = n2;
        if (this.mRotateFilter != null) {
            GLES20.glViewport((int)0, (int)0, (int)tRTCVideoFrame.width, (int)tRTCVideoFrame.height);
            int n5 = (720 - n3) % 360;
            this.mRotateFilter.a(tRTCVideoFrame.width, tRTCVideoFrame.height);
            this.mRotateFilter.a(tRTCVideoFrame.width, tRTCVideoFrame.height, n5, null, (float)tRTCVideoFrame.width / (float)tRTCVideoFrame.height, false, false);
            this.mRotateFilter.b(n4);
            n4 = this.mRotateFilter.l();
            int n6 = n5 == 90 || n5 == 270 ? tRTCVideoFrame.height : tRTCVideoFrame.width;
            int n7 = n5 == 90 || n5 == 270 ? tRTCVideoFrame.width : tRTCVideoFrame.height;
            tRTCVideoFrame.width = n6;
            tRTCVideoFrame.height = n7;
        }
        return n4;
    }
}

