/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.trtc.impl;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import android.view.Surface;
import android.view.SurfaceHolder;
import com.tencent.liteav.TXCRenderAndDec;
import com.tencent.liteav.basic.log.TXCLog;
import com.tencent.liteav.f;
import com.tencent.liteav.renderer.e;
import com.tencent.rtmp.ui.TXCloudVideoView;
import com.tencent.trtc.TRTCCloud;
import com.tencent.trtc.TRTCCloudListener;
import java.util.HashMap;
import java.util.Map;

public class TRTCRoomInfo {
    private static final String TRTC_INFO = "TRTC.Info";
    private static final String TOKEN = "TRTC.0x0.Token";
    public static final int STATE_BIG_VIDEO = 1;
    public static final int STATE_SMALL_VIDEO = 2;
    public static final int STATE_SUB_VIDEO = 4;
    public static final int STATE_AUDIO = 8;
    public static final int STATE_MUTE_MAIN_VIDEO = 16;
    public static final int STATE_MUTE_SUB_VIDEO = 32;
    public static final int STATE_MUTE_AUDIO = 64;
    public static final int NETWORK_STATUS_OFFLINE = 1;
    public static final int NETWORK_STATUS_RECONNECTING = 2;
    public static final int NETWORK_STATUS_ONLINE = 3;
    public int sdkAppId;
    public long enterTime;
    public int roomId;
    public String strRoomId;
    public String userId;
    public String tinyId;
    public byte[] token = null;
    public String userSig;
    public String privateMapKey;
    public int networkStatus = 1;
    public TRTCCloud.TRTCViewMargin debugMargin = new TRTCCloud.TRTCViewMargin(0.0f, 0.0f, 0.1f, 0.0f);
    public int localPixelFormat;
    public int localBufferType;
    public TRTCCloudListener.TRTCVideoRenderListener localListener;
    public TXCloudVideoView localView = null;
    private HashMap<String, UserInfo> userList = new HashMap();
    private HashMap<Long, Integer> recvFirstIFrameCntList = new HashMap();
    public boolean muteLocalVideo = false;
    public boolean muteRemoteVideo = false;
    public boolean muteAudio;
    public boolean muteRemoteAudio = false;
    public int localRenderRotation = 0;
    private boolean micHasStartd = false;
    private boolean hasExitedRoom = false;
    private int exitRoomCode = 0;
    public f.a bigEncSize = new f.a();
    public f.a smallEncSize = new f.a();

    public void init(int n2, String string) {
        this.roomId = n2;
        this.userId = string;
    }

    public synchronized void clear() {
        this.roomId = 0;
        this.userId = "";
        this.enterTime = 0L;
        this.tinyId = "";
        this.muteLocalVideo = false;
        this.muteAudio = false;
        this.userList.clear();
        this.recvFirstIFrameCntList.clear();
        this.networkStatus = 1;
    }

    public String getStrRoomId() {
        String string = TextUtils.isEmpty((CharSequence)this.strRoomId) ? String.valueOf(this.roomId) : this.strRoomId;
        return string;
    }

    public int getRoomId() {
        return this.roomId;
    }

    public void setRoomId(int n2) {
        this.roomId = n2;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String string) {
        this.userId = string;
    }

    public String getTinyId() {
        return this.tinyId;
    }

    public void setTinyId(String string) {
        this.tinyId = string;
    }

    private String byteArrayToHexStr(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        char[] cArray = "0123456789ABCDEF".toCharArray();
        char[] cArray2 = new char[byArray.length * 2];
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            int n2 = byArray[i2] & 0xFF;
            cArray2[i2 * 2] = cArray[n2 >>> 4];
            cArray2[i2 * 2 + 1] = cArray[n2 & 0xF];
        }
        return new String(cArray2);
    }

    private byte[] hexStrToByteArray(String string) {
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            return new byte[0];
        }
        byte[] byArray = new byte[string.length() / 2];
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            String string2 = string.substring(2 * i2, 2 * i2 + 2);
            byArray[i2] = (byte)Integer.parseInt(string2, 16);
        }
        return byArray;
    }

    public void setToken(Context context, byte[] byArray) {
        this.token = byArray;
        try {
            SharedPreferences.Editor editor = context.getSharedPreferences(TRTC_INFO, 0).edit();
            if (this.token != null) {
                String string = this.byteArrayToHexStr(this.token);
                editor.putString(TOKEN, string);
            } else {
                editor.clear();
            }
            editor.commit();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public byte[] getToken(Context context) {
        try {
            if (this.token == null) {
                SharedPreferences sharedPreferences = context.getSharedPreferences(TRTC_INFO, 0);
                String string = sharedPreferences.getString(TOKEN, "");
                this.token = this.hexStrToByteArray(string);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.token;
    }

    public long getRoomElapsed() {
        return System.currentTimeMillis() - this.enterTime;
    }

    public synchronized void addUserInfo(String string, UserInfo userInfo) {
        this.userList.put(string, userInfo);
    }

    public synchronized void removeRenderInfo(String string) {
        UserInfo userInfo = this.userList.get(string);
        this.recvFirstIFrameCntList.remove(userInfo.tinyID);
        this.userList.remove(string);
    }

    public synchronized UserInfo getUser(String string) {
        return this.userList.get(string);
    }

    public synchronized String getUserIdByTinyId(long l2) {
        HashMap<String, UserInfo> hashMap = this.userList;
        for (Map.Entry<String, UserInfo> entry : hashMap.entrySet()) {
            UserInfo userInfo = entry.getValue();
            if (userInfo == null || userInfo.tinyID != l2) continue;
            return userInfo.userID;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void forEachUser(UserAction userAction) {
        HashMap<String, UserInfo> hashMap = new HashMap<String, UserInfo>(this.userList.size());
        TRTCRoomInfo tRTCRoomInfo = this;
        synchronized (tRTCRoomInfo) {
            hashMap.putAll(this.userList);
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            if (userAction == null || entry.getValue() == null) continue;
            userAction.accept((String)entry.getKey(), (UserInfo)entry.getValue());
        }
    }

    public synchronized void clearUserList() {
        this.userList.clear();
        this.recvFirstIFrameCntList.clear();
    }

    public synchronized int recvFirstIFrame(long l2) {
        Integer n2 = this.recvFirstIFrameCntList.get(l2);
        this.recvFirstIFrameCntList.put(l2, n2 == null ? 1 : n2 + 1);
        return n2 == null ? 1 : n2 + 1;
    }

    public synchronized boolean hasRecvFirstIFrame(long l2) {
        Integer n2 = this.recvFirstIFrameCntList.get(l2);
        return n2 != null && n2 > 0;
    }

    public void micStart(boolean bl) {
        this.micHasStartd = bl;
    }

    public synchronized boolean isMicStard() {
        return this.micHasStartd;
    }

    public synchronized void setRoomExit(boolean bl, int n2) {
        this.hasExitedRoom = bl;
        this.exitRoomCode = n2;
    }

    public synchronized boolean isRoomExit() {
        return this.hasExitedRoom;
    }

    public synchronized int getRoomExitCode() {
        return this.exitRoomCode;
    }

    public static boolean isMuteMainVideo(int n2) {
        return (n2 & 0x10) != 0;
    }

    public static boolean isMuteSubVideo(int n2) {
        return (n2 & 0x20) != 0;
    }

    public static boolean isMuteAudio(int n2) {
        return (n2 & 0x40) != 0;
    }

    public static boolean hasMainVideo(int n2) {
        return (n2 & 1) != 0;
    }

    public static boolean hasSmallVideo(int n2) {
        return (n2 & 2) != 0;
    }

    public static boolean hasSubVideo(int n2) {
        return (n2 & 4) != 0;
    }

    public static boolean hasAudio(int n2) {
        return (n2 & 8) != 0;
    }

    static interface UserAction {
        public void accept(String var1, UserInfo var2);
    }

    public static class UserInfo {
        public long tinyID;
        public String strTinyID;
        public String userID;
        public int terminalType;
        public RenderInfo mainRender = new RenderInfo();
        public RenderInfo subRender = new RenderInfo();
        public int streamType = 2;
        public TRTCCloud.TRTCViewMargin debugMargin = new TRTCCloud.TRTCViewMargin(0.0f, 0.0f, 0.1f, 0.0f);
        public int streamState;

        public UserInfo(long l2, String string, int n2, int n3) {
            this.tinyID = l2;
            this.strTinyID = "" + l2;
            this.userID = string;
            this.terminalType = n2;
            this.streamState = n3;
            this.mainRender.tinyID = l2;
            this.subRender.tinyID = l2;
        }
    }

    public static class RenderInfo
    implements SurfaceHolder.Callback {
        public long tinyID;
        public TXCRenderAndDec render = null;
        public TXCloudVideoView view = null;
        public boolean muteVideo = false;

        public void surfaceCreated(SurfaceHolder surfaceHolder) {
            TXCLog.i("RenderInfo", "trtc_api startRemoteView surfaceCreated " + surfaceHolder.getSurface() + ", " + this.tinyID + ", " + this.render);
            if (surfaceHolder.getSurface().isValid()) {
                e e2;
                e e3 = e2 = this.render != null ? this.render.getVideoRender() : null;
                if (e2 != null) {
                    e2.a(surfaceHolder.getSurface());
                }
            }
        }

        public void surfaceChanged(SurfaceHolder surfaceHolder, int n2, int n3, int n4) {
            e e2;
            TXCLog.i("RenderInfo", "trtc_api startRemoteView surfaceChanged " + surfaceHolder.getSurface() + " width " + n3 + ", height " + n4 + ", " + this.tinyID + ", " + this.render);
            e e3 = e2 = this.render != null ? this.render.getVideoRender() : null;
            if (e2 != null) {
                e2.c(n3, n4);
            }
        }

        public void surfaceDestroyed(SurfaceHolder surfaceHolder) {
            e e2;
            TXCLog.i("RenderInfo", "trtc_api startRemoteView surfaceDestroyed " + surfaceHolder.getSurface() + ", " + this.tinyID + ", " + this.render);
            e e3 = e2 = this.render != null ? this.render.getVideoRender() : null;
            if (e2 != null) {
                e2.a((Surface)null);
            }
        }

        public void stop() {
            try {
                if (this.view != null && this.view.getSurfaceView() != null && this.view.getSurfaceView().getHolder() != null) {
                    this.view.getSurfaceView().getHolder().removeCallback((SurfaceHolder.Callback)this);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

