/*
 * Decompiled with CFR 0.152.
 */
package com.github.uniapp_kill_service_plugin;

import android.content.Context;
import android.content.Intent;
import android.util.Log;
import com.github.uniapp_kill_service_plugin.JsJob;
import com.ykun.live_library.KeepAliveManager;
import com.ykun.live_library.R;
import com.ykun.live_library.config.ForegroundNotification;
import com.ykun.live_library.config.ForegroundNotificationClickListener;
import com.ykun.live_library.utils.SPUtils;

public class GlobalConfig {
    public static String title;
    public static String content;
    public static int time;
    public static boolean autoStart;
    public static boolean autoWakeUp;
    public static int mode;
    public static int icon;
    public static boolean goBackToAppUI;
    public static JsJob jsCall;

    public static void saveConfig(Context context) {
        SPUtils sp = SPUtils.getInstance(context, "kill_servier");
        SPUtils.putI("time", time);
        sp.put("title", title);
        sp.put("content", content);
        sp.put("mode", mode);
        sp.put("autoWakeUp", autoWakeUp);
        sp.put("autoStart", autoStart);
        sp.put("icon", icon);
    }

    public static void restore(Context context) {
        SPUtils sp = SPUtils.getInstance(context, "kill_servier");
        time = sp.getInt("time", 3000);
        title = sp.getString("title", "\u8fdb\u7a0b\u5b88\u62a4");
        content = sp.getString("content", "\u6211\u4e0d\u60f3\u88ab\u6740\u5440");
        mode = sp.getInt("mode", 0);
        autoWakeUp = sp.getBool("autoWakeUp", false);
        autoStart = sp.getBool("autoStart", false);
        icon = sp.getInt("icon", R.drawable.ic_launcher);
    }

    public static void showMainUI(Context context) {
        Intent intent = new Intent();
        try {
            intent.setClassName(context.getPackageName(), "io.dcloud.PandoraEntry");
            intent.setFlags(0x4000000);
            context.startActivity(intent);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void startService(Context application) {
        GlobalConfig.restore(application);
        KeepAliveManager.toKeepAlive(application, mode, title, content, icon, new ForegroundNotification(new ForegroundNotificationClickListener(){

            @Override
            public void foregroundNotificationClick(Context context, Intent intent) {
                Log.d((String)"JOB-->", (String)" foregroundNotificationClick");
                if (goBackToAppUI) {
                    GlobalConfig.showMainUI(context);
                }
            }
        }));
    }

    static {
        autoStart = true;
        goBackToAppUI = true;
    }
}

