/*
 * Decompiled with CFR 0.152.
 */
package com.github.uniapp_kill_service_plugin;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.os.PowerManager;
import android.support.annotation.RequiresApi;
import android.util.Log;
import com.alibaba.fastjson.JSONObject;
import com.github.uniapp_kill_service_plugin.GlobalConfig;
import com.github.uniapp_kill_service_plugin.JsJob;
import com.taobao.weex.annotation.JSMethod;
import com.taobao.weex.common.WXModule;
import com.ykun.live_library.KeepAliveManager;
import com.ykun.live_library.config.KeepAliveConfig;
import com.ykun.live_library.utils.SPUtils;

public class WhiteListModal
extends WXModule
implements JsJob {
    @JSMethod
    public void config(JSONObject config) {
        Activity activity = (Activity)this.mWXSDKInstance.getContext();
        GlobalConfig.title = config.getString("title");
        GlobalConfig.content = config.getString("content");
        GlobalConfig.mode = config.getIntValue("mode");
        GlobalConfig.icon = activity.getResources().getIdentifier("icon", "drawable", activity.getPackageName());
        if (GlobalConfig.mode != 0 && GlobalConfig.mode != 1) {
            GlobalConfig.mode = 1;
        }
        this.closeService();
        GlobalConfig.saveConfig((Context)activity);
        GlobalConfig.jsCall = this;
    }

    public void onActivityDestroy() {
        super.onActivityDestroy();
        GlobalConfig.jsCall = null;
    }

    @JSMethod
    public void showSafeSetting() {
        Activity activity = (Activity)this.mWXSDKInstance.getContext();
        KeepAliveManager.launcherSyskeepAlive((Context)activity);
    }

    @JSMethod
    public void closeService() {
        Activity activity = (Activity)this.mWXSDKInstance.getContext();
        KeepAliveManager.stopWork((Context)activity.getApplication());
        GlobalConfig.jsCall = null;
    }

    @JSMethod
    public void startService() {
        Activity activity = (Activity)this.mWXSDKInstance.getContext();
        GlobalConfig.startService((Context)activity);
        GlobalConfig.jsCall = this;
        SPUtils.getInstance((Context)activity, KeepAliveConfig.SP_NAME).put("autoStart", true);
    }

    @JSMethod
    public void requestIgnoreLimit() {
        if (Build.VERSION.SDK_INT >= 23) {
            this.tryRequestBatteryOptimizations(this.mWXSDKInstance.getContext());
        }
    }

    @JSMethod(uiThread=false)
    public JSONObject checkIfLimited() {
        boolean isIgnoring = false;
        if (Build.VERSION.SDK_INT >= 23) {
            isIgnoring = this.isIgnoringBatteryOptimizations(this.mWXSDKInstance.getContext());
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("isLimit", (Object)(!isIgnoring ? 1 : 0));
        return jsonObject;
    }

    @RequiresApi(api=23)
    private boolean isIgnoringBatteryOptimizations(Context application) {
        boolean isIgnoring = false;
        PowerManager powerManager = (PowerManager)application.getSystemService("power");
        if (powerManager != null) {
            isIgnoring = powerManager.isIgnoringBatteryOptimizations(application.getPackageName());
        }
        return isIgnoring;
    }

    @RequiresApi(api=23)
    private void tryRequestBatteryOptimizations(Context application) {
        KeepAliveManager.batteryOptimizations(application);
        Log.e((String)"petter", (String)("permisson =" + this.isIgnoringBatteryOptimizations(application)));
    }

    @Override
    public void doJob() {
        if (this.mWXSDKInstance != null) {
            this.mWXSDKInstance.fireGlobalEventCallback("doJob", null);
        }
        Log.e((String)"petter", (String)"call fireGlobalEventCallback");
    }
}

