/*
 * Decompiled with CFR 0.152.
 */
package com.ykun.live_library;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.support.annotation.NonNull;

public class DevicesLaunchConfig {
    private static Context mContext;

    public static void launchSystemKeepAlive(Context context) {
        mContext = context.getApplicationContext();
        if (DevicesLaunchConfig.isHuawei()) {
            DevicesLaunchConfig.goHuaweiSetting();
        } else if (DevicesLaunchConfig.isLeTV()) {
            DevicesLaunchConfig.goLetvSetting();
        } else if (DevicesLaunchConfig.isMeizu()) {
            DevicesLaunchConfig.goMeizuSetting();
        } else if (DevicesLaunchConfig.isSamsung()) {
            DevicesLaunchConfig.goSamsungSetting();
        } else if (DevicesLaunchConfig.isVIVO()) {
            DevicesLaunchConfig.goVIVOSetting();
        } else if (DevicesLaunchConfig.isXiaomi()) {
            DevicesLaunchConfig.goXiaomiSetting();
        } else if (DevicesLaunchConfig.isOPPO()) {
            DevicesLaunchConfig.goOPPOSetting();
        } else if (DevicesLaunchConfig.isSmartisan()) {
            DevicesLaunchConfig.goSmartisanSetting();
        }
    }

    private static boolean isHuawei() {
        if (Build.BRAND == null) {
            return false;
        }
        return Build.BRAND.toLowerCase().equals("huawei") || Build.BRAND.toLowerCase().equals("honor");
    }

    private static void goHuaweiSetting() {
        try {
            DevicesLaunchConfig.showActivity("com.huawei.systemmanager", "com.huawei.systemmanager.startupmgr.ui.StartupNormalAppListActivity");
        }
        catch (Exception e) {
            DevicesLaunchConfig.showActivity("com.huawei.systemmanager", "com.huawei.systemmanager.optimize.bootstart.BootStartActivity");
        }
    }

    public static boolean isXiaomi() {
        return Build.BRAND != null && Build.BRAND.toLowerCase().equals("xiaomi");
    }

    private static void goXiaomiSetting() {
        DevicesLaunchConfig.showActivity("com.miui.securitycenter", "com.miui.permcenter.autostart.AutoStartManagementActivity");
    }

    public static boolean isOPPO() {
        return Build.BRAND != null && Build.BRAND.toLowerCase().equals("oppo");
    }

    private static void goOPPOSetting() {
        try {
            DevicesLaunchConfig.showActivity("com.coloros.phonemanager");
        }
        catch (Exception e1) {
            try {
                DevicesLaunchConfig.showActivity("com.oppo.safe");
            }
            catch (Exception e2) {
                try {
                    DevicesLaunchConfig.showActivity("com.coloros.oppoguardelf");
                }
                catch (Exception e3) {
                    DevicesLaunchConfig.showActivity("com.coloros.safecenter");
                }
            }
        }
    }

    public static boolean isVIVO() {
        return Build.BRAND != null && Build.BRAND.toLowerCase().equals("vivo");
    }

    private static void goVIVOSetting() {
        DevicesLaunchConfig.showActivity("com.iqoo.secure");
    }

    public static boolean isMeizu() {
        return Build.BRAND != null && Build.BRAND.toLowerCase().equals("meizu");
    }

    private static void goMeizuSetting() {
        DevicesLaunchConfig.showActivity("com.meizu.safe");
    }

    public static boolean isSamsung() {
        return Build.BRAND != null && Build.BRAND.toLowerCase().equals("samsung");
    }

    private static void goSamsungSetting() {
        try {
            DevicesLaunchConfig.showActivity("com.samsung.android.sm_cn");
        }
        catch (Exception e) {
            DevicesLaunchConfig.showActivity("com.samsung.android.sm");
        }
    }

    public static boolean isLeTV() {
        return Build.BRAND != null && Build.BRAND.toLowerCase().equals("letv");
    }

    private static void goLetvSetting() {
        DevicesLaunchConfig.showActivity("com.letv.android.letvsafe", "com.letv.android.letvsafe.AutobootManageActivity");
    }

    public static boolean isSmartisan() {
        return Build.BRAND != null && Build.BRAND.toLowerCase().equals("smartisan");
    }

    private static void goSmartisanSetting() {
        DevicesLaunchConfig.showActivity("com.smartisanos.security");
    }

    private static void showActivity(@NonNull String packageName) {
        Intent intent = mContext.getPackageManager().getLaunchIntentForPackage(packageName);
        mContext.startActivity(intent);
    }

    private static void showActivity(@NonNull String packageName, @NonNull String activityDir) {
        Intent intent = new Intent();
        intent.setComponent(new ComponentName(packageName, activityDir));
        intent.addFlags(0x10000000);
        mContext.startActivity(intent);
    }
}

