/*
 * Decompiled with CFR 0.152.
 */
package com.ykun.live_library;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.PowerManager;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import android.util.Log;
import com.ykun.live_library.DevicesLaunchConfig;
import com.ykun.live_library.config.ForegroundNotification;
import com.ykun.live_library.config.KeepAliveConfig;
import com.ykun.live_library.config.NotificationUtils;
import com.ykun.live_library.config.RunMode;
import com.ykun.live_library.service.JobHandlerService;
import com.ykun.live_library.service.LocalService;
import com.ykun.live_library.service.RemoteService;
import com.ykun.live_library.utils.KeepAliveUtils;
import com.ykun.live_library.utils.SPUtils;

public class KeepAliveManager {
    private static final String TAG = "KeepAliveManager";

    public static void toKeepAlive(@NonNull Context application, @NonNull int runMode, String title, String content, int res_icon, ForegroundNotification foregroundNotification) {
        if (KeepAliveUtils.isRunning(application)) {
            KeepAliveConfig.foregroundNotification = foregroundNotification;
            SPUtils.getInstance(application, KeepAliveConfig.SP_NAME).put(KeepAliveConfig.TITLE, title);
            SPUtils.getInstance(application, KeepAliveConfig.SP_NAME).put(KeepAliveConfig.CONTENT, content);
            SPUtils.getInstance(application, KeepAliveConfig.SP_NAME).put(KeepAliveConfig.RES_ICON, res_icon);
            SPUtils.getInstance(application, KeepAliveConfig.SP_NAME).put("RUN_MODE", runMode);
            RunMode.setShape(runMode);
            KeepAliveConfig.runMode = RunMode.getShape();
            if (Build.VERSION.SDK_INT >= 21) {
                JobHandlerService.startJob(application);
            } else {
                Intent localIntent = new Intent(application, LocalService.class);
                Intent guardIntent = new Intent(application, RemoteService.class);
                if (Build.VERSION.SDK_INT >= 26) {
                    application.startForegroundService(localIntent);
                    application.startForegroundService(guardIntent);
                } else {
                    application.startService(localIntent);
                    application.startService(guardIntent);
                }
            }
        }
    }

    public static void stopWork(Context application) {
        try {
            KeepAliveConfig.foregroundNotification = null;
            KeepAliveConfig.keepLiveService = null;
            KeepAliveConfig.runMode = RunMode.getShape();
            JobHandlerService.stopJob();
            Intent localIntent = new Intent(application, LocalService.class);
            Intent guardIntent = new Intent(application, RemoteService.class);
            application.stopService(localIntent);
            application.stopService(guardIntent);
            application.stopService(new Intent(application, JobHandlerService.class));
            SPUtils.getInstance(application, KeepAliveConfig.SP_NAME).put("autoStart", false);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("stopWork-->" + e.getMessage()));
        }
    }

    public static void sendNotification(Context context, String title, String content, int icon, Intent intent2) {
        NotificationUtils.sendNotification(context, title, content, icon, intent2);
    }

    public static void launcherSyskeepAlive(Context cex) {
        DevicesLaunchConfig.launchSystemKeepAlive(cex);
    }

    @RequiresApi(api=23)
    public static void batteryOptimizations(Context context) {
        if (!KeepAliveManager.isIgnoringBatteryOptimizations(context)) {
            KeepAliveManager.requestIgnoreBatteryOptimizations(context);
        }
    }

    @RequiresApi(api=23)
    private static boolean isIgnoringBatteryOptimizations(Context context) {
        boolean isIgnoring = false;
        PowerManager powerManager = (PowerManager)context.getSystemService("power");
        if (powerManager != null) {
            isIgnoring = powerManager.isIgnoringBatteryOptimizations(context.getPackageName());
        }
        return isIgnoring;
    }

    @RequiresApi(api=23)
    private static void requestIgnoreBatteryOptimizations(Context context) {
        try {
            Intent intent = new Intent("android.settings.REQUEST_IGNORE_BATTERY_OPTIMIZATIONS");
            intent.setData(Uri.parse((String)("package:" + context.getPackageName())));
            intent.addFlags(0x10000000);
            context.startActivity(intent);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

