/*
 * Decompiled with CFR 0.152.
 */
package com.ykun.live_library.config;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.Intent;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import android.support.v4.app.NotificationCompat;
import android.text.TextUtils;
import com.ykun.live_library.R;
import java.util.Random;

public class NotificationUtils
extends ContextWrapper {
    private NotificationManager manager;
    private String id;
    private String name;
    private Context mContext;
    private NotificationChannel channel;

    private NotificationUtils(Context context) {
        super(context);
        this.mContext = context;
        this.id = this.mContext.getPackageName();
        this.name = this.mContext.getPackageName();
    }

    @RequiresApi(api=26)
    public void createNotificationChannel() {
        if (this.channel == null) {
            this.channel = new NotificationChannel(this.id, (CharSequence)this.name, 4);
            this.channel.enableVibration(false);
            this.channel.enableLights(false);
            this.channel.enableVibration(false);
            this.channel.setVibrationPattern(new long[]{0L});
            this.channel.setSound(null, null);
            this.getManager().createNotificationChannel(this.channel);
        }
    }

    private NotificationManager getManager() {
        if (this.manager == null) {
            this.manager = (NotificationManager)this.mContext.getSystemService("notification");
        }
        return this.manager;
    }

    @RequiresApi(api=26)
    public Notification.Builder getChannelNotification(String title, String content, int icon, Intent intent) {
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)this.mContext, (int)0, (Intent)intent, (int)0x8000000);
        if (TextUtils.isEmpty((CharSequence)title)) {
            title = this.mContext.getApplicationInfo().name;
        }
        if (TextUtils.isEmpty((CharSequence)content)) {
            content = this.mContext.getApplicationInfo().name;
        }
        if (icon == 0) {
            icon = R.drawable.ic_launcher;
        }
        return new Notification.Builder(this.mContext, this.id).setContentTitle((CharSequence)title).setContentText((CharSequence)content).setSmallIcon(icon).setAutoCancel(true).setContentIntent(pendingIntent);
    }

    public NotificationCompat.Builder getNotification_25(String title, String content, int icon, Intent intent) {
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)this.mContext, (int)0, (Intent)intent, (int)0x8000000);
        return new NotificationCompat.Builder(this.mContext, this.id).setContentTitle((CharSequence)title).setContentText((CharSequence)content).setSmallIcon(icon).setAutoCancel(true).setVibrate(new long[]{0L}).setContentIntent(pendingIntent);
    }

    public static void sendNotification(@NonNull Context context, @NonNull String title, @NonNull String content, @NonNull int icon, @NonNull Intent intent) {
        NotificationUtils notificationUtils = new NotificationUtils(context);
        Notification notification = null;
        if (Build.VERSION.SDK_INT >= 26) {
            notificationUtils.createNotificationChannel();
            notification = notificationUtils.getChannelNotification(title, content, icon, intent).build();
        } else {
            notification = notificationUtils.getNotification_25(title, content, icon, intent).build();
        }
        notificationUtils.getManager().notify(new Random().nextInt(10000), notification);
    }

    public static Notification createNotification(@NonNull Context context, @NonNull String title, @NonNull String content, @NonNull int icon, @NonNull Intent intent) {
        NotificationUtils notificationUtils = new NotificationUtils(context);
        Notification notification = null;
        if (Build.VERSION.SDK_INT >= 26) {
            notificationUtils.createNotificationChannel();
            notification = notificationUtils.getChannelNotification(title, content, icon, intent).build();
        } else {
            notification = notificationUtils.getNotification_25(title, content, icon, intent).build();
        }
        return notification;
    }
}

