/*
 * Decompiled with CFR 0.152.
 */
package com.ykun.live_library.pro_sp;

import android.os.Bundle;
import android.support.annotation.NonNull;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

class OpEntry {
    static final int OP_TYPE_GET = 1;
    static final int OP_TYPE_PUT = 2;
    static final int OP_TYPE_CLEAR = 3;
    static final int OP_TYPE_REMOVE = 4;
    static final int OP_TYPE_COMMIT = 5;
    static final int OP_TYPE_APPLY = 6;
    static final int VALUE_TYPE_STRING = 1;
    static final int VALUE_TYPE_INT = 2;
    static final int VALUE_TYPE_LONG = 3;
    static final int VALUE_TYPE_FLOAT = 4;
    static final int VALUE_TYPE_BOOLEAN = 5;
    static final int VALUE_TYPE_STRING_SET = 6;
    static final String KEY_KEY = "key_key";
    static final String KEY_VALUE = "key_value";
    static final String KEY_VALUE_TYPE = "key_value_type";
    static final String KEY_OP_TYPE = "key_op_type";
    @NonNull
    private Bundle bundle;

    private OpEntry() {
        this.bundle = new Bundle();
    }

    public OpEntry(@NonNull Bundle bundle) {
        this.bundle = bundle;
    }

    public String getKey() {
        return this.bundle.getString(KEY_KEY, null);
    }

    public OpEntry setKey(String key) {
        this.bundle.putString(KEY_KEY, key);
        return this;
    }

    public int getValueType() {
        return this.bundle.getInt(KEY_VALUE_TYPE, 0);
    }

    public OpEntry setValueType(int valueType) {
        this.bundle.putInt(KEY_VALUE_TYPE, valueType);
        return this;
    }

    public int getOpType() {
        return this.bundle.getInt(KEY_OP_TYPE, 0);
    }

    public OpEntry setOpType(int opType) {
        this.bundle.putInt(KEY_OP_TYPE, opType);
        return this;
    }

    public String getStringValue(String defValue) {
        return this.bundle.getString(KEY_VALUE, defValue);
    }

    public OpEntry setStringValue(String value) {
        this.bundle.putInt(KEY_VALUE_TYPE, 1);
        this.bundle.putString(KEY_VALUE, value);
        return this;
    }

    public int getIntValue(int defValue) {
        return this.bundle.getInt(KEY_VALUE, defValue);
    }

    public OpEntry setIntValue(int value) {
        this.bundle.putInt(KEY_VALUE_TYPE, 2);
        this.bundle.putInt(KEY_VALUE, value);
        return this;
    }

    public long getLongValue(long defValue) {
        return this.bundle.getLong(KEY_VALUE, defValue);
    }

    public OpEntry setLongValue(long value) {
        this.bundle.putInt(KEY_VALUE_TYPE, 3);
        this.bundle.putLong(KEY_VALUE, value);
        return this;
    }

    public float getFloatValue(float defValue) {
        return this.bundle.getFloat(KEY_VALUE);
    }

    public OpEntry setFloatValue(float value) {
        this.bundle.putInt(KEY_VALUE_TYPE, 4);
        this.bundle.putFloat(KEY_VALUE, value);
        return this;
    }

    public boolean getBooleanValue(boolean defValue) {
        return this.bundle.getBoolean(KEY_VALUE, defValue);
    }

    public OpEntry setBooleanValue(boolean value) {
        this.bundle.putInt(KEY_VALUE_TYPE, 5);
        this.bundle.putBoolean(KEY_VALUE, value);
        return this;
    }

    public Set<String> getStringSet() {
        ArrayList list = this.bundle.getStringArrayList(KEY_VALUE);
        return list == null ? null : new HashSet(list);
    }

    public Bundle getBundle() {
        return this.bundle;
    }

    public OpEntry setStringSettingsValue(Set<String> value) {
        this.bundle.putInt(KEY_VALUE_TYPE, 6);
        this.bundle.putStringArrayList(KEY_VALUE, (ArrayList)(value == null ? null : new ArrayList<String>(value)));
        return this;
    }

    static OpEntry obtainGetOperation(String key) {
        return new OpEntry().setKey(key).setOpType(1);
    }

    static OpEntry obtainPutOperation(String key) {
        return new OpEntry().setKey(key).setOpType(2);
    }

    static OpEntry obtainRemoveOperation(String key) {
        return new OpEntry().setKey(key).setOpType(4);
    }

    static OpEntry obtainClear() {
        return new OpEntry().setOpType(3);
    }
}

