/*
 * Decompiled with CFR 0.152.
 */
package com.ykun.live_library.pro_sp;

import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.Context;
import android.content.SharedPreferences;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import android.os.Process;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.ArrayMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class SharedPreferenceProvider
extends ContentProvider {
    private Map<String, MethodProcess> processerMap = new ArrayMap();
    private MethodProcess methodQueryPid = new MethodProcess(){

        @Override
        public Bundle process(@Nullable String arg, @Nullable Bundle extras) {
            Bundle bundle = new Bundle();
            bundle.putInt("key_result", Process.myPid());
            return bundle;
        }
    };
    private MethodProcess methodQueryValues = new MethodProcess(){

        @Override
        public Bundle process(@Nullable String arg, @Nullable Bundle extras) {
            if (extras == null) {
                throw new IllegalArgumentException("methodQueryValues, extras is null!");
            }
            Context ctx = SharedPreferenceProvider.this.getContext();
            if (ctx == null) {
                throw new IllegalArgumentException("methodQueryValues, ctx is null!");
            }
            String key = extras.getString("key_key");
            SharedPreferences preferences = ctx.getSharedPreferences(arg, 0);
            int valueType = extras.getInt("key_value_type");
            switch (valueType) {
                case 5: {
                    boolean value = preferences.getBoolean(key, extras.getBoolean("key_value"));
                    extras.putBoolean("key_value", value);
                    return extras;
                }
                case 4: {
                    float value = preferences.getFloat(key, extras.getFloat("key_value"));
                    extras.putFloat("key_value", value);
                    return extras;
                }
                case 2: {
                    int value = preferences.getInt(key, extras.getInt("key_value"));
                    extras.putInt("key_value", value);
                    return extras;
                }
                case 3: {
                    long value = preferences.getLong(key, extras.getLong("key_value"));
                    extras.putLong("key_value", value);
                    return extras;
                }
                case 1: {
                    String value = preferences.getString(key, extras.getString("key_value"));
                    extras.putString("key_value", value);
                    return extras;
                }
                case 6: {
                    Set value = preferences.getStringSet(key, null);
                    extras.putStringArrayList("key_value", value == null ? null : new ArrayList(value));
                    return extras;
                }
            }
            throw new IllegalArgumentException("unknown valueType:" + valueType);
        }
    };
    private MethodProcess methodContainKey = new MethodProcess(){

        @Override
        public Bundle process(@Nullable String arg, @Nullable Bundle extras) {
            if (extras == null) {
                throw new IllegalArgumentException("methodQueryValues, extras is null!");
            }
            Context ctx = SharedPreferenceProvider.this.getContext();
            if (ctx == null) {
                throw new IllegalArgumentException("methodQueryValues, ctx is null!");
            }
            String key = extras.getString("key_key");
            SharedPreferences preferences = ctx.getSharedPreferences(arg, 0);
            extras.putBoolean("key_result", preferences.contains(key));
            return extras;
        }
    };
    private MethodProcess methodEditor = new MethodProcess(){

        @Override
        public Bundle process(@Nullable String arg, @Nullable Bundle extras) {
            if (extras == null) {
                throw new IllegalArgumentException("methodQueryValues, extras is null!");
            }
            Context ctx = SharedPreferenceProvider.this.getContext();
            if (ctx == null) {
                throw new IllegalArgumentException("methodQueryValues, ctx is null!");
            }
            SharedPreferences preferences = ctx.getSharedPreferences(arg, 0);
            ArrayList ops = extras.getParcelableArrayList("key_result");
            if (ops == null) {
                ops = new ArrayList();
            }
            SharedPreferences.Editor editor = preferences.edit();
            block5: for (Bundle opBundler : ops) {
                int opType = opBundler.getInt("key_op_type");
                switch (opType) {
                    case 2: {
                        editor = this.editValue(editor, opBundler);
                        continue block5;
                    }
                    case 4: {
                        editor = editor.remove(opBundler.getString("key_key"));
                        continue block5;
                    }
                    case 3: {
                        editor = editor.clear();
                        continue block5;
                    }
                }
                throw new IllegalArgumentException("unkonw op type:" + opType);
            }
            int applyOrCommit = extras.getInt("key_op_type");
            if (applyOrCommit == 6) {
                editor.apply();
                return null;
            }
            if (applyOrCommit == 5) {
                boolean res = editor.commit();
                Bundle bundle = new Bundle();
                bundle.putBoolean("key_result", res);
                return bundle;
            }
            throw new IllegalArgumentException("unknown applyOrCommit:" + applyOrCommit);
        }

        private SharedPreferences.Editor editValue(SharedPreferences.Editor editor, Bundle opBundle) {
            String key = opBundle.getString("key_key");
            int valueType = opBundle.getInt("key_value_type");
            switch (valueType) {
                case 5: {
                    return editor.putBoolean(key, opBundle.getBoolean("key_value"));
                }
                case 4: {
                    return editor.putFloat(key, opBundle.getFloat("key_value"));
                }
                case 2: {
                    return editor.putInt(key, opBundle.getInt("key_value"));
                }
                case 3: {
                    return editor.putLong(key, opBundle.getLong("key_value"));
                }
                case 1: {
                    return editor.putString(key, opBundle.getString("key_value"));
                }
                case 6: {
                    ArrayList list = opBundle.getStringArrayList("key_value");
                    if (list == null) {
                        return editor.putStringSet(key, null);
                    }
                    return editor.putStringSet(key, new HashSet(list));
                }
            }
            throw new IllegalArgumentException("unknown valueType:" + valueType);
        }
    };

    public boolean onCreate() {
        this.processerMap.put("method_query_value", this.methodQueryValues);
        this.processerMap.put("method_contain_key", this.methodContainKey);
        this.processerMap.put("method_edit", this.methodEditor);
        this.processerMap.put("method_query_pid", this.methodQueryPid);
        return true;
    }

    @Nullable
    public Cursor query(@NonNull Uri uri, @Nullable String[] projection, @Nullable String selection, @Nullable String[] selectionArgs, @Nullable String sortOrder) {
        throw new UnsupportedOperationException();
    }

    @Nullable
    public String getType(@NonNull Uri uri) {
        throw new UnsupportedOperationException();
    }

    @Nullable
    public Uri insert(@NonNull Uri uri, @Nullable ContentValues values) {
        throw new UnsupportedOperationException();
    }

    public int delete(@NonNull Uri uri, @Nullable String selection, @Nullable String[] selectionArgs) {
        throw new UnsupportedOperationException();
    }

    public int update(@NonNull Uri uri, @Nullable ContentValues values, @Nullable String selection, @Nullable String[] selectionArgs) {
        throw new UnsupportedOperationException();
    }

    @Nullable
    public Bundle call(@NonNull String method, @Nullable String arg, @Nullable Bundle extras) {
        MethodProcess processer = this.processerMap.get(method);
        return processer == null ? null : processer.process(arg, extras);
    }

    public static interface MethodProcess {
        public Bundle process(@Nullable String var1, @Nullable Bundle var2);
    }
}

