/*
 * Decompiled with CFR 0.152.
 */
package com.ykun.live_library.pro_sp;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.os.Process;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.ArrayMap;
import com.ykun.live_library.pro_sp.OpEntry;
import com.ykun.live_library.pro_sp.PreferenceUtil;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public class SharedPreferenceProxy
implements SharedPreferences {
    private static Map<String, SharedPreferenceProxy> sharedPreferenceProxyMap;
    private static AtomicInteger processFlag;
    private Context ctx;
    private String preferName;

    private SharedPreferenceProxy(Context ctx, String name) {
        this.ctx = ctx.getApplicationContext();
        this.preferName = name;
    }

    public Map<String, ?> getAll() {
        throw new UnsupportedOperationException("Not support method getAll");
    }

    @Nullable
    public String getString(String key, @Nullable String defValue) {
        OpEntry result = this.getResult(OpEntry.obtainGetOperation(key).setStringValue(defValue));
        return result == null ? defValue : result.getStringValue(defValue);
    }

    @Nullable
    public Set<String> getStringSet(String key, @Nullable Set<String> defValues) {
        OpEntry result = this.getResult(OpEntry.obtainGetOperation(key).setStringSettingsValue(defValues));
        if (result == null) {
            return defValues;
        }
        Set<String> set = result.getStringSet();
        if (set == null) {
            return defValues;
        }
        return set;
    }

    public int getInt(String key, int defValue) {
        OpEntry result = this.getResult(OpEntry.obtainGetOperation(key).setIntValue(defValue));
        return result == null ? defValue : result.getIntValue(defValue);
    }

    public long getLong(String key, long defValue) {
        OpEntry result = this.getResult(OpEntry.obtainGetOperation(key).setLongValue(defValue));
        return result == null ? defValue : result.getLongValue(defValue);
    }

    public float getFloat(String key, float defValue) {
        OpEntry result = this.getResult(OpEntry.obtainGetOperation(key).setFloatValue(defValue));
        return result == null ? defValue : result.getFloatValue(defValue);
    }

    public boolean getBoolean(String key, boolean defValue) {
        OpEntry result = this.getResult(OpEntry.obtainGetOperation(key).setBooleanValue(defValue));
        return result == null ? defValue : result.getBooleanValue(defValue);
    }

    public boolean contains(String key) {
        Bundle input = new Bundle();
        input.putString("key_key", key);
        try {
            Bundle res = this.ctx.getContentResolver().call(PreferenceUtil.URI, "method_contain_key", this.preferName, input);
            return res.getBoolean("key_result");
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public SharedPreferences.Editor edit() {
        return new EditorImpl();
    }

    public void registerOnSharedPreferenceChangeListener(SharedPreferences.OnSharedPreferenceChangeListener listener) {
        throw new UnsupportedOperationException();
    }

    public void unregisterOnSharedPreferenceChangeListener(SharedPreferences.OnSharedPreferenceChangeListener listener) {
        throw new UnsupportedOperationException();
    }

    private OpEntry getResult(@NonNull OpEntry input) {
        try {
            Bundle res = this.ctx.getContentResolver().call(PreferenceUtil.URI, "method_query_value", this.preferName, input.getBundle());
            return new OpEntry(res);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static SharedPreferences getSharedPreferences(@NonNull Context ctx, String preferName) {
        if (processFlag.get() == 0) {
            Bundle bundle = ctx.getContentResolver().call(PreferenceUtil.URI, "method_query_pid", "", null);
            int pid = 0;
            if (bundle != null) {
                pid = bundle.getInt("key_result");
            }
            if (pid == 0) {
                return SharedPreferenceProxy.getFromLocalProcess(ctx, preferName);
            }
            processFlag.set(Process.myPid() == pid ? 1 : -1);
            return SharedPreferenceProxy.getSharedPreferences(ctx, preferName);
        }
        if (processFlag.get() > 0) {
            return SharedPreferenceProxy.getFromLocalProcess(ctx, preferName);
        }
        return SharedPreferenceProxy.getFromRemoteProcess(ctx, preferName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SharedPreferences getFromRemoteProcess(@NonNull Context ctx, String preferName) {
        Class<SharedPreferenceProxy> clazz = SharedPreferenceProxy.class;
        synchronized (SharedPreferenceProxy.class) {
            SharedPreferenceProxy preferenceProxy;
            if (sharedPreferenceProxyMap == null) {
                sharedPreferenceProxyMap = new ArrayMap();
            }
            if ((preferenceProxy = sharedPreferenceProxyMap.get(preferName)) == null) {
                preferenceProxy = new SharedPreferenceProxy(ctx.getApplicationContext(), preferName);
                sharedPreferenceProxyMap.put(preferName, preferenceProxy);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return preferenceProxy;
        }
    }

    private static SharedPreferences getFromLocalProcess(@NonNull Context ctx, String preferName) {
        return ctx.getSharedPreferences(preferName, 0);
    }

    static {
        processFlag = new AtomicInteger(0);
    }

    public class EditorImpl
    implements SharedPreferences.Editor {
        private ArrayList<OpEntry> mModified = new ArrayList();

        public SharedPreferences.Editor putString(String key, @Nullable String value) {
            OpEntry entry = OpEntry.obtainPutOperation(key).setStringValue(value);
            return this.addOps(entry);
        }

        public SharedPreferences.Editor putStringSet(String key, @Nullable Set<String> values) {
            OpEntry entry = OpEntry.obtainPutOperation(key).setStringSettingsValue(values);
            return this.addOps(entry);
        }

        public SharedPreferences.Editor putInt(String key, int value) {
            OpEntry entry = OpEntry.obtainPutOperation(key).setIntValue(value);
            return this.addOps(entry);
        }

        public SharedPreferences.Editor putLong(String key, long value) {
            OpEntry entry = OpEntry.obtainPutOperation(key).setLongValue(value);
            return this.addOps(entry);
        }

        public SharedPreferences.Editor putFloat(String key, float value) {
            OpEntry entry = OpEntry.obtainPutOperation(key).setFloatValue(value);
            return this.addOps(entry);
        }

        public SharedPreferences.Editor putBoolean(String key, boolean value) {
            OpEntry entry = OpEntry.obtainPutOperation(key).setBooleanValue(value);
            return this.addOps(entry);
        }

        public SharedPreferences.Editor remove(String key) {
            OpEntry entry = OpEntry.obtainRemoveOperation(key);
            return this.addOps(entry);
        }

        public SharedPreferences.Editor clear() {
            return this.addOps(OpEntry.obtainClear());
        }

        public boolean commit() {
            Bundle input = new Bundle();
            input.putParcelableArrayList("key_result", this.convertBundleList());
            input.putInt("key_op_type", 5);
            Bundle res = null;
            try {
                res = SharedPreferenceProxy.this.ctx.getContentResolver().call(PreferenceUtil.URI, "method_edit", SharedPreferenceProxy.this.preferName, input);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (res == null) {
                return false;
            }
            return res.getBoolean("key_result", false);
        }

        public void apply() {
            Bundle intput = new Bundle();
            intput.putParcelableArrayList("key_result", this.convertBundleList());
            intput.putInt("key_op_type", 6);
            try {
                SharedPreferenceProxy.this.ctx.getContentResolver().call(PreferenceUtil.URI, "method_edit", SharedPreferenceProxy.this.preferName, intput);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private SharedPreferences.Editor addOps(OpEntry op) {
            EditorImpl editorImpl = this;
            synchronized (editorImpl) {
                this.mModified.add(op);
                return this;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ArrayList<Bundle> convertBundleList() {
            EditorImpl editorImpl = this;
            synchronized (editorImpl) {
                ArrayList<Bundle> bundleList = new ArrayList<Bundle>(this.mModified.size());
                for (OpEntry entry : this.mModified) {
                    bundleList.add(entry.getBundle());
                }
                return bundleList;
            }
        }
    }
}

