/*
 * Decompiled with CFR 0.152.
 */
package com.ykun.live_library.receive;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.Looper;
import com.ykun.live_library.onepx.OnePixelActivity;
import com.ykun.live_library.utils.KeepAliveUtils;

public final class OnepxReceiver
extends BroadcastReceiver {
    Handler mHander = new Handler(Looper.getMainLooper());
    boolean appIsForeground = false;

    public void onReceive(Context context, Intent intent) {
        if (intent.getAction().equals("android.intent.action.SCREEN_OFF")) {
            this.appIsForeground = KeepAliveUtils.IsForeground(context);
            try {
                Intent it = new Intent(context, OnePixelActivity.class);
                it.addFlags(0x10000000);
                it.addFlags(0x20000000);
                context.startActivity(it);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            context.sendBroadcast(new Intent("_ACTION_SCREEN_OFF"));
        } else if (intent.getAction().equals("android.intent.action.SCREEN_ON")) {
            context.sendBroadcast(new Intent("finish activity"));
            if (!this.appIsForeground) {
                this.appIsForeground = false;
                try {
                    Intent home = new Intent("android.intent.action.MAIN");
                    home.setFlags(0x10000000);
                    home.addCategory("android.intent.category.HOME");
                    context.getApplicationContext().startActivity(home);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            context.sendBroadcast(new Intent("_ACTION_SCREEN_ON"));
        }
    }
}

