/*
 * Decompiled with CFR 0.152.
 */
package com.ykun.live_library.service;

import android.app.job.JobInfo;
import android.app.job.JobParameters;
import android.app.job.JobScheduler;
import android.app.job.JobService;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.support.annotation.RequiresApi;
import android.util.Log;
import com.github.uniapp_kill_service_plugin.GlobalConfig;
import com.ykun.live_library.service.LocalService;
import com.ykun.live_library.service.RemoteService;
import com.ykun.live_library.utils.KeepAliveUtils;

@RequiresApi(api=21)
public final class JobHandlerService
extends JobService {
    private String TAG = ((Object)((Object)this)).getClass().getSimpleName();
    private static JobScheduler mJobScheduler;
    private static int EXECUTE_COUNT;

    public static void startJob(Context context) {
        try {
            mJobScheduler = (JobScheduler)context.getSystemService("jobscheduler");
            JobInfo.Builder builder = new JobInfo.Builder(10, new ComponentName(context.getPackageName(), JobHandlerService.class.getName())).setPersisted(true);
            if (Build.VERSION.SDK_INT >= 24) {
                builder.setMinimumLatency(1000L);
            } else {
                builder.setPeriodic(1000L);
            }
            mJobScheduler.schedule(builder.build());
        }
        catch (Exception e) {
            Log.e((String)"startJob->", (String)e.getMessage());
        }
    }

    public static void stopJob() {
        if (mJobScheduler != null) {
            mJobScheduler.cancelAll();
        }
    }

    private void startService(Context context) {
        try {
            Log.i((String)this.TAG, (String)"---\u300b\u542f\u52a8\u53cc\u8fdb\u7a0b\u4fdd\u6d3b\u670d\u52a1");
            Intent localIntent = new Intent(context, LocalService.class);
            Intent guardIntent = new Intent(context, RemoteService.class);
            if (Build.VERSION.SDK_INT >= 26) {
                this.startForegroundService(localIntent);
                this.startForegroundService(guardIntent);
            } else {
                this.startService(localIntent);
                this.startService(guardIntent);
            }
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)e.getMessage());
        }
    }

    public boolean onStartJob(JobParameters jobParameters) {
        try {
            Log.d((String)"JOB-->", (String)(" Job \u6267\u884c " + ++EXECUTE_COUNT));
            if (Build.VERSION.SDK_INT >= 24) {
                JobHandlerService.startJob((Context)this);
            }
            if (!KeepAliveUtils.isServiceRunning(this.getApplicationContext(), this.getPackageName() + ":local") || !KeepAliveUtils.isRunningTaskExist(this.getApplicationContext(), this.getPackageName() + ":remote")) {
                Log.d((String)"JOB-->", (String)" \u91cd\u65b0\u5f00\u542f\u4e86 \u670d\u52a1 ");
                this.startService((Context)this);
            }
            if (GlobalConfig.jsCall != null) {
                if (EXECUTE_COUNT % 4 == 0) {
                    GlobalConfig.jsCall.doJob();
                    Log.d((String)"JOB-->", (String)"call js callback");
                }
            } else {
                if (!KeepAliveUtils.isRuning(this.getApplicationContext())) {
                    GlobalConfig.showMainUI(this.getApplicationContext());
                }
                Log.d((String)"JOB-->", (String)"jscallback is null");
            }
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)e.getMessage());
        }
        return false;
    }

    public boolean onStopJob(JobParameters jobParameters) {
        Log.d((String)"JOB-->", (String)" Job \u505c\u6b62");
        if (!KeepAliveUtils.isServiceRunning(this.getApplicationContext(), this.getPackageName() + ":local") || !KeepAliveUtils.isRunningTaskExist(this.getApplicationContext(), this.getPackageName() + ":remote")) {
            this.startService((Context)this);
        }
        return false;
    }

    static {
        EXECUTE_COUNT = 0;
    }
}

