/*
 * Decompiled with CFR 0.152.
 */
package com.ykun.live_library.service;

import android.app.Notification;
import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.media.MediaPlayer;
import android.os.Build;
import android.os.Handler;
import android.os.IBinder;
import android.os.PowerManager;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.Log;
import com.ykun.keeplive.KeepAliveAidl;
import com.ykun.live_library.KeepAliveRuning;
import com.ykun.live_library.R;
import com.ykun.live_library.config.KeepAliveConfig;
import com.ykun.live_library.config.NotificationUtils;
import com.ykun.live_library.receive.NotificationClickReceiver;
import com.ykun.live_library.receive.OnepxReceiver;
import com.ykun.live_library.service.HideForegroundService1;
import com.ykun.live_library.service.RemoteService;
import com.ykun.live_library.utils.SPUtils;

public final class LocalService
extends Service {
    private OnepxReceiver mOnepxReceiver;
    private ScreenStateReceiver screenStateReceiver;
    private boolean isPause = true;
    private MediaPlayer mediaPlayer;
    private LocalBinder mBilder;
    private Handler handler;
    private String TAG = ((Object)((Object)this)).getClass().getSimpleName();
    private KeepAliveRuning mKeepAliveRuning;
    private ServiceConnection connection = new ServiceConnection(){

        public void onServiceDisconnected(ComponentName name) {
            Intent remoteService = new Intent((Context)LocalService.this, RemoteService.class);
            if (Build.VERSION.SDK_INT >= 26) {
                LocalService.this.startForegroundService(remoteService);
            } else {
                LocalService.this.startService(remoteService);
            }
            Intent intent = new Intent((Context)LocalService.this, RemoteService.class);
            LocalService.this.bindService(intent, LocalService.this.connection, 8);
            PowerManager pm = (PowerManager)LocalService.this.getSystemService("power");
            boolean isScreenOn = pm.isScreenOn();
            if (isScreenOn) {
                LocalService.this.sendBroadcast(new Intent("_ACTION_SCREEN_ON"));
            } else {
                LocalService.this.sendBroadcast(new Intent("_ACTION_SCREEN_OFF"));
            }
        }

        public void onServiceConnected(ComponentName name, IBinder service) {
            try {
                if (LocalService.this.mBilder != null && KeepAliveConfig.foregroundNotification != null) {
                    KeepAliveAidl guardAidl = KeepAliveAidl.Stub.asInterface(service);
                    guardAidl.wakeUp(SPUtils.getInstance(LocalService.this.getApplicationContext(), KeepAliveConfig.SP_NAME).getString(KeepAliveConfig.TITLE), SPUtils.getInstance(LocalService.this.getApplicationContext(), KeepAliveConfig.SP_NAME).getString(KeepAliveConfig.CONTENT), SPUtils.getInstance(LocalService.this.getApplicationContext(), KeepAliveConfig.SP_NAME).getInt(KeepAliveConfig.RES_ICON));
                }
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
    };

    public void onCreate() {
        super.onCreate();
        Log.i((String)"\u672c\u5730\u670d\u52a1", (String)"\uff1a\u672c\u5730\u670d\u52a1\u542f\u52a8\u6210\u529f");
        if (this.mBilder == null) {
            this.mBilder = new LocalBinder();
        }
        PowerManager pm = (PowerManager)this.getSystemService("power");
        this.isPause = pm.isScreenOn();
        if (this.handler == null) {
            this.handler = new Handler();
        }
    }

    public IBinder onBind(Intent intent) {
        return this.mBilder;
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        KeepAliveConfig.runMode = SPUtils.getInstance(this.getApplicationContext(), KeepAliveConfig.SP_NAME).getInt("RUN_MODE");
        Log.d((String)this.TAG, (String)("\u8fd0\u884c\u6a21\u5f0f\uff1a" + KeepAliveConfig.runMode));
        if (this.mediaPlayer == null && KeepAliveConfig.runMode == 1) {
            this.mediaPlayer = MediaPlayer.create((Context)this, (int)R.raw.novioce);
            this.mediaPlayer.setVolume(0.0f, 0.0f);
            this.mediaPlayer.setOnCompletionListener(new MediaPlayer.OnCompletionListener(){

                public void onCompletion(MediaPlayer mediaPlayer) {
                    Log.i((String)LocalService.this.TAG, (String)"\u5faa\u73af\u64ad\u653e\u97f3\u4e50");
                    LocalService.this.play();
                }
            });
            this.play();
        }
        if (this.mOnepxReceiver == null) {
            this.mOnepxReceiver = new OnepxReceiver();
        }
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.SCREEN_OFF");
        intentFilter.addAction("android.intent.action.SCREEN_ON");
        this.registerReceiver(this.mOnepxReceiver, intentFilter);
        if (this.screenStateReceiver == null) {
            this.screenStateReceiver = new ScreenStateReceiver();
        }
        IntentFilter intentFilter2 = new IntentFilter();
        intentFilter2.addAction("_ACTION_SCREEN_OFF");
        intentFilter2.addAction("_ACTION_SCREEN_ON");
        this.registerReceiver(this.screenStateReceiver, intentFilter2);
        this.shouDefNotify();
        try {
            Intent intent3 = new Intent((Context)this, RemoteService.class);
            this.bindService(intent3, this.connection, 8);
        }
        catch (Exception e) {
            Log.i((String)"RemoteService--", (String)e.getMessage());
        }
        try {
            if (Build.VERSION.SDK_INT < 25) {
                this.startService(new Intent((Context)this, HideForegroundService1.class));
            }
        }
        catch (Exception e) {
            Log.i((String)"HideForegroundService--", (String)e.getMessage());
        }
        if (this.mKeepAliveRuning == null) {
            this.mKeepAliveRuning = new KeepAliveRuning();
        }
        this.mKeepAliveRuning.onRuning();
        return 1;
    }

    private void play() {
        Log.i((String)this.TAG, (String)"\u64ad\u653e\u97f3\u4e50");
        if (this.mediaPlayer != null && !this.mediaPlayer.isPlaying()) {
            this.mediaPlayer.start();
        }
    }

    private void pause() {
        if (this.mediaPlayer != null && this.mediaPlayer.isPlaying()) {
            this.mediaPlayer.pause();
        }
    }

    public void onDestroy() {
        super.onDestroy();
        this.unbindService(this.connection);
        this.unregisterReceiver(this.mOnepxReceiver);
        this.unregisterReceiver(this.screenStateReceiver);
        if (this.mKeepAliveRuning != null) {
            this.mKeepAliveRuning.onStop();
        }
        if (this.mediaPlayer != null && this.mediaPlayer.isPlaying()) {
            this.mediaPlayer.stop();
            this.mediaPlayer = null;
        }
    }

    private void shouDefNotify() {
        if (Build.VERSION.SDK_INT >= 26) {
            KeepAliveConfig.CONTENT = SPUtils.getInstance(this.getApplicationContext(), KeepAliveConfig.SP_NAME).getString(KeepAliveConfig.CONTENT);
            KeepAliveConfig.DEF_ICONS = SPUtils.getInstance(this.getApplicationContext(), KeepAliveConfig.SP_NAME).getInt(KeepAliveConfig.RES_ICON, R.drawable.ic_launcher);
            KeepAliveConfig.TITLE = SPUtils.getInstance(this.getApplicationContext(), KeepAliveConfig.SP_NAME).getString(KeepAliveConfig.TITLE);
            String title = SPUtils.getInstance(this.getApplicationContext(), KeepAliveConfig.SP_NAME).getString(KeepAliveConfig.TITLE);
            Log.d((String)("JOB-->" + this.TAG), (String)("KeepAliveConfig.CONTENT_" + KeepAliveConfig.CONTENT + "    " + KeepAliveConfig.TITLE + "  " + title));
            if (!TextUtils.isEmpty((CharSequence)KeepAliveConfig.TITLE) && !TextUtils.isEmpty((CharSequence)KeepAliveConfig.CONTENT)) {
                Intent intent2 = new Intent(this.getApplicationContext(), NotificationClickReceiver.class);
                intent2.setAction("CLICK_NOTIFICATION");
                Notification notification = NotificationUtils.createNotification((Context)this, KeepAliveConfig.TITLE, KeepAliveConfig.CONTENT, KeepAliveConfig.DEF_ICONS, intent2);
                this.startForeground(8888, notification);
                Log.d((String)"JOB-->", (String)(this.TAG + "\u663e\u793a\u901a\u77e5\u680f"));
            }
        }
    }

    private final class LocalBinder
    extends KeepAliveAidl.Stub {
        private LocalBinder() {
        }

        @Override
        public void wakeUp(String title, String discription, int iconRes) throws RemoteException {
            LocalService.this.shouDefNotify();
        }
    }

    private class ScreenStateReceiver
    extends BroadcastReceiver {
        private ScreenStateReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().equals("_ACTION_SCREEN_OFF")) {
                LocalService.this.isPause = false;
                LocalService.this.play();
            } else if (intent.getAction().equals("_ACTION_SCREEN_ON")) {
                LocalService.this.isPause = true;
                LocalService.this.pause();
            }
        }
    }
}

