/*
 * Decompiled with CFR 0.152.
 */
package com.ykun.live_library.service;

import android.app.Notification;
import android.app.Service;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Build;
import android.os.IBinder;
import android.os.PowerManager;
import android.os.RemoteException;
import android.text.TextUtils;
import android.util.Log;
import com.ykun.keeplive.KeepAliveAidl;
import com.ykun.live_library.R;
import com.ykun.live_library.config.KeepAliveConfig;
import com.ykun.live_library.config.NotificationUtils;
import com.ykun.live_library.receive.NotificationClickReceiver;
import com.ykun.live_library.service.LocalService;
import com.ykun.live_library.utils.SPUtils;

public final class RemoteService
extends Service {
    private RemoteBinder mBilder;
    private String TAG = "RemoteService";
    private final ServiceConnection connection = new ServiceConnection(){

        public void onServiceDisconnected(ComponentName name) {
            Intent remoteService = new Intent((Context)RemoteService.this, LocalService.class);
            if (Build.VERSION.SDK_INT >= 26) {
                RemoteService.this.startForegroundService(remoteService);
            } else {
                RemoteService.this.startService(remoteService);
            }
            RemoteService.this.bindService(new Intent((Context)RemoteService.this, LocalService.class), RemoteService.this.connection, 8);
            PowerManager pm = (PowerManager)RemoteService.this.getSystemService("power");
            boolean isScreenOn = pm.isScreenOn();
            if (isScreenOn) {
                RemoteService.this.sendBroadcast(new Intent("_ACTION_SCREEN_ON"));
            } else {
                RemoteService.this.sendBroadcast(new Intent("_ACTION_SCREEN_OFF"));
            }
        }

        public void onServiceConnected(ComponentName name, IBinder service) {
            RemoteService.this.shouDefNotify();
        }
    };

    public void onCreate() {
        super.onCreate();
        Log.i((String)this.TAG, (String)" onCreate");
        if (this.mBilder == null) {
            this.mBilder = new RemoteBinder();
        }
    }

    public IBinder onBind(Intent intent) {
        return this.mBilder;
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        try {
            this.bindService(new Intent((Context)this, LocalService.class), this.connection, 8);
            this.shouDefNotify();
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)e.getMessage());
        }
        return 1;
    }

    private void shouDefNotify() {
        if (Build.VERSION.SDK_INT >= 26) {
            KeepAliveConfig.CONTENT = SPUtils.getInstance(this.getApplicationContext(), KeepAliveConfig.SP_NAME).getString(KeepAliveConfig.CONTENT);
            KeepAliveConfig.DEF_ICONS = SPUtils.getInstance(this.getApplicationContext(), KeepAliveConfig.SP_NAME).getInt(KeepAliveConfig.RES_ICON, R.drawable.ic_launcher);
            KeepAliveConfig.TITLE = SPUtils.getInstance(this.getApplicationContext(), KeepAliveConfig.SP_NAME).getString(KeepAliveConfig.TITLE);
            String title = SPUtils.getInstance(this.getApplicationContext(), KeepAliveConfig.SP_NAME).getString(KeepAliveConfig.TITLE);
            Log.d((String)("JOB-->" + this.TAG), (String)("KeepAliveConfig.CONTENT_" + KeepAliveConfig.CONTENT + "    " + KeepAliveConfig.TITLE + "  " + title));
            if (!TextUtils.isEmpty((CharSequence)KeepAliveConfig.TITLE) && !TextUtils.isEmpty((CharSequence)KeepAliveConfig.CONTENT)) {
                Intent intent2 = new Intent(this.getApplicationContext(), NotificationClickReceiver.class);
                intent2.setAction("CLICK_NOTIFICATION");
                Notification notification = NotificationUtils.createNotification((Context)this, KeepAliveConfig.TITLE, KeepAliveConfig.CONTENT, KeepAliveConfig.DEF_ICONS, intent2);
                this.startForeground(8888, notification);
                Log.d((String)"JOB-->", (String)(this.TAG + "\u663e\u793a\u901a\u77e5\u680f"));
            }
        }
    }

    public void onDestroy() {
        super.onDestroy();
        this.unbindService(this.connection);
    }

    private final class RemoteBinder
    extends KeepAliveAidl.Stub {
        private RemoteBinder() {
        }

        @Override
        public void wakeUp(String title, String discription, int iconRes) throws RemoteException {
            Log.i((String)RemoteService.this.TAG, (String)" wakeUp");
            if (Build.VERSION.SDK_INT >= 26) {
                if (title != null || discription != null) {
                    KeepAliveConfig.CONTENT = title;
                    KeepAliveConfig.DEF_ICONS = iconRes;
                    KeepAliveConfig.TITLE = discription;
                } else {
                    KeepAliveConfig.CONTENT = SPUtils.getInstance(RemoteService.this.getApplicationContext(), KeepAliveConfig.SP_NAME).getString(KeepAliveConfig.CONTENT);
                    KeepAliveConfig.DEF_ICONS = SPUtils.getInstance(RemoteService.this.getApplicationContext(), KeepAliveConfig.SP_NAME).getInt(KeepAliveConfig.RES_ICON, R.drawable.ic_launcher);
                    KeepAliveConfig.TITLE = SPUtils.getInstance(RemoteService.this.getApplicationContext(), KeepAliveConfig.SP_NAME).getString(KeepAliveConfig.TITLE);
                }
                if (KeepAliveConfig.TITLE != null && KeepAliveConfig.CONTENT != null) {
                    Intent intent2 = new Intent(RemoteService.this.getApplicationContext(), NotificationClickReceiver.class);
                    intent2.setAction("CLICK_NOTIFICATION");
                    Notification notification = NotificationUtils.createNotification((Context)RemoteService.this, KeepAliveConfig.TITLE, KeepAliveConfig.CONTENT, KeepAliveConfig.DEF_ICONS, intent2);
                    RemoteService.this.startForeground(8888, notification);
                    Log.d((String)"JOB-->", (String)(RemoteService.this.TAG + "2 \u663e\u793a\u901a\u77e5\u680f"));
                }
            }
        }
    }
}

