/*
 * Decompiled with CFR 0.152.
 */
package com.ykun.live_library.utils;

import android.app.ActivityManager;
import android.app.Application;
import android.content.ComponentName;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Process;
import java.util.List;

public class KeepAliveUtils {
    public static boolean isRunning(Context application) {
        String packageName;
        int pid = Process.myPid();
        String processName = "";
        ActivityManager mActivityManager = (ActivityManager)application.getSystemService("activity");
        for (ActivityManager.RunningAppProcessInfo appProcess : mActivityManager.getRunningAppProcesses()) {
            if (appProcess.pid != pid) continue;
            processName = appProcess.processName;
            break;
        }
        return processName.equals(packageName = application.getPackageName());
    }

    public static boolean isServiceRunning(Context ctx, String className) {
        boolean isRunning = false;
        ActivityManager activityManager = (ActivityManager)ctx.getSystemService("activity");
        List servicesList = activityManager.getRunningServices(Integer.MAX_VALUE);
        for (ActivityManager.RunningServiceInfo si : servicesList) {
            if (className.equals(si.service.getClassName())) {
                isRunning = true;
            }
            if (!className.equals(si.process)) continue;
            isRunning = true;
        }
        return isRunning;
    }

    public static boolean isRuning(Context context) {
        ActivityManager am = (ActivityManager)context.getSystemService("activity");
        List tasks = am.getRunningTasks(1);
        if (tasks != null && !tasks.isEmpty()) {
            for (ActivityManager.RunningTaskInfo task : tasks) {
                ComponentName topActivity = task.topActivity;
                if (!topActivity.getPackageName().equals(context.getPackageName())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean IsForeground(Context context) {
        ComponentName topActivity;
        ActivityManager am = (ActivityManager)context.getSystemService("activity");
        List tasks = am.getRunningTasks(1);
        return tasks != null && !tasks.isEmpty() && (topActivity = ((ActivityManager.RunningTaskInfo)tasks.get((int)0)).topActivity).getPackageName().equals(context.getPackageName());
    }

    public static boolean isRunningTaskExist(Context context, String processName) {
        ActivityManager am = (ActivityManager)context.getSystemService("activity");
        List processList = am.getRunningAppProcesses();
        for (ActivityManager.RunningAppProcessInfo info : processList) {
            if (!info.processName.equals(processName)) continue;
            return true;
        }
        return false;
    }

    public static String getApplicationName(Application application) {
        PackageManager packageManager = null;
        ApplicationInfo applicationInfo = null;
        try {
            packageManager = application.getPackageManager();
            applicationInfo = packageManager.getApplicationInfo(application.getPackageName(), 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            applicationInfo = null;
        }
        String applicationName = (String)packageManager.getApplicationLabel(applicationInfo);
        return applicationName;
    }
}

