/*
 * Decompiled with CFR 0.152.
 */
package com.ykun.live_library.utils;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.NonNull;
import com.ykun.live_library.R;
import com.ykun.live_library.pro_sp.PreferenceUtil;

@SuppressLint(value={"ApplySharedPref"})
public final class SPUtils {
    private static Context mContext;
    private static SharedPreferences mPreferences;

    public static SPUtils getInstance(Context context, String spName) {
        mContext = context;
        SPUtils.init(mContext);
        return new SPUtils();
    }

    public void put(@NonNull String key, String value) {
        SPUtils.putS(key, value);
    }

    public String getString(@NonNull String key) {
        return SPUtils.getS(key);
    }

    public String getString(@NonNull String key, String defaultValue) {
        return SPUtils.getS(key);
    }

    public void put(@NonNull String key, int value) {
        SPUtils.putI(key, value);
    }

    public int getInt(@NonNull String key) {
        return SPUtils.getI(key, R.drawable.ic_launcher);
    }

    public int getInt(@NonNull String key, int defaultValue) {
        return SPUtils.getI(key, defaultValue);
    }

    public static void init(Context context) {
        if (mPreferences == null) {
            mPreferences = PreferenceUtil.getSharedPreference(context, "DEV_YKUN");
        }
    }

    public static String getS(String key) {
        return mPreferences.getString(key, "");
    }

    public static int getI(String key, int def) {
        return mPreferences.getInt(key, def);
    }

    public static void putS(String key, String def) {
        mPreferences.edit().putString(key, def).apply();
    }

    public static void putI(String key, int def) {
        mPreferences.edit().putInt(key, def).apply();
    }

    public void put(String autoWakeUp, boolean autoWakeUp1) {
        mPreferences.edit().putBoolean(autoWakeUp, autoWakeUp1).apply();
    }

    public boolean getBool(String autoWakeUp, boolean autoWakeUp1) {
        return mPreferences.getBoolean(autoWakeUp, autoWakeUp1);
    }
}

